const legalSummarizer = {};


const BASE_URL='https://ai.lexcomply.co/';

const getSummary = async (content, complianceId, key, isArchive) => {

    return new Promise(async(resolve,reject)=>{

        try {
            const res = await fetch(`${BASE_URL}node/get-summary`, {
                method: "POST",
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    content,
                    complianceId,
                    key,
                    isArchive
                })
            });
    
            if (!res.ok) {
                throw new Error('Failed to fetch summary');
            }
    
            const summary = await res.json();
            
            resolve(summary.data); // Resolve with new summary
        
        } catch (err) {
            reject(err); // Reject with error if fetching new summary fails
        }
    })
   

}


const showSummary = (data, container) => {


    const summaryContainer = document.createElement("div");
    summaryContainer.classList.add('summary-container');
    container.appendChild(summaryContainer);


    //add send email input and button
    const summaryMail=document.createElement("div");
    summaryMail.classList.add("summary-mail");
    summaryMail.innerHTML=`<img src="https://lexbuddy.com/assests/images/share-node.png" alt="share icon"/>`
   

    summaryContainer.appendChild(summaryMail);


    //click event to send mail
    summaryMail.addEventListener("click",async function(){

        const email=prompt("Provide email ID to send mail");

        if(email){

            const isMailSent=await sendSummaryMail(email,container);
             alert(`Mail sent to the email Id : ${email}`);
            // if(isMailSent){
            //     alert(`Mail sent to the email Id : ${email}`);
            // }else{
            //     alert("cannot send mail right now...Try Again");
            // }

        }
      
    })

    const textContainer=document.createElement("div");
    textContainer.classList.add("summary-text-container");
    summaryContainer.appendChild(textContainer);
    
    //heading of AI generated Summary
    const summaryHeading=document.createElement("h4");
    summaryHeading.innerHTML=`AI Generated Summary <img src="https://lexbuddy.com/assests/images/wand.svg" alt="wand icon" />`;
    
    textContainer.appendChild(summaryHeading)

    const summaryDivider = document.createElement("hr");
    textContainer.appendChild(summaryDivider)

    for (const key in data) {
        if (key == "timestamp" || key == "contentHash") {

            continue;
        
        } else {

            const summarySubHeading = document.createElement("h6");
            summarySubHeading.innerText = key.replace("_"," ");
            textContainer.appendChild(summarySubHeading);
    
            const summaryPointsContainer = document.createElement("ul");
            textContainer.appendChild(summaryPointsContainer);
    
            if (Array.isArray(data[key])) {

                data[key].forEach((summaryPoint) => {

                    const summaryPointPara = document.createElement("li");
                    summaryPointPara.innerText = summaryPoint;
                    summaryPointsContainer.appendChild(summaryPointPara);
                });
            } else if (typeof data[key] === 'object') {

                for (const subKey in data[key]) {
                    
                    const summaryPointPara = document.createElement("li");
                    summaryPointPara.innerText = subKey + ": " + data[key][subKey];
                    summaryPointsContainer.appendChild(summaryPointPara);
                }
            }
        }
    }



    //adding disclaimer
    const disclaimerDiv=document.createElement("div");
    disclaimerDiv.classList.add("disclaimer-div");
    disclaimerDiv.innerText="*Disclaimer :  This is techonology driven summary of a compliance, so readers are adivsed not to construe this as legal opinion and are advised to take a view of subject experts"
    
    textContainer.appendChild(disclaimerDiv);
}

const summaryButtonClick = async (container, summaryButton) => {
    try {
        // Disable the summary button
        summaryButton.disabled = true;

        // Display spinner inside the button
        summaryButton.innerHTML = '<span class="summary-btn-label" style="margin-right:15px;"><span class="spinner-border spinner-border-sm text-white" role="status" aria-hidden="true"></span></span>Generating...';

        // Extract content, complianceId, and key
        const content = container.querySelector("span").innerText;
        const complianceId = document.querySelector(`#complianceId`).innerText;
        const key = container.getAttribute('data-type');
        const isArchive=container.getAttribute('data-archive');

        // Get summary asynchronously
        const summary = await getSummary(content, complianceId, key, isArchive);

        // If summary is received, display it
        if (summary) {
            // Hide the summary button
            summaryButton.style.display = "none";

            // Parse the summary JSON
            const parsedSummary = JSON.parse(summary);

            // Show the summary
            showSummary(parsedSummary, container);
        }
    } catch (error) {
        console.error("Error occurred while fetching summary:", error);
    } finally {
        // Re-enable the summary button
        summaryButton.disabled = false;

        // Restore original text inside the button
        summaryButton.innerHTML = `<span class="summary-btn-label"><img src="https://lexbuddy.com/assests/images/magic-wand.png" alt="wand icon"/></span> Get Summary`;
    }
}





//send summary to mail
const sendSummaryMail=(email,container)=>{


    //getting key,value for sending in mail
    
    const complianceId=document.querySelector('#complianceId').innerText;

    const complianceHead=document.querySelector('div[id^="act"] > div.col-xs-8.col-sm-8.descp > span').innerText; 

    const impact=document.querySelector('div[id^="act"] > div:nth-child(7) > span').innerText;

    const criticality=document.querySelector('div[id^="act"] > div:nth-child(6) > span').innerText;

    const date=document.querySelector('div[id^="act"] > div:nth-child(8) > span').innerText;

    const complianceDesc=document.querySelector('div[id^="act"] > div.col-xs-12.col-sm-12.descp > span').innerText;

    
    const actName=document.querySelector('div[id^="all_text"] > div.col-xs-12.bg-blue.HeadFixZ > h3 > strong').innerText;


    const key=container.getAttribute('data-name');    
    

    //container of the generated summary
    const summaryTextContainer = document.getElementsByClassName("summary-text-container")[0];

    const hrElement = summaryTextContainer.querySelector('hr');

    const h4Element=summaryTextContainer.querySelector('h4');

    const disclaimerElement=summaryTextContainer.querySelector(".disclaimer-div");

    //removing to get summary html for mail
    h4Element.remove();
    hrElement.remove();
    disclaimerElement.remove();

    const summaryHtml=summaryTextContainer.innerHTML;


    //inserting back so that html structure remains intact
    summaryTextContainer.insertBefore(hrElement, summaryTextContainer.firstChild);
    summaryTextContainer.insertBefore(h4Element, summaryTextContainer.firstChild);
    summaryTextContainer.append(disclaimerElement);
    
    return new Promise((resolve, reject) => {
        const xhr = new XMLHttpRequest();

        xhr.open('POST', `https://demo.ertdemo.com/summaryMail.php`);
        xhr.setRequestHeader('Content-Type', 'application/json');

        xhr.onload = function () {
            if (xhr.status === 200) {

                // commented and removed parsed satement due to error "Unexpected json" mercy [6/may-]
                // const response = JSON.parse(xhr.responseText);
                const response = xhr.responseText;
                resolve(response); // Resolve with the response data
            } else {
                reject('Request failed. Status: ' + xhr.status); // Reject with the status
            }
        };

        xhr.onerror = function () {
            reject('Request failed. Network error'); // Reject for network errors
        };

        xhr.send(JSON.stringify({ email, summary: summaryHtml,complianceId,complianceDesc,complianceHead,key,date,actName,impact,criticality}));
    });
}


legalSummarizer.init = () => {


    const summaryContainers = document.getElementsByClassName("summarizer-container");

    Array.from(summaryContainers).forEach((container) => {


        //checking if button already rendered
        if(container.querySelector(".summary-btn-success")){
        
            return;
        }

        //render buttons only if the content is greater than 100 characters
        if(container.querySelector("span").innerText.length > 200){

            const summaryButton = document.createElement("button");
            summaryButton.classList.add( 'summary-btn-success','btn-rounded', 'waves-effect', 'waves-light');
            summaryButton.innerHTML=`<span class="summary-btn-label"><img src="https://lexbuddy.com/assests/images/magic-wand.png" alt="wand icon"/></span> Get Summary`
            
            //click event for gpt api
            summaryButton.addEventListener('click', () => summaryButtonClick(container, summaryButton));
    
            container.appendChild(summaryButton);
        }
       
    });
}
