<?php
require 'include/header.php';
error_reporting(E_ALl);
function remove_non_alpha($input) {
    $output = preg_replace('/[^a-zA-Z]/', '_', $input);
    return strtolower ($output);
}

function export_backup_file() {

	$c_id	=$_SESSION['company_id'];  
	$company_id = $c_id;
	$c_id3 	= get_company_by_id( $company_id );
	$name 	= $c_id3['name'];
	$f_name	= remove_non_alpha($name);

	$backupFolder = 'support'; 
	$timestamp = date('Y-m-d_H-i-s');
    $outputFile = $backupFolder . '/' . $f_name . '_'.$timestamp.'.sql.gz';
	$pdo = connect_db();
    try {

        $tables = ['company', 'company_act', 'certificate_display', 'company_compliance', 'company_event', 'report_cron', 'user_role', 'held_event', 'evedance_docs', 'go_live_history', 'user', 'user_auth', 'company_compliance_history', 'login_log'];

		//if (!is_dir($backupFolder)) {
		//	mkdir($backupFolder, 0755, true); 
		//}
		
        $gz = gzopen($outputFile, 'w');
        if (!$gz) {
            throw new Exception("Failed to open $outputFile for writing.");
        }

        foreach ($tables as $table) {

            $stmt = $pdo->query("SHOW CREATE TABLE `$table`");
            $row = $stmt->fetch(PDO::FETCH_ASSOC);

			if($table == 'company_compliance_history'){
				$stmt = $pdo->prepare("SELECT * FROM `$table` WHERE sr in ( SELECT sr from company_compliance WHERE company_id = :company_id) ");
			}elseif($table == 'user'){
				$stmt = $pdo->prepare("SELECT * FROM `$table` WHERE user_id in ( SELECT user_id from user_role WHERE Company_id = :company_id)");
			}elseif($table == 'user_auth'){
				$stmt = $pdo->prepare("SELECT * FROM `$table` WHERE user_id in ( SELECT user_id from user_role WHERE Company_id = :company_id)");
			}elseif($table == 'login_log'){
				$stmt = $pdo->prepare("SELECT * FROM `$table` WHERE user_id in ( SELECT user_id from user_role WHERE Company_id = :company_id)");
			}elseif($table == 'user_role'){
				$stmt = $pdo->prepare("SELECT * FROM `$table` WHERE Company_id = :company_id");
			}else{
				$stmt = $pdo->prepare("SELECT * FROM `$table` WHERE company_id = :company_id");
			}
            $stmt->execute(['company_id' => $company_id]);
			

            if ($stmt->rowCount() > 0) {
                gzwrite($gz, "-- Data for table `$table`\n");
              while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
					$columns = '`' . implode('`, `', array_keys($row)) . '`';
					$values = implode(', ', array_map([$pdo, 'quote'], array_values($row))); // Use only PDO::quote
					gzwrite($gz, "INSERT INTO `$table` ($columns) VALUES ($values);\n");
				}
                gzwrite($gz, "\n");
            }
        }

        gzclose($gz);
        echo "Backup completed";

    } catch (Exception $e) {
        echo "Error: " . $e->getMessage() . "<br>";
    }
}

if(isset($_POST['passwords'])){
$chk		= date('dm');
	if($_POST['passwords'] == $chk){
		echo export_backup_file();
		echo "<br> Done ";
	}else{
	echo "Password issue";
}
}else{
	echo "Password issue";
}

?>