<?php
// Used for showing AI-generated summary of a file
include('include/configpdo.php');

function myUrlEncode($string) {    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");    return str_replace($entities, $replacements, urlencode($string));}

function get_form_document( $id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select * from `news` where `sr`=?" );
    $query->bindValue( 1, $id );
	//$query->bindValue( 2, 1 );
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

// Check if it's a GET request
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    //$file = $_GET['file'];
    $type = $_GET['type'];
	if(is_numeric($_GET['file'])){
		$file = $_GET['file'];
	}else{
		$filesf 			= myUrlEncode(urldecode($_GET['file']));
		$encryptionMethod	= "aes-256-cbc";	
		$secretHash 		= "Lex@90";	 
		$file	= substr(openssl_decrypt($filesf, $encryptionMethod, $secretHash, 0, 1212121212121212), 2);		
	}
    $row = get_form_document($file);
	$url = 'https://lexcomply.com/'.$row['link'];
// 	echo $url;
    // $url = "https://demo.ertdemo.com/uploads/1125950554____Certificate of Incorporation (7).pdf";
    
} else {
    // If it's not a GET request, return an error
    http_response_code(405); // Method Not Allowed
    echo json_encode(array("message" => "Invalid Request."));
    exit;
}
?>

<!doctype html>
<html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="AI generated summary of legal notifications">
    <!-- Open Graph / Facebook -->
    <!-- <meta property="og:type" content="website">
    <meta property="og:url" content="https://www.yourwebsite.com/">
    <meta property="og:title" content="Your Page Title">
    <meta property="og:description"
        content="A brief description of your page that highlights key points and includes important keywords."> -->
    <meta property="og:image" content="assets/images/seo.png">

    <!-- Twitter -->
    <!-- <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://www.yourwebsite.com/">
    <meta property="twitter:title" content="Your Page Title">
    <meta property="twitter:description"
        content="A brief description of your page that highlights key points and includes important keywords."> -->
    <meta property="twitter:image" content="assets/images/seo.png">

    <!-- Additional Meta Tags -->
    <!-- <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta name="author" content="Your Name or Company">
    <meta name="keywords" content="keyword1, keyword2, keyword3, keyword4"> -->
    <title>Roha Dossier Summary</title>
	<link rel="icon" href="favicon_6.ico" />
    <link
        href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400;700&family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,400&family=Roboto+Slab:wght@100;300;400;500&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.0.1/css/bootstrap.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@icon/themify-icons@1.0.1-alpha.3/themify-icons.min.css">

</head>
<style>
*,
*::before,
*::after {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

ol,
ul {
    padding-left: 0rem;
}

body {
    font-family: 'Open Sans', sans-serif;
    font-size: 14px;
}

ul li {
    list-style: none;
}

h1,
p {
    font-family: 'Open Sans', sans-serif;
}

.main-logo {
    padding: 10px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.main-logo a img {
    width: 19rem;
    height: 4rem;
    object-fit: contain;
}

.main-logo a {

    display: block;
}

.summary {
    width: 100%;
    height: 100%;

}

.main-section {
    width: 100%;
    padding-bottom: 4rem;
    height: 100%;
    background-color: #F2F7FF;
}

.w-80 {
    width: 80%;
    margin: 0 auto;

}

.pt-5 {
    padding-top: 6rem;
    /* margin-top: 5rem; */
}

.main-nav {
    width: 100%;
    background-color: #fff;
    box-shadow: rgba(0, 0, 0, 0.16) 0px 1px 2px;
    position: fixed;
    top: 0;
}

.summary h1 {
    font-size: 32px;
}

.summary p {
    font-size: 16px;
    color: #333333;
}

.data-container {
    margin-top: 2rem;
    background-color: #fff;
    width: 100%;
    height: 100%;
    padding: 1rem 1.5rem;
}

.data-container h1 {
    color: #16A9E4;
    /* text-align: center; */
    margin-bottom: 1rem;

}

.button1 {
    border: 1px solid #7BC33C;
    text-decoration: none;
    line-height: inherit;
    padding: 8px 12px;
    color: #fff;
    margin-top: 1rem;
    font-weight: 700;
    background: #7BC33C;
    border-radius: 5px;
    text-align: center;
    min-width: 110px;
    display: inline-block;
    text-transform: uppercase;
    border: none;
}

.button1:hover {
    background: #69b329 radial-gradient(circle, transparent 1%, #69b329 1%) center/15000%;
    color: #fff;
    text-decoration: none;
}

.button1:active {
    background-color: #69b329;
    background-size: 100%;
    transition: background 0s;
}


.loading {
    background: linear-gradient(180deg, #06565e 0%, #1a9a82 100%);
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    position: fixed;
    display: flex;
    z-index: 1000;
    align-items: center;
    justify-content: center;
}

.loading h1 {
    color: #FFFFFF;
    text-align: center;
    font-family: 'open sans'sans-serif;
    text-transform: uppercase;
    font-size: 20px;
    position: relative;
}

.loading h1:after {
    position: absolute;
    content: "";
    -webkit-animation: Dots 2s cubic-bezier(0, .39, 1, .68) infinite;
    animation: Dots 2s cubic-bezier(0, .39, 1, .68) infinite;
}

.loader {
    margin: 5% auto 30px;
}

.book {
    border: 4px solid #FFFFFF;
    width: 60px;
    height: 45px;
    position: relative;
    perspective: 150px;
}

.page {
    display: block;
    width: 30px;
    height: 45px;
    border: 4px solid #FFFFFF;
    border-left: 1px solid #0f766f;
    margin: 0;
    position: absolute;
    right: -4px;
    top: -4px;
    overflow: hidden;
    background: #107770;
    transform-style: preserve-3d;
    -webkit-transform-origin: left center;
    transform-origin: left center;
}

.fadeout {
    animation: fadeout 1s ease-in-out forwards;
}

@keyframes fadeout {
    0% {
        opacity: 1;
    }



    50% {
        opacity: 0.5;
    }



    100% {
        opacity: 0;
        display: none;
    }
}

.book .page:nth-child(1) {
    -webkit-animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.6s infinite;
    animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.6s infinite;
}

.book .page:nth-child(2) {
    -webkit-animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.45s infinite;
    animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.45s infinite;
}

.book .page:nth-child(3) {
    -webkit-animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.2s infinite;
    animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.2s infinite;
}


/* Page turn */

@-webkit-keyframes pageTurn {
    0% {
        -webkit-transform: rotateY(0deg);
        transform: rotateY(0deg);
    }

    20% {
        background: #7bc33ca3;
    }

    40% {
        background: #7bc33ca3;
        -webkit-transform: rotateY(-180deg);
        transform: rotateY(-180deg);
    }

    100% {
        background: #7bc33ca3;
        -webkit-transform: rotateY(-180deg);
        transform: rotateY(-180deg);
    }
}

@keyframes pageTurn {
    0% {
        transform: rotateY(0deg);
    }

    20% {
        background: #10776f;
    }

    40% {
        background: #10776f;
        transform: rotateY(-180deg);
    }

    100% {
        background: #107770;
        transform: rotateY(-180deg);
    }
}


/* Dots */

@-webkit-keyframes Dots {
    0% {
        content: "";
    }

    33% {
        content: ".";
    }

    66% {
        content: "..";
    }

    100% {
        content: "...";
    }
}

@keyframes Dots {
    0% {
        content: "";
    }

    33% {
        content: ".";
    }

    66% {
        content: "..";
    }

    100% {
        content: "...";
    }
}

/* footer */
#footer {
    background: #20AEE4;
    padding: 50px 0px 20px;
    /* position: fixed;
    width: 100%;
    bottom: 0; */
}

#footer p {
    font-size: 16px;
    line-height: 22px;
    color: rgba(255, 255, 255, 0.7);
    margin-bottom: 20px;
    font-weight: 500;
}

#footer p.copyright {
    margin: 0px;
    font-weight: 400;
}

#footer a {
    color: rgba(255, 255, 255, 0.7);
}

#footer .row .col {
    padding-left: 40px;
}

#footer .row .col:first-child {
    padding-left: 15px;
}

#footer .count {
    font-size: 22px;
    color: rgba(255, 255, 255, 0.7);
    letter-spacing: 20px;
    display: inline-block;
    position: relative;
    z-index: 2;
}

#footer .count::before {
    content: "";
    width: 100%;
    height: 23px;
    background: var(--light-green);
    display: inline-block;
    position: absolute;
    left: 0px;
    top: 0px;
    z-index: -1;
}

.footer-list h6 {
    font-size: 20px;
    line-height: 26px;
    padding-bottom: 20px;
    margin-bottom: 20px;
    color: rgba(255, 255, 255, 0.7);
    border-bottom: 3px solid #D8D8D8;
}

.footer-list ul li {
    margin-bottom: 10px;
}

.footer-list ul li a {
    font-size: 16px;
    line-height: 22px;
    color: rgba(255, 255, 255, 0.7);
    text-decoration: none;
}

.footer-list ul li:last-child {
    margin-bottom: 0px;
}

/* summary section */
.summary-section {
    width: 100%;
}

.other-summaries {
    width: 25%;
    margin-top: 2rem;
}

.other-summaries-inner {
    width: 100%;
    height: auto;
    padding: 1rem;
    background-color: #fff;
}

.other-summaries-inner h2 {
    font-size: 20px;
    margin-bottom: 1.5rem;
}

.other-summaries-inner li:first-child {
    border-top: 1px solid #acacac;
}

.other-summaries-inner li {
    padding: 10px 0;
    border-bottom: 1px solid #acacac;
}

.other-summaries-inner a p {
    font-size: 12px;
    color: #999999;
    margin-bottom: 0;
}

.other-summaries-inner a {
    text-decoration: none;
}

.other-summaries-inner a h6 {
    font-size: 16px;
    /* color: #000; */
    text-decoration: underline;
    margin-bottom: 0;

}

.social-media-icons {
    display: flex;
    justify-content: space-between;
    align-items: center;
    width: 100%;
}

.social-medias {
    width: 100%;
    background-color: #fff;
    padding: 1rem;
    margin-top: 1rem;
    /* border-radius: 8px; */

}

.social-medias h2 {
    width: 100%;
    font-size: 20px;
}

.social-medias a {
    text-decoration: none;
}

.social-media-icons i {
    font-size: large;
}

.social-media-icons .social-icon {
    display: flex;
    justify-content: center;
    align-items: center;
    margin-top: 1rem;
    background-color: #f2f7ff;
    padding: 5px 10px;
    border-radius: 5px;
}

.import {
    position: absolute;
    top: .5rem;
    font-size: large;
    background-color: aliceblue;
    padding: 5px 10px;
    border-radius: 5px;
    cursor: pointer;
}

@media screen and (max-width: 446px) {

    .summary-section,
    .other-summaries {
        width: 100%;
        padding-bottom: 2rem;
    }

    .w-80 {
        width: 90%;
        margin: 0 auto;
    }
}
</style>

<body>
    <div class="loading">
        <div>
            <div class="loader book">
                <figure class="page"></figure>
                <figure class="page"></figure>
                <figure class="page"></figure>
            </div>
            <h1>summarising</h1>
        </div>

    </div>

    <nav class="main-nav">
        <figure class="main-logo">
            <a href="https://rohacms.dess.net/"><img src="dess_logo_final2.png" alt="logo"
                    loading="lazy"></a>         
        </figure>
    </nav>
    <section class="main-section">

        <section class="summary">
            <div class="w-80 d-flex flex-wrap justify-content-between mt-5 pt-5">
                <!-- <h1>Dossier Summary Below</h1>
                <span>We offer nextgen compliance research solutions for Corporates, Professionals and Students.</span> -->
                <section class="summary-section">
                    <div class="data-container">
                        <div class="w-100 justify-content-end d-flex position-relative">
                            <div class="import"> <i class="ti ti-import"></i>
                            </div>
                        </div>
                        <p id="summary">Loading...</p>
                    </div>
                </section>

            </div>
        </section>

    </section>
    <footer id="footer">

    </footer>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous">
    </script>

    <script>
    $(document).ready(() => {
        getSummary();
        getNotifications();
    });




    //getting summary of the document
    async function getSummary() {

        try {
            const res = await fetch(`https://ai.lexcomply.co/node/get-notification-summary`, {
                method: "POST",
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    url:"<?=$url?>",
                    fileId: "<?=$file?>",
                    type: "<?=$type?>",
                })
            });

            if (!res.ok) {
                throw new Error('Failed to fetch summary');
            }

            const summary = await res.json();
            $("#summary").html(summary.data);
            $('.loading').addClass("fadeout");
            // resolve(summary.data); // Resolve with new summary

        } catch (err) {
            // reject(err); // Reject with error if fetching new summary fails

            $("#").html("Failed to get summary..Please try again");
        }
    }



    function getNotifications() {
        //getting notifications
        $.ajax({
            url: "https://ai.lexcomply.co/node/get-notifications",
            method: "GET",
            datatype: "json",
            success: function(res) {

                let html = '';
                res.data.forEach((notification) => {

                    if (notification.file != "<?=$file?>") {
                        html += `<li>
                                <a href="https://lexcomply.com/summary.php/?file=${notification.fileId}&type=${notification.type}" data-file="${notification.fileId}" target="_blank">
                                    <h6>${notification.title}</h6>
                                    <p>${notification.subTitle}...</p>
                                </a>
                            </li>`
                    }

                });

                $("#notificationContainer").html(html);
            },
            error: function(err) {
                console.log(err);
            }
        })
    }
    </script>
</body>

</html>