<?php
// Used for showing AI-generated summary of a file
include('include/configpdo.php');

function myUrlEncode($string) {    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");    return str_replace($entities, $replacements, urlencode($string));}

function get_form_document( $id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select * from `news` where `sr`=?" );
    $query->bindValue( 1, $id );
	//$query->bindValue( 2, 1 );
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

// Check if it's a GET request
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    //$file = $_GET['file'];
    $type = $_GET['type'];
	if(is_numeric($_GET['file'])){
		$file = $_GET['file'];
	}else{
		$filesf 			= myUrlEncode(urldecode($_GET['file']));
		$encryptionMethod	= "aes-256-cbc";	
		$secretHash 		= "Lex@90";	 
		$file	= substr(openssl_decrypt($filesf, $encryptionMethod, $secretHash, 0, 1212121212121212), 2);		
	}
    $row = get_form_document($file);
	$url = 'https://lexcomply.com/'.$row['link'];
// 	echo $url;
    // $url = "https://demo.ertdemo.com/uploads/1125950554____Certificate of Incorporation (7).pdf";
    
} else {
    // If it's not a GET request, return an error
    http_response_code(405); // Method Not Allowed
    echo json_encode(array("message" => "Invalid Request."));
    exit;
}
?>

<!doctype html>
<html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="AI generated summary of legal notifications">
    <!-- Open Graph / Facebook -->
    <!-- <meta property="og:type" content="website">
    <meta property="og:url" content="https://www.yourwebsite.com/">
    <meta property="og:title" content="Your Page Title">
    <meta property="og:description"
        content="A brief description of your page that highlights key points and includes important keywords."> -->
    <meta property="og:image" content="https://lexcomply.com/assets/images/seo.jpg">

    <!-- Twitter -->
    <!-- <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://www.yourwebsite.com/">
    <meta property="twitter:title" content="Your Page Title">
    <meta property="twitter:description"
        content="A brief description of your page that highlights key points and includes important keywords."> -->
    <meta property="twitter:image" content="https://lexcomply.com/assets/images/seo.jpg">

    <!-- Additional Meta Tags -->
    <!-- <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">
    <meta name="robots" content="index, follow">
    <meta name="author" content="Your Name or Company">
    <meta name="keywords" content="keyword1, keyword2, keyword3, keyword4"> -->
    <title>Lexcomply Dossier Summary</title>
    <link
        href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400;700&family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,400&family=Roboto+Slab:wght@100;300;400;500&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.0.1/css/bootstrap.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@icon/themify-icons@1.0.1-alpha.3/themify-icons.min.css">

</head>
<style>
*,
*::before,
*::after {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

ol,
ul {
    padding-left: 0rem;
}

body {
    font-family: 'Open Sans', sans-serif;
    font-size: 14px;
}

ul li {
    list-style: none;
}

h1,
p {
    font-family: 'Open Sans', sans-serif;
}

.main-logo {
    padding: 0px 20px 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin: 0;
}

.main-logo a img {
    width: 14rem;
    height: 5rem;
    object-fit: contain;
}

.main-logo a {

    display: block;
}

.summary {
    width: 100%;
    height: 100%;

}

.main-section {
    width: 100%;
    padding-bottom: 4rem;
    height: 100%;
    background-color: #F2F2F2;
}

.w-80 {
    width: 80%;
    margin: 0 auto;

}

.pt-5 {
    padding-top: 6rem;
    /* margin-top: 5rem; */
}

.main-nav {
    width: 100%;
    background-color: #fff;
    box-shadow: rgba(0, 0, 0, 0.16) 0px 1px 2px;
    position: fixed;
    top: 0;
    z-index: 99;
}

.summary h1 {
    font-size: 32px;
}

.summary p {
    font-size: 16px;
    color: #333333;
}

.data-container {
    /* margin-top: 2rem; */
    background-color: #fff;
    width: 100%;
    height: 100%;
    padding: 1rem 1.5rem;
}

.data-container h1 {
    color: #16A9E4;
    text-decoration: underline;
    /* text-align: center; */
    margin-bottom: 1rem;

}

.button1 {
    border: 1px solid #7BC33C;
    text-decoration: none;
    line-height: inherit;
    padding: 8px 12px;
    color: #fff;
    margin-top: 1rem;
    font-weight: 700;
    background: #7BC33C;
    border-radius: 5px;
    text-align: center;
    min-width: 110px;
    display: inline-block;
    text-transform: uppercase;
    border: none;
}

.button1:hover {
    background: #20AEE4 radial-gradient(circle, transparent 1%, #20AEE4 1%) center/15000%;
    color: #fff;
    text-decoration: none;
}

.button1:active {
    background-color: #20AEE4;
    background-size: 100%;
    transition: background 0s;
}


.loading {
    background: linear-gradient(180deg, #20AEE4 0%, #0dcaf0 100%);
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    position: fixed;
    display: flex;
    z-index: 1000;
    align-items: center;
    justify-content: center;
}

.loading h1 {
    color: #FFFFFF;
    text-align: center;
    font-family: 'open sans'sans-serif;
    text-transform: uppercase;
    font-size: 20px;
    position: relative;
}

.loading h1:after {
    position: absolute;
    content: "";
    -webkit-animation: Dots 2s cubic-bezier(0, .39, 1, .68) infinite;
    animation: Dots 2s cubic-bezier(0, .39, 1, .68) infinite;
}

.loader {
    margin: 5% auto 30px;
}

.book {
    border: 4px solid #FFFFFF;
    width: 60px;
    height: 45px;
    position: relative;
    perspective: 150px;
}

.page {
    display: block;
    width: 30px;
    height: 45px;
    border: 4px solid #FFFFFF;
    /* border-left: 1px solid #0f766f; */
    margin: 0;
    position: absolute;
    right: -4px;
    top: -4px;
    overflow: hidden;
    background: #1ab6e7;
    transform-style: preserve-3d;
    -webkit-transform-origin: left center;
    transform-origin: left center;
}

.fadeout {
    animation: fadeout 1s ease-in-out forwards;
}

@keyframes fadeout {
    0% {
        opacity: 1;
    }



    50% {
        opacity: 0.5;
    }



    100% {
        opacity: 0;
        display: none;
    }
}

.book .page:nth-child(1) {
    -webkit-animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.6s infinite;
    animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.6s infinite;
}

.book .page:nth-child(2) {
    -webkit-animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.45s infinite;
    animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.45s infinite;
}

.book .page:nth-child(3) {
    -webkit-animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.2s infinite;
    animation: pageTurn 1.2s cubic-bezier(0, .39, 1, .68) 1.2s infinite;
}


/* Page turn */

@-webkit-keyframes pageTurn {
    0% {
        -webkit-transform: rotateY(0deg);
        transform: rotateY(0deg);
    }

    20% {
        background: #9AD6F0;
        /* Medium shade */
    }

    40% {
        background: #1A92C4;
        /* Darker shade */
        -webkit-transform: rotateY(-180deg);
        transform: rotateY(-180deg);
    }

    100% {
        background: #17bbea;
        /* Lighter shade */
        -webkit-transform: rotateY(-180deg);
        transform: rotateY(-180deg);
    }
}

/* @keyframes pageTurn {
    0% {
        transform: rotateY(0deg);
    }

    20% {
        background: #10776f;
    }

    40% {
        background: #10776f;
        transform: rotateY(-180deg);
    }

    100% {
        background: #107770;
        transform: rotateY(-180deg);
    }
} */


/* Dots */

@-webkit-keyframes Dots {
    0% {
        content: "";
    }

    33% {
        content: ".";
    }

    66% {
        content: "..";
    }

    100% {
        content: "...";
    }
}

@keyframes Dots {
    0% {
        content: "";
    }

    33% {
        content: ".";
    }

    66% {
        content: "..";
    }

    100% {
        content: "...";
    }
}

/* footer */
#footer {
    background: #20AEE4;
    padding: 50px 0px 20px;
    /* position: fixed;
    width: 100%;
    bottom: 0; */
}

#footer p {
    font-size: 16px;
    line-height: 22px;
    color: #fff;
    margin-bottom: 20px;
    font-weight: 500;
}

#footer p.copyright {
    margin: 0px;
    font-weight: 400;
}

#footer a {
    color: #fff;
}

#footer .row .col {
    padding-left: 40px;
}

#footer .row .col:first-child {
    padding-left: 15px;
}

#footer .count {
    font-size: 22px;
    color: #fff;
    letter-spacing: 20px;
    display: inline-block;
    position: relative;
    z-index: 2;
}

#footer .count::before {
    content: "";
    width: 100%;
    height: 23px;
    background: var(--light-green);
    display: inline-block;
    position: absolute;
    left: 0px;
    top: 0px;
    z-index: -1;
}

.footer-list h6 {
    font-size: 20px;
    line-height: 26px;
    padding-bottom: 20px;
    margin-bottom: 20px;
    color: #fff;
    border-bottom: 3px solid #fff;
}

.footer-list ul li {
    margin-bottom: 10px;
}

.footer-list ul li a {
    font-size: 16px;
    line-height: 22px;
    color: #fff;
    text-decoration: none;
}

.footer-list ul li:last-child {
    margin-bottom: 0px;
}

/* summary section */
.summary-section {
    width: 73%;
    margin-top: 2rem;
    background-color: #fff;
    /* width: 100%; */
    height: 100%;
}

.other-summaries {
    width: 25%;
    margin-top: 2rem;
}

.other-summaries-inner {
    width: 100%;
    height: auto;
    padding: 1rem;
    background-color: #fff;
}

.other-summaries-inner h2 {
    font-size: 20px;
    margin-bottom: 1.5rem;
}

.other-summaries-inner li:first-child {
    border-top: 1px solid #acacac;
}

.other-summaries-inner li {
    padding: 10px 0;
    border-bottom: 1px solid #acacac;
}

.other-summaries-inner a p {
    font-size: 12px;
    color: #999999;
    margin-bottom: 0;
}

.other-summaries-inner a {
    text-decoration: none;
}

.other-summaries-inner a h6 {
    font-size: 16px;
    /* color: #000; */
    text-decoration: underline;
    margin-bottom: 0;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.social-media-icons {
    display: flex;
    justify-content: space-between;
    align-items: center;
    width: 100%;
    border-top: 1px solid #acacac;
}

.social-medias {
    width: 100%;
    background-color: #fff;
    padding: 1rem;
    margin-top: 1rem;
    /* border-radius: 8px; */

}

.social-medias h2 {
    width: 100%;
    font-size: 20px;
    margin-bottom: 1.5rem;
}

.social-medias a {
    text-decoration: none;
}

.social-media-icons i {
    font-size: large;
}

.social-media-icons .social-icon {
    display: flex;
    justify-content: center;
    align-items: center;
    margin-top: 1rem;
    background-color: #f2f7ff;
    padding: 5px 10px;
    border-radius: 5px;
}

.import {
    color: #278c49;
    font-size: large;
    background-color: #f2f7ff;
    padding: 5px 10px;
    border-radius: 5px;
    cursor: pointer;
}

@media screen and (max-width: 446px) {

    .summary-section,
    .other-summaries {
        width: 100%;
        padding-bottom: 2rem;
    }

    .w-80 {
        width: 90%;
        margin: 0 auto;
    }
}

.summary-header {
    width: 100%;
    padding: 1rem 1.5rem;
    background-color: #278c49;
    color: #fff;
    align-items: center;
    display: flex;
    justify-content: space-between
}

#summary h2 {
    font-size: 24px;
}

.mt-1rem {
    margin-top: 1rem;
}
</style>

<body>
    <div class="loading">
        <div>
            <div class="loader book">
                <figure class="page"></figure>
                <figure class="page"></figure>
                <figure class="page"></figure>
            </div>
            <h1>summarising</h1>
        </div>

    </div>

    <nav class="main-nav">
        <figure class="main-logo">
            <a href="https://lexbuddy.com/"><img src="https://lexcomply.com/assests/img/logoComplyFinal.png" alt="logo"
                    loading="lazy"></a>
            <!-- <a class="button1" href="https://lexcomply.com/login.php">Sign In</a> -->
        </figure>
    </nav>
    <section class="main-section">

        <section class="summary">

            <div class="w-80 d-flex flex-wrap justify-content-between mt-5 pt-5">

                <!-- <h1>Dossier Summary Below</h1>
                <span>We offer nextgen compliance research solutions for Corporates, Professionals and Students.</span> -->
                <section class="summary-section">
                    <div class="summary-header">
                        <h1> AI Summary</h1>
                        <div class="justify-content-end d-flex position-relative">
                            <div class="import" id="exportPdf"> <i class="ti ti-import"></i>
                            </div>
                        </div>
                    </div>
                    <div class="data-container">

                        <p id="summary">Loading...</p>
                    </div>

                </section>


                <section class="other-summaries">
                    <div class="other-summaries-inner">
                        <h2><i class="ti ti-blackboard"></i> Other Summaries</h2>
                        <ul id="notificationContainer">

                        </ul>
                    </div>
                    <div class="social-medias">
                        <h2><i class="ti ti-clip"></i> Connect with us</h2>
                        <div class="social-media-icons">


                            <div class="social-icon">
                                <a href="https://www.facebook.com/lexcomply" target="_blank">
                                    <i class="ti ti-facebook"></i>
                                </a>
                            </div>
                            <div class="social-icon">
                                <a href="https://twitter.com/lexcomply" target="_blank">
                                    <i class="ti ti-twitter"></i>
                                </a>
                            </div>
                            <div class="social-icon">
                                <a href="https://www.linkedin.com/company/lexcomply/" target="_blank">
                                    <i class="ti ti-linkedin"></i>
                                </a>
                            </div>

                        </div>
                    </div>
                </section>
                <span class="mt-1rem"><em>*Disclaimer : This is technology driven summary of a compliance, so readers
                        are advised
                        not to
                        construe
                        this as legal opinion and are advised to take a view of subject experts</em></span>
            </div>

        </section>

    </section>
    <div id="exportPdfContainer" style="display:none;">
        <style>
        #exportPdfContainerInner h1,
        p {
            font-family: 'Open Sans', sans-serif;
        }

        #exportPdfContainerInner header {
            width: 100%;
        }

        #exportPdfContainerInner header .header {
            background-color: #278c49;
            padding: 1rem 2rem;
            display: flex;
            /* justify-content: center; */
        }

        #exportPdfContainerInner .header img {
            background-color: #fff;
            padding: 5px 10px;
            border-radius: 10px;
            width: 14rem;
            height: auto;
            object-fit: contain;
        }

        #exportPdfContainerInner header .heading h1 {
            margin-top: 2rem;
            text-align: center;
            /* text-decoration: underline 12px; */
            color: #767676;
            display: inline;
            border-bottom: 2px solid #767676;
            font-size: 2rem;
        }

        #exportPdfContainerInner header .heading {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 100%;
        }

        #exportPdfContainerInner footer {
            padding: 1.5rem 2rem;
            display: flex;
            justify-content: space-between;
            align-items: baseline;
            margin-top: 1rem;
            border-top: 1px solid #acacac;
        }

        #exportPdfContainerInner footer h4 {
            color: #767676;
            margin: 7px 0;
            font-weight: 500;
            font-size: 16px;
        }

        #exportPdfContainerInner .foot {
            margin: 1rem 0 2rem 0;
            padding: 1rem 2rem;
        }

        #exportPdfContainerInner .foot h4 {
            margin: 7px 0;
            font-size: 20px;
            font-weight: 500;
        }

        #summaryPdf {
            padding: 1rem 2rem;
        }

        #exportPdfContainerInner em {
            display: block;
            color: #767676;
            padding: 0px 2rem;
            font-size: 14px;
            width: 100%;
        }

        #summaryPdf h1,
        #summaryPdf h2,
        #summaryPdf h3,
        #summaryPdf h4,
        #summaryPdf h5,
        #summaryPdf h6 {
            margin: 10px 0;
            font-weight: 500;
            line-height: 24px !important;
        }

        #summaryPdf h1 {
            font-size: 2rem;
            margin-bottom: 2rem;
            line-height: 2rem !important;
        }

        #summaryPdf h2 {
            font-size: 1.5rem;
            margin-bottom: 1rem
        }

        #summaryPdf h3 {
            font-size: 1rem;
        }

        #summaryPdf h4 {
            font-size: 0.5rem;
        }

        #summaryPdf h5 {
            font-size: 0.25rem;
        }

        #summaryPdf h6 {
            font-size: 0.25rem;
        }

        #summaryPdf p {
            line-height: 24px;
            margin-bottom: 2rem;
        }

        #exportPdfContainerInner span {
            padding: 0px 2rem;
        }
        </style>
        <section class="pdf" id="exportPdfContainerInner">
            <header>
                <div class="header">
                    <img src="https://lexcomply.com/assets/images/newlogo.png" alt="">
                </div>
                <div class="heading">
                    <h1> AI Summary</h1>
                </div>
            </header>
            <main>
                <div id="summaryPdf">
                    <p id="exportSummaryContainer">
                    </p>
                </div>
                <div class="foot">
                    <h4>Thank You</h4>
                    <h4>Team Lexcomply</h4>
                </div>
                <span><em>*Disclaimer : This is techonology driven summary of a compliance, so readers are adivsed
                        not to
                        construe
                        this as legal opinion and are advised to take a view of subject experts</em></span>
            </main>
            <footer>
                <div>
                    <h4>RSJ Lexsys Private Limited</h4>
                    <h4>2/11B Basement, Jangpura-A,</h4>
                    <h4> New Delhi -110014</h4>
                    <h4 style="text-decoration: underline">www.lexbuddy.com</h4>

                </div>
                <div>
                    <h4>+91-9625100928</h4>
                    <h4>helpline@lexbuddy.com</h4>
                </div>
            </footer>
        </section>
    </div>
    <!-- <footer id="footer">
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="footer-list">
                        <h6>Reach Us</h6>
                        <div class="address">
                            <p>2/11B Jangpura-A,<br>
                                Jangpura New Delhi-110014</p>
                            <p><strong>CIN No:</strong> U74140DL2015PTC276522</p>
                            <p><a href="mailto:info@lexcomply.com" style="text-decoration: none;">
                                    info@lexcomply.com</a> </p>

                            <p><a href="tel:+91-7982703102">+91-9625100928</a></p>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-12">
                    <div class="footer-list">
                        <h6>Social Connect</h6>
                        <ul>
                            <li>
                                <a href="https://facebook.com/lexcomply" target="_blank">Facebook</a>
                            </li>
                            <li>
                                <a href="https://twitter.com/lexcomply" target="_blank">Twitter</a>
                            </li>
                            <li>
                                <a href="https://www.linkedin.com/company/lexcomply/" target="_blank">Linkedin</a>
                            </li>
                            
            <li>
              <a href="https://plus.google.com/+LexComplyOfficial" target="_blank">Google Plus</a>
            </li>
                            <li>
                                <a href="https://www.youtube.com/@lexcomply6169" target="_blank">Youtube</a>
                            </li>
                            <li>
                                <a href="https://lexcomply.com/media" target="_blank">Media Coverage</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-sm-3 col-12">
                    <div class="footer-list">
                        <h6>Quick Links</h6>
                        <ul>
                            <li>
                                <a href="https://lexcomply.com/terms" target="_blank">Terms of Use</a>
                            </li>
                            <li>
                                <a href="https://lexcomply.com/privacy-policy" target="_blank">Privacy Policy</a>
                            </li>
                            <li>
                                <a href="https://lexcomply.com/contact-us" target="_blank">Contact Us</a>
                            </li>
                            <li>
                                <a href="https://lexcomply.com/about-us" target="_blank">About Us</a>
                            </li>
                            <li>
                                <a href="https://lexcomply.com/blog/" target="_blank">Blog</a>
                            </li>
                            <li>
                                <a href="https://lexcomply.com/our-clients" target="_blank">Client and Partners</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-sm-3 col-12">
                    <div class="footer-list">
                        <h6>Solutions</h6>
                        <ul>

                            <li>
                                <a href="https://lexcomply.com/enterprise-compliance-management"
                                    target="_blank">Compliance management</a>
                            </li>
                            <li>
                                <a href="https://lexcomply.com/contract-management" target="_blank">Contract Lifecycle
                                    Management</a>
                            </li>
                            <li>
                                <a href="https://lexcomply.com/enterprise-risk-management" target="_blank">Enterprise
                                    Risk Management</a>
                            </li>
                            <li>
                                <a href="https://lexcomply.com/enterprise-litigation-management"
                                    target="_blank">Litigation Management</a>
                            </li>
                            <li>
                                <a href="https://lexbuddy.com/" target="_blank">Lexbuddy</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-12">
                    <hr>
                    <p class="copyright text-center">
                        Copyright ©2015-2024 All Rights Reserved By RSJ Lexsys Pvt Ltd.
                    </p>
                </div>
            </div>
        </div>

       
    </footer> -->

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous">
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>


    <script>
    $(document).ready(() => {
        getSummary();
        getNotifications();
    });

    function encryptData(data, secretKey, iv) {
        // Convert the secret key and IV to ArrayBuffer
        const enc = new TextEncoder();
        const keyBuffer = enc.encode(secretKey);
        const ivBuffer = enc.encode(iv);
    
        // Import the key
        return crypto.subtle.importKey(
            'raw',           // Raw format of the key
            keyBuffer,       // The secret key as ArrayBuffer
            { name: 'AES-CBC' }, // Algorithm to use
            false,           // Extractable (not allowed for this use case)
            ['encrypt']      // What the key is allowed to do
        ).then(function(key) {
            // Encrypt the data
            return crypto.subtle.encrypt(
                {
                    name: 'AES-CBC',
                    iv: ivBuffer,  // Initialization vector (IV)
                },
                key,              // The secret key
                enc.encode(data)  // The data to encrypt as ArrayBuffer
            );
        }).then(function(encryptedData) {
            // Convert encrypted data to base64
            return btoa(String.fromCharCode(...new Uint8Array(encryptedData)));
        }).catch(function(err) {
            console.error('Encryption failed:', err);
        });
    }


    //getting summary of the document
    async function getSummary() {

        try {
            const res = await fetch(`https://ai.lexcomply.co/node/get-notification-summary`, {
                method: "POST",
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    url: "<?=$url?>",
                    fileId: "<?=$file?>",
                    type: "<?=$type?>",
                })
            });

            if (!res.ok) {
                throw new Error('Failed to fetch summary');
            }

            const summary = await res.json();
            $("#summary").html(summary.data);
            $("#exportSummaryContainer").html(summary.data);
            $('.loading').addClass("fadeout");


            if (!summary.status) {
                $("#exportPdf").hide();
            }

        } catch (err) {
            // reject(err); // Reject with error if fetching new summary fails

            $("#").html("Failed to get summary..Please try again");
        }
    }



    function getNotifications() {
        //getting notifications
        $.ajax({
            url: "https://ai.lexcomply.co/node/get-notifications",
            method: "GET",
            datatype: "json",
            success: function(res) {

                let html = '';
                let pendingRequests = res.data.length;
                res.data.forEach((notification) => {

                    if (notification.file != "<?=$file?>") {
                        
                        
                        var xhr = new XMLHttpRequest();
                        xhr.open("POST", "https://hmc.lexcomply.com/encryptfile.php", true);
                        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                        xhr.onreadystatechange = function() {
                            if (xhr.readyState == 4 && xhr.status == 200) {
                                // console.log("Response from PHP: " + xhr.responseText);
                                html += `<li>
                                    <a href="https://hmc.lexcomply.com/summary.php/?file=${xhr.responseText}&type=${notification.type}" data-file="${xhr.responseText}" target="_blank">
                                        <h6>${notification.title}</h6>
                                        <p>${notification.subTitle}...</p>
                                    </a>
                                </li>`;
                                
                                 pendingRequests--; // Decrement the counter

                                // Log the html variable only when all requests are completed
                                if (pendingRequests === 0) {
                                    $("#notificationContainer").html(html);
                                    console.log(html);
                                }
                            }
                        };
                        xhr.send("fileId=" + encodeURIComponent(notification.fileId));
                        
                        // Example usage
                        // html += `<li>
                        //         <a href="https://lexcomply.com/summary.php/?file=${notification.fileId}&type=${notification.type}" data-file="${notification.fileId}" target="_blank">
                        //             <h6>${notification.title}</h6>
                        //             <p>${notification.subTitle}...</p>
                        //         </a>
                        //     </li>`
                    }

                });

            },
            error: function(err) {
                console.log(err);
            }
        })
    }


    //exporting summary pdf
    $("#exportPdf").on('click', function() {

        //getting html to export
        const summaryContent = $("#exportPdfContainer").html();


        //PDF options
        const opt = {
            margin: 1,
            filename: `Lexcomply_AI_Summary_${new Date().toLocaleDateString('en-GB')}_${new Date().toLocaleTimeString('en-GB')}.pdf`,
            image: {
                type: 'jpeg',
                quality: 0.98
            },
            html2canvas: {
                scale: 1
            },
            jsPDF: {
                unit: 'in',
                format: 'letter',
                orientation: 'portrait'
            }
        };

        //saving
        html2pdf().set(opt).from(summaryContent).save();

    })
    </script>
</body>

</html>