<?php
include "include/header.php";
error_reporting(E_ALL);
insert_compliance_click_log('Compliance Revisions Tab');
$company_id =$_SESSION['company_id'];

function dictionary($data){
    $result = '';
    switch($data){
        case 'description':
            $result = 'Description';
            break;
        case 'app_geog':
            $result = 'Scope';
            break;
        case 'state':
            $result = 'State';
            break;
        case 'location':
            $result = 'Location';
            break;
        case 'event':
            $result = 'Event';
            break;
        case 'event_periodicity':
            $result = 'Event Periodicity';
            break;
        case 'application':
            $result = 'Applicability';
            break;
        case 'exemption':
            $result = 'Exemption';
            break;
        case 'section':
            $result = 'Section';
            break;
        case 'sub_section':
            $result = 'Sub Section';
            break;
        case 'rule':
            $result = 'Rule';
            break;
        case 'rule_name':
            $result = 'Rule Name';
            break;
        case 'sub_head':
            $result = 'Sub Head';
            break;
        case 'state':
            $result = 'State';
            break;
        case 'criticality':
            $result = 'Criticality';
            break;
        case 'periodicity':
            $result = 'Periodicity';
            break;
        case 'applicable_online':
            $result = 'Applicable Online';
            break;
        case 'site':
            $result = 'Site';
            break;
        case 'due_date':
            $result = 'Due Date';
            break;
        case 'triggers':
            $result = 'Triggers';
            break;
        case 'provision':
            $result = 'Penal Provision';
            break;
        case 'agency':
            $result = 'Statutory Agency';
            break;
        case 'agency_add':
            $result = 'Statutory Agency Address';
            break;
        case 'remarks':
            $result = 'Remarks';
            break;
        case 'key1':
            $result = 'Key Definition';
            break;
        case 'form_name':
            $result = 'Form Name';
            break;
        case 'form_purpose':
            $result = 'Form Purpose';
            break;
        case 'potential_impact':
            $result = 'Potential Impact';
            break;
        case 'wef_date':
            $result = 'With Effect Date';
            break;
        default:
            $result = "";
    }
    return $result;
}

function getComplianceVerID(){
	$dbh = connect_db();
	$today = date('Y-m-d');
	// $datebeforeOneWeek = date("Y-m-d", strtotime("-1 week"));
	$datebeforeOneWeek = date("Y-m-d", strtotime("-15 days"));
	
	$dates = "( DATE(`compliance_ver`.`time_stap`) BETWEEN '$datebeforeOneWeek' AND '$today' )";
	try {
		$query = $dbh->prepare( "SELECT `compliance_ver`.`id` FROM `compliance_ver` WHERE $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) GROUP BY `compliance_ver`.`id` ORDER BY `compliance_ver`.`sr` DESC" );
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
	    foreach($result as $r){
	        $rArray[] = $r['id'];
	    }
	    return $rArray;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}

function getQuery(){
	$compliances = getComplianceVerID();
	$query = "(";
	$i = 1;
	foreach($compliances as $comp){
		if($i==1){
			$query .= "`company_compliance`.`compliance_id`='$comp'";
		} else {
			$query .= " OR `company_compliance`.`compliance_id`='$comp'";
		}
		$i++;
	}
	$query .= ")";
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT DISTINCT(`company_id`) FROM `company_compliance` WHERE $query");
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		$m = 1;
		$q = "(";
		foreach($result as $r){
			$companyid = $r['company_id'];
			if($m==1){
				$q .= "`user_role`.`Company_id`='$companyid'";
			} else {
				$q .= " OR `user_role`.`Company_id`='$companyid'";
			}
			$m++;
		}
		$q .= ")";
		return $q;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function getComplianceData($complianceID){
    $dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT * FROM `compliance_ver` WHERE `id`='$complianceID' ORDER BY `sr` DESC LIMIT 1,1" );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	} 
}

function getComplianceDataDetail($complianceID){
    $dbh = connect_db();
	$today = date('Y-m-d');
	$datebeforeOneWeek = date("Y-m-d", strtotime("-30 days"));
	
	$dates = "( DATE(`compliance_ver`.`time_stap`) BETWEEN '$datebeforeOneWeek' AND '$today' )";
	try {		
		$query = $dbh->prepare( "SELECT `compliance`.`description`, `compliance`.`act_id`, `act`.`name`, `compliance_ver`.`wef_date`, `act_fields`.`country`, `act_fields`.`state` FROM `compliance` JOIN `act` ON `act`.`id`=`compliance`.`act_id` JOIN `act_fields` ON `act_fields`.`act_id`=`act`.`id` JOIN `compliance_ver` ON `compliance`.`id`=`compliance_ver`.`id` WHERE `compliance`.`id`='$complianceID' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' ORDER BY `compliance_ver`.`sr` DESC LIMIT 1 " );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	} 
}

function getComplianceVerData($complianceID){
    $dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT * FROM `compliance_ver` WHERE `id`='$complianceID' AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' ORDER BY `sr` DESC LIMIT 1" );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	} 
}

function compareTwoData($a, $b, $columnName){
	// if($a == '' && $b == '-'){
		// return 1;
	// } else if($a == '-' && $b == ''){
		// return 1;
	// } else {
		$data = strcmp(trim($a), ($b));
		if($data == 0){
			return 1;
		} else {
			return dictionary($columnName);
		}
	// }
}

function get_decorated_diff($old, $new){
    $from_start = strspn($old ^ $new, "\0");        
    $from_end = strspn(strrev($old) ^ strrev($new), "\0");

    $old_end = strlen($old) - $from_end;
    $new_end = strlen($new) - $from_end;

    $start = substr($new, 0, $from_start);
    $end = substr($new, $new_end);
    $new_diff = substr($new, $from_start, $new_end - $from_start);  
    $old_diff = substr($old, $from_start, $old_end - $from_start);
	// if($old == '' && $new == '-'){
		// $new = $new;
	// } else if($old == '-' && $new == ''){
		// $new = $new;
	// } else {
		$new = "$start<del style='color:#cb0000'>$old_diff</del><ins style='color:#058e05'>$new_diff</ins>$end";
	// }
    // $old = "$start<del style='background-color:#ffcccc'>$old_diff</del>$end";
    return array("new"=>$new);
}

function getCompared($a, $b, $columnName){
    $data = strcmp(trim($a), trim($b));
    if($data == 0){
        return 1;
    } else {
        return dictionary($columnName);
    }
}


function compareTwoDataD($a, $b, $columnName){
    $data = strcmp(trim($a), trim($b));
    if($data == 0){
        return 1;
    } else {
        return $columnName;
    }
}

function getChangedData($cC){
    $change = array();
    $finalData = array();
    $compliance = getComplianceData($cC);
    $compliance_ver = getComplianceVerData($cC);
	if( strtotime($compliance['wef_date']) < strtotime($compliance_ver['wef_date']) ){
		$change[] = compareTwoData($compliance['description'], $compliance_ver['description'], 'description');
		$change[] = compareTwoData($compliance['department'], $compliance_ver['department'], 'department');
		$change[] = compareTwoData($compliance['app_geog'], $compliance_ver['app_geog'], 'app_geog');
		$change[] = compareTwoData($compliance['state'], $compliance_ver['state'], 'state');
		$change[] = compareTwoData($compliance['location'], $compliance_ver['location'], 'location');
		$change[] = compareTwoData($compliance['event'], $compliance_ver['event'], 'event');
		$change[] = compareTwoData($compliance['event_periodicity'], $compliance_ver['event_periodicity'], 'event_periodicity');
		$change[] = compareTwoData($compliance['application'], $compliance_ver['application'], 'application');
		$change[] = compareTwoData($compliance['exemption'], $compliance_ver['exemption'], 'exemption');
		$change[] = compareTwoData($compliance['section'], $compliance_ver['section'], 'section');
		$change[] = compareTwoData($compliance['sub_section'], $compliance_ver['sub_section'], 'sub_section');
		$change[] = compareTwoData($compliance['rule'], $compliance_ver['rule'], 'rule');
		$change[] = compareTwoData($compliance['rule_name'], $compliance_ver['rule_name'], 'rule_name');
		$change[] = compareTwoData($compliance['sub_head'], $compliance_ver['sub_head'], 'sub_head');
		$change[] = compareTwoData($compliance['criticality'], $compliance_ver['criticality'], 'criticality');
		$change[] = compareTwoData($compliance['periodicity'], $compliance_ver['periodicity'], 'periodicity');
		$change[] = compareTwoData($compliance['applicable_online'], $compliance_ver['applicable_online'], 'applicable_online');
		$change[] = compareTwoData($compliance['site'], $compliance_ver['site'], 'site');
		$change[] = compareTwoData($compliance['due_date'], $compliance_ver['due_date'], 'due_date');
		$change[] = compareTwoData($compliance['triggers'], $compliance_ver['triggers'], 'triggers');
		$change[] = compareTwoData($compliance['provision'], $compliance_ver['provision'], 'provision');
		$change[] = compareTwoData($compliance['agency'], $compliance_ver['agency'], 'agency');
		$change[] = compareTwoData($compliance['agency_add'], $compliance_ver['agency_add'], 'agency_add');
		$change[] = compareTwoData($compliance['key1'], $compliance_ver['key1'], 'key1');
		$change[] = compareTwoData($compliance['form_name'], $compliance_ver['form_name'], 'form_name');
		$change[] = compareTwoData($compliance['form_purpose'], $compliance_ver['form_purpose'], 'form_purpose');
		$change[] = compareTwoData($compliance['potential_impact'], $compliance_ver['potential_impact'], 'potential_impact');
		foreach (array_keys($change, '1') as $key) {
			unset($change[$key]);
		}
		$finalData[] = array('compid' => $cC, 'data' => $change);
	}
    return $finalData;
}

function getCountcomplianceVer($complianceid){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT COUNT(`compliance_ver`.`sr`) FROM `compliance_ver` WHERE `compliance_ver`.`id`='$complianceid' AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!=''" );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`compliance_ver`.`sr`)'];
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}

function getUserCompliance(){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$role = $_SESSION['user_role'];
	$usrid = get_user_by_id( $_SESSION['user_id'])['email'];
	$today = date('Y-m-d');
	$datebeforeOneWeek = date("Y-m-d", strtotime("-15 days"));	
	$dates = "( DATE(`compliance_ver`.`time_stap`) BETWEEN '$datebeforeOneWeek' AND '$today' )";
	
	try {
		if($role == 'Fpr'){
			$sql="SELECT DISTINCT(`company_compliance`.`compliance_id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`company_id` = '$company_id' AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `company_compliance`.`fpr_id`='$usrid' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) ORDER BY `compliance_ver`.`sr` DESC LIMIT 0,30";	   
		}elseif($role == 'Approver'){
			$sql="SELECT DISTINCT(`company_compliance`.`compliance_id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`company_id` = '$company_id' AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `company_compliance`.`appr_id`='$usrid' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) ORDER BY `compliance_ver`.`sr` DESC LIMIT 0,30";			
		}elseif($role == 'Hod'){
			$sql="SELECT DISTINCT(`company_compliance`.`compliance_id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`company_id` = '$company_id' AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `company_compliance`.`hod_id`='$usrid' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) ORDER BY `compliance_ver`.`sr` DESC LIMIT 0,30";			
		}else{
			$sql="SELECT DISTINCT(`company_compliance`.`compliance_id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`company_id` = '$company_id' AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) ORDER BY `compliance_ver`.`sr` DESC LIMIT 0,30";
		}
		$query = $dbh->prepare($sql);
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['compliance_id'];
		}
		return $rArray;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}


function getUserComplianceCount($user){
	$dbh = connect_db();
	$today = date('Y-m-d');
	// $datebeforeOneWeek = date("Y-m-d", strtotime("-1 week"));
	$datebeforeOneWeek = date("Y-m-d", strtotime("-15 days"));
	
	$dates = "( DATE(`compliance_ver`.`time_stap`) BETWEEN '$datebeforeOneWeek' AND '$today' )";
	try {
		$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`compliance_id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE (`company_compliance`.`fpr_id`='$user' OR `company_compliance`.`appr_id`='$user' OR `company_compliance`.`hod_id`='$user') AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) GROUP `company_compliance`.`compliance_id` BY ORDER BY `compliance_ver`.`sr`" );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`compliance_id`)'];
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}

//get act id for Management/Auditor
function getMaCompliance($companyid, $dL){
	$dbh = connect_db();
	$today = date('Y-m-d');
	// $datebeforeOneWeek = date("Y-m-d", strtotime("-1 week"));
	$datebeforeOneWeek = date("Y-m-d", strtotime("-15 days"));
	
	$dates = "( DATE(`compliance_ver`.`time_stap`) BETWEEN '$datebeforeOneWeek' AND '$today' )";
	try {
		$query = $dbh->prepare( "SELECT DISTINCT(`compliance_ver`.`id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id`  WHERE $dL AND $companyid AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) order by `company_compliance`.`act_id`, `company_compliance`.`compliance_id` ORDER BY `compliance_ver`.`sr` DESC LIMIT 0,30" );

		$query->bindValue(1, $companyid);
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['id'];
		}
		return $rArray;
	} catch (Exception $e) {
		return $e->getMessage(); 
	}
}

function getMaComplianceCount($companyid, $dL){
	$dbh = connect_db();
	$today = date('Y-m-d');
	// $datebeforeOneWeek = date("Y-m-d", strtotime("-1 week"));
	$datebeforeOneWeek = date("Y-m-d", strtotime("-15 days"));
	
	$dates = "( DATE(`compliance_ver`.`time_stap`) BETWEEN '$datebeforeOneWeek' AND '$today' )";
	try {
		$query = $dbh->prepare( "SELECT COUNT(`compliance_ver`.`id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id`  WHERE $dL AND $companyid AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) order by `company_compliance`.`act_id`, `company_compliance`.`compliance_id` GROUP `company_compliance`.`compliance_id` ORDER BY `compliance_ver`.`sr`" );

		$query->bindValue(1, $companyid);
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`compliance_ver`.`id`)'];
	} catch (Exception $e) {
		return $e->getMessage(); 
	}
}


//get act id for Admin
function getAllCompliance($company_id){
	$dbh = connect_db();
	$today = date('Y-m-d');
	// $datebeforeOneWeek = date("Y-m-d", strtotime("-1 week"));
	$datebeforeOneWeek = date("Y-m-d", strtotime("-15 days"));
	
	$dates = "( DATE(`compliance_ver`.`time_stap`) BETWEEN '$datebeforeOneWeek' AND '$today' )";
	try {
		$query = $dbh->prepare( "SELECT DISTINCT(`compliance_ver`.`id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE $company_id AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) ORDER BY `compliance_ver`.`sr` DESC LIMIT 0,30");
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['id'];
		}
		return $rArray;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}

function getAllComplianceCount($company_id){
	$dbh = connect_db();
	$today = date('Y-m-d');
	// $datebeforeOneWeek = date("Y-m-d", strtotime("-1 week"));
	$datebeforeOneWeek = date("Y-m-d", strtotime("-15 days"));
	
	$dates = "( DATE(`compliance_ver`.`time_stap`) BETWEEN '$datebeforeOneWeek' AND '$today' )";
	try {
		$query = $dbh->prepare( "SELECT COUNT(`compliance_ver`.`id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE $company_id AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) GROUP `company_compliance`.`compliance_id` ORDER BY `compliance_ver`.`sr`");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`compliance_ver`.`id`)'];
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}

function getCompanies($user_id){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT DISTINCT(`Company_id`) FROM `user_role` WHERE `user_id`=? and `user_role`.Company_id != '8102019031119' and `user_role`.Company_id != '1442019052928' and `user_role`.Company_id != '890161907375' and `user_role`.Company_id != '32920190190'" );
		$query->bindValue(1, $user_id);
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['Company_id'];
		}
		return $rArray;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}

//get Admin users email
function selectAdmin(){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT DISTINCT(`user`.`email`) FROM `user` JOIN  `user_role` ON `user`.`user_id`=`user_role`.`user_id` WHERE `user`.`status`=1 and `user_role`.Company_id != '8102019031119' and `user_role`.Company_id != '1442019052928' and `user_role`.Company_id != '890161907375' and `user_role`.Company_id != '32920190190' AND `user_role`.`user_role`='Admin' and `user`.`email` != 'ankita@rsj.co.in' and `user`.`email` != 'askbrake@lexcomply.com' and `user`.`email` != 'compliance@rsj.co.in' and `user`.`email` != 'vishal.bansal@lexcomply.com' and `user`.`email` != 'cspankajkumar@gmail.com' and `user`.`email` != 'deeptijoshi90@gmail.com' and `user`.`email` != 'demo@lexcomply.com' and `user`.`email` != 'divyaverma@rsj.co.in' and `user`.`email` != 'dummy5@lexcomply.com' and `user`.`email` != 'info@spacindia.in' and `user`.`email` != 'kumarvijay1969@gmail.com' and `user`.`email` != 'menon.jayakrishnan@mindteck.com' and `user`.`email` != 'n.lakhotia@rediff.com' and `user`.`email` != 'NPH@lexcomply.com' and `user`.`email` != 'prakash@globalcanesugar.com' and `user`.`email` != 'shelly@rsj.co.in' and `user`.`email` != 'macit2009@gmail.com' and `user`.`email` != 'accounts@sumatilegal.com'  and `user`.`email` != 'mohnish@bcshettyco.com' and `user`.`email` != 'manoj.prasad@external.cnhind.com' and `user`.`email` != 'mansi.dhillon@nucleussoftware.com'  and `user`.`email` not like '%@saifasteners.com%' and `user`.`email` NOT LIKE '%@nucleussoftware.com%' and `user`.`email` not like '%@nucluessoftware.com%' and  `user`.`email` not like '%@rashtriyametal.com%' and  `user`.`email` not like '%@darcl%' and  `user`.`email` not like '%@siegwerk%'  and  `user`.`email` not like '%@rashtriyametal%' and  `user`.`email` not like '%@cjdarcl%' and  `user`.`email` not like '%@m.darcl%' and  `user`.`email` not like '%@M.DARCL%' and  `user`.`email` not like '%@CJDARCL%'" );
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['email'];
		}
		return $rArray;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}

function selectManagemmentAudi(){
	$companies = getQuery();
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT DISTINCT(`user`.`email`) FROM `user` JOIN  `user_role` ON `user`.`user_id`=`user_role`.`user_id` WHERE `user`.`status`=1 AND $companies AND (`user_role`.`user_role`='Management' OR `user_role`.`user_role`='Auditor') AND `user`.`email` != 'ankita@rsj.co.in' and `user`.`email` != 'askbrake@lexcomply.com' and `user`.`email` != 'compliance@rsj.co.in' and `user`.`email` != 'vishal.bansal@lexcomply.com' and `user`.`email` != 'cspankajkumar@gmail.com' and `user`.`email` != 'deeptijoshi90@gmail.com' and `user`.`email` != 'demo@lexcomply.com' and `user`.`email` != 'divyaverma@rsj.co.in' and `user`.`email` != 'dummy5@lexcomply.com' and `user`.`email` != 'info@spacindia.in' and `user`.`email` != 'kumarvijay1969@gmail.com' and `user`.`email` != 'menon.jayakrishnan@mindteck.com' and `user`.`email` != 'n.lakhotia@rediff.com' and `user`.`email` != 'NPH@lexcomply.com' and `user`.`email` != 'prakash@globalcanesugar.com' and `user`.`email` != 'shelly@rsj.co.in' and `user`.`email` != 'macit2009@gmail.com' and `user`.`email` != 'accounts@sumatilegal.com'  and `user`.`email` != 'mohnish@bcshettyco.com' and `user`.`email` != 'manoj.prasad@external.cnhind.com' and `user`.`email` != 'mansi.dhillon@nucleussoftware.com'  and `user`.`email` not like '%@saifasteners.com%' and `user`.`email` NOT LIKE '%@nucleussoftware.com%' and `user`.`email` not like '%@nucluessoftware.com%' and  `user`.`email` not like '%@rashtriyametal.com%' and  `user`.`email` not like '%@darcl%' and  `user`.`email` not like '%@siegwerk%'  and  `user`.`email` not like '%@rashtriyametal%' and  `user`.`email` not like '%@cjdarcl%' and  `user`.`email` not like '%@m.darcl%' and  `user`.`email` not like '%@M.DARCL%' and  `user`.`email` not like '%@CJDARCL%' " );
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['email'];
		}
		return $rArray;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}


//get user_id using users email
function getUserIId($useremail){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT `user_id` FROM `user` WHERE `email`=?" );
		$query->bindValue(1, $useremail);
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}

//get Location Department for Management/Auditor

function getLocationDepMange($email){
	$dbh = connect_db();
	try {
	    $query = $dbh->prepare("SELECT `location`, `department` FROM `company_compliance` WHERE (`fpr_id`=? OR `appr_id`=? OR `hod_id`=?) AND `status`=1 AND `act_id`!='99998' AND `act_id`!='99999' AND `status`!=2 AND `status`!=7 GROUP BY `location`, `department`");
	    $query->bindValue(1, $email);
	    $query->bindValue(2, $email);
	    $query->bindValue(3, $email);
	    $query-> execute();
	    $result = $query->fetchAll();
	    return $result;
	} catch (Exception $e) {
		return $e->getMessage(); 
	}
}

function getLocationDep($userid, $email){
	$dbh = connect_db();
	$locDep = getLocationDepMange($email); // Get Location/Department if user role is also as FPR/APPROVER/HoD
	$qu = array();
	foreach($locDep as $ld){
	    if($ld['location']!='' && $ld['department']!=''){
	        $qu[] = "(`location`='".$ld['location']."' AND `department`='".$ld['department']."')";
	    }
	}
	try {
		$query = $dbh->prepare( "SELECT `location`, `Department` FROM `user_role` WHERE `user_id`=? AND (`user_role`.`user_role`='Management' OR `user_role`.`user_role`='Auditor')" );
		$query->bindValue(1, $userid);
		$query->execute();
		$result = $query->fetchAll();
		$rcount = count($result);
		foreach($result as $r){
			$explodeLoc = explode(",",$r['location']);
			$explodeDep = explode(",",$r['Department']);
			for($i=0;$i<count($explodeLoc);$i++){
			    if($explodeLoc[$i]!='' && $explodeDep[$i]!=''){
			        $qu[] = "(`location`='$explodeLoc[$i]' AND `department`='$explodeDep[$i]')";
			    }
			}
		}
		$newArray = array_unique(array_filter($qu));
		$res = "( ";
		$m = 1;
		foreach($newArray as $nA){
		    if($m == 1){
		        $res .= $nA;
		    } else {
		        $res .= " OR ".$nA;
		    }
		    $m++;
		}
		$res .= " ) ";
		return $res;
	} catch (Exception $e) {
		return $e->getMessage(); 
	}
}


function getActNameComp($actid){
	$dbh = connect_db();
    try{
		$query = $dbh->prepare("SELECT `name` FROM `act` WHERE `id`=?");
        $query->bindValue(1, $actid);
        $query->execute();
        $result = $query->fetchColumn();
		return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
      
}
function getChangedDataDetails($cC){
	$change = array();
	$compliance = getComplianceData($cC);
	$compliance_ver = getComplianceVerData($cC);
	if(strtotime($compliance['wef_date']) < strtotime($compliance_ver['wef_date'])){
		$change[] = compareTwoDataD($compliance['description'], $compliance_ver['description'], 'description');
		$change[] = compareTwoDataD($compliance['department'], $compliance_ver['department'], 'department');
		$change[] = compareTwoDataD($compliance['app_geog'], $compliance_ver['app_geog'], 'app_geog');
		$change[] = compareTwoDataD($compliance['state'], $compliance_ver['state'], 'state');
		$change[] = compareTwoDataD($compliance['location'], $compliance_ver['location'], 'location');
		$change[] = compareTwoDataD($compliance['event'], $compliance_ver['event'], 'event');
		$change[] = compareTwoDataD($compliance['event_periodicity'], $compliance_ver['event_periodicity'], 'event_periodicity');
		$change[] = compareTwoDataD($compliance['application'], $compliance_ver['application'], 'application');
		$change[] = compareTwoDataD($compliance['exemption'], $compliance_ver['exemption'], 'exemption');
		$change[] = compareTwoDataD($compliance['section'], $compliance_ver['section'], 'section');
		$change[] = compareTwoDataD($compliance['sub_section'], $compliance_ver['sub_section'], 'sub_section');
		$change[] = compareTwoDataD($compliance['rule'], $compliance_ver['rule'], 'rule');
		$change[] = compareTwoDataD($compliance['rule_name'], $compliance_ver['rule_name'], 'rule_name');
		$change[] = compareTwoDataD($compliance['sub_head'], $compliance_ver['sub_head'], 'sub_head');
		$change[] = compareTwoDataD($compliance['criticality'], $compliance_ver['criticality'], 'criticality');
		$change[] = compareTwoDataD($compliance['periodicity'], $compliance_ver['periodicity'], 'periodicity');
		$change[] = compareTwoDataD($compliance['applicable_online'], $compliance_ver['applicable_online'], 'applicable_online');
		$change[] = compareTwoDataD($compliance['site'], $compliance_ver['site'], 'site');
		$change[] = compareTwoDataD($compliance['due_date'], $compliance_ver['due_date'], 'due_date');
		$change[] = compareTwoDataD($compliance['triggers'], $compliance_ver['triggers'], 'triggers');
		$change[] = compareTwoDataD($compliance['provision'], $compliance_ver['provision'], 'provision');
		$change[] = compareTwoDataD($compliance['agency'], $compliance_ver['agency'], 'agency');
		$change[] = compareTwoDataD($compliance['agency_add'], $compliance_ver['agency_add'], 'agency_add');
		$change[] = compareTwoDataD($compliance['key1'], $compliance_ver['key1'], 'key1');
		$change[] = compareTwoDataD($compliance['form_name'], $compliance_ver['form_name'], 'form_name');
		$change[] = compareTwoDataD($compliance['form_purpose'], $compliance_ver['form_purpose'], 'form_purpose');
		$change[] = compareTwoDataD($compliance['potential_impact'], $compliance_ver['potential_impact'], 'potential_impact');
		foreach (array_keys($change, '1') as $key) {
			unset($change[$key]);
		}
	}
	return $change;
}


function hideacts() {
	$dbh = connect_db();
	
  try {
   	  $query = $dbh->prepare("SELECT act_id FROM `act_hide`");
	   $query->bindValue();
      $query->execute();
	$result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_country_rt() {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
  try {
   	  $query = $dbh->prepare("SELECT `act_fields`.`country` FROM `act_fields` inner join company_act on company_act.act_id = act_fields.act_id WHERE `act_fields`.`country` != '' and company_act.company_id = $company_id and act_fields.category != 'internal' group by `act_fields`.country");
      $query->execute();
	$result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function getComplinceByActids(){
	$dbh = connect_db();
	$today = date('Y-m-d');
	$datebeforeOneWeek = date("Y-m-d", strtotime("-30 days"));
	$role = $_SESSION['user_role'];
	$company_id = $_SESSION['company_id'];
	$user = get_user_by_id( $_SESSION['user_id'])['email'];
	$dates = "( DATE(`compliance_ver`.`time_stap`) BETWEEN '$datebeforeOneWeek' AND '$today' )";
	try {
		if($role == 'Fpr'){
			$sql = "SELECT DISTINCT(`company_compliance`.`compliance_id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE (`company_compliance`.`fpr_id`='$user') AND `company_compliance`.`company_id`='$company_id' AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) ORDER BY `compliance_ver`.`sr` DESC LIMIT 0,30";	   
		}elseif($role == 'Approver'){
			$sql = "SELECT DISTINCT(`company_compliance`.`compliance_id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE (`company_compliance`.`appr_id`='$user') AND `company_compliance`.`company_id`='$company_id' AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) ORDER BY `compliance_ver`.`sr` DESC LIMIT 0,30";			
		}elseif($role == 'Hod'){
			$sql = "SELECT DISTINCT(`company_compliance`.`compliance_id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE (`company_compliance`.`hod_id`='$user') AND `company_compliance`.`company_id`='$company_id' AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7 AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) ORDER BY `compliance_ver`.`sr` DESC LIMIT 0,30";
			
		}else{
			$sql="SELECT DISTINCT(`company_compliance`.`compliance_id`) FROM `compliance_ver` JOIN `company_compliance` ON `company_compliance`. `compliance_id`= `compliance_ver`.`id` WHERE `company_compliance`.`status`!=2 AND `company_compliance`.`company_id`='$company_id' AND  `company_compliance`.`status`!=7 AND `company_compliance`.`act_id`!='99998' AND `company_compliance`.`act_id`!='99999' AND $dates AND YEAR(`compliance_ver`.`wef_date`)!='2016' AND `compliance_ver`.`wef_date`!='' AND `compliance_ver`.`act_id` NOT IN (SELECT DISTINCT(`act_id`) FROM `act_hide`) ORDER BY `compliance_ver`.`sr` DESC LIMIT 0,30";
		}		
		$query = $dbh->prepare($sql);
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['compliance_id'];
		}
		return $rArray;
	} catch (PDOException $e) {
		return $e->getMessage(); 
	}
}

$counter = 1;

//$today		= date('Y-m-d');
//$lastdate	= date('Y-m-d', strtotime("-30 day"));
//$company_id = $_SESSION['company_id'];
//$role = $_SESSION['user_role'];
//$usrid = get_user_by_id( $_SESSION['user_id'])['email'];
//echo "select compliance.due_date,compliance.timestampp,compliance.id, compliance.sub_head, compliance.description,compliance.periodicity, compliance.criticality, compliance.legal_date,act.name as actname, act.date as actdate,act.id as actid,act_fields.country as country from compliance inner join act on act.id=compliance.act_id inner join company_act on company_act.act_id = compliance.act_id inner join act_fields on act_fields.act_id = compliance.act_id inner join company_compliance on company_compliance.compliance_id = compliance.id where compliance.timestampp between '$lastdate' and '$today' and company_act.company_id = $company_id and legal_date != '' and company_compliance.fpr_id = '$usrid' ";
?>

<style>
#outer {
    width: 100%;
    text-align: center;
}
.inner {
    display: inline-block;
	background: #5c3d87db;
}
.grey-botton, .button1 {
    background-color: rgba(3,3,3,0.5);
    color: #ffffff !important;
}
.primary-button, .grey-botton, .button2, .button1 {
    border-radius: 5px;
    background-color: var(--main-color);
    border: none;
    color: #FFFFFF;
    width: auto;
    cursor: pointer;
    font-weight: 400;
    display: inline-block;
    justify-content: center;
    align-items: center;
    padding: 8px 30px;
    height: 40px;
}
.grey-botton:hover, .button1 {
    background-color: #4f2d7f;
    transition: all 0.5s ease;
    color: #fff;
}
.table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th, .table>thead>tr>td, .table>thead>tr>th{
	border-top: none;
}
.input-group-addon{
	background-color: transparent;
    border: none;
}
.select2-container--default .select2-selection--single{
	border-radius: 1px;
	border: 1px solid #b1bac0;
}
.select2-container .select2-selection--single{
	height: 33px;
}
</style>
<div class="page page-ui-tiles">
	<section class="tile">
		<!-- tile header -->
		<div class="tile-header dvd dvd-btm">
			<h1 class="custom-font"><strong>Compliance Revisions</strong></h1>
			
		</div>
		<!-- tile body -->
		<div class="tile-body">
			<div class="form-group">
	<!-- Insert code -->	
<section class="tile" >
		<!-- tile body -->
		<div class="tile-body">
			<div class="form-group" >
				<form id="revisionFrom">
				<table class="table">
					<tr>
						<td><span class="">Country</span> </td>
						<td> <select name="country" id="country" class="form-control">
				<option value="0"></option>
				<?php 
				$fdep=get_country_rt();
				foreach($fdep as $ie){									
				?>
				<option value="<?=$ie['country']?>"><?=$ie['country']?></option>
				<?php	} ?>
				</select></td>
					<td><span class="">Act</span></td>
					<td><select name="act" id="vvalueq" class="form-control">
				<option value="0"></option>
								<optgroup label="Central Act(s)">
                                <?php
									$row=get_central_act_select_list_by_company_id( $company_id );
									foreach($row as $key)
									{
										$act=get_act_by_id($key['act_id']); ?>
										<option value="<?=$act['id'];?>"><?=$act['name'];?></option>
							  <?php } ?>
                                </optgroup>
                                <optgroup label="State Act(s)">
								<?php
									$row=get_state_act_select_list_by_company_id( $company_id );
									foreach($row as $key)
									{
										$act=get_act_by_id($key['act_id']);?>
										<option value="<?=$act['id'];?>">[<?=$act['state'];?>]&nbsp;<?=$act['name'];?></option>
								<?php } ?>
                                </optgroup>
                                
				</select></td>
				
					</tr>
				
				</table>
				
				
				
				<div class="form-group input-group">
				<span class="input-group-addon">Keyword</span><input type="text" class="form-control" id="realtxt"  placeholder="Search">
                    
				</div>
				

				<div class="col-md-12" style="text-align:right;">
					
					<span class="input-group-btn ">
						<a class="btn btn-primary"  name="search" type="submit"  onclick="freehandComplianceRevesions()">Search</a>
						<button class="btn btn-warning" type="button" onclick="archiveFormreset();">Clear</button>
						
					</span>
					
                </div> 
				
                                            
												
												                                           
            </div>
									 
		</div>
		</form>
		<!-- /tile body -->

	</section>



	
            </div>									 
		</div>	

<?php 
$urllex = 'https://lexcomply.com/compliance_list_for_mail_gtcms_api.php';
$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, $urllex);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
curl_setopt($curl, CURLOPT_HEADER, false);
$datalex = curl_exec($curl);
curl_close($curl);
$complianceID = json_decode($datalex); // get compliance data to filter


?>
		
		<!-- /tile body -->
		<section id = "cntRevisions">
<form target="_blank" method="post" action="export_excel_compliance_revisions.php">
	<input type="text" value="<?php foreach(getComplinceByActids() as $rs1){ 
	$cid = $rs1;
	if( !in_array($cid, $complianceID) ){
	echo ','.$cid; 
	}
	}
	?>" id="sr" name="sr" hidden>
	<input type="submit" value="Export To Excel" class="btn btn-success pull-right" formtarget="_blank"/>
	</form>
		<table class="table table-bordered" cellspacing="0" width="100%" style='table-layout: fixedX;'>
                        <thead class="bg-green" style="background-color:#4f2d7f !important;">
                            <tr>
                                <th>S.No</th>
								<th>Act Name</th>
								<th>Country</th>
								<th>State</th>
								<th>Compliance ID</th>
								<th>Compliance Description</th>
								<th>Change Effective From</th>
								<th>Heading/s Impacted</th>
								<th>View</th>
                            </tr>
                        </thead>
                        <tbody id="new_complianceAdd">
						<?php
						foreach(getComplinceByActids() as $userCompliance){
							$cid = $userCompliance;
							if( !in_array($cid, $complianceID) ){
								$comcount = getCountcomplianceVer($userCompliance);
								if($comcount>1){
									$finalData = getChangedData($userCompliance);
									$mailContent = "";
									$m = 1;
									foreach($finalData as $fD){
										$complianceData = getComplianceDataDetail($fD['compid']);
										$actid = $complianceData['act_id'];
										if($complianceData['state']!=''){
											$state = $complianceData['state'];
										} else {
											$state ='-';
										}
										$changedColumns = '';
										$i = 1;
										foreach($fD['data'] as $column){
											if($i == 1){
												$changedColumns .= $column;
											} else {
												$changedColumns .= ", ".$column;
											}
											$i++;
										}
										if($changedColumns!=''){
										?>
											<tr>						  
												<td><?php echo $counter;?></td>
												<td><?php echo $complianceData['name']; ?></td>
												<td><?php echo $complianceData['country'];?></td>                   
												<td><?php echo $state;?></td>
												<td><?php echo $fD['compid'];?></td>										
												<td><?php echo $complianceData['description']?></td>
												<td><?php echo $complianceData['wef_date']?></td>
												<td><?php echo $changedColumns; ?></td>
												<td><a href="javascript:void(0);" id="dormate" onclick="view_revisions_details(<?=$fD['compid'];?>)"  data-toggle="modal" data-target="#modalpopup" data-toggle="tooltip" title="Take Action For Events"><i class="fa fa-eye"></i></a></td>
											</tr>
										<?php
										$counter++;
										}
									
									}
								}
						
							} 
						} 
						?>
                        </tbody>
                    </table>
				<div id="filterdata"></div>
			</section>
	
</div>