<?php  
// include "include/header.php";
$host = $_SERVER['HTTP_HOST'];
$protocol = strpos(strtolower($_SERVER['SERVER_PROTOCOL']),'https')=== FALSE ? 'http' : 'https';
function get_min_live_date_company_all(){
  $dbh = connect_db(); 
  try {
	$company_id	= $_SESSION['company_id'];
    $query = $dbh->prepare("SELECT min(live_date) as live from `company_compliance` where company_id =? and live_date != '' ");
	$query->bindValue(1, $company_id);
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result['live'];
	}
	catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_user_departmnet($fpr,$appr ) {
	$dbh = connect_db();
	try {
		$company=$_SESSION['company_id'];
		$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE company_id=? and fpr_id=? and appr_id=? and status !=?" );
		$query->bindValue(1, $company);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $appr);
		$query->bindValue(4, 2);
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
function get_compliances_id_by_act_id_2_loc($fpr, $appr ) {
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select cc.location as location from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%'   and cc.`company_id`=? and cc.`cycle_id`='0' and cc.fpr_id=? and cc.appr_id=? group by cc.location" );
		$query->bindValue(1, $company_id);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $appr);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_attached_no_by_sr( $id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select count(id) as count from `evedance_docs` where `company_compliance_id`=?" );
    $query->bindValue( 1, $id );
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result['count'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}


function get_compliances_id_by_act_id_2($fpr, $appr ) {
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select cc.department as department from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%'   and cc.`company_id`=? and cc.`cycle_id`='0' and cc.fpr_id=? and cc.appr_id=? group by cc.department" );
		$query->bindValue(1, $company_id);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $appr);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function fetch_distinct_location_from_company_compliance_2( $company_id ){
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		$role=$_SESSION['user_role'];
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user['email'];			
			$query = $dbh->prepare("Select distinct location from company_compliance where company_id=? and fpr_id='$user_mail' and status != '2' and status = '7' and location!='' order by location");
		} else if(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct location from company_compliance where company_id=? and appr_id='$user_mail' and status != '2' and status = '7' and location!='' order by location");
		} else if(strtoupper($role)=="HOD"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct location from company_compliance where company_id=? and hod_id='$user_mail' and status != '2' and status = '7' and location!='' order by location");
		} else if(strtoupper($_SESSION['user_role'])==strtoupper('Management')){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct location from company_compliance where company_id=? and location!='' and status != '2' and status = '7' and $location_department order by location");
		} else if(strtoupper($_SESSION['user_role'])==strtoupper('Auditor')){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct location from company_compliance where company_id=? and location!='' and status != '2' and status = '7' and $location_department order by location");
		} else {
		  $query = $dbh->prepare("Select distinct location from company_compliance where company_id=? and location!='' and status != '2' and status = '7' order by location");
		}
		//$query = $dbh->prepare("Select distinct location from company_compliance where company_id=?");
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function fetch_distinct_auditor(){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try {		
		$query = $dbh->prepare("Select DISTINCT auditor_id from company_compliance where company_id=? and auditor_id!=''");
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();	
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function fetch_distinct_fpr_id_from_company_compliance_2( $company_id ){
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		$role=$_SESSION['user_role'];
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user['email'];			
			$query = $dbh->prepare("Select distinct fpr_id from company_compliance where company_id=? and fpr_id='$user_mail' and fpr_id!='' and status != '2' and status = '7' order by fpr_id");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct fpr_id from company_compliance where company_id=? and appr_id='$user_mail' and fpr_id!='' and status != '2' and status = '7' order by fpr_id");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct fpr_id from company_compliance where company_id=? and hod_id='$user_mail' and fpr_id!='' and status != '2' and status = '7' order by fpr_id");
		}elseif(strtoupper($_SESSION['user_role'])==strtoupper('Management')){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("Select distinct fpr_id from company_compliance where company_id=? and hod_id='$user_mail' and fpr_id!='' and status != '2' and status = '7' and $location_department order by fpr_id");
		}elseif(strtoupper($_SESSION['user_role'])==strtoupper('Auditor')){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("Select distinct fpr_id from company_compliance where company_id=? and hod_id='$user_mail' and fpr_id!='' and status != '2' and status = '7' and $location_department order by fpr_id");
		}else{
		  $query = $dbh->prepare("Select distinct fpr_id from company_compliance where company_id=? and fpr_id!='' and status != '2' and status = '7' order by fpr_id");
		}
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function fetch_distinct_department_from_company_compliance_2( $company_id ){
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		$role=$_SESSION['user_role'];
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user['email'];
			
			$query = $dbh->prepare("Select distinct department from company_compliance where company_id=? and fpr_id='$user_mail' and department!='' and status = '7' and status != '2' order by department");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct department from company_compliance where company_id=? and appr_id='$user_mail' and department!='' and status = '7' and status != '2' order by department");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct department from company_compliance where company_id=? and hod_id='$user_mail' and department!='' and status = '7' and status != '2' order by department");
		}elseif(strtoupper($_SESSION['user_role'])==strtoupper('Management')){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("Select distinct department from company_compliance where company_id=? and department!='' and $location_department and status != '2' and status = '7' order by department");
		}elseif(strtoupper($_SESSION['user_role'])==strtoupper('Auditor')){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("Select distinct department from company_compliance where company_id=? and department!='' and $location_department and status != '2' and status = '7' order by department");
		}else{
		  $query = $dbh->prepare("Select distinct department from company_compliance where company_id=? and department!='' and status != '2' and status = '7' order by department");
		}
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}  


function get_central_act_select_list_by_company_id_2( $company_id ) {
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	$user=get_user_by_id($user_id);
	$uemail=$user['email'];
	$dbh = connect_db();
	try {
		if(strtoupper(strtoupper($_SESSION['user_role']))=='FPR'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'central' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and company_compliance.fpr_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='APPROVER'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'central' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and company_compliance.appr_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='HOD'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'central' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and company_compliance.hod_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'central' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and $location_department ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'central' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and $location_department ORDER BY act.name ASC" );
		}else{
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'central' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? ORDER BY act.name ASC" );
		}
		$query->bindValue( 1, $company_id );
		//$query->bindValue( 2, 1 );
		$query->execute();
		$result = $query->fetchAll();
		//$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}	


function get_state_act_select_list_by_company_id_2( $company_id ) {
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	$user=get_user_by_id($user_id);
	$uemail=$user['email'];
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='FPR'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'state' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and company_compliance.fpr_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='APPROVER'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'state' AND company_compliance.status = '7' and company_compliance.status != '2'  AND company_compliance.company_id =? and company_compliance.appr_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='HOD'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'state' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and company_compliance.hod_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='Management'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'state' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and $location_department ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='Auditor'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'state' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and $location_department ORDER BY act.name ASC" );
		}else{
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'state' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? ORDER BY act.name ASC" );
		}
		$query->bindValue( 1, $company_id );
		//$query->bindValue( 2, 1 );
		$query->execute();
		$result = $query->fetchAll();
		//$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_local_act_select_list_by_company_id_2( $company_id ) {
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	$user=get_user_by_id($user_id);
	$uemail=$user['email'];
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='FPR'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'local' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and company_compliance.fpr_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='APPROVER'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'local' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and company_compliance.appr_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='HOD'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'local' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and company_compliance.hod_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='Management'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'local' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and $location_department ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='Auditor'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'local' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? and $location_department ORDER BY act.name ASC" );
		}else{
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = 'local' AND company_compliance.status = '7' and company_compliance.status != '2' AND company_compliance.company_id =? ORDER BY act.name ASC" );
		}
    
		$query->bindValue( 1, $company_id );
		//$query->bindValue( 2, 1 );
		$query->execute();
		$result = $query->fetchAll();
		//$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function fetch_distinct_appr_id_from_company_compliance_2( $company_id ){
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		$role=$_SESSION['user_role'];
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct appr_id from company_compliance where company_id=? and fpr_id='$user_mail' and appr_id!='' and status != '2' and status = '7'");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct appr_id from company_compliance where company_id=? and appr_id='$user_mail' and appr_id!='' and status != '2' and status = '7'");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct appr_id from company_compliance where company_id=? and hod_id='$user_mail' and appr_id!='' and status != '2' and status = '7'");
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct appr_id from company_compliance where company_id=?  and appr_id!='' and $location_department and status != '2' and status = '7' order by appr_id");
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct appr_id from company_compliance where company_id=? and appr_id!='' and $location_department and status != '2' and status = '7' order by appr_id");
		}else{
		  $query = $dbh->prepare("Select distinct appr_id from company_compliance where company_id=? and appr_id!='' and status != '2' and status = '7' order by appr_id");
		}
    //$query = $dbh->prepare("Select distinct appr_id from company_compliance where company_id=?");
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
  
  
function fetch_distinct_hod_id_from_company_compliance_2( $company_id ){
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		$role=$_SESSION['user_role'];
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct hod_id from company_compliance where company_id=? and fpr_id='$user_mail' and hod_id!='' order by hod_id");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct hod_id from company_compliance where company_id=? and appr_id='$user_mail' and hod_id!='' order by hod_id");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select distinct hod_id from company_compliance where company_id=? and hod_id='$user_mail' and hod_id!='' order by hod_id");
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("Select distinct hod_id from company_compliance where company_id=? and department!='' and $location_department and and hod_id!='' status != '2' and status = '7' order by hod_id");
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("Select distinct hod_id from company_compliance where company_id=? and department!='' and hod_id!='' and $location_department and status != '2' and status = '7' order by hod_id");
		}else{
		  $query = $dbh->prepare("Select distinct hod_id from company_compliance where company_id=? and hod_id!='' and status != '2' and status = '7' order by hod_id");
		}
    
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_all_compliance_by_1stdate_2nddate_company_id_view_reported_u( $date1, $date2, $company_id ) {
	$dbh = connect_db();
	try {
		$role=$_SESSION['user_role'];
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user['email'];			
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status='4' and `company_id`=? and fpr_id='$user_mail'");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status='4' and `company_id`=? and appr_id='$user_mail'");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status='4' and `company_id`=? and hod_id='$user_mail'");
		}else{
		  $query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status='4' and `company_id`=?");
		}
		$query->bindValue( 1, $date1);
		$query->bindValue( 2, $date2 );
		$query->bindValue( 3, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		// return $e->getMessage();
	}
}
function get_live_date_compliance_by_id( $id ) {
	$company	=	$_SESSION['company_id'];
	$dbh = connect_db();
	try {
    $query = $dbh->prepare( "select MIN(`live_date`) as live_date from `company_compliance` where `status` =4 and `company_id` = '$company' and `live_date` != '' and `live_date` != 'NULL' " );
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result['live_date'];
  } catch (Exception $e) {
    // return $e->getMessage();
  }
}


function get_all_compliance_by_1stdate_2nddate_company_id_next_due( $date1, $date2, $company_id, $statusx ) {
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		$role=$_SESSION['user_role'];
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user['email'];
			
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status!='2' and status!='7' and `company_id`=? and fpr_id='$user_mail' $statusx order by DATE(due_date) desc");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status='4' and `company_id`=? and appr_id='$user_mail' $statusx order by DATE(due_date) desc");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status!='2' and status!='7' and `company_id`=? and hod_id='$user_mail' $statusx order by DATE(due_date) desc");
		}elseif(strtoupper($role)=="MANAGEMENT"){ 
			$user_mail=$user['email'];
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status!='2' and status!='7' and `company_id`=? $statusx and $location_department order by DATE(due_date) desc");
		}elseif(strtoupper($role)=="AUDITOR"){ 
			$user_mail=$user['email'];
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status!='2' and status!='7' and `company_id`=? $statusx and $location_department order by DATE(due_date) desc");					
		}else{
		  $query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status!='2' and status!='7' and `company_id`=? $statusx order by DATE(due_date) desc");
		}
		$query->bindValue( 1, $date1);
		$query->bindValue( 2, $date2 );	
		$query->bindValue( 3, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_all_compliance_by_1stdate_2nddate_company_id_next( $date1, $date2, $company_id, $statusx ) {
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		$role=$_SESSION['user_role'];
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user['email'];
			
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status!='2' and status!='7' and `company_id`=? and fpr_id='$user_mail' $statusx order by due_date desc");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status='4' and `company_id`=? and appr_id='$user_mail' $statusx order by due_date desc");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status!='2' and status!='7' and `company_id`=? and hod_id='$user_mail' $statusx order by due_date desc");
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status!='2' and status!='7' and `company_id`=? $statusx and $location_department order by due_date desc");
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){ 
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status!='2' and status!='7' and `company_id`=? $statusx and $location_department order by due_date desc");
		}else{
		  $query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status!='2' and status!='7' and `company_id`=? $statusx order by due_date desc");
		}
		$query->bindValue( 1, $date1);
		$query->bindValue( 2, $date2 );	
		$query->bindValue( 3, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_all_compliance_by_1stdate_2nddate_company_id_view_reported_next( $date1, $date2, $company_id, $statusx ) {
	$dbh = connect_db();
	try {
		$role=$_SESSION['user_role'];
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user['email'];			
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status='4'  and `company_id`=? and fpr_id='$user_mail' $statusx");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status='4'  and `company_id`=? and appr_id='$user_mail' $statusx");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status='4'  and `company_id`=? and hod_id='$user_mail' $statusx");
		}else{
		  $query = $dbh->prepare("SELECT * FROM `company_compliance` where `due_date` BETWEEN ? And ? and status='4'  and `company_id`=? $statusx");
		}
		$query->bindValue( 1, $date1);
		$query->bindValue( 2, $date2 );	
		$query->bindValue( 3, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

//Auditor
//Management
// status will be 'compliant', 'due', 'over' only for management section
function management_event_cycle_newTest($status='compliant', $userRole) {
	$dbh = connect_db();
	$today			= date('Y-m-d');
	$prev_date_s 	= date('Y-m-d', strtotime($today .' -1 day'));
	$p10date		= date('Y-m-d', strtotime("+10 day"));
	$first_date 	= '1970-01-01';
	if($status == 'due'){
		$statusr = " status !=7 and due_date between '$today' and '$p10date'";
	}elseif($status == 'over'){
		$statusr = " status !=7 and due_date between '$first_date' and '$prev_date_s'";
	}else{
		$statusr = " status =7 ";
	}
	try {
		$user_id		= $_SESSION['user_id']; 
		$company_id		= $_SESSION['company_id'];
		
		$query = $dbh->prepare("SELECT Department,location FROM `user_role` WHERE Company_id='$company_id' and user_id='$user_id' and user_role='$userRole'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		$str	= $result['Department']; $str2	= $result['location']; $dep	= explode(',',$str); $loc	= explode(',',$str2);
		$res	= "SELECT `hod_id` FROM `company_compliance` WHERE `company_id`='$company_id'  and ( ";
		for($i=0;$i<count($dep);$i++){
			if($i == 0){
				$res.=" (`location`='$loc[$i]' and `department`='$dep[$i]')";
			}else{
				$res.=" or (`location`='$loc[$i]' and `department`='$dep[$i]')";
			}		
		}
		$res.= ' ) GROUP by `hod_id`'; 
		$query = $dbh->prepare("$res");
		$query->execute();
		$result2 = $query->fetchAll();
		$res2	= "SELECT `fpr_id`,`appr_id` FROM `company_compliance` WHERE `company_id`='$company_id' and ";
		$il = 1;
		foreach($result2 as $hod){
			$hodq	= $hod['hod_id'];
			if($il == 1){
				$res2.=" ( `hod_id`='$hodq'";
			}else{
				$res2.=" or `hod_id`='$hodq'";
			}
			$il++;
		}
		$res2.= ' ) GROUP by `fpr_id`,`appr_id`'; 
		$query = $dbh->prepare("$res2");
		$query->execute();
		$result3 = $query->fetchAll();
		$res3	= "SELECT sr FROM `company_compliance` WHERE `company_id`='$company_id' and ";
		$ir = 1;
		foreach($result3 as $rlk){
			$fpr_id		= $rlk['fpr_id']; $appr_id	= $rlk['appr_id'];
			if($ir== 1){
				$res3.=" (`fpr_id`='$fpr_id' and `appr_id`='$appr_id' and act_id = 99999 and $statusr";
			}else{
				$res3.=" or `fpr_id`='$fpr_id' and `appr_id`='$appr_id' and act_id = 99999 and $statusr";
			}
			$ir++;
		}
		$res3.= ' ) ';
		$query = $dbh->prepare("$res3");
		$query->execute();
		$result4 = $query->fetchAll();
		if($result4){
			$resNum = "";
			foreach($result4 as $i){
				foreach(array_unique($i) as $j){
					$resNum .=$j.",";
				}
			}
			$resArray = explode(",",$resNum); $countNum = count($resArray); $srString = ""; $lastItem = $countNum - 2;
			$srString = " OR (";
			for($i = 0; $i < $countNum; $i++){
				if($i == $lastItem){
					$srString .= "`sr`=".$resArray[$i];
				} else if( $resArray[$i]!="" && $i < $lastItem){
					$srString .= "`sr`=".$resArray[$i]." OR ";
				}
			}
			$srString .= ")";
		}else {
			$srString = "";
		}
		return $srString;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}



function management_event_cycle_newFpr($status='compliant', $fpr, $userRole) {
	$dbh = connect_db();
	$today			= date('Y-m-d');
	$prev_date_s 	= date('Y-m-d', strtotime($today .' -1 day'));
	$p10date		= date('Y-m-d', strtotime("+10 day"));
	$first_date 	= '1970-01-01';
	if($status == 'due') {
		$statusr = " status !=7 and due_date between '$today' and '$p10date'";
	}elseif($status == 'over'){
		$statusr = " status !=7 and due_date between '$first_date' and '$prev_date_s'";
	}else{
		$statusr = " status =7 ";
	}
	try {
		$user_id		= $_SESSION['user_id']; $company_id		= $_SESSION['company_id'];
		$query = $dbh->prepare("SELECT Department,location FROM `user_role` WHERE Company_id='$company_id' and user_id='$user_id' and user_role='$userRole'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		$str	= $result['Department']; $str2	= $result['location']; $dep	= explode(',',$str); $loc	= explode(',',$str2);
		$res	= "SELECT `company_compliance`.`hod_id` FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company_id'  and ( ";
		for($i=0;$i<count($dep);$i++){
			if($i == 0){
				$res.=" (`company_compliance`.`location`='$loc[$i]' and `company_compliance`.`department`='$dep[$i]')";
			}else{
				$res.=" or (`company_compliance`.`location`='$loc[$i]' and `company_compliance`.`department`='$dep[$i]')";
			}		
		}
		$res.= ' ) GROUP by `company_compliance`.`hod_id`'; 
		$query = $dbh->prepare("$res");
		$query->execute();
		$result2 = $query->fetchAll();
		$res2	= "SELECT `company_compliance`.`fpr_id` FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company_id' and ";
		$il = 1;
		foreach($result2 as $hod){
			$hodq	= $hod['hod_id'];
			if($il == 1){
				$res2.=" ( `company_compliance`.`hod_id`='$hodq'";
			}else{
				$res2.=" or `company_compliance`.`hod_id`='$hodq'";
			}
			$il++;
		}
		$res2.= ' ) GROUP by `company_compliance`.`fpr_id`'; 
		$query = $dbh->prepare("$res2");
		$query->execute();
		$result3 = $query->fetchAll();
		$fpr_id = array();
		foreach($result3 as $rlk){
			$fpr_id	[]= $rlk['fpr_id'];
		}		
		if(in_array($fpr, $fpr_id)){
			$res3	= "SELECT sr FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company_id' and `company_compliance`.`fpr_id`='$fpr' and act_id = 99999 and $statusr";
			$query = $dbh->prepare("$res3");
			$query->execute();
			$result4 = $query->fetchAll();
			if($result4){
				$resNum = "";
				foreach($result4 as $i){
					foreach(array_unique($i) as $j){
						$resNum .=$j.",";
					}
				}
				$resArray = explode(",",$resNum); $countNum = count($resArray); $srString = ""; $lastItem = $countNum - 2;
				$srString = " OR (";
				for($i = 0; $i < $countNum; $i++){
					if($i == $lastItem){
						$srString .= "`sr`=".$resArray[$i];
					} else if( $resArray[$i]!="" && $i < $lastItem){
						$srString .= "`sr`=".$resArray[$i]." OR ";
					}
				}
				$srString .= ")";
			} else {
				$srString="";
			}
		} else{
			$srString="";
		}
		
		return $srString;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function management_event_cycle_newApr($status='compliant', $apr, $userRole) {
	$dbh = connect_db();
	$today			= date('Y-m-d');
	$prev_date_s 	= date('Y-m-d', strtotime($today .' -1 day'));
	$p10date		= date('Y-m-d', strtotime("+10 day"));
	$first_date 	= '1970-01-01';
	if($status == 'due'){
		$statusr = " status !=7 and status='4' and due_date between '$today' and '$p10date'";
	}elseif($status == 'over'){
		$statusr = " status !=7 and status='4' and due_date between '$first_date' and '$prev_date_s'";
	}else{
		$statusr = " status =7 ";
	}
	try {
		$user_id		= $_SESSION['user_id']; $company_id		= $_SESSION['company_id'];
		$query = $dbh->prepare("SELECT Department,location FROM `user_role` WHERE Company_id='$company_id' and user_id='$user_id' and user_role='$userRole'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		$str	= $result['Department']; $str2	= $result['location']; $dep	= explode(',',$str); $loc	= explode(',',$str2);
		$res	= "SELECT `company_compliance`.`hod_id` FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company_id'  and ( ";
		for($i=0;$i<count($dep);$i++){
			if($i == 0){
				$res.=" (`company_compliance`.`location`='$loc[$i]' and `company_compliance`.`department`='$dep[$i]')";
			}else{
				$res.=" or (`company_compliance`.`location`='$loc[$i]' and `company_compliance`.`department`='$dep[$i]')";
			}		
		}
		$res.= ' ) GROUP by `company_compliance`.`hod_id`'; 
		$query = $dbh->prepare("$res");
		$query->execute();
		$result2 = $query->fetchAll();
		$res2	= "SELECT `company_compliance`.`appr_id` FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company_id' and ";
		$il = 1;
		foreach($result2 as $hod){
			$hodq	= $hod['hod_id'];
			if($il == 1){
				$res2.=" ( `company_compliance`.`hod_id`='$hodq'";
			}else{
				$res2.=" or `company_compliance`.`hod_id`='$hodq'";
			}
			$il++;
		}
		$res2.= ' ) GROUP by `company_compliance`.`appr_id`'; 
		$query = $dbh->prepare("$res2");
		$query->execute();
		$result3 = $query->fetchAll();
		$appr_id = array();
		foreach($result3 as $rlk){
			$appr_id	[]= $rlk['appr_id'];
		}		
		if(in_array($apr, $appr_id)){
			// $gotcha = 1;
			$res3	= "SELECT sr FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company_id' and `company_compliance`.`appr_id`='$apr' and act_id = 99999 and $statusr";
			$query = $dbh->prepare("$res3");
			$query->execute();
			$result4 = $query->fetchAll();
			if($result4){
				$resNum = "";
				foreach($result4 as $i){
					foreach(array_unique($i) as $j){
						$resNum .=$j.",";
					}
				}
				$resArray = explode(",",$resNum); $countNum = count($resArray); $srString = ""; $lastItem = $countNum - 2;
				$srString = " OR (";
				for($i = 0; $i < $countNum; $i++){
					if($i == $lastItem){
						$srString .= "`sr`=".$resArray[$i];
					} else if( $resArray[$i]!="" && $i < $lastItem){
						$srString .= "`sr`=".$resArray[$i]." OR ";
					}
				}
				$srString .= ")";
			} else {
				$srString="";
			}
		} else{
			$srString="";
		}
		
		return $srString;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

// var_dump(management_event_cycle_newApr('compliant', 'demo@lexcomply.com'));


//Only for HoD section
function event_data_hod_new() {
 $dbh = connect_db();
  try {		
		$user_id		= get_user_by_id($_SESSION['user_id']);
		$user_email		= $user_id['email'];
		$company_id		= $_SESSION['company_id'];
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? and `hod_id`=? group by `fpr_id`,`appr_id`");
		$query->bindValue(1, $company_id);
		$query->bindValue(2, $user_email);
		$query->execute();
		$usersid = $query->fetchAll();
		$ir = 0;
		$res =" (";
		foreach($usersid as $usr){
			$appr 	= $usr['appr_id'];
			$fpr 	= $usr['fpr_id'];
			if($ir == 0){
				$res.=" (`company_compliance`.`appr_id`='$appr' and `company_compliance`.`fpr_id`='$fpr')";
			}else{
				$res.=" or (`company_compliance`.`appr_id`='$appr' and `company_compliance`.`fpr_id`='$fpr')";
			}
			$ir++;
		}
		$res.= ' )'; 
		return $res;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

// Conditional Compliance 
function get_count_compliance_all_conditional() {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($_SESSION['user_role'])=="FPR"){ 
			$user_mail=$user['email'];			
			$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? and status=? and due_date >? and fpr_id=?");
			$query->bindValue(4, $user_mail);
		} else if(strtoupper($_SESSION['user_role'])=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=?  and status=? and due_date >? and appr_id=?");
			$query->bindValue(4, $user_mail);
		} else if(strtoupper($_SESSION['user_role'])== 'HOD'){
			$location_department = event_data_hod_new();
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and `status`=? and `due_date` >? and $location_department and `due_date`!='' and `due_date`!='-' " );		
		} else if(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and `status`=? and `due_date` >? and $location_department and `due_date`!='' and `due_date`!='-' " ); 			
		} else if(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and `status`=? and `due_date` >? and $location_department and `due_date`!='' and `due_date`!='-' " ); 			
		} else {
			$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE company_id=? and status=? and due_date >? and `due_date`!='' and `due_date`!='-'");	
		}
		$query->bindValue(1, $company_id);
		$query->bindValue(2, 5);
		$query->bindValue(3, $mend); 
	
		$query->execute();
		$result = $query->fetchAll();
		return $result;		
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

// Overdue Compliance 
function get_count_compliance_all_overdue() {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$user = get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($_SESSION['user_role'])=="FPR"){ 
			$user_mail=$user['email'];			
			$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? and `due_date` BETWEEN ? and ? and status!='2' and status!='7' and status!='4' and fpr_id=? and `due_date`!='' and `due_date`!='-'  order by DATE(due_date) ASC");
			$query->bindValue(4, $user_mail);
		} else if(strtoupper($_SESSION['user_role'])=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? and `due_date` BETWEEN ? And ? and status='4' and appr_id=? and `due_date`!='' and `due_date`!='-'  order by DATE(due_date) ASC");
			$query->bindValue(4, $user_mail);
		} else if(strtoupper($_SESSION['user_role'])== 'HOD'){
			$location_department = event_data_hod_new();
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and (status='1' or status='3' or status='6'  or status='4' or status='5') and `due_date` BETWEEN ? and ? and $location_department and `due_date`!='' and `due_date`!='-' order by DATE(due_date) ASC" );		
		} else if(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newTest('over', 'Management');
			$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? and (status='1' or status='3' or status='6'  or status='4' or status='5') and `due_date` BETWEEN ? and ? and $location_department and `due_date`!='' and `due_date`!='-' $srNum order by DATE(due_date) ASC");			
		} else if(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newTest('over', 'Auditor');
			$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? and (status='1' or status='3' or status='6'  or status='4' or status='5') and `due_date` BETWEEN ? and ? and $location_department and `due_date`!='' and `due_date`!='-' $srNum order by DATE(due_date) ASC");			
		} else {
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and (status='1' or status='3' or status='6'  or status='4' or status='5') and `due_date` BETWEEN ? and ? and `due_date`!='' and `due_date`!='-'  order by DATE(due_date) ASC" );
		}
		$query->bindValue(1, $company_id);
		$query->bindValue(2, $fdaym);
		$query->bindValue(3, $yest);		
	
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

// Due Compliance 
function get_count_compliance_all_due() {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	
	$today = date("Y-m-d");
	$mend = date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {
		$user=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($_SESSION['user_role'])=="FPR"){ 
			$user_mail = $user['email'];			
			$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? and `due_date` BETWEEN ? and ? and status!='2' and status!='7' and status!='4' and fpr_id=? and `due_date`!='' and `due_date`!='-' order by DATE(due_date) ASC");
			$query->bindValue(4, $user_mail);
		} else if(strtoupper($_SESSION['user_role'])=="APPROVER"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? and `due_date` BETWEEN ? and ? and status='4' and appr_id=? and `due_date`!='' and `due_date`!='-' order by DATE(due_date) ASC");
			$query->bindValue(4, $user_mail);
		} else if(strtoupper($_SESSION['user_role'])=='HOD'){
			$location_department = event_data_hod_new();
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and (status='1' or status='3' or status='6'  or status='4' or status='5') and `due_date` BETWEEN ? and ? and $location_department and `due_date`!='' and `due_date`!='-' order by DATE(due_date) ASC" );		
		} else if(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newTest('due', 'Management');
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and (status='1' or status='3' or status='6'  or status='4' or status='5') and `due_date` BETWEEN ? and ? and $location_department and `due_date`!='' and `due_date`!='-' $srNum order by DATE(due_date) ASC" ); 
		} else if(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newTest('due', 'Auditor');
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and (status='1' or status='3' or status='6'  or status='4' or status='5') and `due_date` BETWEEN ? and ? and $location_department and `due_date`!='' and `due_date`!='-' $srNum order by DATE(due_date) ASC" ); 
		} else {
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and (status='1' or status='3' or status='6'  or status='4' or status='5') and `due_date` BETWEEN ? and ? and `due_date`!='' and `due_date`!='-' order by DATE(due_date) ASC" ); 
		}
		$query->bindValue(1, $company_id);
		$query->bindValue(2, $today);
		$query->bindValue(3, $mend);
		
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

// Compliant Compliance
function get_count_compliance_all_comp() {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	try {		
		if(strtoupper($_SESSION['user_role'])== 'HOD'){
			$location_department = event_data_hod_new();
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and `status`=?  and `due_date` >= date_time and $location_department and `due_date`!='' and `due_date`!='-'  " );		
		}else if(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newTest('compliant', 'Management');
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and `status`=?  and `due_date` >= date_time and $location_department and `due_date`!='' and `due_date`!='-' $srNum" );
		} else if(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newTest('compliant', 'Auditor');
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and `status`=?  and `due_date` >= date_time and $location_department and `due_date`!='' and `due_date`!='-' $srNum" );
		} else {
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and `status`=?  and `due_date` >= date_time and `due_date`!='' and `due_date`!='-' " );
		}
		$query->bindValue(1, $company_id);
		$query->bindValue(2, 7);
		
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

// Delayed Compliance
function get_count_compliance_all_noncomp() {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$location_department = event_data_hod_new();
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and `status`=? and `due_date` < date_time and $location_department and `due_date`!='' and `due_date`!='-' " );
		} else if(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` where `company_id`=? and `status`=? and `due_date` < date_time and $location_department and `due_date`!='' and `due_date`!='-' " );
		} else if(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` where `company_id`=? and `status`=? and `due_date` < date_time and $location_department and `due_date`!='' and `due_date`!='-' " );
		} else {
			$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `company_id`=? and `status`=? and `due_date` < date_time and `due_date`!='' and `due_date`!='-'  " );
		}
		$query->bindValue(1, $company_id);
		$query->bindValue(2, 7);
		
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
	
function getSr($dataArray, $columnName){
	foreach($dataArray as $da){
		$res .= $da[$columnName].",";
	}
	return $res;
}

//Conditional Compliance
$numOfconditionalcompliance = count(get_count_compliance_all_conditional());
$totalOfconditionalcompliance = get_count_compliance_all_conditional();
$srconditionalc = getSr($totalOfconditionalcompliance, 'sr');

//Overdue Compliance
$numOfoverduecompliance = count(get_count_compliance_all_overdue());
$totalOfoverduecompliance = get_count_compliance_all_overdue();
$sroverduec = getSr($totalOfoverduecompliance, 'sr');

//Due Compliance
$numOfduecompliance = count(get_count_compliance_all_due());
$totalOfduecompliance = get_count_compliance_all_due();
$srduec = getSr($totalOfduecompliance, 'sr');

//Compliant Compliance
$numOfcompliantcompliance = count(get_count_compliance_all_comp());
$totalOfcompliantcompliance = get_count_compliance_all_comp();
$srcompliantc = getSr($totalOfcompliantcompliance, 'sr');

//Delayed Compliance
$numOfdelayedcompliance = count(get_count_compliance_all_noncomp());
$totalOfdelayedcompliance = get_count_compliance_all_noncomp();
$srdelayedc = getSr($totalOfdelayedcompliance, 'sr');

//SumTotal Compliance
$sumTotalCompliance = $numOfconditionalcompliance + $numOfoverduecompliance + $numOfduecompliance + $numOfcompliantcompliance + $numOfdelayedcompliance;


/*user_dl_all*/
function get_fpr_company_compliance_details(){
	$dbh 		= 	connect_db();
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	try {
	  	$user2		=	get_user_by_id( $_SESSION['user_id'] );
		$user_mail	=	$user2['email'];
		if(strtoupper($_SESSION['user_role'])=="HOD"){
			$query = $dbh->prepare("SELECT distinct fpr_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and fpr_id != '' and hod_id = '$user_mail' ");
		}elseif(strtoupper($_SESSION['user_role'])=="MANAGEMENT"){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("SELECT distinct fpr_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and fpr_id != '' and $location_department ");
		}elseif(strtoupper($_SESSION['user_role'])=="AUDITOR"){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("SELECT distinct fpr_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and fpr_id != '' and $location_department");
		}elseif(strtoupper($_SESSION['user_role'])=="ADMIN"){
			$query = $dbh->prepare("SELECT distinct fpr_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and fpr_id != ''"); 
		}else {
			$query = $dbh->prepare("SELECT distinct fpr_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and fpr_id = ''");  
		}
		$query->bindValue( 1, $company_id); 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_appr_company_compliance_details(){
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	try {
	  	$user2		=	get_user_by_id( $_SESSION['user_id'] );
		$user_mail	=	$user2['email'];
		if(strtoupper($_SESSION['user_role'])=="HOD"){
			$query = $dbh->prepare("SELECT distinct appr_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and appr_id != '' and hod_id = '$user_mail' ");
		}elseif(strtoupper($_SESSION['user_role'])=="MANAGEMENT"){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("SELECT distinct appr_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and appr_id != '' and $location_department ");
		}elseif(strtoupper($_SESSION['user_role'])=="AUDITOR"){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("SELECT distinct appr_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and appr_id != '' and $location_department");
		}elseif(strtoupper($_SESSION['user_role'])=="ADMIN"){
			$query = $dbh->prepare("SELECT distinct appr_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and appr_id != ''"); 
		}else {
			$query = $dbh->prepare("SELECT distinct appr_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and appr_id = ''");  
		}
		$query->bindValue( 1, $company_id); 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_hod_company_compliance_details(){
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	try {
	  	$user2		=	get_user_by_id( $_SESSION['user_id'] );
		$user_mail	=	$user2['email'];
		if(strtoupper($_SESSION['user_role'])=="HOD"){
			$query = $dbh->prepare("SELECT distinct hod_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and hod_id != '' and hod_id = '$user_mail' ");
		}elseif(strtoupper($_SESSION['user_role'])=="MANAGEMENT"){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("SELECT distinct hod_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and hod_id != '' and $location_department ");
		}elseif(strtoupper($_SESSION['user_role'])=="AUDITOR"){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("SELECT distinct hod_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and hod_id != '' and $location_department");
		}elseif(strtoupper($_SESSION['user_role'])=="ADMIN"){
			$query = $dbh->prepare("SELECT distinct hod_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and hod_id != ''"); 
		}else {
			$query = $dbh->prepare("SELECT distinct hod_id FROM `company_compliance` WHERE `company_id`=? and status!=2 and hod_id = ''");  
		}
		$query->bindValue( 1, $company_id); 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_fpr_company_compliance_details_overdue($fprs) { 
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$hod_event= event_data_hod_new();
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6' or status='5') and due_date BETWEEN '$fdaym' and '$yest' and $hod_event and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and fpr_id= '$fprs'" );
			$m_event_compliant = 0;
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newFpr('over', $fprs, 'Management');
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6' or status='5') and due_date BETWEEN '$fdaym' and '$yest' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'  and fpr_id= '$fprs' and $location_department $srNum" ); 
			$m_event_compliant = 0;
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newFpr('over', $fprs, 'Auditor');
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6' or status='5') and due_date BETWEEN '$fdaym' and '$yest' and $location_department and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and fpr_id= '$fprs' $srNum" ); 
			$m_event_compliant = 0;
		}else{
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6' or status='5') and due_date BETWEEN '$fdaym' and '$yest' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and fpr_id= '$fprs'" ); 
			$m_event_compliant = 0;
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		$count = $result['count(*)'];
		$resultd = $m_event_compliant+$count;
		return $resultd;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_appr_company_compliance_details_overdue($fprs) {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$hod_event= event_data_hod_new();
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='4' and due_date BETWEEN '$fdaym' and '$yest' and $hod_event and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and appr_id= '$fprs'" );
			$m_event_compliant = 0;
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newApr('over', $fprs, 'Management');
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='4' and due_date BETWEEN '$fdaym' and '$yest' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and appr_id= '$fprs' and $location_department $srNum" ); 
			//$m_event_compliant = count(management_event_cycle('over'));
			//$m_event_compliant = 0;
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newApr('over', $fprs, 'Auditor');
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='4' and due_date BETWEEN '$fdaym' and '$yest' and $location_department and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and appr_id= '$fprs' $srNum" ); 
			$m_event_compliant = 0;
		}else{
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='4' and due_date BETWEEN '$fdaym' and '$yest' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and appr_id= '$fprs'" ); 
			$m_event_compliant = 0;
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		$count = $result['count(*)'];
		$resultd = $m_event_compliant+$count;
		return $resultd;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_hod_company_compliance_details_overdue($fprs) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	try {
		//$query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ? and hod_id= '$fprs' and `status`!= '2' and `status`!= '7' and `status`!= '5' and due_date BETWEEN '$fdaym' and '$yest'  " ); 
		//$hod_event= event_data_hod();
		$query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ?  and `status`!= '2' and `status`!= '7' and due_date BETWEEN '$fdaym' and '$yest' and (hod_id= '$fprs' or compliance_id=555)  " ); 
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_fpr_company_compliance_details_due($fprs) {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod_new();
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6' or status='5') and due_date BETWEEN '$today' and '$mend' and $hod_event and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and fpr_id= '$fprs'" );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newFpr('due', $fprs, 'Management');
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6' or status='5') and due_date BETWEEN '$today' and '$mend' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'  and fpr_id= '$fprs' and $location_department $srNum" ); 
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newFpr('due', $fprs, 'Auditor');
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6' or status='5') and due_date BETWEEN '$today' and '$mend' and $location_department and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and fpr_id= '$fprs' $srNum" ); 
		}else{
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6' or status='5') and due_date BETWEEN '$today' and '$mend' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and fpr_id= '$fprs'" ); 
		}		 	
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		$count = $result['count(*)'];
		$resultd = $count;
		return $resultd;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_appr_company_compliance_details_due($fprs) {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod_new();
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='4' and due_date BETWEEN '$today' and '$mend' and $hod_event and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and appr_id= '$fprs'" );
			$m_event_compliant = 0;
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newApr('due', $fprs, 'Management');
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='4' and due_date BETWEEN '$today' and '$mend' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and appr_id= '$fprs' and $location_department $srNum" ); 
			//$m_event_compliant = count(management_event_cycle('due'));
			$m_event_compliant = 0;
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newApr('due', $fprs, 'Auditor');	
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='4' and due_date BETWEEN '$today' and '$mend' and $location_department and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and appr_id= '$fprs' $srNum" ); 
			$m_event_compliant = 0;
		}else{
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='4' and due_date BETWEEN '$today' and '$mend' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and appr_id= '$fprs'" ); 
			$m_event_compliant = 0;
		}		 	
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		$count = $result['count(*)'];
		$resultd = $m_event_compliant+$count;
		return $resultd;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
function get_hod_company_compliance_details_due($fprs) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$fdaym=date("Y-m-d");
	$yest=date("Y-m-d",strtotime("+10 days"));
	try {
		//$hod_event= event_data_hod();
		$query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ? and (hod_id= '$fprs' or compliance_id=555) and `status`!= '2' and `status`!= '7' and due_date BETWEEN '$fdaym' and '$yest'  " ); 
		//$query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ? and hod_id= '$fprs' and `status`!= '2' and `status`!= '7' and due_date BETWEEN '$fdaym' and '$yest'  " ); 
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_fpr_company_compliance_details_delay($fprs) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try {
		$query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ? and fpr_id= '$fprs'  and `status` = '7' and due_date != '' and due_date < date_time" ); 
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_appr_company_compliance_details_delay($fprs) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try {
		$query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ? and appr_id= '$fprs' and `status` = '7' and due_date != '' and due_date < date_time" ); 
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_hod_company_compliance_details_delay($fprs) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try {
		$hod_event= event_data_hod_new();
		$query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ? and (hod_id= '$fprs' or compliance_id=555) and `status` = '7'  and due_date < date_time " ); 
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_fpr_company_compliance_details_compliant($fprs) {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod_new();
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='7'  and due_date >= date_time and $hod_event and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and fpr_id= '$fprs'" );
			$m_event_compliant = 0;
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newFpr('compliant', $fprs, 'Management');
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='7'  and due_date >= date_time and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and fpr_id= '$fprs' and $location_department $srNum" );
			// $m_event_compliant = count(management_event_cycle('compliant'));
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newFpr('compliant', $fprs, 'Auditor');
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='7'  and due_date >= date_time and $location_department and fpr_id= '$fprs' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' $srNum" );
		}else{
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='7'  and due_date >= date_time and fpr_id= '$fprs' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
			$m_event_compliant = 0;
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		$count = $result['count(*)'];
		$resultd = $count;
		return $resultd;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
//-- new 
function get_fpr_company_compliance_details_c_compliance($fprs) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$mend=date('Y-m-d', strtotime("+10 day"));	
	try {
		$sql="select count(sr) as count from `company_compliance` where `company_id`= $company_id and fpr_id= '$fprs'  and `status` = '5' and due_date >'$mend' and due_date != '' " ;
		$query = $dbh->prepare( $sql); 
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_appr_company_compliance_details_compliant($fprs) {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod_new();
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='7'  and due_date >= date_time and $hod_event and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and appr_id= '$fprs'" );
			$m_event_compliant = 0;
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newApr('compliant', $fprs, 'Management');
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='7'  and due_date >= date_time and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and appr_id= '$fprs' and $location_department $srNum" );
			$m_event_compliant = 0;
			//$m_event_compliant = count(management_event_cycle('compliant'));
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$srNum = management_event_cycle_newApr('compliant', $fprs, 'Auditor');	
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='7'  and due_date >= date_time and $location_department and appr_id= '$fprs' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' $srNum" );
			$m_event_compliant = 0;
		}else{
			$query = $dbh->prepare( "select count(*) from company_compliance where company_id='$company_id' and status='7'  and due_date >= date_time and appr_id= '$fprs' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
			$m_event_compliant = 0;
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		$count = $result['count(*)'];
		$resultd = $m_event_compliant+$count;
		return $resultd;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
//-- new 
function get_appr_company_compliance_details_c_comp($fprs) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$mend=date('Y-m-d', strtotime("+10 day"));	
	try {
		//  $query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ? and appr_id= '$fprs' and `status` = '4' and due_date != '' and status_fpr ='Conditional Compliance' " ); 
		$query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ? and appr_id= '$fprs' and `status` = '4' and due_date != '' and status_fpr ='Conditional Compliance' and due_date >'$mend' " ); 
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
function get_hod_company_compliance_details_compliant($fprs) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try {
		$hod_event= event_data_hod_new();
		$query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ? and (hod_id= '$fprs' or compliance_id=555) and `status` = '7' and due_date != '' and due_date >=  date_time " ); 
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
//-- new  
function get_hod_company_compliance_details_c_comp($fprs) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$mend=date('Y-m-d', strtotime("+10 day"));	
	try {
		//$hod_event= event_data_hod();
		$query = $dbh->prepare( "select count(sr) as count from `company_compliance` where `company_id`= ? and (hod_id= '$fprs' or compliance_id=555) and `status` = '5' and due_date >'$mend' " ); 
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
// change stop
function get_user_details_2($id) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select * from `user` where `email` = '$id'  " ); 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		if(!$result){ $rs = '<b style="color:red">Not Found</b>'; }else {
			if($result['status'] == 1){
				$rs = '<b style="color:green">Active</b>';
			}else {
				$rs = '<b style="color:red">Not Active</b>';
			}
		}
		return $rs;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_user_by_location_fpr_1($user) {
	$dbh = connect_db();
	$company = $_SESSION['company_id'];
	try {
		$query = $dbh->prepare( "select DISTINCT(`location`) from `company_compliance` where `company_id` = $company AND `status` != 2 AND `fpr_id` = '$user' AND `location` != '' " );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_user_by_department_fpr_1($user) {
	$dbh = connect_db();
	$company = $_SESSION['company_id'];
	try {
		$query = $dbh->prepare( "select DISTINCT(`department`) from `company_compliance` where `company_id` = $company AND `status` != 2 AND `fpr_id` = '$user' AND `department` != '' " );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_user_by_location_appr_1($user) {
	$dbh = connect_db();
	$company = $_SESSION['company_id'];
	try {
		$query = $dbh->prepare("select DISTINCT(`location`) from `company_compliance` where `company_id` = $company AND `status` != 2 AND `appr_id` = '$user' AND `location` != '' " );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_user_by_department_appr_1($user) {
	$dbh = connect_db();
	$company = $_SESSION['company_id'];
	try {
		$query = $dbh->prepare( "select DISTINCT(`department`) from `company_compliance` where `company_id` = $company AND `status` != 2 AND `appr_id` = '$user' AND `department` != '' " );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_user_by_location_hod_1($user) {
	$dbh = connect_db();
	$company = $_SESSION['company_id'];
	try {
		$query = $dbh->prepare( "select DISTINCT(`location`) from `company_compliance` where `company_id` = $company AND `status` != 2 AND `hod_id` = '$user' AND `location` != '' " );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_user_by_department_hod_1($user) {
	$dbh = connect_db();
	$company = $_SESSION['company_id'];
	try {
		$query = $dbh->prepare( "select DISTINCT(`department`) from `company_compliance` where `company_id` = $company AND `status` != 2 AND `hod_id` = '$user' AND `department` != '' " );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_user_compliance_gt_user($user_email, $type) {
	$dbh = connect_db();
	$company = $_SESSION['company_id'];
	try {
		if($type == 'fpr'){
			$query = $dbh->prepare( "select count(sr) from `company_compliance`  where fpr_id = '$user_email' AND company_id =  '$company' and status != 7 and cycle_id = 0 and due_date != ''" );
		}elseif($type == 'appr'){
			$query = $dbh->prepare( "select count(sr) from `company_compliance`  where appr_id = '$user_email' AND company_id =  '$company' and status != 7 and cycle_id = 0 and due_date != ''" );
		}else{
			$query = $dbh->prepare( "select count(sr) from `company_compliance`  where hod_id = '$user_email' AND company_id =  '$company' and status != 7  and cycle_id = 0 and due_date != ''" );  
		}
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count(sr)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/*user_dl_all*/


/* starts two_iframe*/
//------------------ Criticality Overdue---------------------------------//
function get_compliance_by_criticality_overdue_low( $company_id ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	try {
	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Low' and $hod_event and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Low' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-' and $management" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Low' and $management and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		}else{
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Low' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		}    
    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_compliance_by_criticality_overdue_high( $company_id ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='High' and $hod_event and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='High' and $management and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='High' and $management and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		}else{
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='High' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		}
    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_compliance_by_criticality_overdue_medium( $company_id ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Medium' and $hod_event and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Medium' and $management and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Medium' and $management and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		}else{
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Medium' and company_compliance.`due_date`!='' and company_compliance.`due_date`!='-'" );
		} 
    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


/* End two_iframe*/

/* starts four_iframe*/
function get_compliance_by_criticality_non_low( $company_id ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	try {
	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and company_compliance.hod_id='$emmm' and compliance.criticality='Low' and company_compliance.due_date!='' " );		
		} else if(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='Low' and company_compliance.due_date!='' and $location_department" );
		} else if(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='Low' and company_compliance.due_date!='' and $location_department" );
		}else{
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='Low' and company_compliance.due_date!=''" );
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_non_high( $company_id ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and company_compliance.hod_id='$emmm' and compliance.criticality='High' and company_compliance.due_date!='' " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='High' and company_compliance.due_date!='' and $location_department" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='High' and company_compliance.due_date!='' and $location_department" );
		}else{
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='High' and company_compliance.due_date!=''" );
		}

		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_compliance_by_criticality_non_medium( $company_id ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and company_compliance.hod_id='$emmm' and compliance.criticality='Medium' and company_compliance.due_date!='' " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='Medium' and company_compliance.due_date!='' and $location_department" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);	
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='Medium' and company_compliance.due_date!='' and $location_department" );
		}else{
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='Medium' and company_compliance.due_date!=''" );
		}
    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends four_iframe*/

/* Starts ten_iframe*/
//----------------------location wise All Compliances----------//
function get_location_by_company_idd($company_id ) {
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select distinct location from `company_compliance` where `company_id`=? and location!='' and $hod_event " );		 
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select distinct location from `company_compliance` where `company_id`=? and location!='' and $management" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "select distinct location from `company_compliance` where `company_id`=? and location!='' and $location_department" );
		}else{
			$query = $dbh->prepare( "select distinct location from `company_compliance` where `company_id`=? and location!=''" );
		}
		$query->bindValue(1, $company_id );
		$query->execute();
		//$result = $query->fetch(PDO::FETCH_ASSOC);
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}




function get_count_compliance_location_comp($loc, $company_id) {
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `location` = '$loc' and due_date >= date_time and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `location` = '$loc' and due_date >= date_time and $management" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `location` = '$loc' and due_date >= date_time and $location_department" );
		}else{
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `location` = '$loc' and due_date >= date_time" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}



function get_count_compliance_location_compliant_event($loc, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db(); 
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date >= date_time and company_compliance.company_id='$company_id' and company_compliance.status=7 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$loc' and company_compliance.status=7 ) and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date >= date_time and company_compliance.company_id='$company_id' and company_compliance.status=7 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$loc' and company_compliance.status=7 ) and $management " );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date >= date_time and company_compliance.company_id='$company_id' and $location_department and company_compliance.status=7 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$loc' and company_compliance.status=7 )"  );
		}else{
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date >= date_time and company_compliance.company_id='$company_id' and company_compliance.status=7 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$loc' and company_compliance.status=7 )" );
		}	
	
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/* ends ten_iframe*/

/* Starts pendingatfpr.php */
function get_all_conditional_compliance_test($company_id){
	$role=$_SESSION['user_role'];
	$user=get_user_by_id( $_SESSION['user_id'] ); 
	$user_mail=$user['email'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("Select * from company_compliance where company_id=? and status='5' and appr_id=?");
		$query->bindValue( 1, $company_id );
		$query->bindValue( 2, $user_mail );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	}catch (Exception $e) {
		return $e->getMessage();
	}	 
}
/* Ends pendingatfpr.php */

/*starts compliant_cm_pending.php */

function get_count_status_7_of_user(){ 
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
  try {
	$location_department = select_department_location_new($user_id, $company_id, $user_role);
	if($_SESSION['user_role'] == 'Admin') {
		$query = $dbh->prepare( "select * FROM `company_compliance` WHERE `company_id`=? and `act_id` !='99999' and `act_id` !='99998' and `status` =7 and (auditor_status=1' ) and due_date != '' ORDER BY sr ASC " );	
	}else {
		$query = $dbh->prepare("select * FROM `company_compliance` WHERE `company_id`=? and `act_id` !='99999' and `act_id` !='99998' and `status` =7 and (auditor_status=1  ) and due_date != '' and $location_department ORDER BY sr ASC ");	
	}   
	$query->bindValue(1, $company_id);
    $query->execute();
	$result = $query->fetchAll();
	return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_count_status_7_of_user_all_sr(){ 
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	try {
		if($_SESSION['user_role'] == 'Admin') {
			$query = $dbh->prepare( "select * FROM `company_compliance` WHERE `company_id`=? and `act_id` !='99999' and `act_id` !='99998' and `status` =7 and (auditor_status=1 or  auditor_status='' ) and due_date != '' ORDER BY sr ASC " );	
		}else {
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare("select * FROM `company_compliance` WHERE `company_id`=? and `act_id` !='99999' and `act_id` !='99998' and `status` =7 and (auditor_status=1 or  auditor_status='' ) and due_date != '' and $location_department ORDER BY sr ASC ");
		}  
		$query->bindValue(1, $company_id);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/*Ends compliant_cm_pending.php */

/*starts compliant_cm_reject.php*/
function get_count_status_7_of_user_reject(){ 
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	try {
		if($_SESSION['user_role'] == 'Admin') {
			$query = $dbh->prepare( "select * FROM `company_compliance` WHERE `company_id`=? and `act_id` !='99999' and `act_id` !='99998' and `status` =1 and auditor_status=1 and due_date != ''" );	
		}else {
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "select * FROM `company_compliance` WHERE `company_id`=? and `act_id` !='99999' and `act_id` !='99998' and `status` =1 and auditor_status=1 and due_date != '' and $location_department" );	
		}   
		$query->bindValue(1, $company_id);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/*ends compliant_cm_reject.php */

/* starts nine_iframe.php */

function get_department_by_company_idd($company_id ) {
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select distinct department from `company_compliance` where `company_id`=? and department!='' and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "select distinct department from `company_compliance` where `company_id`=? and department!='' and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$management= event_data_management();
			$query = $dbh->prepare( "select distinct department from `company_compliance` where `company_id`=? and department!='' and $management" );
		}else{
		  $query = $dbh->prepare( "select distinct department from `company_compliance` where `company_id`=? and department!=''" );
		}  
	
		$query->bindValue(1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}




function get_count_compliance_department_comp($dep, $company_id) {
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
		$emmm=$_SESSION['email'];
		$hod_event= event_data_hod();
		$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `department` = '$dep' and due_date >= date_time and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `department` = '$dep' and due_date >= date_time and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `department` = '$dep' and due_date >= date_time and $management" );
		} else {
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `department` = '$dep' and due_date >= date_time" );
		}	    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_department_compliant_event($dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db(); 
	try {
	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date >= date_time and company_compliance.company_id='$company_id' and company_compliance.status=7 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep' and company_compliance.status=7 ) and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date >= date_time and company_compliance.company_id='$company_id' and company_compliance.status=7 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and company_compliance.status=7 ) and $management " );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date >= date_time and company_compliance.company_id='$company_id' and company_compliance.status=7 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and company_compliance.status=7 ) and $management" );
		} else {
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date >= date_time and company_compliance.company_id='$company_id' and company_compliance.status=7 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep' and company_compliance.status=7 )" );
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/* ends nine_iframe.php */

/* starts depart_due_over_pending.php */
function get_count_compliance_department_overdue($dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='4' and status!='2' and status!='7' and `department` = '$dep' and due_date BETWEEN '$fdaym' and '$yest' and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='4' and status!='2' and status!='7' and `department` = '$dep' and due_date BETWEEN '$fdaym' and '$yest' and compliance_id!='' and $management" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status='4' and status!='7' and `department` = '$dep' and due_date BETWEEN '$fdaym' and '$yest' and compliance_id!='' and $management" );
		} else{
			$query = $dbh->prepare("select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7'  and status='4' and `department` = '$dep' and due_date BETWEEN '$fdaym' and '$yest' and compliance_id!=''");
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_overdue_event($dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db(); 
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and  due_date BETWEEN '$fdaym' and '$yest' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status=4 and company_compliance.status!=2 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep' and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2 ) and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and  due_date BETWEEN '$fdaym' and '$yest' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status=4 and company_compliance.status!=2 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2) and $management " );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and  due_date BETWEEN '$fdaym' and '$yest' and company_compliance.company_id='$company_id'  and company_compliance.status!=7 and company_compliance.status=4 and company_compliance.status!=2 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2) and $management" );
		}else{
			$query = $dbh->prepare("SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and  due_date BETWEEN '$fdaym' and '$yest' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status!=2 and company_compliance.status=4 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2 )");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_department_due($dep, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare("select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7' and status='4' and `department` = '$dep' and due_date BETWEEN '$today' and '$mend' and $hod_event ");
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status='4' and status!='7' and `department` = '$dep' and due_date BETWEEN '$today' and '$mend' and compliance_id!='' and $management" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status='4'  and status!='7' and `department` = '$dep' and due_date BETWEEN '$today' and '$mend' and compliance_id!='' and $management" );	 
		}else{
		  $query = $dbh->prepare("select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7' and status='4' and `department` = '$dep' and due_date BETWEEN '$today' and '$mend' and compliance_id!=''");
		}	
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_due_event($dep, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db(); 
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date BETWEEN '$today' and '$mend' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status=4 and company_compliance.status!=2 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep' and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2) and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date BETWEEN '$today' and '$mend' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status=4 and company_compliance.status!=2 and compliance_id!='' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2 ) and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR') {
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date BETWEEN '$today' and '$mend' and company_compliance.company_id='$company_id'  and company_compliance.status!=7 and company_compliance.status=4 and company_compliance.status!=2 and compliance_id!='' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2 ) and $management" );
		} else {
			$query = $dbh->prepare("SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date BETWEEN '$today' and '$mend' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status=4 and company_compliance.status!=2 and compliance_id!='' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2)");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_noncomp($dep, $company_id) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `department` = '$dep' and due_date < date_time and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `department` = '$dep' and due_date < date_time and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR') {
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `department` = '$dep' and due_date < date_time and $management" );
		}else{
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status='7' and `department` = '$dep' and due_date < date_time " );
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends depart_due_over_pending.php */

/* starts six_iframe.php */

function get_count_compliance_department_overdue_new($dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7' and `location` = '$dep' and due_date BETWEEN '$fdaym' and '$yest' and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7' and `location` = '$dep' and due_date BETWEEN '$fdaym' and '$yest' and compliance_id!='' and $management" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7' and `location` = '$dep' and due_date BETWEEN '$fdaym' and '$yest' and compliance_id!='' and $location_department" );
		} else{
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7' and `location` = '$dep' and due_date BETWEEN '$fdaym' and '$yest' and compliance_id!=''" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_department_overdue_event_new($dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db(); 
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and  due_date BETWEEN '$fdaym' and '$yest' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status!=2 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep' and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2) and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and  due_date BETWEEN '$fdaym' and '$yest' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status!=2 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2 ) and $management " );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and  due_date BETWEEN '$fdaym' and '$yest' and company_compliance.company_id='$company_id' and $location_department and company_compliance.status!=7 and company_compliance.status!=2 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2 and $location_department)" );
		}else{
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and  due_date BETWEEN '$fdaym' and '$yest' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status!=2 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2)" );
		}
    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_department_due_new($dep, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7' and `location` = '$dep' and due_date BETWEEN '$today' and '$mend' and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7' and `location` = '$dep' and due_date BETWEEN '$today' and '$mend' and compliance_id!='' and $management" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7' and `location` = '$dep' and due_date BETWEEN '$today' and '$mend' and compliance_id!='' and $location_department" );
		}else{
			$query = $dbh->prepare( "select sr as count from company_compliance where company_id='$company_id' and status!='2' and status!='7' and `location` = '$dep' and due_date BETWEEN '$today' and '$mend' and compliance_id!=''" );
		}		
    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_due_event_new($dep, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db(); 
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if($_SESSION['user_role']=='Hod'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date BETWEEN '$today' and '$mend' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status!=2 and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep' and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2) and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date BETWEEN '$today' and '$mend' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status!=2 and compliance_id!='' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2 ) and $management " );
		 
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date BETWEEN '$today' and '$mend' and company_compliance.company_id='$company_id' and $location_department and company_compliance.status!=7 and company_compliance.status!=2 and compliance_id!='' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2 and $location_department)" );
		 
		}else{
			$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date BETWEEN '$today' and '$mend' and company_compliance.company_id='$company_id' and company_compliance.status!=7 and company_compliance.status!=2 and compliance_id!='' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep'  and compliance.periodicity like '%event%' and company_compliance.status!=7 and company_compliance.status!=2)" );
		 
		}
		
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/* ends six_iframe.php */

/* starts chart_locationwiseall.php */
//<---------------departmentwise--------------->

function get_count_compliance_department_overdue_chart_location($sr, $dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($dep) and due_date BETWEEN '$fdaym' and '$yest' and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($dep) and due_date BETWEEN '$fdaym' and '$yest' and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($dep) and due_date BETWEEN '$fdaym' and '$yest' and $management" );
		} else{
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($dep) and due_date BETWEEN '$fdaym' and '$yest'" ); 
		}	
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_overdue_event_chart_location($sr, $dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db(); 
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date BETWEEN '$fdaym' and '$yest' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep' and compliance.periodicity like '%event%') and $hod_event " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date BETWEEN '$fdaym' and '$yest' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id' and company_compliance.department='$dep'  and compliance.periodicity like '%event%') and $management " );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and  due_date BETWEEN '$fdaym' and '$yest' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'   and company_compliance.department='$dep'  and compliance.periodicity like '%event%') and $management" );
		} else {
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and  due_date BETWEEN '$fdaym' and '$yest' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and compliance.periodicity like '%event%')" );
		}    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_location_overdue_event_chart_location($sr, $dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db(); 
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date BETWEEN '$fdaym' and '$yest' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep' and compliance.periodicity like '%event%') and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date BETWEEN '$fdaym' and '$yest' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id' and company_compliance.location='$dep'  and compliance.periodicity like '%event%') and $management " );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr)  and  due_date BETWEEN '$fdaym' and '$yest' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'   and company_compliance.location='$dep'  and compliance.periodicity like '%event%') and $management" );
		} else{
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and  due_date BETWEEN '$fdaym' and '$yest' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep'  and compliance.periodicity like '%event%')" );
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_department_due_chart_location($sr, $dep, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($dep) and due_date BETWEEN '$today' and '$mend' and $hod_event " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($dep) and due_date BETWEEN '$today' and '$mend' and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($dep) and due_date BETWEEN '$today' and '$mend' and $management" );
		}else{
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($dep) and due_date BETWEEN '$today' and '$mend'" );
		}   
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_department_due_event_chart_location($sr, $dep, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db(); 
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date BETWEEN '$today' and '$mend' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep' and compliance.periodicity like '%event%') and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date BETWEEN '$today' and '$mend' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and compliance.periodicity like '%event%') and $management " );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999  and due_date!='' and ($sr) and due_date BETWEEN '$today' and '$mend' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and compliance.periodicity like '%event%') and $management" );
		} else{
			$query = $dbh->prepare( "SELECT * from company_compliance where company_compliance.act_id=99999 and company_compliance.due_date!='' and ($sr) and company_compliance.due_date BETWEEN '$today' and '$mend' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep'  and compliance.periodicity like '%event%')" );
		}	
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_location_due_event_chart_location($sr, $dep, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db(); 
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date BETWEEN '$today' and '$mend' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep' and compliance.periodicity like '%event%') and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date BETWEEN '$today' and '$mend' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep'  and compliance.periodicity like '%event%') and $management " );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999   and due_date!='' and ($sr) and due_date BETWEEN '$today' and '$mend' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep'  and compliance.periodicity like '%event%') and $management" );
		} else {
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date BETWEEN '$today' and '$mend' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$dep'  and compliance.periodicity like '%event%')" ); 
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_department_comp_chart_location($sr, $dep, $company_id) {
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($dep) and due_date >= date_time and $hod_event " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($dep) and due_date >= date_time and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($dep) and due_date >= date_time and $management" );
		} else{
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($dep) and due_date >= date_time" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_department_noncomp_chart_location($sr, $dep, $company_id) {
	$dbh = connect_db();
	try {
	  	if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($dep) and due_date < date_time and $hod_event " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($dep) and due_date < date_time and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($dep) and due_date < date_time and $management"  );
		}else{
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($dep) and due_date < date_time " );
		}    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


//<----------------------------location wise-------------------->

function get_count_compliance_location_overdue_chart_location($sr, $loca, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($loca) and due_date BETWEEN '$fdaym' and '$yest' and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($loca) and due_date BETWEEN '$fdaym' and '$yest' and $management" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($loca) and due_date BETWEEN '$fdaym' and '$yest' and $management" );
		} else{
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($loca) and due_date BETWEEN '$fdaym' and '$yest'" ); 
		}	
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_location_due_chart_location($sr, $loca, $company_id) {
	$today=date("Y-m-d");
	$mend=date("Y-m-t");
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($loca) and due_date BETWEEN '$today' and '$mend' and $hod_event " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($loca) and due_date BETWEEN '$today' and '$mend' and $management" );
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($loca) and due_date BETWEEN '$today' and '$mend' and $management" );
		} else{
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($loca) and due_date BETWEEN '$today' and '$mend'" );
		}    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_location_comp_chart_location($sr, $loca, $company_id) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($loca) and due_date >= date_time and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($loca) and due_date >= date_time and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($loca) and due_date >= date_time and $management" );
		} else{
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($loca) and due_date >= date_time" );
		}    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_location_noncomp_chart_location($sr, $loca, $company_id) {	
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($loca) and due_date < date_time and $hod_event " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($loca) and due_date < date_time and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($loca) and due_date < date_time and $management" );
		}else {
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and ($loca) and due_date < date_time " );
		}    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/* ends chart_locationwiseall.php */

/* starts chart_static_compliance.php */
function get_compliance_by_criticality_medium( $company_id, $cric ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$cric = $cric;
	$cric=strtoupper($cric);
	$dbh = connect_db();
	try {   
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and upper(compliance.criticality)='$cric' and $hod_event " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare("select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and upper(compliance.criticality)='$cric' and $management");
		}elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare("select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id'  and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and upper(compliance.criticality)='$cric' and $management ");
		}else{
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and upper(compliance.criticality)='$cric' order by fpr_id, appr_id, hod_id, location, department, due_date" );
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_medium_sr( $company_id, $cric, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {   
		$cric = $cric;
		$cric=strtoupper($cric);
		$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and upper(compliance.criticality)='$cric' and ($sr)" );
	
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_compliance_by_criticality_medium_non( $company_id, $cric ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$cric = $cric;
	$cric=strtoupper($cric);
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='$cric' and $hod_event " );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='$cric' and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='$cric' and $management" );
		}else{
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='$cric' order by fpr_id, appr_id, hod_id, location, department, due_date" );
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}	



function get_compliance_by_criticality_medium_non_sr( $company_id, $cric, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$cric = $cric;
		$cric=strtoupper($cric);
		$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='$cric' and ($sr) order by fpr_id, appr_id, hod_id, location, department, due_date" );
		
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}	
/* ends chart_static_compliance.php */

/* starts chart_locat_compwise.php */
function get_count_compliance_location_comp_chart($sr, $loc, $company_id) {
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr)  and due_date >= date_time and location='$loc' and $hod_event ");
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT' OR $_SESSION['user_role']=='Management'){
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and due_date >= date_time and location='$loc' and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and due_date >= date_time and location='$loc' and $location_department" );
		} else {
		 $query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and due_date >= date_time and location='$loc'" );
		}		 
       $query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}



function get_count_compliance_location_comp_event_chart($sr, $loc, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db(); 
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date >= date_time  and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$loc' and compliance.periodicity like '%event%') and $hod_event " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date >= date_time  and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id' and company_compliance.location='$loc' ) and $management " );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare(  "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date >= date_time  and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id' and $location_department  and company_compliance.location='$loc' )"  );
		} else{
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date >= date_time  and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.location='$loc' )" );
		}	
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends chart_locat_compwise.php */

/* starts chart_depart_compwise.php */
function get_count_compliance_department_comp_chart($sr, $dep, $company_id) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr)  and due_date >= date_time and $hod_event " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and due_date >= date_time and department='$dep' and $management" );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and due_date >= date_time and department='$dep' and $management" );
		} else{
			$query = $dbh->prepare( "select * from company_compliance where company_id='$company_id' and status='7' and ($sr) and due_date >= date_time and department='$dep'" );
		}    
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}



function get_count_compliance_department_comp_event_chart($sr, $dep, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db(); 
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date >= date_time  and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep' and compliance.periodicity like '%event%') and $hod_event " );
		} elseif(strtoupper($_SESSION['user_role'])=='MANAGMENT'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date >= date_time  and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep') and $management " );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$emmm=$_SESSION['email'];
			$management= event_data_management();
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date >= date_time  and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep' ) and $management" );
		} else{
			$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date >= date_time  and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.company_id='$company_id'  and company_compliance.department='$dep' )" );
		}	
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends chart_depart_compwise.php */

/* starts elevan_iframe.php */
function get_compliance_by_criticality_overdue_high_chart( $company_id,$type ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	$type=strtoupper($type);
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {	  
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%' and $hod_event" );
		}elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){
			$management= event_data_management();
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%' and $management " );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and $location_department and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
		}else{
			$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time  and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );	
		}	    
		$query->execute();
		$result = $query->fetchAll(); 
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends elevan_iframe.php */

/* starts chart_high_criticality_nonpoten.php */

function get_compliance_by_criticality_medium_chart( $company_id, $type ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$type=strtoupper($type);
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$user_role = $_SESSION['user_role'];
	try {
		if(strtoupper($_SESSION['user_role'])=='HOD'){
			$emmm=$_SESSION['email'];		
			$hod_event= event_data_hod();
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and upper(compliance.potential_impact) LIKE '%$type%' and $hod_event " );
		}	elseif(strtoupper($_SESSION['user_role'])=='MANAGEMENT'){		 
			$management= event_data_management();
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='HIGH'  and upper(compliance.potential_impact) LIKE '%$type%' and $management " );
		} elseif(strtoupper($_SESSION['user_role'])=='AUDITOR'){
			$location_department = select_department_location_new($user_id, $company_id, $user_role);
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and $location_department and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='HIGH'  and upper(compliance.potential_impact) LIKE '%$type%'"  );
		} else {	
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where company_id='$company_id' and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='HIGH'  and upper(compliance.potential_impact) LIKE '%$type%'" );	
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends chart_high_criticality_nonpoten.php */

/*  starts freedisplay.php */

function search_word($string, $word){
	if(preg_match("/{$word}/i", $string)) {
		return 1;
	}else {
		return 0;
	}
}
function management_event_cycle_3() {
	$dbh = connect_db();
	$today			= date('Y-m-d');
	$prev_date_s 	= date('Y-m-d', strtotime($today .' -1 day'));
	$p10date		= date('Y-m-d', strtotime("+10 day"));
	$first_date 	= '1970-01-01';
	$statusr = "";
	
	try {
		$user_id		= $_SESSION['user_id'];
		$company_id		= $_SESSION['company_id'];
		$query = $dbh->prepare("SELECT Department,location FROM `user_role` WHERE Company_id='$company_id' and user_id='$user_id' and user_role='Management'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		$str	= $result['Department'];
		$str2	= $result['location'];
		$dep	= explode(',',$str);
		$loc	= explode(',',$str2);
		$res	= "SELECT `company_compliance`.`hod_id` FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company_id'  and ( ";
		for($i=0;$i<count($dep);$i++){
			if($i == 0){
				$res.=" (`company_compliance`.`location`='$loc[$i]' and `company_compliance`.`department`='$dep[$i]')";
			}else{
				$res.=" or (`company_compliance`.`location`='$loc[$i]' and `company_compliance`.`department`='$dep[$i]')";
			}		
		}
		$res.= ' ) GROUP by `company_compliance`.`hod_id`'; 
		$query = $dbh->prepare("$res");
		$query->execute();
		$result2 = $query->fetchAll();
		$res2	= "SELECT `company_compliance`.`fpr_id`,`company_compliance`.`appr_id` FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company_id' and ";
		$il = 1;
		foreach($result2 as $hod){
			$hodq	= $hod['hod_id'];
			if($il == 1){
				$res2.=" ( `company_compliance`.`hod_id`='$hodq'";
			}else{
				$res2.=" or `company_compliance`.`hod_id`='$hodq'";
			}
			$il++;
		}
		$res2.= ' ) GROUP by `company_compliance`.`fpr_id`,`company_compliance`.`appr_id`'; 
		$query = $dbh->prepare("$res2");
		$query->execute();
		$result3 = $query->fetchAll();
		$res3	= "SELECT sr FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company_id' and ";
		$ir = 1;
		foreach($result3 as $rlk){
			$fpr_id		= $rlk['fpr_id'];
			$appr_id	= $rlk['appr_id'];
			if($ir== 1){
				$res3.=" ( `company_compliance`.`fpr_id`='$fpr_id' and `company_compliance`.`appr_id`='$appr_id' and act_id = 99999 ";
			}else{
				$res3.=" or `company_compliance`.`fpr_id`='$fpr_id' and `company_compliance`.`appr_id`='$appr_id' and act_id = 99999 ";
			}
			$ir++;
		}
		$res3.= ' ) ';
		$query = $dbh->prepare("$res3");
		$query->execute();
		$result4 = $query->fetchAll();
		return $result4;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function management_event_cycle_final_2() {
	$dbh = connect_db();
	try {
		$sd = 1;
		$nt = management_event_cycle_3();
		$res2 = '';
		foreach($nt as $total){
			$sr	= $total['sr'];
			if($sd == 1){
				$res2.=" ( `company_compliance`.`sr`='$sr'";
			}else{
				$res2.=" or `company_compliance`.`sr`='$sr'";
			}
			$sd++;
		}
		$res2.= ' ) ';
		return $res2;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
function event_data_management_2() {
	$dbh = connect_db();
	try {
		$aaaa=select_dep_loc_by_user_id();
		$fprusr=select_dep_fpr_user_M(); // fpr
		$apprusr=select_dep_appr_user_M(); // appr
		$management= "($fprusr and $apprusr and company_compliance.hod_id='' ) or  ($fprusr and $apprusr  and $aaaa)";		 
		$result= "(".$management.")";
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function select_compliance_rejected_by_auditor($location, $department, $act, $fpr, $appr, $hod, $duedatefrom, $duedateto, $auditor){
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	try {
		$role = strtoupper($_SESSION['user_role']);
		$user2 = get_user_by_id( $_SESSION['user_id'] );
		if($role=="FPR"){ 
			$user_mail = $user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1' and $auditor and $location and $department and ( $act ) and fpr_id like '%$user_mail%' and $hod and $appr and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
		}elseif($role=="APPROVER"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1' and $auditor and $location and $department and ( $act ) and $fpr and $hod and appr_id like '%$user_mail%'  and due_date BETWEEN '$duedatefrom' and '$duedateto'");
		}elseif($role=="HOD"){ 
			$user_mail=$user2['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and  auditor_status='1'  and $auditor and $location and $department and ( $act ) and $fpr and $hod_event and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");
		}elseif($role=="MANAGEMENT"){ 
			$user_mail=$user['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1'  and $auditor and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and $location_department ");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1'  and $auditor and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1'  and $auditor and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1'  and $auditor and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");
			}
		} elseif ($role=="AUDITOR"){ 
			$user_mail=$user['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1'  and $auditor and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and $location_department ");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1'  and $auditor and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1'  and $auditor and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1'  and $auditor and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");
			}
		}else{
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='1' and auditor_status='1'  and $auditor and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");
		}	
		$query->execute();
		$rej_auditor = $query->fetchAll();
		return $rej_auditor;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function select_compliant_compliance_report($location, $department, $act, $fpr, $appr, $hod, $duedatefrom, $duedateto){
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	try{
		$role=$_SESSION['user_role'];
		$user2=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and fpr_id like '%$user_mail%' and $hod and $appr and due_date  BETWEEN '$duedatefrom' and '$duedateto'  and due_date >= date_time");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and $fpr and $hod and appr_id like '%$user_mail%'  and due_date BETWEEN '$duedatefrom' and '$duedateto' and due_date >= date_time");
		}elseif($role=="HOD" or $role=="Hod" or $role=="hod"){ 
			$user_mail=$user2['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and $fpr and $hod_event and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date >= date_time");
		}elseif(strtoupper($role)==strtoupper("Management")){ 
			$user_mail=$user['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$srNum = management_event_cycle_newTest('compliant', 'Management');
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and due_date >= date_time and $location_department $srNum");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and due_date >= date_time and $aaaa");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and due_date >= date_time and $aaaa");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and due_date >= date_time and $aaaa");
			}
		}elseif(strtoupper($role)==strtoupper("Auditor")){ 
			$user_mail=$user['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$srNum = management_event_cycle_newTest('compliant', 'Auditor');
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and due_date >= date_time and $location_department $srNum");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and due_date >= date_time and $aaaa");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and due_date >= date_time and $aaaa");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and due_date >= date_time and $aaaa");
			}
		}else{
		  $query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and due_date >= date_time ");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	}catch (Exception $e){
		return $e->getMessage();
	}
}

function select_delayed_compliance_report($location, $department, $act, $fpr, $appr, $hod, $duedatefrom, $duedateto){
	$dbh = connect_db();
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$company_id = $_SESSION['company_id'];
	try{
		$role=$_SESSION['user_role'];
		$user2=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and fpr_id like '%$user_mail%' and $hod and $appr and due_date  BETWEEN '$duedatefrom' and '$duedateto' and due_date < date_time");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and $fpr and $hod and appr_id like '%$user_mail%'  and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time");
		}elseif($role=="HOD" or $role=="Hod" or $role=="hod"){ 
			$user_mail=$user2['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and $fpr and $hod_event and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time");
		}elseif(strtoupper($role)==strtoupper("Management")){ 
			$user_mail=$user['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time  and $location_department");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and $fpr and $hod and $appr like '%$appr%' and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time");
			}
		}elseif(strtoupper($role)==strtoupper("Auditor")){ 
			$user_mail=$user['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time  and $location_department");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time");
			}
		}else{
		  $query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='7' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time ");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	}catch (Exception $e){
		return $e->getMessage();
	}
	
}

function select_due_compliance_report($location, $department, $act, $fpr, $appr, $hod, $duedatefrom, $duedateto){	
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	
	$today = date("Y-m-d");
	$mend = date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();	
	try {
		$role=$_SESSION['user_role'];
		$user2=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and fpr_id like '%$user_mail%' and $hod and $appr and due_date  BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'  ");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='4') and $location and $department and ( $act ) and $fpr and $hod and appr_id like '%$user_mail%'  and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto' ");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user2['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and $fpr and $hod_event and $appr and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'  ");
		}elseif(strtoupper($role)==strtoupper("Management")){ 
			$user_mail=$user2['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$srNum = management_event_cycle_newTest('due', 'Management');
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'  and $location_department $srNum");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			}
		}elseif(strtoupper($role)==strtoupper("Auditor")){ 
			$user_mail=$user['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$srNum = management_event_cycle_newTest('due', 'Auditor');
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'  and $location_department $srNum");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			}
		}else{							 
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$today' and '$mend' and due_date  BETWEEN '$duedatefrom' and '$duedateto'  ");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	}catch (Exception $e){
		return $e->getMessage();
	}
}

function select_overdue_compliance_report($location, $department, $act, $fpr, $appr, $hod, $duedatefrom, $duedateto){
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	
	try {
		$role=$_SESSION['user_role'];
		$user2=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6' or status='4'  or status='5') and $location and $department and ( $act ) and fpr_id like '%$user_mail%' and $hod and $appr and due_date  BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto'   ");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='4') and $location and $department and ( $act ) and $fpr and $hod and appr_id like '%$user_mail%'  and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto' ");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user2['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and $location and $department and ( $act ) and $fpr and $hod_event and $appr and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto'  ");
		}elseif(strtoupper($role)==strtoupper("Management")){ 
			$user_mail=$user2['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$srNum = management_event_cycle_newTest('over', 'Management');
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto' and $location_department $srNum");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			}
		}elseif(strtoupper($role)==strtoupper("Auditor")){ 
			$user_mail=$user2['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$srNum = management_event_cycle_newTest('over', 'Auditor');
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto' and $location_department $srNum");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto'");
			}
		}else{									 
		  $query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6'  or status='4'  or status='5') and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$fdaym' and '$yest' and due_date  BETWEEN '$duedatefrom' and '$duedateto'  ");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	}catch (Exception $e){
		return $e->getMessage();
	}
}

function select_conditional_compliance_report($location, $department, $act, $fpr, $appr, $hod, $duedatefrom, $duedateto){
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	
	try {
		$role=$_SESSION['user_role'];
		$user2=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and $location and $department and ( $act ) and fpr_id like '%$user_mail%' and $hod and $appr and due_date  BETWEEN '$duedatefrom' and '$duedateto'  ");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and $location and $department and ( $act ) and $fpr and $hod and appr_id like '%$user_mail%'  and due_date BETWEEN '$duedatefrom' and '$duedateto'");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user2['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and $location and $department and ( $act ) and $fpr and $hod_event and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
		}elseif(strtoupper($role)==strtoupper("Management")){ 
			$user_mail=$user['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and $location_department");		
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");		
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");		
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");		
			}
		}elseif(strtoupper($role)==strtoupper("Auditor")){ 
			$user_mail=$user['email'];
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and $location_department");		
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");		
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");		
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto'");		
			}
		}else{									 
		  $query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='5' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
										 
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	}catch (Exception $e){
		return $e->getMessage();
	}
}
function select_pendingatfpr_compliance_report($location, $department, $act, $fpr, $appr, $hod, $duedatefrom, $duedateto){
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	
	try {
		$role=$_SESSION['user_role'];
		$user2=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and fpr_id like '%$user_mail%' and $hod and $appr and due_date  BETWEEN '$duedatefrom' and '$duedateto'  ");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and $fpr and $hod and appr_id like '%$user_mail%'  and due_date BETWEEN '$duedatefrom' and '$duedateto'");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user2['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and $fpr and $hod_event and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
		}elseif(strtoupper($role)==strtoupper("Management")){ 
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and $location_department $srNum");	 
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");	 
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");	 
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");	 
			}
		}elseif(strtoupper($role)==strtoupper("Auditor")){ 
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and $location_department $srNum");	 
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");	 
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");	 
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");	 
			}
		}else{									 
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and (status='1' or status='3' or status='6') and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");	 
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	}catch (Exception $e){ 
		return $e->getMessage();
	}
}

function select_pendingatappr_compliance_report($location, $department, $act, $fpr, $appr, $hod, $duedatefrom, $duedateto){
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();
	
	try {
		$role=$_SESSION['user_role'];
		$user2=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and $location and $department and ( $act ) and fpr_id like '%$user_mail%' and $hod and $appr and due_date  BETWEEN '$duedatefrom' and '$duedateto'  ");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and $location and $department and ( $act ) and $fpr and $hod and appr_id like '%$user_mail%'  and due_date BETWEEN '$duedatefrom' and '$duedateto'");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user2['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and $location and $department and ( $act ) and $fpr and $hod_event and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
		}elseif(strtoupper($role)==strtoupper("Management")){ 
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and $location_department $srNum ");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
			}
		}elseif(strtoupper($role)==strtoupper("Auditor")){ 
			if($location=="location like '%%'" && $department=="department like '%%'"){
				$location_department = select_department_location_new($user_id, $company_id, $user_role);
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and $location_department $srNum ");
			} else if($location=="location like '%%'" && $department!="department like '%%'") {
				$loc = select_location_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and $loc and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
			} else if($location!="location like '%%'" && $department=="department like '%%'"){
				$depart = select_department_by_user();
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and $location and $depart and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
			} else {
				$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
			}
		}else{									 
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status='4' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	}catch (Exception $e){
		return $e->getMessage();
	}
}

function select_nofilter_compliance_report($location, $department, $act, $fpr, $appr, $hod, $duedatefrom, $duedateto){
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$dbh = connect_db();	
	try {
		$dbh = connect_db();
		$role=$_SESSION['user_role'];
		$user2=get_user_by_id( $_SESSION['user_id'] );
		if(strtoupper($role)=="FPR"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status!='2' and $location and $department and ( $act ) and fpr_id like '%$user_mail%' and $hod and $appr and due_date  BETWEEN '$duedatefrom' and '$duedateto'  ");
		}elseif(strtoupper($role)=="APPROVER"){ 
			$user_mail=$user2['email'];
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status!='2' and $location and $department and ( $act ) and $fpr and $hod and appr_id like '%$user_mail%'  and due_date BETWEEN '$duedatefrom' and '$duedateto'");
		}elseif(strtoupper($role)=="HOD"){ 
			$user_mail=$user2['email'];
			$hod_event= event_data_hod();
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status!='2' and $location and $department and ( $act ) and $fpr and $hod_event and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
		}elseif(strtoupper($role)==strtoupper("Management")){ 
			$user_mail=$user['email'];
			$management= event_data_management_2();
			$sql="select distinct sr from company_compliance where company_id='$company_id' and status!='2' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and ($management)";
			$query = $dbh->prepare($sql);
		}elseif(strtoupper($role)==strtoupper("Auditor")){ 
			$user_mail=$user['email'];
			$aaaa=select_dep_loc_by_user_id();
			$query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status!='2' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' and $aaaa");	
		}else{
		  $query = $dbh->prepare("select distinct sr from company_compliance where company_id='$company_id' and status!='2' and $location and $department and ( $act ) and $fpr and $hod and $appr and due_date BETWEEN '$duedatefrom' and '$duedateto' ");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	}catch (Exception $e){
		return $e->getMessage();
	}
}


/* ends freedisplay.php */

/* starts get acts */
function get_state_act_select_list_by_company_id_n( $company_id, $return, $st,$regs,$scope) {
	$user_id=$_SESSION['user_id'];
	$user=get_user_by_id($user_id);
	$uemail=$user['email'];
	if($return!='' && $st!='' && $regs!=''){
		$cond="compliance.`sub_head` like '%ret%' or compliance.`sub_head` like '%due%' or compliance.`sub_head` like '%registration%'";
	} elseif($return!=''){
		$cond="compliance.`sub_head` like '%ret%'";
	} elseif($st!=''){
		$cond="compliance.`sub_head` like '%due%'";
	}elseif($regs!=''){
		$cond="compliance.`sub_head` like '%registration%'";
	}else{
		$cond="compliance.`sub_head` like '%%'";
	}
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='FPR'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id INNER JOIN compliance on compliance.id=company_compliance.compliance_id WHERE act.scope = '$scope' AND company_compliance.status!= '7' AND company_compliance.company_id =? and company_compliance.fpr_id='$uemail' and ($cond) ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='APPROVER'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id INNER JOIN compliance on compliance.id=company_compliance.compliance_id WHERE act.scope = '$scope' AND company_compliance.status!= '7' AND company_compliance.company_id =? and company_compliance.appr_id='$uemail' and ($cond) ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='HOD'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id INNER JOIN compliance on compliance.id=company_compliance.compliance_id WHERE act.scope = '$scope' AND company_compliance.status!= '7' AND company_compliance.company_id =? and company_compliance.hod_id='$uemail' and ($cond) ORDER BY act.name ASC" );
		}else{
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id INNER JOIN compliance on compliance.id=company_compliance.compliance_id WHERE act.scope = '$scope' AND company_compliance.status!= '7' AND company_compliance.company_id =?  and ($cond) ORDER BY act.name ASC" );
		}
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_state_act_select_list_by_company_id_22( $company_id,$scope ) {
	$user_id=$_SESSION['user_id'];
	$user=get_user_by_id($user_id);
	$uemail=$user['email'];
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='FPR'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = '$scope' AND company_compliance.status!= '7' AND company_compliance.company_id =? and company_compliance.fpr_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='APPROVER'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = '$scope' AND company_compliance.status!= '7' AND company_compliance.company_id =? and company_compliance.appr_id='$uemail' ORDER BY act.name ASC" );
		}elseif(strtoupper($_SESSION['user_role'])=='HOD'){
			$query = $dbh->prepare( "SELECT distinct company_compliance.act_id FROM company_compliance INNER JOIN act ON act.id = company_compliance.act_id WHERE act.scope = '$scope' AND company_compliance.status!= '7' AND company_compliance.company_id =? and company_compliance.hod_id='$uemail' ORDER BY act.name ASC" );
		}else{
			$query = $dbh->prepare( "SELECT company_act.act_id FROM company_act INNER JOIN act ON act.id = company_act.act_id WHERE act.scope =  '$scope' AND company_act.status =  '1' AND company_act.company_id =?" );
		}
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends get acts */

/* starts check_freedisplay_graph_demo.php */
function get_count_compliance_all_overdue_report($company_id, $sr) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select sr as count from company_compliance where $company_id and (status='1' or status='3' or status='6'  or status='4'  or status='5') and due_date BETWEEN '$fdaym' and '$yest' and ($sr)" ); 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_due_report($company_id, $sr) {
	$today = date("Y-m-d");
	$mend = date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try { 
		$query = $dbh->prepare( "select sr as count from company_compliance where $company_id and (status='1' or status='3' or status='6'  or status='4'  or status='5') and due_date BETWEEN '$today' and '$mend' and ($sr)" ); 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_comp_report($company_id, $sr) {	
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select sr as count from company_compliance where $company_id and status='7'  and due_date >= date_time and ($sr)" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_noncomp_report($company_id, $sr) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select sr as count from company_compliance where $company_id and status='7' and due_date < date_time and ($sr)" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_overdue_normal_report( $company_id, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and ($sr) and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Normal'" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_overdue_medium_report( $company_id, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and ($sr) and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Medium'" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_overdue_high_report( $company_id, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and ($sr) and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='High'" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_overdue_low_report( $company_id, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where company_id='$company_id' and ($sr) and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='Low'" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_locations_b_company_id( $company_id, $sr ) {
	$dbh = connect_db();
	try {
			
		$query = $dbh->prepare( "select distinct(location) from `company_compliance` where $company_id and location!='' and ($sr)" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage(); 
	}
}

function get_count_compliance_by_1stdate_2nddate_company_id_fpr_appr( $company_id, $location, $sr ) {
	$dbh = connect_db();
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	try {
		$query = $dbh->prepare("SELECT sr as count FROM `company_compliance` where  `due_date` BETWEEN '$fdaym' and '$yest' and $company_id and status!='2' and status!='7' and location='$location' and ($sr)"); 
		$query->execute();
		$result = $query->fetchAll();  
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_location_overdue_event($loc, $company_id, $sr) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db(); 
	try {
		$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and  due_date BETWEEN '$fdaym' and '$yest' and ($sr) and status!='2' and status!='7' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.location='$loc'  and compliance.periodicity like '%event%')" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_non_low_report( $company_id, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where $company_id and ($sr) and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='Low'" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_non_high_report( $company_id, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where $company_id and ($sr) and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='High'" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_non_medium_report( $company_id, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where $company_id and ($sr) and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='Medium'" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_non_normal_report( $company_id, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where $company_id and ($sr) and (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='Normal'" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_department_by_company_idd_sr($company_id, $sr ) {
  $dbh = connect_db();
  try {  
	$query = $dbh->prepare( "select distinct department from `company_compliance` where $company_id and department!='' and ($sr)" );
	$query->bindValue(1, $company_id );
    $query->execute();
    $result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_count_compliance_department_overdue_report($dep, $company_id, $sr) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select sr as count from company_compliance where $company_id and (status='1' or status='3' or status='6'  or status='4'  or status='5') and `department` = '$dep' and due_date BETWEEN '$fdaym' and '$yest' and compliance_id!='' and ($sr)" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_overdue_event_report($dep, $company_id, $sr) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db(); 
	try {
		$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and  due_date BETWEEN '$fdaym' and '$yest' and ($sr) and status!='2' and status!='7' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.department='$dep'  and compliance.periodicity like '%event%')" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_due_report($dep, $company_id, $sr) {
	$today=date("Y-m-d");
	$mend=date("Y-m-t");
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select sr as count from company_compliance where $company_id and (status='1' or status='3' or status='6'  or status='4'  or status='5') and `department` = '$dep' and due_date BETWEEN '$today' and '$mend' and compliance_id!='' and ($sr)" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_due_event_report($dep, $company_id, $sr) {
	$today=date("Y-m-d");
	$mend=date("Y-m-t");
	$dbh = connect_db(); 
	try {
		$query = $dbh->prepare( "SELECT sr as count from company_compliance where act_id=99999 and due_date!='' and due_date BETWEEN '$today' and '$mend' and compliance_id!='' and ($sr) and status!='2' and status!='7' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id  and company_compliance.department='$dep'  and compliance.periodicity like '%event%' )" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_comp_report($dep, $company_id, $sr) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select sr as count from company_compliance where $company_id and status='7' and `department` = '$dep' and due_date >= date_time and ($sr)" ); 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_department_noncomp_report($dep, $company_id, $sr) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select sr as count from company_compliance where $company_id and status='7' and `department` = '$dep' and due_date < date_time and ($sr)" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_overdue_high_potential_report( $company_id,$type,$sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	$type=strtoupper($type);
	try {
		$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where $company_id and ($sr) and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
		$query->execute();
		$result = $query->fetchAll(); 
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_overdue_high_potential_non_report( $company_id,$type,$sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	$type=strtoupper($type);
	try {
		$query = $dbh->prepare( "select criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` where $company_id and ($sr) and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" ); 
		$query->execute();
		$result = $query->fetchAll(); 
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends check_freedisplay_graph_demo.php */

/* starts popupdue_over_comp.php*/

function get_count_compliance_all_overdue_chart($company_id, $sr) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select * from company_compliance where ($sr) and (status='1' or status='3' or status='6'  or status='4'  or status='5') and due_date BETWEEN '$fdaym' and '$yest'" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_count_compliance_all_due_chart($company_id, $sr) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select * from company_compliance where ($sr) and (status='1' or status='3' or status='6'  or status='4'  or status='5') and due_date BETWEEN '$today' and '$mend'" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_comp_chart($company_id, $sr) {
	$dbh = connect_db();
	try {
		 $query = $dbh->prepare( "select * from company_compliance where ($sr) and status='7'  and due_date >= date_time" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_noncomp_chart($company_id, $sr) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select * from company_compliance where ($sr) and status='7' and due_date < date_time " );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends popupdue_over_comp.php */

/* starts popupcri_over.php */
function get_comapny_compliance_by_sr_for_all_report( $srn ) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select * from `company_compliance` where `company_compliance`.`sr`=?" );
		$query->bindValue( 1, $srn );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_compliance_by_criticality_medium_sr_chart( $company_id, $cric, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$cric = $cric;
	$dbh = connect_db();
	try {
		if($cric=="high" or $cric=="High" or $cric=="HIGH" ){
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='$cric' and ($sr)" );	
		}elseif($cric=="low" or $cric=="Low" or $cric=="LOW" ){
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='$cric' and ($sr)" );
		}elseif($cric=="normal" or $cric=="Normal" or $cric=="NORMAL" ){
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='$cric' and ($sr)" );
		}elseif($cric=="medium" or $cric=="Medium" or $cric=="MEDIUM" ){
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and compliance.criticality='$cric' and ($sr)" );  
		} 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}


function get_compliance_by_criticality_medium_non_sr_chart( $company_id, $cric, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$cric = $cric;
	$dbh = connect_db();
	try {
		if($cric=="high" or $cric=="High" or $cric=="HIGH" ){
			$query = $dbh->prepare( "select * from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='$cric' and ($sr)" );
		}elseif($cric=="low" or $cric=="Low" or $cric=="LOW" ){
			$query = $dbh->prepare( "select * from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='$cric' and ($sr)" );
		}elseif($cric=="normal" or $cric=="Normal" or $cric=="NORMAL" ){
			$query = $dbh->prepare( "select * from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='$cric' and ($sr)" );
		}elseif($cric=="medium" or $cric=="Medium" or $cric=="MEDIUM" ){
			$query = $dbh->prepare( "select * from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where (company_compliance.status='7') and company_compliance.due_date < company_compliance.date_time and compliance.criticality='$cric' and ($sr)" );
		}		
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends popupcri_over.php */

/* starts popup_loca_over.php */

function get_overdue_locationwise_chart( $company_id, $sr, $loca ) {
	$dbh = connect_db();
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	try {
		$query = $dbh->prepare("SELECT * FROM `company_compliance` where  `due_date` BETWEEN '$fdaym' and '$yest' and status!='2' and status!='7' and ($sr) and $loca ");
		$query->execute();
		$result = $query->fetchAll();  
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_location_overdue_event_chart($sr, $dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db(); 
	try {
		$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and  due_date BETWEEN '$fdaym' and '$yest' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.location='$dep'  and compliance.periodicity like '%event%')" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends popup_loca_over.php */

/* starts popupdepart_all.php */
//<---------------departmentwise--------------->

function get_count_compliance_department_overdue_chart($sr, $dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select * from company_compliance where (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($dep) and due_date BETWEEN '$fdaym' and '$yest'" ); 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_overdue_event_chart($sr, $dep, $company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db(); 
	try {
		$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and  due_date BETWEEN '$fdaym' and '$yest' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.department='$dep'  and compliance.periodicity like '%event%')" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_due_chart($sr, $dep, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select * from company_compliance where (status='1' or status='3' or status='6'  or status='4'  or status='5') and ($sr) and ($dep) and due_date BETWEEN '$today' and '$mend'" );
		$query->execute();
    $result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_count_compliance_department_due_event_chart($sr, $dep, $company_id) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db(); 
	try {
		$query = $dbh->prepare( "SELECT * from company_compliance where act_id=99999 and due_date!='' and ($sr) and due_date BETWEEN '$today' and '$mend' and (fpr_id,appr_id) in (SELECT distinct fpr_id,appr_id FROM `company_compliance` inner join compliance on compliance.id=company_compliance.compliance_id and company_compliance.department='$dep'  and compliance.periodicity like '%event%')" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_department_comp_chart_new($sr, $dep, $company_id) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select * from company_compliance where status='7' and ($sr) and ($dep) and due_date >= date_time" );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_department_noncomp_chart($sr, $dep, $company_id) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "select * from company_compliance where status='7' and ($sr) and ($dep) and due_date < date_time " );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends popupdepart_all.php */

/* starts popup_over_poten.php */

function get_compliance_by_criticality_medium_chart_new( $company_id, $type, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$type=strtoupper($type);
	$dbh = connect_db();
	try {
		if($type=="MONETARY"){
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where ($sr) and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
		}elseif($type=="IMPRISONMENT"){
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where ($sr) and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
		}elseif($type=="OPERATIONAL"){
			$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where ($sr) and (company_compliance.status='1' or company_compliance.status='3' or company_compliance.status='6'  or company_compliance.status='4'  or company_compliance.status='5') and company_compliance.due_date BETWEEN '$fdaym' and '$yest' and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/* ends popup_over_poten.php */

/* starts popup_noncomp_poten.php */
function get_compliance_by_criticality_medium_sr_chart_new( $company_id, $type, $sr ) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$type=strtoupper($type);
	$dbh = connect_db();
	try {
		if($_SESSION['user_role']=='Hod'){
			$emmm=$_SESSION['email'];		
			if($type=="MONETARY"){
				$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where ($sr) and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and hod_id='$emmm' and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
			
			}elseif($type=="IMPRISONMENT"){
				$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where ($sr) and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and hod_id='$emmm' and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
			
			}elseif($type=="OPERATIONAL"){
				$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where ($sr) and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and hod_id='$emmm' and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
			}
		}else{
			if($type=="MONETARY"){
				$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where ($sr) and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
			}elseif($type=="IMPRISONMENT"){
				$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where ($sr) and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time  and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
			}elseif($type=="OPERATIONAL"){
				$query = $dbh->prepare( "select company_compliance.* from company_compliance inner join compliance on `company_compliance`.`compliance_id`=`compliance`.`id` where ($sr) and company_compliance.status='7' and company_compliance.due_date < company_compliance.date_time and upper(compliance.criticality)='HIGH' and upper(compliance.potential_impact) LIKE '%$type%'" );
			}
	
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/* ends popup_noncomp_poten.php */

/* starts edit_wizard_update.php */
function check_email_address($email) {
	if (!preg_match("/^[^@]{1,64}@[^@]{1,255}$/", $email)) {
		return false;
    }
    $email_array = explode("@", $email);
    $local_array = explode(".", $email_array[0]);
    for ($i = 0; $i < sizeof($local_array); $i++) {
		if (!preg_match("/^(([A-Za-z0-9!#$%&'*+\/=?^_`{|}~-][A-Za-z0-9!#$%&'*+\/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$/", $local_array[$i])) {
			return false;
        }
    }
    if (!preg_match("/^\[?[0-9\.]+\]?$/", $email_array[1])) { 
		$domain_array = explode(".", $email_array[1]);
        if (sizeof($domain_array) < 2) {
			return false; 
        }
        for ($i = 0; $i < sizeof($domain_array); $i++) {
			if (!preg_match("/^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$/", $domain_array[$i])) {
				return false;
            }
        }
    }
    return true;
}

	
	
function delete_compliance_by_sr( $sr){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("DELETE FROM `company_compliance` WHERE sr=?");
		$query->bindValue( 1, $sr );
		$result = $query->execute();
		if($result){ $rs = '1';} else { $rs = '0'; }
		return $rs;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
	
/* ends edit_wizard_update.php */

function check_ongng_compliance_have_or_not($company_id,$department,$location,$fpr,$appr,$hod,$due_date) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("select count(cc.sr) as count From `company_compliance` AS cc
INNER JOIN `compliance` AS c ON cc.`compliance_id`=c.`id`
WHERE cc.`company_id`=? and c.`periodicity` like '%going%' and cc.`department`=? and (cc.`location`=? ) and (cc.`cycle_id`='0' or cc.`cycle_id`!=0) and cc.`fpr_id`=? and cc.`appr_id`=? and cc.`hod_id`=?  and str_to_date(cc.live_date, '%Y-%m-%d')<=str_to_date(?, '%Y-%m-%d') and (str_to_date(c.expiry_date, '%Y-%m-%d')>str_to_date(?, '%Y-%m-%d') or c.expiry_date='') ");
		$query->bindValue( 1, $company_id );	
		$query->bindValue( 2, $department );	
		$query->bindValue( 3, $location );	
		$query->bindValue( 4, $fpr );	
		$query->bindValue( 5, $appr );	
		$query->bindValue( 6, $hod );	
		$query->bindValue( 7, $due_date );	
		$query->bindValue( 8, $due_date );	
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function insert_cycle_ccompliance_cron2_new($act_id, $compliance_id, $company_id, $department, $location, $fpr_id, $appr_id, $hod_id, $triggerdays, $due_date){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("INSERT INTO `company_compliance` (`company_id`, `act_id`, `compliance_id`,`department`, `location`, `triggerdays`, `due_date`, `fpr_id`, `appr_id`, `hod_id`) SELECT * FROM (SELECT '$company_id' As company_id, '$act_id' As act_id, '$compliance_id' As compliance_id, '$department' As department, '$location' As location, '$triggerdays' As triggerdays , '$due_date' As due_date, '$fpr_id' AS fpr_id, '$appr_id' As appr_id, '$hod_id' As hod_id) AS tmp WHERE NOT EXISTS ( SELECT * FROM `company_compliance` WHERE due_date = '$due_date' and fpr_id='$fpr_id' and act_id='$act_id' and company_id='$company_id' and appr_id='$appr_id' and hod_id='$hod_id' and department='$department' and  location='$location' ) LIMIT 1");
		$query->execute();	
	} catch (Exception $e) {
		$act_id.'='.$e->getMessage();
	}
}

function insert_cycle_ccompliance_cron2_new_appr($act_id, $compliance_id, $company_id, $department, $location, $fpr_id, $appr_id, $hod_id, $triggerdays, $due_date){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("INSERT INTO `company_compliance` (`company_id`, `act_id`, `compliance_id`,`department`, `location`, `triggerdays`, `due_date`, `fpr_id`, `appr_id`, `hod_id`, `status`) VALUES('$company_id', '$act_id', '$compliance_id, '$department', '$location', '$triggerdays', '$due_date', '$fpr_id', '$appr_id', '$hod_id', 4)");
		$query->execute();	
		$id = $dbh->lastInsertId();
		return $id;
	} catch (Exception $e) {
		$act_id.'='.$e->getMessage();
	}
}



function getExcludeDate($fpr, $approver, $hod, $location, $department, $companyid){
	
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `cycle_id`=? AND `fpr_id`=? AND 
		`appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `act_id`=? AND `compliance_id`=? AND `status`=? AND `company_id`=?");
		$query->bindValue(1, 0);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $hod);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, 99998);
		$query->bindValue(8, 556);
		$query->bindValue(9, 7);
		$query->bindValue(10, $companyid);
		$query->execute();
		$result = $query->fetchAll();
		$dates = array();
		foreach($result as $ex){
			$dates[] = $ex['due_date'];			
		}
		return $dates;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getpendingApproverDate($fpr, $approver, $hod, $location, $department, $companyid){	
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `due_date`, `sr` FROM `company_compliance` WHERE `cycle_id`=? AND `fpr_id`=? AND 
		`appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `act_id`=? AND `compliance_id`=? AND `status`=? AND `company_id`=?");
		$query->bindValue(1, 0);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $hod);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, 99998);
		$query->bindValue(8, 556);
		$query->bindValue(9, 4);
		$query->bindValue(10, $companyid);
		$query->execute();
		$result = $query->fetchAll();
		$dates = array();
		$sr = array();
		foreach($result as $ex){
			$dates[] = $ex['due_date'];
			$sr [] = $ex['sr'];			
		}
		return array($dates, $sr);
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getpendingApproverDateEv($fpr, $approver, $companyid){	
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `due_date`, `sr` FROM `company_compliance` WHERE `cycle_id`=? AND `fpr_id`=? AND 
		`appr_id`=? AND `act_id`=? AND `compliance_id`=? AND `status`=? AND `company_id`=?");
		$query->bindValue(1, 0);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, 99999);
		$query->bindValue(5, 555);
		$query->bindValue(6, 4);
		$query->bindValue(7, $companyid);
		$query->execute();
		$result = $query->fetchAll();
		$dates = array();
		$sr = array();
		foreach($result as $ex){
			$dates[] = $ex['due_date'];
			$sr [] = $ex['sr'];			
		}
		return array($dates, $sr);
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getpendingApproverSrEv($fpr, $approver, $companyid){	
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `sr` FROM `company_compliance` WHERE `cycle_id`=? AND `fpr_id`=? AND 
		`appr_id`=? AND `act_id`=? AND `compliance_id`=? AND `status`=? AND `company_id`=?");
		$query->bindValue(1, 0);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, 99999);
		$query->bindValue(5, 555);
		$query->bindValue(6, 4);
		$query->bindValue(7, $companyid);
		$query->execute();
		$result = $query->fetchAll();
		$sr = array();
		foreach($result as $ex){
			$sr [] = $ex['sr'];			
		}
		return $sr;
	} catch(Exception $e){
		return $e->getMessage();
	}
}


function getExcludeDateEvent($companyid, $fpr, $approver){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `cycle_id`=? AND `fpr_id`=? AND `appr_id`=? AND `act_id`=? AND `compliance_id`=? AND (`status`=? OR `status`=?) AND `company_id`=?");
		$query->bindValue(1, 0);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, 99999);
		$query->bindValue(5, 555);
		$query->bindValue(6, 7);
		$query->bindValue(7, 4);
		$query->bindValue(8, $companyid);
		$query->execute();
		$result = $query->fetchAll();
		$dates = array();
		foreach($result as $ex){
			$dates[] = $ex['due_date'];			
		}
		return $dates;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function get_data_for_cron2_ongoing_cycle_compliances_by_company_idnewfn($company_id){
	$emails_e = email_to_deactive_for_company_compliance_2();
	$dbh = connect_db(); 
	try {
		$query = $dbh->prepare("SELECT DISTINCT `company_compliance`.`company_id`, `company_compliance`.`department`,`company_compliance`.`location`,`company_compliance`.`fpr_id`,`company_compliance`.`appr_id`,`company_compliance`.`hod_id` FROM `company_compliance` INNER JOIN `compliance` on `company_compliance`.`compliance_id`=`compliance`.`id` where `compliance`.`periodicity` like '%going%' and `company_compliance`.`hod_id`!='' and `company_compliance`.`appr_id`!='' and `company_compliance`.`status`!='2' and `company_compliance`.`status`!='7' and `company_compliance`.`location`!='' and `company_compliance`.`company_id`='$company_id' AND $emails_e");
		$query->execute();
		$result = $query->fetchAll();
		return $result; 
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getPeriodicity($sr){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `compliance`.`periodicity` FROM `compliance` JOIN `company_compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`sr`=?");
		$query->bindValue(1, $sr);
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function getCompliancedata($sr){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `sr`=?");
		$query->bindValue(1, $sr);
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function get_company_compliances_details_for_golive_cron_by_company_id_and_act_id222( $complianceid, $act ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select compliance.due_date as pattern, compliance.expiry_date as expiry_date from compliance where compliance.act_id=? AND compliance.id=?" ); 
	$query->bindValue(1, $act );
	$query->bindValue(2, $complianceid );
    $query->execute();
	$result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

// get all compliances for particular compliance_id
function getAllCompliances($complianceid, $fpr, $approver, $hod, $location, $department, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `compliance_id`=? AND `cycle_id`=? AND `fpr_id`=? AND `appr_id`=?  AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=? AND `status`!=7");
		$query->bindValue(1, $complianceid);
		$query->bindValue(2, 0);
		$query->bindValue(3, $fpr);
		$query->bindValue(4, $approver);
		$query->bindValue(5, $hod);
		$query->bindValue(6, $location);
		$query->bindValue(7, $department);
		$query->bindValue(8, $companyid);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}


function getAllCompliancesGenerated($complianceid, $fpr, $approver, $hod, $location, $department, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `compliance_id`=? AND `cycle_id`!=? AND `fpr_id`=? AND `appr_id`=?  AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=? AND `status`!=7");
		$query->bindValue(1, $complianceid);
		$query->bindValue(2, 0);
		$query->bindValue(3, $fpr);
		$query->bindValue(4, $approver);
		$query->bindValue(5, $hod);
		$query->bindValue(6, $location);
		$query->bindValue(7, $department);
		$query->bindValue(8, $companyid);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function updateCompliance($sr, $fpr, $approver, $hod, $location, $department){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET `fpr_id`=?,`hod_id`=?,`appr_id`=?,`department`=?,`location`=? WHERE `sr`=?");
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $hod);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $department);
		$query->bindValue(5, $location);
		$query->bindValue(6, $sr);
		$result = $query->execute();
		if($result){ return 1; } else { return 0; }
	} catch(Exception $e){
		return $e->getMessage();
	}
}


function updateComplianceEvent($compliance_id, $sr, $fpr, $approver, $hod, $location, $department){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET `fpr_id`=?,`hod_id`=?,`appr_id`=?,`department`=?,`location`=? WHERE `sr`=? AND `compliance_id`=?");
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $hod);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $department);
		$query->bindValue(5, $location);
		$query->bindValue(6, $sr);
		$query->bindValue(7, $compliance_id);
		$result = $query->execute();
		if($result){ return 1; } else { return 0; }
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function updateComplianceEventN($sr, $fpr, $approver, $hod, $location, $department){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET `fpr_id`=?,`hod_id`=?,`appr_id`=?,`department`=?,`location`=? WHERE `sr`=?");
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $hod);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $department);
		$query->bindValue(5, $location);
		$query->bindValue(6, $sr);
		$result = $query->execute();
		if($result){ return 1; } else { return 0; }
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function updateComplianceEventNotZero($compliance_id, $sr, $fpr, $approver, $hod, $location, $department){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET `fpr_id`=?, `appr_id`=?,  `hod_id`=?,`department`=?,`location`=? WHERE `sr`=? AND `compliance_id`=?");
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $approver);
		$query->bindValue(3, $hod);
		$query->bindValue(4, $department);
		$query->bindValue(5, $location);
		$query->bindValue(6, $sr);
		$query->bindValue(7, $compliance_id);
		$result = $query->execute();
		if($result){ return 1; } else { return 0; }
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getLivedate($companyid, $complianceid, $fpr, $appr, $hod, $location, $department){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT MIN(`live_date`) from `company_compliance` WHERE `compliance_id`=? AND `company_id`=? AND `status`!=7 AND `status`!=2 AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=?");
		$query->bindValue(1, $complianceid);
		$query->bindValue(2, $companyid);
		$query->bindValue(3, $fpr);
		$query->bindValue(4, $appr);
		$query->bindValue(5, $hod);
		$query->bindValue(6, $location);
		$query->bindValue(7, $department);
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function getAllCompliancesnotExecuted($complianceid, $fpr, $approver, $hod, $location, $department, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `sr`, `cycle_id` FROM `company_compliance` WHERE `compliance_id`=? AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=? AND (`due_date` Is NULL OR `due_date`='') AND `cycle_id`!=? AND (`status`=1 OR `status`=3 OR `status`=6) ORDER BY `sr` ASC");
		$query->bindValue(1, $complianceid);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $hod);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, $companyid);
		$query->bindValue(8, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getAllCompliancesReported($complianceid, $fpr, $approver, $hod, $location, $department, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `sr`, `cycle_id` FROM `company_compliance` WHERE `compliance_id`=? AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=? AND (`due_date` Is NULL OR `due_date`='') AND `cycle_id`!=? AND `status`=4 ORDER BY `sr` ASC");
		$query->bindValue(1, $complianceid);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $hod);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, $companyid);
		$query->bindValue(8, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getAllCompliancesnotExecutedEvent($complianceid, $fpr, $approver, $hod, $location, $department, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `compliance_id`=? AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=? AND `cycle_id`!=? AND `due_date` Is NOT NULL AND `status`!=7 AND `status`!=4");
		$query->bindValue(1, $complianceid);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $hod);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, $companyid);
		$query->bindValue(8, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

// delete compliances with cycle id !=0
function deleteCompliance($complianceid, $fpr, $approver, $hod, $location, $department, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_compliance` WHERE `compliance_id`=? AND `cycle_id`!=? AND (`status`=1 OR `status`=3 OR `status`=2 OR `status`=6 OR `status`=10) AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=?");
		$query->bindValue(1, $complianceid);
		$query->bindValue(2, 0);
		$query->bindValue(3, $fpr);
		$query->bindValue(4, $approver);
		$query->bindValue(5, $hod);
		$query->bindValue(6, $location);
		$query->bindValue(7, $department);
		$query->bindValue(8, $companyid);
		$result = $query->execute();
		if($result){ return 1;} else { return 0;}
	} catch(Exception $e){
		return $e->getMessage();
	}
}


// delete compliances with cycle id !=0 Ongoing and Event
function deleteCycleCompliances($cycle_id, $fpr, $approver, $hod, $location, $department, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_compliance` WHERE `cycle_id`=? AND (`status`=1 OR `status`=3 OR `status`=2 OR `status`=6 OR `status`=10) AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=?");
		$query->bindValue(1, $cycle_id);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $hod);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, $companyid);
		$result = $query->execute();
		if($result){ return 1;} else { return 0;}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function deleteGenCycleCompliances($cycle_id, $fpr, $approver, $hod, $location, $department, $companyid, $complianceid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_compliance` WHERE `cycle_id`=? AND `status`!=7 AND `status`!=2 AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=? AND `compliance_id`=?");
		$query->bindValue(1, $cycle_id);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $hod);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, $companyid);
		$query->bindValue(8, $complianceid);
		$result = $query->execute();
		if($result){ return 1;} else { return 0;}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function deleteComplianceEvent($complianceid, $fpr, $approver, $hod, $department, $location, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_compliance` WHERE `compliance_id`=? AND `cycle_id`!=? AND (`status`=1 OR `status`=3 OR `status`=2 OR `status`=6 OR `status`=10) AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=?");
		$query->bindValue(1, $complianceid);
		$query->bindValue(2, 0);
		$query->bindValue(3, $fpr);
		$query->bindValue(4, $approver);
		$query->bindValue(5, $hod);
		$query->bindValue(6, $location);
		$query->bindValue(7, $department);
		$query->bindValue(8, $companyid);
		$result = $query->execute();
		if($result){ return 1;} else { return 0;}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getDuedate($sr){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `due_date` FROM `company_compliance` WHERE `sr`=? AND `cycle_id`=?");
		$query->bindValue(1, $sr);
		$query->bindValue(2, 0);
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function minCycleDate($fpr, $approver, $hod, $department, $location, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT MIN(`due_date`) FROM `company_compliance` WHERE `compliance_id`=? AND `cycle_id`=? AND (`status`=1 OR `status`=3 OR `status`=6) AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=? AND `due_date`!=''");
		$query->bindValue(1, '556');
		$query->bindValue(2, 0);
		$query->bindValue(3, $fpr);
		$query->bindValue(4, $approver);
		$query->bindValue(5, $hod);
		$query->bindValue(6, $location);
		$query->bindValue(7, $department);
		$query->bindValue(8, $companyid);
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function minCycleDateEvent($fpr, $approver, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT MIN(`due_date`) FROM `company_compliance` WHERE `compliance_id`=? AND `cycle_id`=? AND (`status`=1 OR `status`=3 OR `status`=6) AND `fpr_id`=? AND `appr_id`=? AND `company_id`=? AND `due_date`!=''");
		$query->bindValue(1, '555');
		$query->bindValue(2, 0);
		$query->bindValue(3, $fpr);
		$query->bindValue(4, $approver);
		$query->bindValue(5, $companyid);
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function getParentCompliance($companyid, $fpr, $approver, $hod, $location, $department){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `compliance_id`=? AND `act_id`=? AND `cycle_id`=? AND (`status`=1 OR `status`=3 OR `status`=6)");
		$query->bindValue(1, $companyid);	
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $hod);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, 556);
		$query->bindValue(8, 99998);
		$query->bindValue(9, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}


function getPreParentCompliance($companyid, $fpr, $approver, $hod, $location, $department){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `compliance_id`=? AND `act_id`=? AND `cycle_id`=? AND `status`!=7");
		$query->bindValue(1, $companyid);	
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $hod);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, 556);
		$query->bindValue(8, 99998);
		$query->bindValue(9, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function getParentComplianceEvent($companyid, $duedate, $fpr, $approver){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? AND`due_date`=? AND `fpr_id`=? AND `appr_id`=? AND `compliance_id`=? AND `act_id`=? AND `cycle_id`=?");
		$query->bindValue(1, $companyid);
		$query->bindValue(2, $duedate);
		$query->bindValue(3, $fpr);
		$query->bindValue(4, $approver);
		$query->bindValue(5, 555);
		$query->bindValue(6, 99999);
		$query->bindValue(7, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function getParentComplianceEventN($companyid, $fpr, $approver){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? AND `fpr_id`=? AND `appr_id`=? AND `compliance_id`=? AND `act_id`=? AND `cycle_id`=? AND `status`!=7 AND `status`!=4");
		$query->bindValue(1, $companyid);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, 555);
		$query->bindValue(5, 99999);
		$query->bindValue(6, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function getParentComplianceEventNnn($companyid, $fpr, $approver, $query){
    $dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? AND `fpr_id`=? AND `appr_id`=? AND `compliance_id`=? AND `act_id`=? AND `cycle_id`=? AND (`status`=1 OR `status`=3 OR `status`=6 $query)");
		$query->bindValue(1, $companyid);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, 555);
		$query->bindValue(5, 99999);
		$query->bindValue(6, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function insertEditlogEvent($type, $old_data, $new_data, $editorid, $editorrole, $company_id, $event_name, $sr=""){
	$dbh = connect_db();
	$date = date("Y-m-d");
	$time = date("h:i:s");
	$ip = $_SERVER['REMOTE_ADDR'];
	try{
		$query = $dbh->prepare("INSERT INTO `edit_wizard_log`(`type`, `previous_data`, `new_data`, `editor_id`, `editor_role`, `company_id`, `sr`, `event_name`, `date`, `time`, `ip`) VALUES (?,?,?,?,?,?,?,?,?,?)");
		$query->bindValue(1, $type);
		$query->bindValue(2, $old_data);
		$query->bindValue(3, $new_data);
		$query->bindValue(4, $editorid);
		$query->bindValue(5, $editorrole);
		$query->bindValue(6, $company_id);
		$query->bindValue(7, $event_name);
		$query->bindValue(8, $sr);
		$query->bindValue(9, $date);
		$query->bindValue(10, $time);
		$query->bindValue(11, $ip);		
		$result = $query->execute();
		if($result){ 
			return 1;
		} else {
			return 0;
		}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function insertEditlog($type, $previousdata, $newdate, $editorid, $editorrole, $companyid, $complianceid, $actid, $sr){
	$dbh = connect_db();
	$date = date("Y-m-d");
	$time = date("h:i:s");
	$ip = $_SERVER['REMOTE_ADDR'];
	try{
		$query = $dbh->prepare("INSERT INTO `edit_wizard_log`(`type`, `previous_data`, `new_data`, `editor_id`, `editor_role`, `company_id`, `compliance_id`, `act_id`, `sr`, `date`, `time`, `ip`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
		$query->bindValue(1, $type);
		$query->bindValue(2, $previousdata);
		$query->bindValue(3, $newdate);
		$query->bindValue(4, $editorid);
		$query->bindValue(5, $editorrole);
		$query->bindValue(6, $companyid);
		$query->bindValue(7, $complianceid);
		$query->bindValue(8, $actid);
		$query->bindValue(9, $sr);
		$query->bindValue(10, $date);
		$query->bindValue(11, $time);
		$query->bindValue(12, $ip);
		$result = $query->execute();
		if($result){ return 1;} else {return 0;}
	} catch(Exception $e){
		return $e->getMessage();
	}
}


function checkEvent($ev, $fpr, $approver){
	$companyid = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_event` WHERE `company_id`=? AND `event_name`=? AND `fpr_user_id`=? AND `appr_user_id`=? AND `cycle_id`=?");
		$query->bindValue(1, $companyid);
		$query->bindValue(2, $ev);
		$query->bindValue(3, $fpr);
		$query->bindValue(4, $approver);
		$query->bindValue(5, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getEventResult($evname, $fpr, $approver){
	$res = array();
	foreach($evname as $ev){
		if($ev != ""){
			$checkEvent = checkEvent($ev, $fpr, $approver);
			$res[] = $checkEvent;
		} 
	}
	return $res;
}

function get_min_live_date_by_company_id_fpr_appr_for_event_cycle( $company_id, $fpr, $appr) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT MIN(`company_compliance`.`live_date`) FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id`=`compliance`.`id` WHERE `compliance`.`periodicity` LIKE '%event%' AND `company_compliance`.`company_id`=? AND `company_compliance`.`fpr_id`=? AND `company_compliance`.`appr_id`=? AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`live_date` IS NOT NULL AND `company_compliance`.`status`!=7 AND `company_compliance`.`status`!=4" );
		$query->bindValue( 1, $company_id );
		$query->bindValue( 2, $fpr );
		$query->bindValue( 3, $appr );
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_min_live_date_by_company_id_fpr_appr_for_Oging_cycle($company_id, $fpr, $appr, $hod, $loc, $dep ) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT MIN(`company_compliance`.`live_date`) FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id`=`compliance`.`id` WHERE `compliance`.`periodicity` LIKE '%going%' AND `company_compliance`.`fpr_id`=? AND `company_compliance`.`appr_id`=? AND `company_compliance`.`hod_id`=? AND `company_compliance`.`location`=? AND `company_compliance`.`department`=? AND `company_compliance`.`company_id`=? AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`live_date` IS NOT NULL AND `company_compliance`.`status`!=7 AND `company_compliance`.`status`!=4" );		
		$query->bindValue( 1, $fpr );
		$query->bindValue( 2, $appr );
		$query->bindValue( 3, $hod );
		$query->bindValue( 4, $loc );
		$query->bindValue( 5, $dep );
		$query->bindValue( 6, $company_id );
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function update_event_compliance_by_all($event, $appr, $fpr, $company_id, $prfpr, $prappr){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "update company_event set fpr_user_id=?, appr_user_id=? where fpr_user_id=? and appr_user_id=? and company_id=? and cycle_id=? and event_name=?" );
		$query->bindValue( 1, $fpr );
		$query->bindValue( 2, $appr );
		$query->bindValue( 3, $prfpr );
		$query->bindValue( 4, $prappr );
		$query->bindValue( 5, $company_id );
		$query->bindValue( 6, '0' );
		$query->bindValue( 7, $event );
		$result = $query->execute();
		if($result){ $result= "1";} else { $result= "0";}
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function update_event_by_sr_new($sr, $appr, $fpr, $company_id, $prfpr, $prappr){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "UPDATE `company_event` SET `fpr_user_id`=?, `appr_user_id`=? WHERE `fpr_user_id`=? AND `appr_user_id`=? AND `company_id`=? AND `cycle_id`=? AND `sr`=?" );
		$query->bindValue( 1, $fpr );
		$query->bindValue( 2, $appr );
		$query->bindValue( 3, $prfpr );
		$query->bindValue( 4, $prappr );
		$query->bindValue( 5, $company_id );
		$query->bindValue( 6, '0' );
		$query->bindValue( 7, $sr );
		$result = $query->execute();
		if($result){ $result= "1";} else { $result= "0";}
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function checkpreComp($previousfpr, $previousappr, $event_name){
    $company_id = $_SESSION['company_id'];
	$event = ';'.$event_name.';';
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` AND `compliance`.`event` LIKE '%$event%' AND `company_compliance`.`fpr_id`=? AND `company_compliance`.`appr_id`=? AND `company_compliance`.`cycle_id`=? AND `company_compliance`.`status`!=? AND `company_compliance`.`company_id`=?" );
		$query->bindValue( 1, $previousfpr );
		$query->bindValue( 2, $previousappr );
		$query->bindValue( 3, 0 );
		$query->bindValue( 4, 7 );
		$query->bindValue( 5, $company_id );
		$result = $query->fetchAll();
		if($result!=false){
		    if(count($result)>=1){
		        return 1;
		    } else {
		        return 0;
		    }
		} else {
		    return 0;
		}
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function update_event_eventName($appr, $fpr, $prfpr, $prappr, $event_name){
    $company_id = $_SESSION['company_id'];
    $check = checkpreComp($prfpr, $prappr, $event_name);
    if($check == 1){
        $dbh = connect_db();
    	try {
    		$query = $dbh->prepare( "INSERT INTO `company_event`(`company_id`, `event_name`, `fpr_user_id`, `status`, `appr_user_id`, `cycle_id`) VALUES (?,?,?,?,?,?)" );
    		$query->bindValue( 1, $company_id );
    		$query->bindValue( 2, $event_name );
    		$query->bindValue( 3, $fpr );
    		$query->bindValue( 4, 1 );
    		$query->bindValue( 3, $appr );
    		$query->bindValue( 6, '0' );
    		$result = $query->execute();
    		if($result){ $result= "1";} else { $result= "0";}
    		return $result;
    	} catch (Exception $e) {
    		return $e->getMessage();
    	}
    } else {
    	$dbh = connect_db();
    	try {
    		$query = $dbh->prepare( "UPDATE `company_event` SET `fpr_user_id`=?, `appr_user_id`=? WHERE `fpr_user_id`=? AND `appr_user_id`=? AND `company_id`=? AND `cycle_id`=? AND `event_name`=?" );
    		$query->bindValue( 1, $fpr );
    		$query->bindValue( 2, $appr );
    		$query->bindValue( 3, $prfpr );
    		$query->bindValue( 4, $prappr );
    		$query->bindValue( 5, $company_id );
    		$query->bindValue( 6, '0' );
			$query->bindValue( 7, $event_name );
    		$result = $query->execute();
    		if($result){ $result= "1";} else { $result= "0";}
    		return $result;
    	} catch (Exception $e) {
    		return $e->getMessage();
    	}
    }
}


function get_event_by_fpr_id_company_event($apprid, $fprid, $event, $company_id){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("Select * FROM `company_event` where `fpr_user_id`=? and `appr_user_id`=? and `company_id`=? and `event_name`=? and cycle_id = ?");	
		$query->bindValue( 1, $fprid );
		$query->bindValue( 2, $apprid );
		$query->bindValue( 3, $company_id );
		$query->bindValue( 4, $event );
		$query->bindValue( 5, 0 );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function deleteAllPreviousEventsComp($company_id, $prevfpr, $prevappr){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_compliance` WHERE `company_id`=? AND `fpr_id`=? AND `appr_id`=? AND `cycle_id`=? AND (`status`=1 OR `status`=2 OR `status`=3 OR `status`=6) AND `act_id`=? AND `compliance_id`=?");
		$query->bindValue(1, $company_id);
		$query->bindValue(2, $prevfpr);
		$query->bindValue(3, $prevappr);
		$query->bindValue(4, 0);
		$query->bindValue(5, 99999);
		$query->bindValue(6, 555);
		$result = $query->execute();
		if($result){
			return 1;
		} else {
			return 0;
		}
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function checkEventsforPreviousfprappr($company_id, $prevfpr, $prevappr){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `sr` FROM `company_event` WHERE `company_id`=? AND `fpr_user_id`=? AND `appr_user_id`=? AND `cycle_id`=?");
		$query->bindValue(1, $company_id);
		$query->bindValue(2, $prevfpr);
		$query->bindValue(3, $prevappr);
		$query->bindValue(4, 0);
		$query->execute();
		$result = $query->fetchAll();
		if(count($result)>=1){
			return count($result);
		} else {
			return 0;
		}
	} catch(Exception $e){
		$e->getMessage();
	}
}

function select_company_compliance_status_seven($company, $act_id) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT * from `company_compliance` WHERE company_id=? and act_id=? and status=?");
		$query->bindValue( 1, $company );
		$query->bindValue( 2, $act_id );
		$query->bindValue( 3, '7' );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function delete_company_compliance_in_event($company, $act_id, $due){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("DELETE FROM `company_compliance` WHERE company_id=? and act_id=? and due_date=? and `status` !=? ");
		$query->bindValue( 1, $company );
		$query->bindValue( 2, $act_id );
		$query->bindValue( 3, $due );
		$query->bindValue( 4, '7' );
		$result = $query->execute();
		if($result){ $rs = '1';} else { $rs = '0'; }
		return $rs;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCompliancesofAct($company_id, $act_id, $fpr, $approver, $hod, $location, $department){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? AND `act_id`=? AND `fpr_id`=? AND `appr_id`=? 
		AND `hod_id`=? AND `location`=? AND `department`=? AND `cycle_id`=? 
		AND (`status`=1 OR `status`=2 OR `status`=3 OR `status`=6 OR `status`=10)");
		$query->bindValue(1, $company_id);
		$query->bindValue(2, $act_id);
		$query->bindValue(3, $fpr);
		$query->bindValue(4, $approver);
		$query->bindValue(5, $hod);
		$query->bindValue(6, $location);
		$query->bindValue(7, $department);
		$query->bindValue(8, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
	
}

function get_compliance_id_get_sr( $location, $department, $hod, $approver, $fpr, $complid, $actid, $company) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("Select * from company_compliance where company_id=? and hod_id=? and fpr_id=? and appr_id=? and location=? and department=? and act_id=? and compliance_id=? and status!=? and cycle_id='0'");
		$query->bindValue( 1, $company );
		$query->bindValue( 2, $hod );
		$query->bindValue( 3, $fpr );
		$query->bindValue( 4, $approver );
		$query->bindValue( 5, $location );
		$query->bindValue( 6, $department );
		$query->bindValue( 7, $actid );
		$query->bindValue( 8, $complid );
		$query->bindValue( 9, '7' );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}	

function getPerdiodicityofCompliance($compliance_id){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `periodicity` FROM `compliance` WHERE `id`=?");
		$query->bindValue(1, $compliance_id);
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCycleCompliancedel($location, $department, $hod, $appr, $fpr, $compid, $act_id, $com_id){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `compliance_id`=? AND `company_id`=? AND `location`=? AND 
		`department`=? AND `hod_id`=? AND `fpr_id`=? AND `appr_id`=? AND `act_id`=? AND `status`!=? AND `cycle_id`!=?");
		$query->bindValue(1, $compid);
		$query->bindValue(2, $com_id);
		$query->bindValue(3, $location);
		$query->bindValue(4, $department);
		$query->bindValue(5, $hod);
		$query->bindValue(6, $fpr);
		$query->bindValue(7, $appr);
		$query->bindValue(8, $act_id);
		$query->bindValue(9, 7);
		$query->bindValue(10, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function deleteEvent($eventName, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_event` WHERE event_name=? and company_id=? and cycle_id=?");
		$query->bindValue(1, $eventName);
		$query->bindValue(2, $companyid);
		$query->bindValue(3, 0);
		$result = $query->execute();
		if($result){ return 1; } else { return 0;}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function insertDeletelog($editorid, $editorrole, $companyid, $complianceid, $actid, $eventname=false, $data){
	$dbh = connect_db();
	$date = date("Y-m-d");
	$time = date("h:i:s");
	$ip = $_SERVER['REMOTE_ADDR'];
	try{
		$query = $dbh->prepare("INSERT INTO `delete_compliance_log`(`editor_id`, `editor_role`, `data`, `company_id`, `compliance_id`, `act_id`, `event_name`, `date`, `time`, `ip`) VALUES (?,?,?,?,?,?,?,?,?,?)");
		$query->bindValue(1, $editorid);
		$query->bindValue(2, $editorrole);
		$query->bindValue(3, $data);
		$query->bindValue(4, $companyid);
		$query->bindValue(5, $complianceid);
		$query->bindValue(6, $actid);
		$query->bindValue(7, $eventname);
		$query->bindValue(8, $date);
		$query->bindValue(9, $time);
		$query->bindValue(10, $ip);
		$result = $query->execute();
		if($result){ return 1;} else {return 0;}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getSrforaccordingtoAct($com_id, $act_id, $location, $department, $appr, $fpr, $hod){
		$dbh = connect_db();
		try {
			$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id` = ? and `act_id` = ? 
			and `status` != ? and `fpr_id` = ? and `appr_id` = ? and `hod_id` = ? and `location` = ? and `department` = ? ");
			$query->bindValue(1, $com_id);
			$query->bindValue(2, $act_id);
			$query->bindValue(3, 7);
			$query->bindValue(4, $fpr);
			$query->bindValue(5, $appr);
			$query->bindValue(6, $hod);
			$query->bindValue(7, $location);
			$query->bindValue(8, $department);
			$query->execute();
			$result = $query->fetchAll();
			return $result;
		} catch(Exception $e){
			return $e->getMessage();
		}
	}


function select_company_compliance_by_status( $sr) 
{
  $dbh = connect_db();
  try {
    $query = $dbh->prepare("DELETE FROM `company_compliance` WHERE sr=?");
	$query->bindValue( 1, $sr );
    $result = $query->execute();
	if($result){ $rs = '1';} else { $rs = '0'; }
    return $rs;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function delete_user_role_in_email($company, $user_id, $type) 
{
  $dbh = connect_db();
  try {
    $query = $dbh->prepare("DELETE FROM `user_role` WHERE user_id=? and Company_id=? and user_role=?");
	$query->bindValue( 1, $user_id );
	$query->bindValue( 2, $company );
	$query->bindValue( 3, $type );
    $result = $query->execute();
	if($result){ $rs = '1';} else { $rs = '0'; }
    return $rs;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_compliance_id_get_sr_n( $location, $department, $hod, $approver, $fpr, $actid, $company) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare("Select * from company_compliance where company_id=? and hod_id=? and fpr_id=? and appr_id=? and location=? and department=? and act_id=?  and status!=?");
	$query->bindValue( 1, $company );
	$query->bindValue( 2, $hod );
	$query->bindValue( 3, $fpr );
	$query->bindValue( 4, $approver );
	$query->bindValue( 5, $location );
	$query->bindValue( 6, $department );
	$query->bindValue( 7, $actid );
	$query->bindValue( 8, '7' );
    $query->execute();
    $result = $query->fetchAll();
	//$result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function update_get_compliance_by_ids($fpr, $hod, $appr, $company_id, $act_id, $fprz, $hodz, $apprz ,$location, $department,$prevloc,$prevdep) { 
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "UPDATE `company_compliance` SET `fpr_id`=?,`hod_id`=?,`appr_id`=?,`department`=?,`location`=? WHERE `fpr_id`=? and `hod_id`=? and `appr_id`=? and `act_id`=? and `company_id`=? and `location`=? and `department`=?" );
    $query->bindValue( 1, $fpr );
	$query->bindValue( 2, $hod );
	$query->bindValue( 3, $appr );
	$query->bindValue( 4, $department );
	$query->bindValue( 5, $location );
    $query->bindValue( 6, $fprz );
	$query->bindValue( 7, $hodz );
	$query->bindValue( 8, $apprz );
	$query->bindValue( 9, $act_id );
	$query->bindValue( 10, $company_id );
		$query->bindValue( 11, $prevloc );
	$query->bindValue( 12, $prevdep );
    $result = $query->execute();
	if($result){ $cv = '1' ;} else { $cv = '0';} 
	return $cv;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function check_in_email_company_compliance($email, $role) { 
	$company_id = $_SESSION['company_id'];
  $dbh = connect_db();
  try {
	  if($role=='hod'){
    $query = $dbh->prepare( "select * from company_compliance where company_id = ? and hod_id=?" );
	$query->bindValue( 1, $company_id );
	$query->bindValue( 2, $email );
	  }elseif($role=='fpr'){
	$query = $dbh->prepare( "select * from company_compliance where company_id = ? and fpr_id=?" );
	$query->bindValue( 1, $company_id );
	$query->bindValue( 2, $email );  
	  }elseif($role=='appr')
	  {
	$query = $dbh->prepare( "select * from company_compliance where company_id = ? and appr_id=?" );
	$query->bindValue( 1, $company_id );
	$query->bindValue( 2, $email );	  
	  }else{
	$query = $dbh->prepare( "select * from company_compliance where company_id = ? and company_id=?" );
	$query->bindValue( 1, $company_id );
	$query->bindValue( 2, $email );	  
	  }
    $result = $query->execute();
	if($result){ $cv = '1' ;} else { $cv = '0';} 
	return $cv;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_company_compliance_by_sr( $id ) {
  $dbh = connect_db();
  try {
	  $company_id=$_SESSION['company_id']; 
    $query = $dbh->prepare( "select * from `company_compliance` where sr=? and company_id = ?" );
    $query->bindValue( 1, $id );
	$query->bindValue( 2, $company_id );
    $query->execute();
	$result = $query->fetchAll();
    //$result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

/*----------------- allocation_wizard.php ---------------*/
function get_company_compliances_id_by_act_id_and_company_id( $act_id,$company_id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select count(distinct(compliance_id)) from company_compliance where act_id=? and company_id=?" );
    $query->bindValue( 1, $act_id );
	$query->bindValue( 2, $company_id );
    $query->execute();
	//$result = $query->fetchAll();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function fetch_All_location_from_company_compliance_status_for_alloc( $company_id, $act_id, $status, $compliance )
{
  $dbh = connect_db();
  try {
	$role=$_SESSION['user_role'];
		$user=get_user_by_id( $_SESSION['user_id'] );
		if($role=="FPR" or $role=="Fpr" or $role=="fpr"){ 
			$user_mail=$user['email'];
			
			$query = $dbh->prepare("Select count(*) from company_compliance where company_id=? and fpr_id='$user_mail' and act_id='$act_id' and compliance_id='$compliance'");
		}elseif($role=="APPROVER" or $role=="Approver" or $role=="approver"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select count(*) from company_compliance where company_id=? and appr_id='$user_mail' and act_id='$act_id' and compliance_id='$compliance'");
		}elseif($role=="HOD" or $role=="Hod" or $role=="hod"){ 
			$user_mail=$user['email'];
			$query = $dbh->prepare("Select count(*) from company_compliance where company_id=? and hod_id='$user_mail' and act_id='$act_id' and compliance_id='$compliance'");
		}else{
		  $query = $dbh->prepare("Select count(*) from company_compliance where company_id=? and act_id='$act_id' and compliance_id='$compliance' and `status` !=7 and cycle_id = 0");
		}
    //$query = $dbh->prepare("Select distinct location from company_compliance where company_id=?");
	$query->bindValue( 1, $company_id );
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
	return $result;
	}
	catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_compliances_id_by_act_id_and_company_id_with_limit( $act_id,$start,$limit ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "SELECT id FROM `compliance` WHERE act_id=?  order by id asc limit $start,$limit " );
    $query->bindValue( 1, $act_id );
	//$query->bindValue( 2, $start );
	//$query->bindValue( 3, $limit );
    $query->execute();
	$result = $query->fetchAll();
    //$result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_all_compliances_id_by_act_id_only_comp( $act_id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select `id` from compliance where act_id=? and status=?  order by id asc" );
    $query->bindValue( 1, $act_id );
	$query->bindValue( 2, 1 );
    $query->execute();
	$result = $query->fetchAll();
    //$result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_all_compliances_id_by_act_id_only_count( $act_id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select count(*) from compliance where act_id=? and status=?" );
    $query->bindValue( 1, $act_id );
	$query->bindValue( 2, 1 );
    $query->execute();
	//$result = $query->fetchAll();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function complianceDataExists($location, $department, $compid, $act_id, $company, $fpr, $hod, $approver){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? AND `act_id`=? AND 
		`compliance_id`=? AND `fpr_id`=? AND `hod_id`=? AND `appr_id`=? AND `department`=? AND `location`=?");
		$query->bindValue(1, $company);
		$query->bindValue(2, $act_id);
		$query->bindValue(3, $compid);
		$query->bindValue(4, $fpr);
		$query->bindValue(5, $hod);
		$query->bindValue(6, $approver);
		$query->bindValue(7, $department);
		$query->bindValue(8, $location);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function insertDupLog($editorid, $editorrole, $company, $compid, $act_id, $dataComp){
	$dbh = connect_db();
	$date = date("Y-m-d");
	$time = date("h:i:s");
	$ip = $_SERVER['REMOTE_ADDR'];
	try{
		$query = $dbh->prepare("INSERT INTO `duplicate_compliance_log`(`editor_id`, `editor_role`, `data`, 
		`company_id`, `compliance_id`, `act_id`, `date`, `time`, `ip`) VALUES (?,?,?,?,?,?,?,?,?)");
		$query->bindValue(1, $editorid);
		$query->bindValue(2, $editorrole);
		$query->bindValue(3, $dataComp);
		$query->bindValue(4, $company);
		$query->bindValue(5, $compid);
		$query->bindValue(6, $act_id);
		$query->bindValue(7, $date);
		$query->bindValue(8, $time);
		$query->bindValue(9, $ip);
		$result = $query->execute();
		if($result){ return 1;} else {return 0;}
	} catch(Exception $e){
		return $e->getMessage();
	}
}


// Delegation 
function updateCompanyEvent($sr, $role, $olduser, $newuser, $checUser){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = "";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_user_id`';
		$nparam = '`appr_user_id`';
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_user_id`';
		$nparam = '`fpr_user_id`';
	}
	try{
		$query = $dbh->prepare("UPDATE `company_event` SET $param=? WHERE $param=? AND `company_id`=? AND `sr`=? AND $nparam=? AND `cycle_id`=?");
		$query->bindValue(1, $newuser);
		$query->bindValue(2, $olduser);
		$query->bindValue(3, $company_id);
		$query->bindValue(4, $sr);
		$query->bindValue(5, $checUser);
		$query->bindValue(6, 0);
		$result = $query->execute();
		if($result){
			return 1;
		} else {
			return 0;
		}
	} catch(Exception $e){
		return $e->getMessage();
	}
}
function checkEventAssigned($user, $role, $anotherUser){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = "";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_user_id`';
		$nparam = '`appr_user_id`';
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_user_id`';
		$nparam = '`fpr_user_id`';
	}
	try{
		$query = $dbh->prepare("SELECT `sr`,`event_name` FROM `company_event` WHERE $param = ? AND `company_id`=? AND `cycle_id`=? AND $nparam=?");
		$query->bindValue(1, $user);
		$query->bindValue(2, $company_id);
		$query->bindValue(3, 0);
		$query->bindValue(4, $anotherUser);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function updateComplianceAll($role, $olduser, $newuser, $fpr, $appr, $hod, $location, $department){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = ""; $nparam=""; $mparam="";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_id`';
		$nparam = '`appr_id`'; $ndata = $appr;
		$mparam = '`hod_id`'; $mdata = $hod;
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_id`';
		$nparam = '`fpr_id`'; $ndata = $fpr;
		$mparam = '`hod_id`'; $mdata = $hod;
	} elseif(strtoupper($role) == "HOD"){
		$param = '`hod_id`';
		$nparam = '`fpr_id`'; $ndata = $fpr;
		$mparam = '`appr_id`'; $mdata = $appr;
	}
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET $param = ? WHERE $param =? AND $nparam =? AND $mparam=? AND `company_id`=? AND 
		`location`=? AND `department`=? AND `status`!=?");
		$query->bindValue(1, $newuser);
		$query->bindValue(2, $olduser);
		$query->bindValue(3, $ndata);
		$query->bindValue(4, $mdata);
		$query->bindValue(5, $company_id);
		$query->bindValue(6, $location);
		$query->bindValue(7, $department);
		$query->bindValue(8, 7);
		$result = $query->execute();
		if($result){
			return 1;
		} else {
			return 0;
		}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function selectComplianceAll($role, $olduser, $newuser, $fpr, $appr, $hod, $location, $department){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = ""; $nparam=""; $mparam=""; $ndata=""; $mdata="";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_id`';
		$nparam = '`appr_id`'; $ndata = $appr;
		$mparam = '`hod_id`'; $mdata = $hod;
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_id`';
		$nparam = '`fpr_id`'; $ndata = $fpr;
		$mparam = '`hod_id`'; $mdata = $hod;
	} elseif(strtoupper($role) == "HOD"){
		$param = '`hod_id`';
		$nparam = '`fpr_id`'; $ndata = $fpr;
		$mparam = '`appr_id`'; $mdata = $appr;
	}
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE $param =? AND $nparam =? AND $mparam=? AND `company_id`=? AND `location`=? AND `department`=? AND `status`!=?");
		$query->bindValue(1, $olduser);
		$query->bindValue(2, $ndata);
		$query->bindValue(3, $mdata);
		$query->bindValue(4, $company_id);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, 7);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function checkifComplianceisevent($compliance_id){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `periodicity` FROM `compliance` WHERE `id`=?");
		$query->bindValue(1, $compliance_id);
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getEventName($compliance_id){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `event` FROM `compliance` WHERE `id`=?");
		$query->bindValue(1, $compliance_id);
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getEventnameAct($actid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `event` FROM `compliance` WHERE `act_id`=?");
		$query->bindValue(1, $actid);
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['event'];
		}
		return $rArray;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getEventscompliance($prevfpr, $prevappr, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id`=`compliance`.`id` WHERE `compliance`.`periodicity` LIKE '%event%' AND `company_compliance`.`fpr_id`=? AND `company_compliance`.`appr_id`=? AND `company_compliance`.`company_id`=?");
		$query->bindValue(1, $prevfpr);
		$query->bindValue(2, $prevappr);
		$query->bindValue(3, $companyid);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getEventforPrevious($prevfpr, $prevappr, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_event` WHERE `fpr_user_id`=? AND `appr_user_id`=? AND `company_id`=?");
		$query->bindValue(1, $prevfpr);
		$query->bindValue(2, $prevappr);
		$query->bindValue(3, $companyid);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function insertDellog($type, $previousdata, $newdata, $editorid, $editorrole, $companyid, $complianceid, $actid, $eventName=NULL){
	$dbh = connect_db();
	$date = date("Y-m-d");
	$time = date("h:i:s");
	$ip = $_SERVER['REMOTE_ADDR'];
	try{
		$query = $dbh->prepare("INSERT INTO `delegation_user_log`(`type`, `previous_data`, `new_data`, `editor_id`, `editor_role`, `company_id`, `compliance_id`, `act_id`, `event_name`, `date`, `time`, `ip`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
		$query->bindValue(1, $type);
		$query->bindValue(2, $previousdata);
		$query->bindValue(3, $newdata);
		$query->bindValue(4, $editorid);
		$query->bindValue(5, $editorrole);
		$query->bindValue(6, $companyid);
		$query->bindValue(7, $complianceid);
		$query->bindValue(8, $actid);
		$query->bindValue(9, $eventName);
		$query->bindValue(10, $date);
		$query->bindValue(11, $time);
		$query->bindValue(12, $ip);
		$result = $query->execute();
		if($result){ return 1;} else {return 0;}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function select_user_live_or_not($company_id, $new_email, $role){
	$dbh = connect_db();
	$newRole = "";
	if(strtoupper($role) == "FPR"){
		$newRole = "Fpr";
	} elseif(strtoupper($role) == "APPROVER"){
		$newRole = "Approver";
	} elseif(strtoupper($role) == "HOD"){
		$newRole = "Hod";
	}
	try{	
		$rf = get_user_by_email( $new_email );
		$new_id = $rf['user_id'];
		$date = date('Y-m-d');
		$query = $dbh->prepare("SELECT count(*) as total FROM `user_role` WHERE `Company_id` = ? AND `user_id` = ? AND `user_role` = ?");
		$query->bindValue( 1, $company_id );
		$query->bindValue( 2, $new_id );
		$query->bindValue( 3, $newRole );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['total'];
	} catch (Exception $e) {
		return $e->getMessage();
	}	
	
}

function checkifnoRole($olduser){
	$dbh = connect_db();
	$rf = get_user_by_email( $olduser );
	$user_id = $rf['user_id'];
	$company_id = $_SESSION['company_id'];
	try{
		$query = $dbh->prepare("SELECT COUNT(`id`) FROM `user_role` WHERE `user_id`=? AND `company_id`=?"); 
		$query->bindValue(1, $user_id);
		$query->bindValue(2, $company_id);
		$query->execute();
		$result = $query->fetchColumn();
		if(count($result>0)){
			return $result;
		} else {
			return 0;
		}
	} catch(Exception $e){
		$e->getMessage();
	}
}

function updateCompanyEventAll($sr, $role, $olduser, $newuser){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = "";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_user_id`';
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_user_id`';
	}
	try{
		$query = $dbh->prepare("UPDATE `company_event` SET $param=? WHERE $param=? AND `company_id`=? AND `sr`=? AND `cycle_id`=?");
		$query->bindValue(1, $newuser);
		$query->bindValue(2, $olduser);
		$query->bindValue(3, $company_id);
		$query->bindValue(4, $sr);
		$query->bindValue(5, 0);
		$result = $query->execute();
		if($result){
			return 1;
		} else {
			return 0;
		}
	} catch(Exception $e){
		return $e->getMessage();
	}
}
function checkEventAssignedAll($user, $role){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = "";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_user_id`';
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_user_id`';
	}
	try{
		$query = $dbh->prepare("SELECT `sr`,`event_name` FROM `company_event` WHERE $param = ? AND `company_id`=? AND `cycle_id`=?");
		$query->bindValue(1, $user);
		$query->bindValue(2, $company_id);
		$query->bindValue(3, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function updateComplianceAllWhole($role, $olduser, $newuser){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = "";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_id`';
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_id`';
	} elseif(strtoupper($role) == "HOD"){
		$param = '`hod_id`';
	}
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET $param = ? WHERE $param =? AND `company_id`=? AND `status`!=?");
		$query->bindValue(1, $newuser);
		$query->bindValue(2, $olduser);
		$query->bindValue(3, $company_id);
		$query->bindValue(4, 7);
		$result = $query->execute();
		if($result){
			return 1;
		} else {
			return 0;
		}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function selectComplianceAllWhole($role, $olduser, $newuser){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = "";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_id`';
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_id`';
	} elseif(strtoupper($role) == "HOD"){
		$param = '`hod_id`';
	}
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE $param =? AND `company_id`=? AND `status`!=?");
		$query->bindValue(1, $olduser);
		$query->bindValue(2, $company_id);
		$query->bindValue(3, 7);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}


// editwizard_update_logs_for_management_and_auditor
function getUserRoleData($role){
    $company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `user_role` WHERE `user_role`=? AND `company_id`=?");
		$query->bindValue(1, $role);
		$query->bindValue(2, $company_id);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getarrayReplaced($array, $newvalue, $value){
	$nArray = explode(',',$array);
	$nArray = array_replace($nArray,
		array_fill_keys(
			array_keys($nArray, $value),
			$newvalue
		)
	);
	$mn = implode(',',$nArray);
	return $mn;
}

function getarrayAppend($array, $value){
	$nArray = explode(',',$array);
	array_push($nArray, $value);
	$mn = implode(',',$nArray);
	return $mn;
}

function updateLocation($id, $location, $department){
	$companyid = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `user_role` SET `location`=?, `Department`=? WHERE `id`=? AND `company_id`=?");
		$query->bindValue(1, $location);
		$query->bindValue(2, $department);
		$query->bindValue(3, $id);
		$query->bindValue(4, $companyid);
		$result = $query->execute();
		if($result){
			return 1;
		} else {
			return 0;
		}		
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function updateDepartment($id, $department, $location){
	$companyid = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `user_role` SET `Department`=?, `location`=? WHERE `id`=? AND `company_id`=?");
		$query->bindValue(1, $department);
		$query->bindValue(2, $location);
		$query->bindValue(3, $id);
		$query->bindValue(4, $companyid);
		$result = $query->execute();
		if($result){
			return 1;
		} else {
			return 0;
		}		
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function insertUpdateLog($type, $oldData, $newData, $editorid, $editorrole, $companyid, $user_id){
	$dbh = connect_db();
	$date = date("Y-m-d");
	$time = date("h:i:s");
	$ip = $_SERVER['REMOTE_ADDR'];
	try{
		$query = $dbh->prepare("INSERT INTO `manage_audit_userlog`(`type`, `previous_data`, `new_data`, `editor_id`, `editor_role`, `company_id`, `user_id`, `date`, `time`, `ip`) 
		VALUES (?,?,?,?,?,?,?,?,?,?)");
		$query->bindValue(1, $type);
		$query->bindValue(2, $oldData);
		$query->bindValue(3, $newData);
		$query->bindValue(4, $editorid);
		$query->bindValue(5, $editorrole);
		$query->bindValue(6, $companyid);
		$query->bindValue(7, $user_id);
		$query->bindValue(8, $date);
		$query->bindValue(9, $time);
		$query->bindValue(10, $ip);
		$result = $query->execute();
		if($result){
			return 1;
		} else {
			return 0;
		}		
	} catch(Exception $e){
		return $e->getMessage();
	}
}

//Checking and inserting data for users and roles
function checkRoleInsert($user, $role, $department, $location){
	$companyid = $_SESSION['company_id'];
	$check = check_user_exists($user);
	if($check == 0){
		$otp = rand('10000','99000');
		activation_mail_send($user, $otp, $role);
		insert_user_role($companyid, $department, $location, $user, $role);
	} else {
		$val = check_user_role($companyid, $user, $role);
		if($val == 0){ 
			insert_user_role($companyid, $department, $location, $user, $role);
		}				
	}
}

function checkIfComplianceGenerated($sr, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? AND `cycle_id`=? AND (`status`=1 OR `status`=3 OR `status`=2 OR `status`=6 OR `status`=10)");
		$query->bindValue(1, $companyid);	
		$query->bindValue(2, $sr);
		$query->execute();
		$result = $query->fetchAll();
		if(count($result)>=1){
			return 1;
		} else {
			return 0;
		}
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function checkpreIfComplianceGenerated($sr, $companyid, $complianceid, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `company_id`=? AND `cycle_id`=? AND `compliance_id`=? AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `status`!=7 AND `status`!=4");
		$query->bindValue(1, $companyid);	
		$query->bindValue(2, $sr);
		$query->bindValue(3, $complianceid);
		$query->bindValue(4, $prevfpr);
		$query->bindValue(5, $prevappr);
		$query->bindValue(6, $prevhod);
		$query->bindValue(7, $prevloc);
		$query->bindValue(8, $prevdep);
		$query->execute();
		$result = $query->fetchAll();
		if(count($result)>=1){
			return 1;
		} else {
			return 0;
		}
	} catch (Exception $e){
		return $e->getMessage();
	}
}


function updategeneratedcyclewithapproverstatus($sr, $companyid, $complianceid, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $fpr, $appr, $hod, $loc, $dep, $previoussr, $duedate){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET `fpr_id`=?, `appr_id`=?, `hod_id`=?, `location`=?, `department`=?, `cycle_id`=? WHERE `company_id`=? AND `cycle_id`=? AND `compliance_id`=? AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `status`=4 AND `due_date`=?");
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $appr);
		$query->bindValue(3, $hod);
		$query->bindValue(4, $dep);
		$query->bindValue(5, $prevdep);
		$query->bindValue(6, $sr);	
		$query->bindValue(7, $companyid);	
		$query->bindValue(8, $previoussr);
		$query->bindValue(9, $complianceid);
		$query->bindValue(10, $prevfpr);
		$query->bindValue(11, $prevappr);
		$query->bindValue(12, $prevhod);
		$query->bindValue(13, $prevloc);
		$query->bindValue(14, $prevdep);
		$query->bindValue(14, $duedate);
		$result = $query->execute();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}



function updategeneratedEvcyclewithapproverstatus($sr, $companyid, $event_name, $prevfpr, $prevappr, $fpr, $appr, $previoussr){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `company_event` SET `fpr_user_id`=?, `appr_user_id`=?, `cycle_id`=? WHERE `company_id`=? AND `cycle_id`=? AND `event_name`=? AND `fpr_user_id`=? AND `appr_user_id`=?");
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $appr);
		$query->bindValue(3, $sr);	
		$query->bindValue(4, $companyid);	
		$query->bindValue(5, $previoussr);
		$query->bindValue(6, $event_name);
		$query->bindValue(7, $prevfpr);
		$query->bindValue(8, $prevappr);
		$result = $query->execute();
		return $result;
	} catch (Exception $e){
		return $e->getMessage();
	}
}

function getfprappr_sr($esr){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_event` WHERE `sr`=? ");
		$query->bindValue(1, $esr);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function checkEventCompliance($event_name, $fpr, $appr){
    $company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id`=`compliance`.`id` WHERE `compliance`.`event` LIKE ? AND `company_compliance`.`fpr_id`=? AND `company_compliance`.`appr_id`=? AND `company_compliance`.`company_id`=? AND `company_compliance`.`cycle_id`=? AND (`company_compliance`.`status`=1 OR `company_compliance`.`status`=2 OR `company_compliance`.`status`=3 OR `company_compliance`.`status`=6) ");
		$query->bindValue(1, '%'.$event_name.'%');
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $appr);
		$query->bindValue(4, $company_id);
		$query->bindValue(5, 0);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function getUserID($email){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `user_id` FROM `user` WHERE `email`='$email'");
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}
			
function chkCompliances($userid, $columnName){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `sr` FROM `company_compliance` WHERE `$columnName`='$userid'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function deleteUserRole($role, $user, $columnName){
	$userid = getUserID($user);
	$compliances = chkCompliances($userid, $columnName);
	$dbh = connect_db();
	try{
		if(count($compliances) >= 1){
			return 0;
		} else {
			// $query = $dbh->prepare("DELETE FROM `user_role` WHERE `user_id`='$userid' AND `user_role`='$role'");
			// $result = $query->execute();
			$result = "";
			if($result){ return 1; } else { return 0; }
		}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function countNumofEventComp($prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `sr` FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id`=`compliance`.`id` WHERE `company_compliance`.`company_id`='$companyid' AND `company_compliance`.`fpr_id`='$prevfpr' AND `company_compliance`.`appr_id`='$prevappr' AND `company_compliance`.`hod_id`='$prevhod' AND `company_compliance`.`location`='$prevloc' AND `company_compliance`.`department`='$prevdep' AND `compliance`.`periodicity` LIKE '%event%' AND `company_compliance`.`status`!=7 AND `company_compliance`.`status`!=4");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function checkDepartmentExist($department){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `department`='$department'  AND `company_id`='$company_id'");
		$query->execute();
		$result = $query->fetchAll();
		if(count($result)>=1){
			return 1;
		} else {
			return 0;
		}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function checkLocationExist($location){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE `location`='$location' AND `company_id`='$company_id'");
		$query->execute();
		$result = $query->fetchAll();
		if(count($result)>=1){
			return 1;
		} else {
			return 0;
		}
	} catch(Exception $e){
		return $e->getMessage();
	}
}


function getEventSrbyeventName($event_name, $prevfpr, $prevappr){
    $company_id = $_SESSION['company_id'];
    $check = checkpreComp($prevfpr, $prevappr, $event_name);
    if($check == 0){
    	$dbh = connect_db();
    	try{
			$query = $dbh->prepare("SELECT `sr` FROM `company_event` WHERE `company_id`='$company_id' AND `event_name`='$event_name' AND `fpr_user_id`='$prevfpr' AND `appr_user_id`='$prevappr' AND `cycle_id`!=0 AND `cycle_id` IN (SELECT `sr` FROM `company_compliance` WHERE `status`!=7 AND `compliance_id`=555 AND `fpr_id`='$prevfpr' AND `appr_id`='$prevappr' AND `company_id`='$company_id')");
    		$query->execute();
    		$result = $query->fetchAll();
    		foreach($result as $r){
    			deletePreEvent($event_name, $company_id, $r['sr']);
    		}
    		return 1;
    	} catch(Exception $e){
    		return $e->getMessage();
    	}
    }
}
function deletePreEvent($event_name, $company_id, $sr){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_event` WHERE `company_id`=? AND `event_name`=? AND `sr`=?");
		$query->bindValue(1, $company_id);
		$query->bindValue(2, $event_name);
		$query->bindValue(3, $sr);
		$result = $query->execute();
		if($result){
			return 1;
		} else {
			return 0;
		}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function checkEventComplianceWhole($act_id, $fpr, $approver, $company_id){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` JOIN `compliance` ON 
		`company_compliance`.`compliance_id`=`compliance`.`id` WHERE `compliance`.`periodicity` LIKE ? AND `company_compliance`.`fpr_id`=? AND	`company_compliance`.`appr_id`=? AND `company_compliance`.`company_id`=? AND `company_compliance`.`cycle_id`=? AND `company_compliance`.`act_id`=? AND (`company_compliance`.`status`=1 OR `company_compliance`.`status`=2 OR `company_compliance`.`status`=3 OR `company_compliance`.`status`=6)");
		$query->bindValue(1, '%event%');
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $appr);
		$query->bindValue(4, $company_id);
		$query->bindValue(5, 0);
		$query->bindValue(6, $act_id);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}
/************* NEW Functions *****************************/
function checkingCE($eventname, $fpr, $approver){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try{
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `compliance`.`periodicity` LIKE '%event%' AND `compliance`.`event` LIKE '%$eventname%' AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$approver' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`status`!=7 AND `company_compliance`.`company_id`='$company_id'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
}

function checkingCA($act, $event, $fpr, $approver){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try{
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `compliance`.`periodicity` LIKE '%event%' AND `compliance`.`event` LIKE '%$event%' AND `compliance`.`act_id` ='$act' AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$approver' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`status`!=7 AND `company_compliance`.`company_id`='$company_id'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
}
						
function checkingCEvent($eventname, $fpr, $approver){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try{
		$query = $dbh->prepare("SELECT * FROM `company_event` WHERE `event_name` ='$eventname' AND `fpr_user_id`='$fpr' AND `appr_user_id`='$approver' AND `cycle_id`=0 AND `status`=1 AND `company_id`='$company_id'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
}
						
function insertEventNew($eventname, $fpr, $approver){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try{
		$query = $dbh->prepare("INSERT INTO `company_event` (`company_id`, `event_name`, `fpr_user_id`, `appr_user_id`, `status`, `cycle_id`) VALUES ('$company_id', '$eventname', '$fpr', '$approver', '1', '0')");
		$result = $query->execute();
		return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
}

function insertEventNewPending($eventname, $fpr, $approver, $cycleid){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try{
		$query = $dbh->prepare("INSERT INTO `company_event` (`company_id`, `event_name`, `fpr_user_id`, `appr_user_id`, `status`, `cycle_id`) VALUES ('$company_id', '$eventname', '$fpr', '$approver', '1', '$cycleid')");
		$result = $query->execute();
		return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
}

function getlastreportedCycle($fpr, $appr){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try{
		$query = $dbh->prepare("SELECT `due_date` FROM `company_compliance` WHERE `fpr_id`='$fpr' AND `appr_id`='$appr' AND `cycle_id`=0 AND `status`=7 AND `company_id`='$company_id' AND `compliance_id`=555 ORDER BY `due_date` DESC LIMIT 1");
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
}

function checkCycleinsert($fpr, $approver, $duedate){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `fpr_id`=? AND `appr_id`=? AND `company_id`=? AND `due_date`=? AND `act_id`=? AND `compliance_id`=? AND `status`=?" );
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $approver);
		$query->bindValue(3, $company_id);
		$query->bindValue(4, $duedate);
		$query->bindValue(5, 99999);
		$query->bindValue(6, 555);
		$query->bindValue(7, 1);
		$query->execute();
		$result = $query->fetchAll();
		if(count($result)>=1){
			return 1;
		} else {
			return 0;	
		}
	} catch(PDOException $e){
		return $e->getMessage();
	}								
}

function checkCycleinsertEvent($fpr, $approver, $duedate){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `fpr_id`=? AND `appr_id`=? AND `company_id`=? AND `due_date`=? AND `act_id`=? AND `compliance_id`=? AND (`status`=? OR `status`=?)" );
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $approver);
		$query->bindValue(3, $company_id);
		$query->bindValue(4, $duedate);
		$query->bindValue(5, 99999);
		$query->bindValue(6, 555);
		$query->bindValue(7, 1);
		$query->bindValue(8, 4);
		$query->execute();
		$result = $query->fetchAll();
		if(count($result)>=1){
			return 1;
		} else {
			return 0;	
		}
	} catch(PDOException $e){
		return $e->getMessage();
	}
}

function getCycleinsertEvent($fpr, $approver, $duedate){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT `sr` FROM `company_compliance` WHERE `fpr_id`=? AND `appr_id`=? AND `company_id`=? AND `due_date`=? AND `act_id`=? AND `compliance_id`=? AND `status`=?" );
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $approver);
		$query->bindValue(3, $company_id);
		$query->bindValue(4, $duedate);
		$query->bindValue(5, 99999);
		$query->bindValue(6, 555);
		$query->bindValue(7, 4);
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
}

function checkCycleinsertOnging($fpr, $approver, $hod, $department, $location, $duedate){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=? AND `due_date`=? AND `act_id`=? AND `compliance_id`=? AND `status`!=?" );
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $approver);
		$query->bindValue(3, $hod);
		$query->bindValue(4, $location);
		$query->bindValue(5, $department);
		$query->bindValue(6, $company_id);
		$query->bindValue(7, $duedate);
		$query->bindValue(8, 99998);
		$query->bindValue(9, 556);
		$query->bindValue(10, 7);
		$query->execute();
		$result = $query->fetchAll();
		if(count($result)>=1){
			return 1;
		} else {
			return 0;	
		}
	} catch(PDOException $e){
		return $e->getMessage();
	}								
}

function get_events_by_company_id_act_idNEW( $company_id, $act_id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "SELECT DISTINCT(`events`.`event`) FROM `events` JOIN (SELECT `compliance`.`event` FROM `compliance` WHERE `compliance`.`act_id`=? )`compliance` ON `compliance`.`event` like CONCAT('%;',`events`.`event`, ';%') INNER JOIN (SELECT `company_compliance`.`compliance_id` FROM `compliance` WHERE  `company_compliance`.`company_id`=? AND `company_compliance`.`act_id`=?)`company_compliance` ON `company_compliance`.`compliance_id` = `compliance`.`id` order by `events`.`event` ASC" );
    $query->bindValue( 1, $act_id );
    $query->bindValue( 2, $company_id );
	$query->bindValue( 3, $act_id );
    $query->execute();
    $result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function addcrondatafofutureed($fpr, $appr, $hod, $location, $department, $events=null, $compliances, $effectivedate, $newdatad){
	$dbh = connect_db();
	$companyid = $_SESSION['company_id'];
	$editorid = $_SESSION["user_id"];
	$editorrole = $_SESSION["user_role"];
	$date = date("Y-m-d");
	$time = date("h:i:s");
	$ip = $_SERVER['REMOTE_ADDR'];
	try{
		$query = $dbh->prepare("INSERT INTO `delegation_cron_data`(`company_id`, `fpr_id`, `appr_id`, `hod_id`, `location`, `department`, `events`, `eocompliance`, `effectivedate`, `new_data`, `editor_id`, `editor_role`, `ip`, `date`, `time`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
		$query->bindValue(1, $companyid);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $appr);
		$query->bindValue(4, $hod);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, $events);
		$query->bindValue(8, $compliances);
		$query->bindValue(9, $effectivedate);
		$query->bindValue(10, $newdatad);
		$query->bindValue(11, $editorid);
		$query->bindValue(12, $editorrole);
		$query->bindValue(13, $ip);
		$query->bindValue(14, $date);
		$query->bindValue(15, $time);
		$query->execute();
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function updateComplianceAll_ed($role, $olduser, $newuser, $fpr, $appr, $hod, $location, $department, $effectivedate){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = ""; $nparam=""; $mparam="";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_id`';
		$nparam = '`appr_id`'; $ndata = $appr;
		$mparam = '`hod_id`'; $mdata = $hod;
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_id`';
		$nparam = '`fpr_id`'; $ndata = $fpr;
		$mparam = '`hod_id`'; $mdata = $hod;
	} elseif(strtoupper($role) == "HOD"){
		$param = '`hod_id`';
		$nparam = '`fpr_id`'; $ndata = $fpr;
		$mparam = '`appr_id`'; $mdata = $appr;
	}
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET $param = ? WHERE $param =? AND $nparam =? AND $mparam=? AND `company_id`=? AND `location`=? AND `department`=? AND `status`!=? AND `due_date`>?");
		$query->bindValue(1, $newuser);
		$query->bindValue(2, $olduser);
		$query->bindValue(3, $ndata);
		$query->bindValue(4, $mdata);
		$query->bindValue(5, $company_id);
		$query->bindValue(6, $location);
		$query->bindValue(7, $department);
		$query->bindValue(8, 7);
		$query->bindValue(9, $effectivedate);
		$result = $query->execute();
		if($result){
			return 1;
		} else {
			return 0;
		}
	} catch(Exception $e){
		return $e->getMessage();
	}
}	

function selectComplianceAll_ed($role, $olduser, $newuser, $fpr, $appr, $hod, $location, $department, $effectivedate){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = ""; $nparam=""; $mparam=""; $ndata=""; $mdata="";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_id`';
		$nparam = '`appr_id`'; $ndata = $appr;
		$mparam = '`hod_id`'; $mdata = $hod;
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_id`';
		$nparam = '`fpr_id`'; $ndata = $fpr;
		$mparam = '`hod_id`'; $mdata = $hod;
	} elseif(strtoupper($role) == "HOD"){
		$param = '`hod_id`';
		$nparam = '`fpr_id`'; $ndata = $fpr;
		$mparam = '`appr_id`'; $mdata = $appr;
	}
	try{
		$query = $dbh->prepare("SELECT * FROM `company_compliance` WHERE $param =? AND $nparam =? AND $mparam=? AND `company_id`=? AND `location`=? AND `department`=? AND `status`!=? AND `due_date`>?");
		$query->bindValue(1, $olduser);
		$query->bindValue(2, $ndata);
		$query->bindValue(3, $mdata);
		$query->bindValue(4, $company_id);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, 7);
		$query->bindValue(8, $effectivedate);
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function selectComplianceAll_eo($role, $olduser, $newuser, $fpr, $appr, $hod, $location, $department){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$param = ""; $nparam=""; $mparam=""; $ndata=""; $mdata="";
	if(strtoupper($role) == "FPR"){
		$param = '`fpr_id`';
		$nparam = '`appr_id`'; $ndata = $appr;
		$mparam = '`hod_id`'; $mdata = $hod;
	} elseif(strtoupper($role) == "APPROVER"){
		$param = '`appr_id`';
		$nparam = '`fpr_id`'; $ndata = $fpr;
		$mparam = '`hod_id`'; $mdata = $hod;
	} elseif(strtoupper($role) == "HOD"){
		$param = '`hod_id`';
		$nparam = '`fpr_id`'; $ndata = $fpr;
		$mparam = '`appr_id`'; $mdata = $appr;
	}
	try{
		$query = $dbh->prepare("SELECT DISTINCT(`compliance_id`) FROM `company_compliance` WHERE $param =? AND $nparam =? AND $mparam=? AND `company_id`=? AND `location`=? AND `department`=? AND `status`!=? AND `compliance_id` IN (SELECT `id` FROM `compliance` WHERE (`periodicity` LIKE '%event%' OR `periodicity` LIKE '%going%'))");
		$query->bindValue(1, $olduser);
		$query->bindValue(2, $ndata);
		$query->bindValue(3, $mdata);
		$query->bindValue(4, $company_id);
		$query->bindValue(5, $location);
		$query->bindValue(6, $department);
		$query->bindValue(7, 7);
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['compliance_id'];
		}
		return $rArray;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function generate_eventcycles($fpr, $approver, $prevfpr, $prevappr){
	//check the 555 complinace id with cycle_id 0 exists with the edited hirarchy for the same due date
	$parentComplianceev = getParentComplianceEventN($company_id, $fpr, $approver);
	//if exists then no changes required
	if(count($parentComplianceev) >= 1){
		// check if any events are assosiated with the heirarchy delete the events
		foreach($parentComplianceev as $parentcv){
			deleteEventforCycle($parentcv['sr'], $fpr, $approver, $company_id);
		}
		// echo "Do nothing";
	} else {							
		// $min_date = minCycleDateEvent( $fpr, $approver, $company_id);	
		$min_date = $livedate;	
		$excludeDate = getExcludeDateEvent($company_id, $prevfpr, $prevappr);
		$min2 = date('Y-m-d', strtotime($min_date));				
		for ($date = strtotime($min2); $date < strtotime("30 March +2 year"); $date = strtotime("+1 Day", $date)) {
			$ddddd = date('Y-m-d', $date);
			$c30date = date('Y-m-t', strtotime($ddddd));
			$c15date = date('Y-m-15', strtotime($ddddd));
			$toddate = date('Y-m-d');
			if (strtotime($min2) < strtotime($c15date) ){
				if(in_array($c15date, $excludeDate)){
				} else {
					$check = checkCycleinsert($fpr, $approver, $c15date); //to avoid duplicate entry of event check cycle
					if($check == 0){
						insert_event_ccompliance_cron2(99999, 555, $company_id, $fpr, $approver, '10', $c15date);
					}
				}
			}
			if (strtotime($min2) < strtotime($c30date) ){
				if(in_array($c30date, $excludeDate)){
				} else {
					$check = checkCycleinsert($fpr, $approver, $c30date); //to avoid duplicate entry of event check cycle
					if($check == 0){
						insert_event_ccompliance_cron2(99999, 555, $company_id, $fpr, $approver, '10', $c30date);
					}
				}
			}
			$date = strtotime($c30date);	 
		}
	}
}

/* New Functions for Hod User wise Compliance for
	Admin, Managment, Auditor, Hod Dashboard
	Developed by Ruchika Arora */
function getfprApprHodUser($hod){
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try{
		$query = $dbh->prepare("SELECT `fpr_id`, `appr_id` FROM `company_compliance` WHERE `hod_id`='$hod' AND `company_id`='$company_id' AND `cycle_id`=0 AND `status`!=2 AND `status`!=10 GROUP BY `fpr_id`, `appr_id`, `hod_id`");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
}

function get_hod_company_compliance_details_overdue_fA($fpr, $approver){
	$company_id = $_SESSION['company_id'];
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		$query = $dbh->prepare( "SELECT COUNT(*) FROM `company_compliance` WHERE `company_id`='$company_id' AND `due_date` BETWEEN '$fdaym' AND '$yest' AND `due_date`!='' AND `due_date`!='-' AND ((`fpr_id`= '$fpr' AND (`status`='1' OR `status`='3' OR `status`='6' OR `status`='5')) OR (`appr_id`='$approver' AND `status`='4'))" );		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(*)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_hod_company_compliance_details_due_fA($fpr, $approver) {
	$user_id = $_SESSION['user_id']; 
	$company_id = $_SESSION['company_id'];
	$user_role = $_SESSION['user_role'];
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		$query = $dbh->prepare("SELECT COUNT(*) FROM `company_compliance` WHERE `company_id`='$company_id' AND (`status`='1' OR `status`='3' OR `status`='6' OR `status`='5') AND `due_date` BETWEEN '$today' and '$mend' AND `due_date`!='' AND `due_date`!='-' AND `fpr_id`= '$fpr' AND `appr_id`='$approver'");		 	
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(*)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_hod_company_compliance_details_delay_fA($fpr, $approver) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	try {
		$query = $dbh->prepare( "SELECT COUNT(*) FROM `company_compliance` WHERE `company_id`='$company_id' AND `status` = '7' AND `due_date` < `date_time` AND `due_date`!='' AND `due_date`!='-' AND `fpr_id`= '$fpr' AND `appr_id`='$approver'" ); 
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(*)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_hod_company_compliance_details_compliant_fA($fpr, $approver) {
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT COUNT(*) FROM `company_compliance` WHERE `company_id`='$company_id' AND `status` = '7' AND `due_date` > `date_time` AND `due_date`!='' AND `due_date`!='-' AND `fpr_id`= '$fpr' AND `appr_id`='$approver'" );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(*)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_hod_company_compliance_details_c_compliance_fA($fpr, $approver) {
	$dbh = connect_db();
	$company_id = $_SESSION['company_id'];
	$mend = date('Y-m-d', strtotime("+10 day"));	
	try {
		$query = $dbh->prepare("SELECT COUNT(*) FROM `company_compliance` WHERE `company_id`='$company_id' AND `status` = '5' AND `due_date` >'$mend' AND `due_date`!='' AND `due_date`!='-' AND `fpr_id`= '$fpr' AND `appr_id`='$approver'");
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(*)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
?>