<?php
include_once("include/configpdo.php");
error_reporting(E_ALL);
//include_once("main_function_solo.php");

function selectGroupTrend(){
    $dbh = connect_db();
    try {
		$query = $dbh->prepare( "SELECT * FROM `company` JOIN `parent` ON `company`.`company_id`=`parent`.`parent_id` WHERE `parent`.`type`=? AND `company`.`company_id` IN (SELECT DISTINCT(`company_id`) FROM `user_role` WHERE `user_role`='Group Management')");
		$query->bindValue(1, 'grp');
        $query->execute();
        $result = $query->fetchAll();
        $rArray = array();
        foreach($result as $r){
            if($r['company_id']!=""){
                $rArray[] = $r['company_id']; 
            }
        }
        return $rArray;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function getChildCompaniesTrend($parentCompany){
	$dbh = connect_db();
    try {
		$query = $dbh->prepare( "SELECT * FROM `company` WHERE `parent_id`='$parentCompany' AND `status`='1' AND `company_id`!= '$parentCompany'"); 
        $query->execute();
	    $result = $query->fetchAll();
	    return $result;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

// Getting Numbers for the compliances
function countOverdueTrend($company_id) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
    $dbh = connect_db();
    try {
		$query = $dbh->prepare( "SELECT COUNT(*) FROM `company_compliance` WHERE `company_id`='$company_id' AND (`status`='1' OR `status`='3' OR `status`='6' OR `status`='4' OR `status`='5') AND `due_date` BETWEEN '$fdaym' AND '$yest' AND `cycle_id` = 0"); 
        $query->execute();
	    $result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result['COUNT(*)'];
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function countDueTrend($company_id) {
	$today = date("Y-m-d");
	$mend = date('Y-m-d', strtotime("+10 day"));
    $dbh = connect_db();
    try {
		$query = $dbh->prepare( "SELECT COUNT(*) FROM `company_compliance` WHERE `company_id`='$company_id' and (status='1' or status='3' or status='6'  or status='4' or status='5') AND `due_date` BETWEEN '$today' AND '$mend' AND `due_date`!='' AND `due_date`!='-'"); 
        $query->execute();
	    $result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result['COUNT(*)'];
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function countCompliantTrend($company_id) {
    $dbh = connect_db();
    $today = date("Y-m-d");
    try {
		$query = $dbh->prepare( "SELECT COUNT(*) FROM `company_compliance` WHERE `company_id`='$company_id' AND status='7'  AND `due_date`!='' AND `due_date`!='-' AND  (`due_date` >= `date_time` OR `compliance_id`=555 OR `compliance_id`=556) AND `cycle_id`=0"); 
        $query->execute();
	    $result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result['COUNT(*)'];
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function countDelayedTrend($company_id) {
    $dbh = connect_db();
    $today = date("Y-m-d");
    try {
		$query = $dbh->prepare( "SELECT COUNT(*) FROM `company_compliance` WHERE `company_id`='$company_id' AND status='7'  AND `due_date`!='' AND `due_date`!='-' AND  `due_date` < `date_time` AND `compliance_id`!=555 AND `compliance_id`!=556 AND `cycle_id`=0"); 
        $query->execute();
	    $result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result['COUNT(*)'];
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function countConditionalTrend($company_id){
	$mend = date('Y-m-d', strtotime("+10 day"));
	$today = date("Y-m-d");
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT COUNT(*) FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company_id' AND `company_compliance`.`status`=5 AND `company_compliance`.`due_date` >'$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`compliance_id`!=555 AND `company_compliance`.`compliance_id`!=556");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result['COUNT(*)'];	
	} catch (Exception $e) {
	    return $e->getMessage();
	}
}

function countNotappTrend($company_id) {
    $dbh = connect_db();
    $today = date("Y-m-d");
    try {
		$query = $dbh->prepare( "SELECT COUNT(*) FROM `company_compliance` WHERE `company_id`='$company_id' AND status='9'  AND `due_date`!='' AND `due_date`!='-' AND `compliance_id`!=555 AND `compliance_id`!=556 AND `cycle_id`=0"); 
        $query->execute();
	    $result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result['COUNT(*)'];
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function insertDataTrendd($due, $overdue, $compliant, $delayed, $conditional, $company_id){
	$dbh = connect_db();
	$date = date("Y-m-d");
//	$date = "2024-09-04";
	$time = date("h:i:s");
    try {
		$query = $dbh->prepare( "INSERT INTO `trend`(`due`, `overdue`, `compliant`, `delayedc`, `conditional`, `company_id`, `date`, `time`) VALUES (?,?,?,?,?,?,?,?)");
		$query->bindValue(1, $due);
		$query->bindValue(2, $overdue);
		$query->bindValue(3, $compliant);
		$query->bindValue(4, $delayed);
		$query->bindValue(5, $conditional);
		$query->bindValue(6, $company_id);
		$query->bindValue(7, $date);
		$query->bindValue(8, $time);
        $result = $query->execute();
	    if($result){
			return 1;
		} else {
			return 0;
		}
    } catch (Exception $e) {
        return $e->getMessage();
    }
}


// Get Group Companies
$group = selectGroupTrend();
var_dump($group);
// $group = array(6172024020704);

// Getting group data of the companies
foreach($group as $grp){
    $company_id = $grp;
    $companies = getChildCompaniesTrend($company_id); // Getting Companies
    // var_dump($companies);
    
    // Declaring Variables For New Data
    $overdue = 0; $due = 0; $totalComplToday = 0; $totalDelayToday = 0; $totalCondiToday = 0; $notapp =0;
    
    foreach($companies as $comp){
    	$company = $comp['company_id'];
    	if($company != ''){
    		$totalComplToday = 0;
    	    $totalDelayToday = 0;
    		$totalCondiToday = 0;
    		$overdue = 0;
    		$due = 0;
    		$compliant = 0;
    		$delayed = 0;
    		$conditional = 0;
    		$compliantEO = 0;
    // 		$compliant = get_count_compliance_all_compDCompp($company);
    		$conditional = countConditionalTrend($company);
    		$overdue = countOverdueTrend($company);
    		$due = countDueTrend($company);
    		$compliant = countCompliantTrend($company);
    		$delayed = countDelayedTrend($company);
    		$conditional = countConditionalTrend($company);
    
    		/// Compliant Event and Ongoing
    // 		$compliantEO = countCompliantEO($company);
    		$totalComplToday = $compliant;
    		
    // 		echo "Due : $due, Overdue : $overdue, Compliant : $compliant, Delayed : $delayed, Conditional : $conditional, Not Applicable : $conditional, Company ID : $company<br>";
    		
    		// Insert data to trend table
            insertDataTrendd($due, $overdue, $compliant, $delayed, $conditional, $comp['company_id']);
    	}
    }
}
?>