<?php
/* Common Function */
function getCompanyNameGroup($company_id){
    $dbh = connect_db();
    try {
		$query = $dbh->prepare( "SELECT `name` FROM `company` WHERE `company_id`=?");
		$query->bindValue(1, $company_id);
        $query->execute();
        $result = $query->fetchColumn();
        return $result;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function getDepartmentFprAppr($fpr, $appr, $company_id ) {
	$dbh = connect_db();
    try {
        $query = $dbh->prepare( "select cc.department as department from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%'   and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.department" );
        $query->execute();
    	$result = $query->fetchAll();
        $rArray = array();
    	foreach($result as $r){
    	    $rArray[] = $r['department'];
    	}
        return $rArray;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function getLocationFprAppr($fpr, $appr, $company_id ) {
	$dbh = connect_db();
    try {
        $query = $dbh->prepare( "select cc.location as location from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%'   and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.location" );
        $query->execute();
    	$result = $query->fetchAll();
        $rArray = array();
    	foreach($result as $r){
    	    $rArray[] = $r['location'];
    	}
        return $rArray;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function getHoDFprAppr($fpr, $appr, $company_id ) {
	$dbh = connect_db();
    try {
        $query = $dbh->prepare( "select cc.hod_id as hod from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%'   and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.hod_id" );
        $query->execute();
    	$result = $query->fetchAll();
    	$rArray = array();
    	foreach($result as $r){
    	    $rArray[] = $r['hod'];
    	}
        return $rArray;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}


/* Overall Status Graph */
function get_count_compliance_all_overdueCountNew($company, $actsid){
	try{
		$fdaym=date("1970-01-01");
		$yest=date("Y-m-d",strtotime("-1 days"));
		$dbh = connect_db();		
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result['COUNT(`company_compliance`.`sr`)'];
	} catch(PDOException $e){
		return $e->getMessage();
	}
	
}

function get_count_compliance_all_dueCountNew($company, $actsid) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 and `company_compliance`.`due_date` BETWEEN '$today' and '$mend' and `company_compliance`.`due_date`!='' and `company_compliance`.`due_date`!='-' $actsid" ); 
		}		 	
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_compCountNew($company, $actsid) {
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0  AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_noncompCountNew($company, $actsid) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE $company  AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` < `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_ccompCountNew($company, $actsid) {
	$dbh = connect_db();
	$mend=date('Y-m-d', strtotime("+10 day"));
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`status`='5' AND `company_compliance`.`due_date` >'$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountComplianceNotApplicable($company, $actsid) {
	$dbh = connect_db();
	$mend=date('Y-m-d', strtotime("+10 day"));
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`status`='9' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/* CHART FUNCTIONS */

function get_count_compliance_all_overdue_data($company, $actsid){
	try{
		$fdaym=date("1970-01-01");
		$yest=date("Y-m-d",strtotime("-1 days"));
		$dbh = connect_db();		
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
	    return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
	
}

function get_count_compliance_all_due_data($company, $actsid) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 and `company_compliance`.`due_date` BETWEEN '$today' and '$mend' and `company_compliance`.`due_date`!='' and `company_compliance`.`due_date`!='-' $actsid" ); 
		}		 	
		$query->execute();
		$result = $query->fetchAll();
	    return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_comp_data($company, $actsid) {
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0  AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_noncomp_data($company, $actsid) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE $company  AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` < `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_ccomp_data($company, $actsid) {
	$dbh = connect_db();
	$mend=date('Y-m-d', strtotime("+10 day"));
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`status`='5' AND `company_compliance`.`due_date` >'$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_not_applicable_data($company, $actsid) {
	$dbh = connect_db();
	$mend=date('Y-m-d', strtotime("+10 day"));
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`status`='9' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

// Ongoing Cycle Overdue, Due, Compliant
function getDataOngoingOverdue($fpr, $appr, $hod, $department, $location, $company) {
	$fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company' AND `company_compliance`.`act_id`=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND `company_compliance`.`location`='$location' AND  `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
	    return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getDataOngoingDue($fpr, $appr, $hod, $department, $location, $company) {
	$today = date("Y-m-d");
	$mend = date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company' AND `company_compliance`.`act_id`=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND `company_compliance`.`location`='$location' AND `company_compliance`.`due_date` BETWEEN '$today' and '$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
	    return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getDataOngoingCompliant($fpr, $appr, $hod, $department, $location, $company) {
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE  `company_compliance`.`company_id`='$company' AND `company_compliance`.`act_id`=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND `company_compliance`.`location`='$location'  AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
	    return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

// Event Cycle Overdue, Due, Compliant
function getDataEventOverdue($fpr, $appr, $company) {
	$fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND  `company_compliance`.`company_id`='$company' AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
	    return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getDataEventDue($fpr, $appr, $company) {
	$today = date("Y-m-d");
	$mend = date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`company_id`='$company' AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date` BETWEEN '$today' and '$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
	    return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getDataEventCompliant($fpr, $appr, $company ) {
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`company_id`='$company' AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}
		$query->execute();
		$result = $query->fetchAll();
	    return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/*********************************** END OVER ALL GRAPH ****************************/
/* Overdue Criticality */

function getCountComplianceOverdueCriticality($company, $criticality, $actsid){
    $fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try{
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND upper(`compliance`.`criticality`)='$criticality' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result['COUNT(`company_compliance`.`sr`)'];
	} catch(PDOException $e){
		return $e->getMessage();
	}
	
}

/* Overdue Criticality CHART*/

function getDataComplianceOverdueCriticality($company, $criticality, $actsid){
    $fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try{
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND upper(`compliance`.`criticality`)='$criticality' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
	    return $result;
	} catch(PDOException $e){
		return $e->getMessage();
	}
	
}

/*********************************** END OVERDUE CRITICALITY GRAPH ****************************/

/*********************************** COMPLIANT CONTINENT ****************************/

function getAllContinents($company){
    $dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare("SELECT DISTINCT(`act_fields`.`continent`) FROM `company_act` JOIN `act_fields` ON `act_fields`.`act_id`=`company_act`.`act_id` WHERE $company AND `company_act`.`act_id`!=99999 AND `company_act`.`act_id`!=99998");
		}
		$query->execute();
		$result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
		    $rArray[] = $r['continent'];
		}
		return $rArray;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function getCountComplianceContinent($company, $continent){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` WHERE $company $continent AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7'  AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `company_compliance`.`cycle_id`='0'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function getCountCompliatContinentOngoing($fpr, $appr, $hod, $department, $location, $company) {
	$loc = strtoupper($location);
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company' AND `company_compliance`.`act_id`=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND upper(`company_compliance`.`location`)='$loc'  AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function getCountCompliantContinentEvent($fpr, $appr, $company) {
	$company_id=$_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND  `company_compliance`.`company_id`='$company' AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function getEventCycleUsersContinent($company, $continent='', $country='', $state='', $location='', $category=''){
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`company_id` FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id` = `compliance`.`id` JOIN `act_fields` ON `act_fields`.`act_id`=`company_compliance`.`act_id` WHERE $company AND `compliance`.`periodicity` LIKE '%event%' $continent AND $country AND $state GROUP BY `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`company_id`" );	
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getOngoingCycleUsersContinent($company, $continent='', $country='', $state=''){
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`company_id` FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id` = `compliance`.`id` JOIN `act_fields` ON `act_fields`.`act_id`=`company_compliance`.`act_id` WHERE $company AND `compliance`.`periodicity` LIKE '%going%' $continent AND $country AND $state GROUP BY `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`company_id`" );	
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/*** CHART FUNCTIONS ***/
function get_count_compliance_continent_compDon($fpr, $appr, $hod, $department, $location, $company) {
	$loc = strtoupper($location);
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`act_id`=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND upper(`company_compliance`.`location`)='$loc'  AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_count_compliance_continent_compDev($fpr, $appr, $company) {
	$company_id=$_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND  `company_compliance`.`company_id`=$company AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_count_compliance_continent_compDLoc($company, $continent, $country, $state, $location) {
	$company_id=$_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` WHERE $continent AND $company AND $country AND $state AND `company_compliance`.`status`='7' AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`cycle_id`=0  AND $location AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

/*********************************** END COMPLIANT CONTINENT GRAPH ****************************/


/*********************************** COMPLIANT COUNTRY GRAPH ****************************/
 
function get_count_compliance_continent_compDNeww($company, $actsid) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7'  AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `company_compliance`.`cycle_id`='0' $actsid");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_count_compliance_continent_compDevNew($fpr, $appr, $company) {
	$company_id=$_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND  `company_compliance`.`company_id`=$company AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_count_compliance_continent_compDonNew($fpr, $appr, $hod, $department, $location, $company) {
	$loc = strtoupper($location);
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`company_id`=$company `company_compliance`.`act_id`=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND upper(`company_compliance`.`location`)='$loc'  AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

/********* CHART *********/

function get_data_compliance_continent_compDNeww($company, $actsid) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7'  AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `company_compliance`.`cycle_id`='0' $actsid");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_data_compliance_continent_compDevNew($fpr, $appr, $company) {
	$company_id=$_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND  `company_compliance`.`company_id`=$company AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function get_data_compliance_continent_compDonNew($fpr, $appr, $hod, $department, $location, $company) {
	$loc = strtoupper($location);
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`company_id`=$company `company_compliance`.`act_id`=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND upper(`company_compliance`.`location`)='$loc'  AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
/*********************************** COMPLIANT COUNTRY IFRAME END ****************************/

/*********************************** COMPLIANT LOCATION IFRAME ****************************/

function getOngoingCycleUsersLocation($company, $location){
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`compliance_id`, `company_compliance`.`company_id` FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id` = `compliance`.`id` JOIN `act_fields` ON `act_fields`.`act_id`=`company_compliance`.`act_id` WHERE $company AND $location AND `compliance`.`periodicity` LIKE '%going%' GROUP BY `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`company_id`" );	
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function geteventCycleUsersLocation($company, $location){
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`company_id` FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id`=`compliance`.`id` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` WHERE $company AND $location AND  `compliance`.`periodicity` LIKE '%event%' GROUP BY `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`company_id`" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function getOngoingUsersLocation($company, $location, $state){
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`compliance_id`, `company_compliance`.`company_id` FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id` = `compliance`.`id` JOIN `act_fields` ON `act_fields`.`act_id`=`company_compliance`.`act_id` WHERE $company AND $location AND $state AND `compliance`.`periodicity` LIKE '%going%' GROUP BY `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`company_id`" );	
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function geteventUsersLocation($company, $location, $state){
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`company_id` FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id`=`compliance`.`id` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` WHERE $company AND $location AND $state AND  `compliance`.`periodicity` LIKE '%event%' GROUP BY `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`company_id`" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getLocationDashboard($company, $country) {
	$dbh = connect_db();
    try {
		$query = $dbh->prepare( "SELECT DISTINCT `company_compliance`.`location` FROM `company_compliance` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` JOIN `company_act` ON `company_act`.`company_id`=`company_compliance`.`company_id` WHERE $company AND `act_fields`.`country`='$country'" );
        $query->execute();
        $result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['location'];
		}
        return $rArray;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function getLocationDashboardState($company, $state) {
	$dbh = connect_db();
    try {
		$query = $dbh->prepare( "SELECT DISTINCT `company_compliance`.`location` FROM `company_compliance` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` JOIN `company_act` ON `company_act`.`company_id`=`company_compliance`.`company_id` WHERE $company AND `act_fields`.`state`='$state'" );
        $query->execute();
        $result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['location'];
		}
        return $rArray;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function getLocationDashboardLocation($company, $location) {
	$dbh = connect_db();
    try {
		$query = $dbh->prepare( "SELECT DISTINCT `company_compliance`.`location` FROM `company_compliance` JOIN `company_act` ON `company_act`.`company_id`=`company_compliance`.`company_id` WHERE $company AND `company_compliance`.`location`='$location'" );
        $query->execute();
        $result = $query->fetchAll();
		$rArray = array();
		foreach($result as $r){
			$rArray[] = $r['location'];
		}
        return $rArray;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function getCountComplianceContinentCompLocation($company, $location) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE $company AND `company_compliance`.`status`='7' AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`cycle_id`=0  AND $location AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function getCountComplianceContinentDelayedLocation($company, $location) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE $company AND `company_compliance`.`status`='7' AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`cycle_id`=0  AND $location AND `company_compliance`.`due_date` < `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function getDataComplianceContinentDelayedLocation($company, $location) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` WHERE $company AND `company_compliance`.`status`='7' AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`cycle_id`=0  AND $location AND `company_compliance`.`due_date` < `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}


function getDataComplianceContinentCompLocation($company, $location) {
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` WHERE $company AND `company_compliance`.`status`='7' AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`cycle_id`=0  AND $location AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}


function getCountOngoingOverdue($fpr, $appr, $hod, $department, $location, $company) {
	$fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company' AND `company_compliance`.`act_id`=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND `company_compliance`.`location`='$location' AND  `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function getCountOngoingDue($fpr, $appr, $hod, $department, $location, $company) {
	$today = date("Y-m-d");
	$mend = date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`company_id`='$company' AND `company_compliance`.`act_id`=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND `company_compliance`.`location`='$location' AND `company_compliance`.`due_date` BETWEEN '$today' and '$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountOngoingCompliant($fpr, $appr, $hod, $department, $location, $company) {
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE  `company_compliance`.`company_id`='$company' AND `company_compliance`.`act_id`=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND `company_compliance`.`location`='$location'  AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

// Event Cycle Overdue, Due, Compliant
function getCountEventOverdue($fpr, $appr, $company) {
	$fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND  `company_compliance`.`company_id`='$company' AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountEventDue($fpr, $appr, $company) {
	$today = date("Y-m-d");
	$mend = date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`company_id`='$company' AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date` BETWEEN '$today' and '$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountEventCompliant($fpr, $appr, $company ) {
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`company_id`='$company' AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


/*********************************** COMPLIANT LOCATION IFRAME END ****************************/

/*********************************** DELAYED CONTINENT IFRAME ****************************/
function getContinentDelayedCount($company, $continent, $country, $state) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) as count FROM `company_compliance` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` WHERE $company AND $continent AND $country AND $state AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` < `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/********** CHART ************/

function get_count_compliance_continent_noncompDe($company, $continent, $country, $state) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` WHERE $company AND $continent AND $country AND $state AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` < `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/*********************************** DELAYED CONTINENT IFRAME END ****************************/


/*********************************** DELAYED COUNTRY IFRAME ****************************/
function getCountComplianceCountryNoncompDe($company, $actsid) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) as count FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` < `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/********** CHART ************/

function getCountComplianceCountryNoncompData($company, $actsid) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` < `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/*********************************** DELAYED COUNTRY IFRAME END ****************************/

/*********************************** OVERDUE CONTINENT IFRAME ****************************/

function getCountComplianceOverdueGraph($company, $continent='', $country='', $state=''){
    $fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try{
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `act_fields` ON `act_fields`.`act_id`=`company_compliance`.`act_id` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND $continent AND $country AND $state" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
	    return $result['COUNT(`company_compliance`.`sr`)'];
	} catch(PDOException $e){
		return $e->getMessage();
	}
	
}

function getOngoingCycleUsers($company, $continent='', $country='', $state=''){
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`compliance_id`, `company_compliance`.`company_id` FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id` = `compliance`.`id` JOIN `act_fields` ON `act_fields`.`act_id`=`company_compliance`.`act_id` WHERE $company AND `compliance`.`periodicity` LIKE '%going%' $continent AND $country AND $state GROUP BY `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`company_id`" );	
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getEventCycleUsers($company, $continent='', $country='', $state=''){
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`company_id` FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id` = `compliance`.`id` JOIN `act_fields` ON `act_fields`.`act_id`=`company_compliance`.`act_id` WHERE $company AND `compliance`.`periodicity` LIKE '%event%' $continent AND $country AND $state GROUP BY `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`company_id`" );	
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_overdueD($company, $continent, $country, $state) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` WHERE $company AND $continent AND $country AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND $state AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_overdueDon($fpr, $appr, $hod, $department, $location, $company) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`act_id`=99998 AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`company_id`='$company' AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND `company_compliance`.`location`='$location' AND  `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_overdueDev($fpr, $appr, $company) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`act_id`=99999 AND `company_compliance`.`company_id`='$company' AND (`company_compliance`.`status`='1' or `company_compliance`.`status`='3' or `company_compliance`.`status`='6'  or `company_compliance`.`status`='4' or `company_compliance`.`status`='5') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


/*********************************** OVERDUE CONTINENT IFRAME END ****************************/

/*********************************** OVERDUE COUNTRY IFRAME ****************************/
function get_count_compliance_all_overdueDNeww($company, $actsid) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`!='2' AND `company_compliance`.`status`!='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_overdueDonNew($fpr, $appr, $hod, $department, $location, $company) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`act_id`=99998 AND `company_compliance`.`status`!='2' AND `company_compliance`.`status`!='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND `company_compliance`.`location`='$location' AND  `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_overdueDevNew($fpr, $appr, $company) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`act_id`=99999 AND `company_compliance`.`status`!='2' AND `company_compliance`.`status`!='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/******* CHART **********/

function get_data_compliance_all_overdueDNeww($company, $actsid) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE $company AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`status`!='2' AND `company_compliance`.`status`!='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' $actsid" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_data_compliance_all_overdueDonNew($fpr, $appr, $hod, $department, $location, $company) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`act_id`=99998 AND `company_compliance`.`status`!='2' AND `company_compliance`.`status`!='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND `company_compliance`.`location`='$location' AND  `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_data_compliance_all_overdueDevNew($fpr, $appr, $company) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`act_id`=99999 AND `company_compliance`.`status`!='2' AND `company_compliance`.`status`!='7' AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/*********************************** OVERDUE COUNTRY IFRAME END ****************************/

/*********************************** DELAYED POTENTIAL IFRAME END ****************************/
function get_compliance_delayed_potential( $company, $type, $actsid ) {
    $fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
    $dbh = connect_db();
    $type=strtoupper($type);
    try {
		$query = $dbh->prepare( "SELECT criticality as title, count(compliance.id) as 'Cnt' from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company and (company_compliance.status='7') and company_compliance.compliance_id!=555 and company_compliance.compliance_id!=556 and company_compliance.due_date < company_compliance.date_time and company_compliance.due_date!='' and upper(compliance.potential_impact) LIKE '%$type%' $actsid" );        
	    $query->execute();
        $result = $query->fetchAll(); 
        return $result;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function get_compliance_delayed_potential_data( $company, $type, $actsid ) {
    $fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
    $dbh = connect_db();
    $type=strtoupper($type);
    try {
		$query = $dbh->prepare( "select `company_compliance`.* from compliance inner join company_compliance on `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company and (company_compliance.status='7') and company_compliance.compliance_id!=555 and company_compliance.compliance_id!=556 and company_compliance.due_date < company_compliance.date_time and company_compliance.due_date!='' and upper(compliance.potential_impact) LIKE '%$type%' $actsid" ); 
	    $query->execute();
        $result = $query->fetchAll(); 
        return $result;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

/*********************************** DELAYED POTENTIAL IFRAME END ****************************/

/*********************************** HIGH RISK GRAPH ****************************/
function getCountComplianceOverdueRisk($company, $actsid) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company  AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999 and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountComplianceDueRisk($company, $actsid) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999 and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$today' and '$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" ); 
		}	 	
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountComplianceCompRisk($company, $actsid) {
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`status`='7' AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" );
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountComplianceDelayedRisk($company, $actsid) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999  AND `company_compliance`.`status`='7' AND `company_compliance`.`due_date` < `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" );
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountComplianceCcompRisk($company, $actsid) {
	$dbh = connect_db();
	$mend=date('Y-m-d', strtotime("+10 day"));
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999  AND `company_compliance`.`status`='5' AND `company_compliance`.`due_date` > '$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" );
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountComplianceOverdueRiskOn($fpr, $appr, $hod, $department, $location, $company_id) {
    $loc = strtoupper($location);
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`company_id`='$company_id' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND upper(`company_compliance`.`location`)='$loc' AND `company_compliance`.`act_id`=99998  and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountComplianceDueRiskOn($fpr, $appr, $hod, $department, $location, $company_id) {
    $loc = strtoupper($location);
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`company_id`='$company_id' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND upper(`company_compliance`.`location`)='$loc' AND `company_compliance`.`act_id`=99998  and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$today' AND '$mend' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountComplianceCompRiskOn($fpr, $appr, $hod, $department, $location, $company_id) {
    $loc = strtoupper($location);
    $filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`company_id`='$company_id' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND upper(`company_compliance`.`location`)='$loc' AND `company_compliance`.`act_id`=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function getCountComplianceOverdueRiskEv($fpr, $appr, $hod, $department, $location, $company_id) {
    $loc = strtoupper($location);
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`company_id`='$company_id' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`act_id`=99999  and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountComplianceDueRiskEv($fpr, $appr, $company_id) {
    $loc = strtoupper($location);
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`company_id`='$company_id' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`act_id`=99999  and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$today' AND '$mend' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getCountComplianceCompRiskEv($fpr, $appr, $company_id) {
    $loc = strtoupper($location);
    $filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`company_id`='$company_id' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`act_id`=99999 AND `company_compliance`.`status`='7' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}



function getCountCompliancenotappRisk($company, $actsid) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999  AND `company_compliance`.`status`='9' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" );
		}		 
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}
/***** CHART ********/

function get_count_compliance_all_overdue_risk($company, $actsid) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company  AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999 AND (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_overdue_riskOn($fpr, $appr, $hod, $department, $location, $company) {
    $loc = strtoupper($location);
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND upper(`company_compliance`.`location`)='$loc' AND `company_compliance`.`act_id`=99998  and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_overdue_riskEv($fpr, $appr, $company) {
    $loc = strtoupper($location);
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`act_id`=99999  and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_due_risk($company, $actsid) {
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999 and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$today' and '$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" ); 
		}	 	
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_due_riskOn($fpr, $appr, $hod, $department, $location, $company) {
    $loc = strtoupper($location);
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND upper(`company_compliance`.`location`)='$loc' AND `company_compliance`.`act_id`=99998  and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$today' AND '$mend' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_due_riskEv($fpr, $appr, $company) {
    $loc = strtoupper($location);
	$today=date("Y-m-d");
	$mend=date('Y-m-d', strtotime("+10 day"));
	$filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`act_id`=99999  and (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$today' AND '$mend' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_comp_risk($company, $actsid) {
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`status`='7' AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_comp_riskOn($fpr, $appr, $hod, $department, $location, $company) {
    $loc = strtoupper($location);
    $filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`hod_id`='$hod' AND `company_compliance`.`department`='$department' AND upper(`company_compliance`.`location`)='$loc' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`act_id`=99998 AND `company_compliance`.`status`='7' AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_comp_riskEv($fpr, $appr, $company) {
    $loc = strtoupper($location);
    $filterDatef = $_SESSION['groupmanageddf'];
	$filterDatet = $_SESSION['groupmanageddt'];
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`company_id`=$company AND `company_compliance`.`fpr_id`='$fpr' AND `company_compliance`.`appr_id`='$appr' AND `company_compliance`.`due_date` BETWEEN '$filterDatef' AND '$filterDatet' AND `company_compliance`.`act_id`=99999 AND `company_compliance`.`status`='7' AND `company_compliance`.`due_date` >= `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_noncomp_risk($company, $actsid) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999  AND `company_compliance`.`status`='7' AND `company_compliance`.`due_date` < `company_compliance`.`date_time` AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function get_count_compliance_all_ccomp_risk($company, $actsid) {
	$dbh = connect_db();
	$mend=date('Y-m-d', strtotime("+10 day"));
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999  AND `company_compliance`.`status`='5' AND `company_compliance`.`due_date` > '$mend' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_count_compliance_all_notapp_risk($company, $actsid) {
	$dbh = connect_db();
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999  AND `company_compliance`.`status`='9' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-' AND `compliance`.`criticality`='High' AND `company_compliance`.`cycle_id`=0 $actsid" );
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/*********************************** HIGH RISK GRAPH END ****************************/

/*********************************** OVERDUE POTENETIAL IMPACT ****************************/
function getCompliancePotentialImpactN($company, $type, $actsid) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	$type=strtoupper($type);
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` INNER JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999 AND (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' and upper(`compliance`.`criticality`)='HIGH' and upper(`compliance`.`potential_impact`) LIKE '%$type%' $actsid" );
		}    
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC); 
		return $result['COUNT(`company_compliance`.`sr`)'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/* CHART */
function getCompliancePotentialImpactNData($company, $type, $actsid) {
	$fdaym=date("1970-01-01");
	$yest=date("Y-m-d",strtotime("-1 days"));
	$dbh = connect_db();
	$type=strtoupper($type);
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.* FROM `company_compliance` INNER JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE $company AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`act_id`!=99999 AND (`company_compliance`.`status`='1' OR `company_compliance`.`status`='3' OR `company_compliance`.`status`='6'  OR `company_compliance`.`status`='4' OR `company_compliance`.`status`='5') AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' and upper(`compliance`.`criticality`)='HIGH' and upper(`compliance`.`potential_impact`) LIKE '%$type%' $actsid" );
		}    
		$query->execute();
		$result = $query->fetchAll(); 
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/*********************************** OVERDUE POTENETIAL IMPACT END ****************************/

/* Overdue Continent Location Wise */
function getCountComplianceContinentOverdueLocation($company, $location, $state) {
    $fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
	$company_id=$_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare("SELECT COUNT(`company_compliance`.`sr`) FROM `company_compliance` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` WHERE $company AND $state AND (`company_compliance`.`status`!='7' OR `company_compliance`.`status`!='2') AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND `company_compliance`.`cycle_id`=0  AND $location AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='-'");
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['COUNT(`company_compliance`.`sr`)'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}


function getDataComplianceContinentOverdueLocation($company, $location, $state) {
	$dbh = connect_db();
	$fdaym = date("1970-01-01");
	$yest = date("Y-m-d",strtotime("-1 days"));
	try {
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` WHERE $company AND $state AND $location AND `company_compliance`.`act_id`!=99999 AND `company_compliance`.`act_id`!=99998 AND (`company_compliance`.`status`!='7' OR `company_compliance`.`status`!='2') AND `company_compliance`.`cycle_id`=0 AND `company_compliance`.`due_date` BETWEEN '$fdaym' AND '$yest' AND `company_compliance`.`due_date`!='' AND `company_compliance`.`due_date`!='-'");
		}
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getOngoingHierarchyLocation($company, $continent, $country, $state, $location){
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`company_id` FROM `company_compliance` JOIN (SELECT `act_id` FROM `act_fields` WHERE $continent AND $continent AND $country AND $state) `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` JOIN(SELECT `id` FROM `compliance` WHERE `compliance`.`periodicity` LIKE '%On Going%') `compliance` ON `company_compliance`.`compliance_id`= `compliance`.`id` WHERE $company AND $location GROUP BY `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`company_id`" ); 
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function geteventHierarchyLocation($company, $continent, $country, $state, $location){
	$dbh = connect_db();
	try {	  
		if(strtoupper($_SESSION['user_role'])=='GROUP MANAGEMENT'){
			$query = $dbh->prepare( "SELECT `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`company_id` FROM `company_compliance` JOIN `act_fields` ON `company_compliance`.`act_id`=`act_fields`.`act_id` JOIN `compliance` ON `compliance`.`act_id`= `act_fields`.`act_id` WHERE $company AND $continent AND $country AND $state AND $location AND `compliance`.`periodicity` LIKE '%event%' GROUP BY `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`company_id`" );  
		}		 
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

