<?php
include("include/header.php");
// include("group_management_functions.php");
// error_reporting(E_ALL);
include("dashboard_functions.php");
include("group_graphs_functions.php");

$host = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
//------------------ Criticality Overdue---------------------------------//

$highOD = getCountComplianceOverdueCriticality($company, "HIGH", $actsid);
$medium = getCountComplianceOverdueCriticality($company, "MEDIUM", $actsid);
$low = getCountComplianceOverdueCriticality($company, "LOW", $actsid);

//--------------Overdue Event Ongoing--------------//
$onHierarchy = getOngoingHierarchyNew($company, $actsid);
$totaloveron =0;
foreach($onHierarchy as $onh){
	if($onh['location']!=''){
		$onfpr          = $onh['fpr_id']; // echo $onfpr;
		$onappr         = $onh['appr_id']; // echo $onappr;
		$onhod          = $onh['hod_id']; // echo $onhod;
		$ondep          = $onh['department']; // echo $onhod;
		$onloc          = $onh['location']; // echo $onhod;
		$onCompany      = $onh['company_id']; // echo $onCompany
		$totaloveron 	+= get_count_compliance_all_overdueCounton($onfpr, $onappr, $onhod, $ondep, $onloc, $onCompany);
	}
}

$evHierarchy = geteventHierarchyNew($company, $actsid);

$totaloverev =0;
foreach($evHierarchy as $evh){
	if($evh['fpr_id']!=''){
		$evfpr          = $evh['fpr_id']; // echo $onfpr;
		$evappr         = $evh['appr_id']; // echo $onappr;
		$evCompany      = $evh['company_id']; // echo $onappr;
		$totaloverev 	+= get_count_compliance_all_overdueCountev($evfpr, $evappr, $evCompany);
	}
}

$high = $highOD+$totaloveron+$totaloverev;

$total_all = $low + $medium + $high; 
  
?>
<script src="netuse/ajax.jquery.min.js"></script>
<script src="netuse/highcharts.js"></script>
<script src="netuse/exporting.js"></script>
<script>
document.addEventListener('readystatechange', function() {
if (document.readyState === 'complete') {
        // Load and append data efficiently
        loadData();
    }
});

function loadData(){
    $.ajax({
        type: 'POST',
        url: '<?=$host;?>/lexcomplyupdates/background_group_over_criticality.php',
        data: { action: 'run_queries' },
        success: function(response) {
            // console.log('Background query response:', response);
        },
        error: function(xhr, status, error) {
            console.error('Error running background query:', error);
        }
    });
}

jQuery(function () {
    jQuery('#two_frame').highcharts({
      chart: {
        type: 'pie',
		style: {
			//fontFamily:'"GT Walsheim Pro Bold"',
			color: '#000',
			fontSize:'10'
			},
        
		 events: {
                    load: addTitle,
                    redraw: addTitle,
                },
    },
    title: {
        text: 'Overdue-Criticality',
		useHTML: true,
		
		style: {
			color: '#000',
			//fontFamily:'"GT Walsheim Pro Regular"',
			fontSize:'14'
			}
        
    },
	
	subtitle: {
                text: "",
                margin: 0,
                y: 0,
                x: 0,
                align: 'center',
                verticalAlign: 'middle',
            },
			
	legend: {
        itemStyle: {
            
            fontWeight: 'bold',
            fontSize: '10px'
        }
		},
	
	
	tooltip: {
        pointFormat: '{series.name}: <b>{point.y:,.0f}</b>'
    },
    
    plotOptions: {
        pie: {
			allowPointSelect: true,
			cursor: 'pointer',  
            
            innerSize: '50%',
            //depth: 45,
			/*colors: [
					'#e92841', 
					'#9bd732',
					'#4f2d7f',
					'#00a7b5',
					],*/
			dataLabels: {
				
                enabled: true,
				format:'{point.y:,.0f}',	
				distance: -20,
                color:'white',
				style: { fontWeight: 'normal'},
            },
			showInLegend: true,	
			point: {
                   
					events: { 
                        click: function () {
							var criticality = encodeURIComponent(this.name);
							var type = encodeURIComponent(this.series.name);
							
							$.ajax({
								
								type : 'POST',
								url	 : '<?=$host;?>/lexcomplyupdates/group_criticality_overdue_chart.php',
								data: {criticality:criticality, type:type},
								success:function(response){
									var myWindow = window.open("", "MsgWindow", 'width=1300px, height=650px, scrollbars=1');
									myWindow.document.open();
									myWindow.document.write(response);  
								    myWindow.document.close();	
								}
							});
                        }
                    }
                }	
        }
    },
	
	credits: {
        enabled: false
    },
	
    series: [{
        name: 'Overdue',
        /*data: [
            <?=$cri_overdue?>
           
        ]*/
		data:[
		
		
		{
            name: 'High',
            y: <?=$high;?>,
            color: '#e92841'
        },
		
		{
            name: 'Medium',
            y: <?=$medium;?>,
            color: '#FF7D1F'
        },
		
		{
            name: 'Low',
            y: <?=$low;?>,
            color: '#22beef'
        },
		/*{
            name: 'Normal',
            y: <?=$normal;?>,
            color:'#f7a35c'
        },*/
			
			]
		
    }]
    });
	
	function addTitle() {
            if (this.subtitle) {
                this.subtitle.destroy();
            }
            var r = this.renderer,
                x = this.series[0].center[0] + this.plotLeft,
                y = this.series[0].center[1] + this.plotTop;
            this.subtitle = r.text('<?php if($total_all==0){ echo "None";}else{ echo $total_all;}?>', 0, 0)
                .css({
                color: '#4f2684',
                fontSize: '16px',
				fontWeight: 'bold'
				//fontFamily:'"GT Walsheim Pro Regular"'
            }).hide()
                .add();
            var bbox = this.subtitle.getBBox();
            this.subtitle.attr({
                x: x - (bbox.width / 2),
                y: y
            }).show();
        }
	
});
</script>
 
<div id="two_frame" style="min-width: 70%; max-width: 100%; height: 100%; margin: 0 auto" class="cls_id"></div>
 