<?php
require 'include/configpdo.php';
error_reporting(0);
require_once 'rsjadmin/Classes/PHPExcel.php';
include("main_function.php");
function getRequestComplianceReport(){
    $dbh = connect_db();
    $date = date("Y-m-d");
    try{
        $query = $dbh->prepare("SELECT * FROM `ongoing_report_request_manage` WHERE `date_added`=? AND `added`=? AND `in_progress`=? AND `completed`=? ORDER BY `id` DESC LIMIT 1");
        $query->bindValue(1, $date);
        $query->bindValue(2, 1);
        $query->bindValue(3, 0);
        $query->bindValue(4, 0);
        $query->execute();
        $result = $query->fetch(PDO::FETCH_ASSOC);
        return $result;
    } catch(PDOException $e){
        return $e->getMessage();
    }
}

function updateRequeststatusInProgress($id){
    $dbh = connect_db();
    $date = date("Y-m-d");
    $time = date("H:i:s");
    try{
        $query = $dbh->prepare("UPDATE `ongoing_report_request_manage` SET `in_progress`=1, `date_progress`='$date', `time_progress`='$time' WHERE `id`=?");
        $query->bindValue(1, $id);
        $result = $query->execute();
        return $result;
    } catch(PDOException $e){
        return $e->getMessage();
    }
}


function updateRequeststatusCompleted($id){
    $dbh = connect_db();
    $date = date("Y-m-d");
    $time = date("H:i:s");
    try{
        $query = $dbh->prepare("UPDATE `ongoing_report_request_manage` SET `completed`=1, `mail_sent_date`='$date', `mail_sent_time`='$time', `date_completed`='$date', `time_completed`='$time' WHERE `id`=?");
        $query->bindValue(1, $id);
        $result = $query->execute();
        return $result;
    } catch(PDOException $e){
        return $e->getMessage();
    }
}


function send_mail_logE($email, $subject, $msg1, $msg2){
	$date = date('Y-m-d H:i:s');
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "INSERT INTO `mail_send_report`(`email`, `subject`, `msg_status`, `msg_status_2`,`date_time`) VALUES ('".$email."','".$subject."','".$msg1."','".$msg2."','".$date."')" );
		$result = $query->execute();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function eventListMail($email, $subject, $message, $attachment){
    require_once('./PHPMailer/class.phpmailer.php');
	$mail = new PHPMailer();
	$mail->IsSMTP();
	$mail->SMTPDebug = 0;  
	$mail->Host = "smtp.pepipost.com";
	$mail->Port = 587;
	$mail->SMTPOptions = array(
				'ssl' => array(
					'verify_peer' => false,
					'verify_peer_name' => false,
					'allow_self_signed' => true
				)
			);
	$mail->Username = "lexcomplypep";
	$mail->Password = "Cms@1010";
	$mail->addCustomHeader('X-custom-header', 'custom-value');
	$mail->SMTPSecure = "SSL"; 
	$mail->SMTPAuth = true; 
	$mail->AddReplyTo("support@lexcomply.com","Lexcomply Support"); 
	$mail->SetFrom('u-support@lexcomply.co', 'Lexcomply CMS');	
	$mail->Subject  = $subject; 
	$mail->MsgHTML($message);
	$mail->AddAddress($email);
	$mail->addAttachment($attachment);
	if(!$mail->send()){
    	$result =  $mail->ErrorInfo;
    	$result2 =  "Not send";
    	send_mail_logE($email, $subject, $result, $result2);
    }else{
    	$result = 'Message has been sent successfully.';
    	$result2 =  "send";
    	send_mail_logE($email, $subject, $result, $result2);
    }
	$mail->ClearAddresses();
	$mail->ClearAllRecipients( );
}

function get_compliance_ny_types( $src, $type ) {
  $dbh = connect_db();
  try {
	  if($type == 'complete'){
			$duedatefrom	= '1970-01-01';
			$duedateto		= date("Y-m-d",strtotime("+15 days"));
			$query = $dbh->prepare( "select count(`sr`) as ql from `company_compliance` where $src and due_date  BETWEEN '$duedatefrom' and '$duedateto'  and due_date >= date_time and status = 7" ); 
	  }elseif($type == 'over'){
			$duedatefrom	= '1970-01-01';
			$duedateto		= date("Y-m-d",strtotime("-1 days"));
		    $query = $dbh->prepare( "select count(`sr`) as ql from `company_compliance` where $src and due_date  BETWEEN '$duedatefrom' and '$duedateto' and due_date != '' and status != 7 " ); 
	  }elseif($type == 'due'){
			$duedatefrom	= date("Y-m-d");
			$duedateto		= date("Y-m-d",strtotime("+15 days"));
		    $query = $dbh->prepare( "select count(`sr`) as ql from `company_compliance` where $src  and due_date  BETWEEN '$duedatefrom' and '$duedateto' and due_date != '' and status != 7"); 
	  }elseif($type == 'delay'){
			$duedatefrom	= '1970-01-01';
			$duedateto		= date("Y-m-d",strtotime("+15 days"));
			$query = $dbh->prepare( "select count(`sr`) as ql from `company_compliance` where $src and due_date  BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time and status = 7" ); 
	  }elseif($type == 'nonapp'){
			$query = $dbh->prepare( "select count(`sr`) as ql from `company_compliance` where $src and status = 9" ); 
	  }
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result['ql'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function search_word($string, $word){
	if(preg_match("/{$word}/i", $string)) {
			return 1;
	}else {
			return 0;
	}
}

function get_compliances_id_by_act_id_2_loc($fpr, $appr, $company_id ) {
	$dbh = connect_db();
  try {
    $query = $dbh->prepare( "select cc.location as location from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%'   and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.location" );
    $query->execute();
	$result = $query->fetchAll();
    //$result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
     return $e->getMessage();
  }
}


function get_user_departmnet_3($fpr,$appr,$company_id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select cc.department as department from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%' and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.department" );
    $query->execute();
    $result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
     return $e->getMessage();
  }
}

function get_user_location_3($fpr,$appr,$company_id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select cc.location as location from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%' and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.location" );
    $query->execute();
    $result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
     return $e->getMessage();
  }
}

function get_user_hod_3($fpr,$appr,$company_id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select cc.hod_id as hod_id from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%' and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.hod_id" );
    $query->execute();
    $result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
     return $e->getMessage();
  }
}

function get_compliances_id_by_act_id_2($fpr, $appr ,$company_id) {
	$dbh = connect_db();
  try {
    $query = $dbh->prepare( "select cc.department as department from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%'   and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.department" );
    $query->execute();
	$result = $query->fetchAll();
    //$result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
     return $e->getMessage();
  }
}

$data = getRequestComplianceReport();
if(!is_bool($data) && count($data)>=1){
    $rowid = $data['id'];
    updateRequeststatusInProgress($rowid);
    $company_id	= $data['company_id'];
    $dateAdded = $data['date_added'];
    $c_name = get_company_by_id( $company_id )['name'];
    $rand = rand(10,100);
    $sr = $data['srrequested'];
    $filename = "ongoing_report/Ongoing-Report-".$rand."-".$dateAdded.".xls";
    $email = $data['mail_sent_to'];
    $role = strtoupper($data['user_role']);
    $company_id = $data['company_id'];
    $for = $data['from_date'];
    $to = $data['to_date'];
    
    // body will be changed here for any export excel
    $qt = 	explode(",",$sr);
    $full_count = 	count($qt)-1;
    
    $src = '';
    if($full_count == 1 ){
    	for($i=1;$i<=$full_count;$i++){
    		$src .= '( `sr` = '.$qt[$i].' )';
    	}
    } else {
        for($i=1;$i<=$full_count;$i++){
        	if($i == 1){
		        $src .= '( `sr` = '.$qt[$i];
	        }elseif($i == $full_count){
		        if($role == 'FPR'){
			        $src .= " or `sr` = ".$qt[$i]." ) AND `fpr_id` = '$usrid' AND `company_id` = '$company_id'";	
		        } elseif($role == 'APPROVER'){
			        $src .= " or `sr` = ".$qt[$i]." ) AND `appr_id` = '$usrid' AND `company_id` = '$company_id'";	
		        } elseif($role == 'HOD'){
			        $src .= " or `sr` = ".$qt[$i]." ) AND `hod_id` = '$usrid' AND `company_id` = '$company_id'";
		        } else {
				    $src .= " or `sr` = ".$qt[$i]." )";
		        }
	        } else {
		        $src .= ' or `sr` = '.$qt[$i];
	        }
        }
    }
    
    $dbh = connect_db();
    $query = $dbh->prepare( "select * from `company_compliance` where $src" );
    $query->execute();
    $result = $query->fetchAll();
    $rtt = 1;
    foreach($result as $rs1 ){
    	$rtt = $rtt+$rtt;
    }
    

	$objPHPExcel = new PHPExcel();
    $styleArray = array(
		'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '4f2d7f')
        ),
		'borders' => array(
		'allborders'    => array('style' => PHPExcel_Style_Border::BORDER_THIN)
		),
		'font'  => array(
        'bold'  => true,
        'color' => array('rgb' => 'FFFFFF'),
        'size'  => 12,
        //'name'  => 'Verdana'
		));
	
    $styleArray1 = array(
		'borders' => array(
		'allborders'    => array('style' => PHPExcel_Style_Border::BORDER_THIN)
		));

    $styleArray2 = array(
		'borders' => array(
		'allborders'    => array('style' => PHPExcel_Style_Border::BORDER_THIN)
		),
		'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '4f2d7f')
        ),
		'font'  => array(
        'bold'  => true,
		'color' => array('rgb' => 'FFFFFF'),
        'size'  => 13,
    ));	
   

    $objPHPExcel->setActiveSheetIndex(0); 
    $rowCount1 = 1;  
    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount1, 'Reference ID');
    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount1, 'Company Name');
    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount1, 'Act');
    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount1, 'Compliance ID');
    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount1, 'Compliance Description');
    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount1, 'Location');
    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount1, 'Department');
    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount1, 'Due Date');
    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount1, 'Actual Date');
    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount1, 'Criticality');
    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount1, 'Periodicity');
    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount1, 'FPR');
    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount1, 'Approver');
    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount1, 'HoD');
    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$rowCount1, 'Status');
    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$rowCount1, 'Amount(INR)');
    $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$rowCount1, 'Penalty(INR)');
    $objPHPExcel->getActiveSheet()->SetCellValue('R'.$rowCount1, 'Interest(INR)');
    
    $rowCount = 5;
    
    $kt = 1;
    foreach($result as $rs ){
	    $showcomp = get_compliance_by_id_4 ($rs['compliance_id']);
	    switch($rs['status']){
		    case 2:
		    $status_r =  "Not Allocated";
		    break;
		
		    case 3:
		    $status_r =  "Draft at fpr";
		    break;
		
		    case 4:
		    $status_r =  "Pending at approver";
		    break;
		
		    case 5:
		    $status_r =  "Conditional";
		    break;
		
		    case 6:
		    $status_r =  "Rejected by Approver";
		    break;
		
		    case 9:
		    $status_r = "Not Applicable";
		    break;
	    }
			
		if($role=='AUDITOR' && ($rs['status']==7 &&  $rs['auditor_status']!=2) && ($showcomp['description']!="Periodic on-Going Check Cycle" && $showcomp['description']!="Periodic Cycle for check Events") ){
			$status_r =  "Pending at Auditor";
		} else {
			if($rs['status']==7){
				if(strtotime($rs['due_date'])>=strtotime($rs['date_time'])){
					$status_r =  "Yes";	
				}
				if(strtotime($rs['due_date'])<strtotime($rs['date_time'])){
					$status_r =  "Yes";	
				}

			}
		}
		
		if($rs['status']==1 && $rs['auditor_status']==1){
		    $status_r =  "Rejected By Auditor";	
		} elseif($rs['status']==1){
		    $status_r =  "Pending at Fpr";	
		}

		//-- --------- --//
		if($rs['due_date']!=$rs['base_due_date'] && $rs['base_due_date']!=''){
			$extend_d = date('d-M-Y', strtotime($rs['base_due_date']));
			$e_date = ' ( Original Due Date : '.$extend_d.' ) ';
		}else {
			$e_date = '';
		}
		//-- --------- --//
		
		
		$showa=get_act_by_id ( $rs['act_id'] );
		
		
		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $rs['sr']);
    	$objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, getCompanyNameD($rs['company_id']));
    	$objPHPExcel->getActiveSheet()->getStyle('B'.$rowCount)->getAlignment()->setWrapText(true);
    	$objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $showa['name']);
    	$objPHPExcel->getActiveSheet()->getStyle('C'.$rowCount)->getAlignment()->setWrapText(true);
    	$objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $rs['compliance_id']);
    	$objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $showcomp['description']);
    	$objPHPExcel->getActiveSheet()->getStyle('E'.$rowCount)->getAlignment()->setWrapText(true);
    	$objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $locq);
    	$objPHPExcel->getActiveSheet()->getStyle('F'.$rowCount)->getAlignment()->setWrapText(true);
    	$objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $dept);
    	$objPHPExcel->getActiveSheet()->getStyle('G'.$rowCount)->getAlignment()->setWrapText(true);
    	$objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $duedate);
    	$objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, $rs['date_time']);
    	$objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, $showcomp['criticality']);
    	$objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, $showcomp['periodicity']);
    	$objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, $rs['fpr_id']);
    	$objPHPExcel->getActiveSheet()->getStyle('L'.$rowCount)->getAlignment()->setWrapText(true);
    	$objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount, $rs['appr_id']);
    	$objPHPExcel->getActiveSheet()->getStyle('M'.$rowCount)->getAlignment()->setWrapText(true);
    	$objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount, $rs['hod_id']);
    	$objPHPExcel->getActiveSheet()->getStyle('N'.$rowCount)->getAlignment()->setWrapText(true);
    	$objPHPExcel->getActiveSheet()->SetCellValue('O'.$rowCount, $status_r);
    	$objPHPExcel->getActiveSheet()->getStyle('O'.$rowCount)->getAlignment()->setWrapText(true);
    	$objPHPExcel->getActiveSheet()->SetCellValue('P'.$rowCount, $rs['amount_c']);
    	$objPHPExcel->getActiveSheet()->SetCellValue('Q'.$rowCount, $rs['penalties']);
    	$objPHPExcel->getActiveSheet()->SetCellValue('R'.$rowCount, $rs['interest']);
    	
    	$objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('B'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('C'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('D'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('E'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('F'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('G'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('H'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('I'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('J'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('K'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('L'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('M'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('N'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('O'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('P'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('Q'.$rowCount)->applyFromArray($styleArray1);
    	$objPHPExcel->getActiveSheet()->getStyle('R'.$rowCount)->applyFromArray($styleArray1);
		
     
        $rowCount++; 
		$kt++;
	}
    
    
    $objPHPExcel->getActiveSheet()->getStyle("A1:R1")->getFont()->setBold(true); 
    $objPHPExcel->getActiveSheet()->getStyle('A1:R1')->applyFromArray($styleArray);
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);
    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(15);
    $objPHPExcel->setActiveSheetIndex(0);
    
    
    
    // this will remain same
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');   
    
    $objWriter->save($filename);
    $date = date('Y-m-d H:i:s');
    $subject = "Ongoing Report - $date";
    $message = "As requested please find the attached file.";
    $mailSend = eventListMail($email, $subject, $message, $filename);
    updateRequeststatusCompleted($rowid);
    unlink($filename);
}	
?>