<?php
require 'include/configpdo.php';
error_reporting(E_ALL);
require_once 'rsjadmin/Classes/PHPExcel.php';
function getRequestComplianceReport(){
    $dbh = connect_db();
    $date = date("Y-m-d");
    try{
        $query = $dbh->prepare("SELECT * FROM `compliance_report_request_manage` WHERE `date_added`=? AND `added`=? AND `in_progress`=? AND `completed`=? ORDER BY `id` DESC LIMIT 1");
        $query->bindValue(1, $date);
        $query->bindValue(2, 1);
        $query->bindValue(3, 0);
        $query->bindValue(4, 0);
        $query->execute();
        $result = $query->fetch(PDO::FETCH_ASSOC);
        return $result;
    } catch(PDOException $e){
        return $e->getMessage();
    }
}

function getCompanyNameCC($company_id){
    $dbh = connect_db();
    try {
		$query = $dbh->prepare( "SELECT `name` FROM `company` WHERE `company_id`=?");
		$query->bindValue(1, $company_id);
        $query->execute();
        $result = $query->fetchColumn();
        return $result;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function updateRequeststatusInProgress($id){
    $dbh = connect_db();
    $date = date("Y-m-d");
    $time = date("H:i:s");
    try{
        $query = $dbh->prepare("UPDATE `compliance_report_request_manage` SET `in_progress`=1, `date_progress`='$date', `time_progress`='$time' WHERE `id`=?");
        $query->bindValue(1, $id);
        $result = $query->execute();
        return $result;
    } catch(PDOException $e){
        return $e->getMessage();
    }
}


function updateRequeststatusCompleted($id){
    $dbh = connect_db();
    $date = date("Y-m-d");
    $time = date("H:i:s");
    try{
        $query = $dbh->prepare("UPDATE `compliance_report_request_manage` SET `completed`=1, `mail_sent_date`='$date', `mail_sent_time`='$time', `date_completed`='$date', `time_completed`='$time' WHERE `id`=?");
        $query->bindValue(1, $id);
        $result = $query->execute();
        return $result;
    } catch(PDOException $e){
        return $e->getMessage();
    }
}


function send_mail_logE($email, $subject, $msg1, $msg2){
	$date = date('Y-m-d H:i:s');
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "INSERT INTO `mail_send_report`(`email`, `subject`, `msg_status`, `msg_status_2`,`date_time`) VALUES ('".$email."','".$subject."','".$msg1."','".$msg2."','".$date."')" );
		$result = $query->execute();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function eventListMail($email, $subject, $message, $attachment){
    require_once('./PHPMailer/class.phpmailer.php');
	$mail = new PHPMailer();
	$mail->IsSMTP();
	$mail->SMTPDebug = 0;  
	$mail->Host = "smtp.pepipost.com";
	$mail->Port = 587;
	$mail->SMTPOptions = array(
				'ssl' => array(
					'verify_peer' => false,
					'verify_peer_name' => false,
					'allow_self_signed' => true
				)
			);
	$mail->Username = "lexcomplypep";
	$mail->Password = "Cms@1010";
	$mail->addCustomHeader('X-custom-header', 'custom-value');
	$mail->SMTPSecure = "SSL"; 
	$mail->SMTPAuth = true; 
	$mail->AddReplyTo("support@lexcomply.com","Lexcomply Support"); 
	$mail->SetFrom('u-support@lexcomply.co', 'Lexcomply CMS');	
	$mail->Subject  = $subject; 
	$mail->MsgHTML($message);
	$mail->AddAddress($email);
	$mail->addAttachment($attachment);
	if(!$mail->send()){
    	$result =  $mail->ErrorInfo;
    	$result2 =  "Not send";
    	send_mail_logE($email, $subject, $result, $result2);
    }else{
    	$result = 'Message has been sent successfully.';
    	$result2 =  "send";
    	send_mail_logE($email, $subject, $result, $result2);
    }
	$mail->ClearAddresses();
	$mail->ClearAllRecipients( );
}

function get_compliance_ny_types( $src, $type ) {
  $dbh = connect_db();
  try {
	  if($type == 'complete'){
			$duedatefrom	= '1970-01-01';
			$duedateto		= date("Y-m-d",strtotime("+15 days"));
			$query = $dbh->prepare( "select count(`sr`) as ql from `company_compliance` where $src and due_date  BETWEEN '$duedatefrom' and '$duedateto'  and due_date >= date_time and status = 7" ); 
	  }elseif($type == 'over'){
			$duedatefrom	= '1970-01-01';
			$duedateto		= date("Y-m-d",strtotime("-1 days"));
		    $query = $dbh->prepare( "select count(`sr`) as ql from `company_compliance` where $src and due_date  BETWEEN '$duedatefrom' and '$duedateto' and due_date != '' and status != 7 " ); 
	  }elseif($type == 'due'){
			$duedatefrom	= date("Y-m-d");
			$duedateto		= date("Y-m-d",strtotime("+15 days"));
		    $query = $dbh->prepare( "select count(`sr`) as ql from `company_compliance` where $src  and due_date  BETWEEN '$duedatefrom' and '$duedateto' and due_date != '' and status != 7"); 
	  }elseif($type == 'delay'){
			$duedatefrom	= '1970-01-01';
			$duedateto		= date("Y-m-d",strtotime("+15 days"));
			$query = $dbh->prepare( "select count(`sr`) as ql from `company_compliance` where $src and due_date  BETWEEN '$duedatefrom' and '$duedateto'  and due_date < date_time and status = 7" ); 
	  }elseif($type == 'nonapp'){
			$query = $dbh->prepare( "select count(`sr`) as ql from `company_compliance` where $src and status = 9" ); 
	  }
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result['ql'];
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function search_word($string, $word){
	if(preg_match("/{$word}/i", $string)) {
			return 1;
	}else {
			return 0;
	}
}

function get_compliances_id_by_act_id_2_loc($fpr, $appr, $company_id ) {
	$dbh = connect_db();
  try {
    $query = $dbh->prepare( "select cc.location as location from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%'   and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.location" );
    $query->execute();
	$result = $query->fetchAll();
    //$result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
     return $e->getMessage();
  }
}


function get_user_departmnet_3($fpr,$appr,$company_id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select cc.department as department from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%' and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.department" );
    $query->execute();
    $result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
     return $e->getMessage();
  }
}

function get_user_location_3($fpr,$appr,$company_id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select cc.location as location from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%' and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.location" );
    $query->execute();
    $result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
     return $e->getMessage();
  }
}

function get_user_hod_3($fpr,$appr,$company_id ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select cc.hod_id as hod_id from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%' and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.hod_id" );
    $query->execute();
    $result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
     return $e->getMessage();
  }
}

function get_compliances_id_by_act_id_2($fpr, $appr ,$company_id) {
	$dbh = connect_db();
  try {
    $query = $dbh->prepare( "select cc.department as department from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%'   and cc.`company_id`='$company_id' and cc.`cycle_id`='0' and cc.fpr_id='$fpr' and cc.appr_id='$appr' group by cc.department" );
    $query->execute();
	$result = $query->fetchAll();
    //$result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
     return $e->getMessage();
  }
}

$data = getRequestComplianceReport();
if(!is_bool($data) && count($data)>=1){
    $rowid = $data['id'];
    updateRequeststatusInProgress($rowid);
    $company_id	= $data['company_id'];
    $dateAdded = $data['date_added'];
    
    $rand = rand(10,100);
    $sr = $data['srrequested'];
    $filename = "compliance_report/Compliance-Report-".$rand."-".$dateAdded.".xls";
    $email = $data['mail_sent_to'];
    $role = $data['user_role'];
    $compaid = $data['company_id'];
    $cc = explode(',',$compaid);
    if(is_array($cc)){
    	$cccompid = "";
    	$c_name = "";
    	$company_id = " AND (";
    	$last_item = count($cc)-1;
    	for($i=0;$i<count($cc);$i++){
    		if( $last_item == $i){
    		    $cccompid .= $cc[$i];
    			$company_id .= "`company_id`='$cc[$i]'";
    			$c_name .= get_company_by_id( $cc[$i] )['name'];
    		} else {
    		    $cccompid .= $cc[$i].", ";
    			$company_id .= "`company_id`='$cc[$i]' OR";
    			$c_name .= get_company_by_id( $cc[$i] )['name'].", ";
    		}
    	}
    	$company_id .= ")";
    } else {
        $company_id = " AND (`company_id`='$compaid')";
        $c_name = get_company_by_id( $compaid )['name'];
    }
    $for = $data['from_date'];
    $to = $data['to_date'];
    
    // body will be changed here for any export excel
    $qt = 	explode(",",$sr);
    $full_count = 	count($qt)-1;
    
    $src = '';
    if($full_count == 1 ){
    	for($i=1;$i<=$full_count;$i++){
    		$src .= '( `sr` = '.$qt[$i].' )';
    	}
    } else {
        for($i=1;$i<=$full_count;$i++){
        	if($i == 1){
		        $src .= '( `sr` = '.$qt[$i];
	        }elseif($i == $full_count){
		        $src .= " or `sr` = ".$qt[$i]." ) $company_id AND `due_date` != '' ";
		    } else {
		        $src .= ' or `sr` = '.$qt[$i];
	        }
        }
    }
    
    $dbh = connect_db();
    $query = $dbh->prepare( "select * from `company_compliance` where $src" );
    $query->execute();
    $result = $query->fetchAll();
    $rtt = 1;
    foreach($result as $rs1 ){
    	$rtt = $rtt+$rtt;
    }
    

	$objPHPExcel = new PHPExcel();
    $styleArray = array(
		'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '4f2d7f')
        ),
		'borders' => array(
		'allborders'    => array('style' => PHPExcel_Style_Border::BORDER_THIN)
		),
		'font'  => array(
        'bold'  => true,
        'color' => array('rgb' => 'FFFFFF'),
        'size'  => 12,
        //'name'  => 'Verdana'
		));
	
    $styleArray1 = array(
		'borders' => array(
		'allborders'    => array('style' => PHPExcel_Style_Border::BORDER_THIN)
		));

    $styleArray2 = array(
		'borders' => array(
		'allborders'    => array('style' => PHPExcel_Style_Border::BORDER_THIN)
		),
		'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'color' => array('rgb' => '4f2d7f')
        ),
		'font'  => array(
        'bold'  => true,
		'color' => array('rgb' => 'FFFFFF'),
        'size'  => 13,
    ));	
   

    $objPHPExcel->setActiveSheetIndex(0); 
    $rowCount1 = 1; 
    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount1, 'Sr.No.');
    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount1, 'Reference ID');
    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount1, 'Compliance ID');
    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount1, 'Sub Title');
    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount1, 'Compliance Description');
    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount1, 'Act');
    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount1, 'Location');
    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount1, 'Department');
    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount1, 'Due Date');
    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount1, 'Compliance Month');
    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount1, 'Actual Date');
    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount1, 'System Date');
    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount1, 'Criticality');
    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount1, 'Periodicity');
    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$rowCount1, 'FPR');
    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$rowCount1, 'Approver');
    $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$rowCount1, 'HoD');
    $objPHPExcel->getActiveSheet()->SetCellValue('R'.$rowCount1, 'Status');
    $objPHPExcel->getActiveSheet()->SetCellValue('S'.$rowCount1, 'Total Delay Time ');
    $objPHPExcel->getActiveSheet()->SetCellValue('T'.$rowCount1, 'Amount(INR)');
    $objPHPExcel->getActiveSheet()->SetCellValue('U'.$rowCount1, 'Penalty(INR)');
    $objPHPExcel->getActiveSheet()->SetCellValue('V'.$rowCount1, 'Interest(INR)');
    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$rowCount1, 'Attachment');
    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$rowCount1, 'FPR Remarks');
    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$rowCount1, 'Approver Remarks');
    $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$rowCount1, 'Company Name');
    
    $rowCount = 2;
    
    $kt = 1;
    foreach($result as $rs ){
	    $showcomp = get_compliance_by_id_4 ($rs['compliance_id']);
	    switch($rs['status']){
		    case 2:
		    $status_r =  "Not Allocated";
		    break;
		
		    case 3:
		    $status_r =  "Draft at fpr";
		    break;
		
		    case 4:
		    $status_r =  "Pending at approver";
		    break;
		
		    case 5:
		    $status_r =  "Conditional";
		    break;
		
		    case 6:
		    $status_r =  "Rejected by Approver";
		    break;
		
		    case 9:
		    $status_r = "Not Applicable";
		    break;
	    }
			
		if($role=='AUDITOR' && ($rs['status']==7 &&  $rs['auditor_status']!=2) && ($showcomp['description']!="Periodic on-Going Check Cycle" && $showcomp['description']!="Periodic Cycle for check Events") ){
			$status_r =  "Pending at Auditor";
		} else {
			if($rs['status']==7){
				if(strtotime($rs['due_date'])>=strtotime($rs['date_time'])){
					$status_r =  "Compliant";	
				}
				if(strtotime($rs['due_date'])<strtotime($rs['date_time'])){
					$status_r =  "Delayed Compliance";	
				}

			}
		}
		
		if($rs['status']==1 && $rs['auditor_status']==1){
		    $status_r =  "Rejected By Auditor";	
		} elseif($rs['status']==1){
		    $status_r =  "Pending at Fpr";	
		}
		if($rs['status'] == 7 && ($rs['compliance_id'] != 555 || $rs['compliance_id'] != 556) && ($rs['due_date'] < $rs['date_time'] ) ) {
			$diff = abs(strtotime($rs['date_time']) - strtotime($rs['due_date']));
			$years = floor($diff / (365*60*60*24));
			$months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
					$days = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));
				if($years == 1 || $years == 0)
					{	$y = 'Year';	} else { $y = 'Years'; }
				if($months == 1 || $months == 0)
					{	$m = 'Month';	} else { $m = 'Months'; }
				if($days == 1 || $days == 0)
					{	$d = 'Day';	} else { $d = 'Days'; }
					$rstl = $years." $y ".$months." $m ".$days." $d ";
				}else {
					$rstl = ' - ';
				}
			//-- -- nw ------- --//
		if($rs['location'] !=''){
			$locq= $rs['location'];
		}else{
			if($rs['compliance_id'] == '555'){
				$locq 	= '';
				$rtswd = 1;
				foreach(get_user_location_3($rs['fpr_id'],$rs['appr_id'],$rs['company_id'] ) as $desptdc){
				$locq	.= $desptdc['location'];
				if($rtswd != 1){
				$locq	.= ' , ';
				$locq	.= $desptdc['location'];
				}
				$rtswd++;
				}
			}
		}
		if($rs['department'] !=''){
			$dept= $rs['department'];
		}else{
			if($rs['compliance_id'] == '555'){
				$dept 	= '';
				$rtswd = 1;
				foreach(get_user_departmnet_3($rs['fpr_id'],$rs['appr_id'],$rs['company_id']  ) as $desptd){
				$dept	.= $desptd['department'];
				if($rtswd != 1){
				$dept	.= ' , ';
				$dept	.= $desptd['department'];
				}
				$rtswd++;
				}	
			}
		}
		
		if($rs['hod_id'] !=''){
			$hodf = $rs['hod_id'];
		}else{
			if($rs['compliance_id'] == '555'){
				$hodf 	= '';
				$rtswh = 1;
				foreach(get_user_hod_3($rs['fpr_id'], $rs['appr_id'],$rs['company_id']  ) as $despth){
    				if($rtswh != 1){
        				$hodf	.= ' , ';
        				$hodf	.= $despth['hod_id'];
    				} else {
    				    $hodf	.= $despth['hod_id'];
    				}
    				$rtswh++;
				}	
			}
		}
		//-- --------- --//
		if($rs['due_date']!=$rs['base_due_date'] && $rs['base_due_date']!=''){
			$extend_d = date('d-M-Y', strtotime($rs['base_due_date']));
			$e_date = ' ( Original Due Date : '.$extend_d.' ) ';
		}else {
			$e_date = '';
		}
		//-- --------- --//
		
		
		$showa=get_act_by_id ( $rs['act_id'] );
		$comevedance=get_evedance_docs_by_company_compliance_id ( $rs['sr'] );
		if(count($comevedance)==0) { 
		    $eved = 'No';
		} else { 
		    $eved = 'Yes'; 
		}
			
		if(search_word($rs['due_date'], '-01-') == 1){
			$month = 'January';
		}elseif(search_word($rs['due_date'], '-02-') == 1){
			$month = 'February';
		}elseif(search_word($rs['due_date'], '-03-') == 1){
			$month = 'March';
		}elseif(search_word($rs['due_date'], '-04-') == 1){
			$month = 'April';
		}elseif(search_word($rs['due_date'], '-05-') == 1){
			$month = 'May';
		}elseif(search_word($rs['due_date'], '-06-') == 1){
			$month = 'June';
		}elseif(search_word($rs['due_date'], '-07-') == 1){
			$month = 'July';
		}elseif(search_word($rs['due_date'], '-08-') == 1){
			$month = 'August';
		}elseif(search_word($rs['due_date'], '-09-') == 1){
			$month = 'September';
		}elseif(search_word($rs['due_date'], '-10-') == 1){
			$month = 'October';
		}elseif(search_word($rs['due_date'], '-11-') == 1){
			$month = 'November';
		}elseif(search_word($rs['due_date'], '-12-') == 1){
			$month = 'December';
		}else{
			$month = '';
		}
		
		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $kt);
		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $rs['sr']);
		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $rs['compliance_id']);
		$objPHPExcel->getActiveSheet()->getStyle('D')->getAlignment()->setWrapText(true);		
		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $showcomp['sub_head']);		
		$objPHPExcel->getActiveSheet()->getStyle('E')->getAlignment()->setWrapText(true);	
		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $showcomp['description'].' '.$e_date);		
		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $showa['name']);
		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, $locq);
		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, $dept);
		$objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, $rs['due_date']);
		$objPHPExcel->getActiveSheet()->SetCellValue('J'.$rowCount, $month);
		$objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, $rs['date_time']);
		$objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, $rs['sys_date']);
		$objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount, $showcomp['criticality']);
		$objPHPExcel->getActiveSheet()->SetCellValue('N'.$rowCount, $showcomp['periodicity']);
		$objPHPExcel->getActiveSheet()->SetCellValue('O'.$rowCount, $rs['fpr_id']);
		$objPHPExcel->getActiveSheet()->SetCellValue('P'.$rowCount, $rs['appr_id']);
		$objPHPExcel->getActiveSheet()->SetCellValue('Q'.$rowCount, $hodf);
		$objPHPExcel->getActiveSheet()->SetCellValue('R'.$rowCount, $status_r);
		$objPHPExcel->getActiveSheet()->SetCellValue('S'.$rowCount, $rstl);
		$objPHPExcel->getActiveSheet()->SetCellValue('T'.$rowCount, $rs['amount_c']);
		$objPHPExcel->getActiveSheet()->SetCellValue('U'.$rowCount, $rs['penalties']);
		$objPHPExcel->getActiveSheet()->SetCellValue('V'.$rowCount, $rs['interest']);
		$objPHPExcel->getActiveSheet()->SetCellValue('W'.$rowCount, $eved);		
		$objPHPExcel->getActiveSheet()->SetCellValue('X'.$rowCount, $rs['delay_resaon']);
        $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$rowCount, $rs['remark_appr']);
        $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$rowCount, getCompanyNameCC($rs['company_id']));	
        		
		
		$objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('B'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('C'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('D'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('E'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('E'.$rowCount)->getAlignment()->setWrapText(true);
		$objPHPExcel->getActiveSheet()->getStyle('F'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('F'.$rowCount)->getAlignment()->setWrapText(true);
		$objPHPExcel->getActiveSheet()->getStyle('G'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('G'.$rowCount)->getAlignment()->setWrapText(true);
		$objPHPExcel->getActiveSheet()->getStyle('H'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('I'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('J'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('K'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('L'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('M'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('M'.$rowCount)->getAlignment()->setWrapText(true);
		$objPHPExcel->getActiveSheet()->getStyle('N'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('N'.$rowCount)->getAlignment()->setWrapText(true);
		$objPHPExcel->getActiveSheet()->getStyle('O'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('O'.$rowCount)->getAlignment()->setWrapText(true);
		$objPHPExcel->getActiveSheet()->getStyle('P'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('P'.$rowCount)->getAlignment()->setWrapText(true);
		$objPHPExcel->getActiveSheet()->getStyle('Q'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('R'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('S'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('T'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('U'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('V'.$rowCount)->applyFromArray($styleArray1);
		$objPHPExcel->getActiveSheet()->getStyle('W'.$rowCount)->getAlignment()->setWrapText(true);
        $objPHPExcel->getActiveSheet()->getStyle('W'.$rowCount)->applyFromArray($styleArray1);
        $objPHPExcel->getActiveSheet()->getStyle('X'.$rowCount)->getAlignment()->setWrapText(true);
        $objPHPExcel->getActiveSheet()->getStyle('X'.$rowCount)->applyFromArray($styleArray1);
        $objPHPExcel->getActiveSheet()->getStyle('Y'.$rowCount)->getAlignment()->setWrapText(true);
        $objPHPExcel->getActiveSheet()->getStyle('Y'.$rowCount)->applyFromArray($styleArray1);
        $objPHPExcel->getActiveSheet()->getStyle('Z'.$rowCount)->getAlignment()->setWrapText(true);
        $objPHPExcel->getActiveSheet()->getStyle('Z'.$rowCount)->applyFromArray($styleArray1);
        
        $rowCount++; 
		$kt++;
	}
    
    
    $objPHPExcel->getActiveSheet()->getStyle("A1:Z1")->getFont()->setBold(true); 
    $objPHPExcel->getActiveSheet()->getStyle('A1:Z1')->applyFromArray($styleArray);
    
    
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(6);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(16);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(32);
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(32);
    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);
    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(18);
    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20); 
    $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(28);
    $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(28);
    $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(24);
    $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(25);
    $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(15);
    $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(17);
    $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(17);
    $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(17);
    $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(17);
    $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(17);
    $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(25);
    $objPHPExcel->setActiveSheetIndex(0);
    
    
    
    // this will remain same
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');   
    
    $objWriter->save($filename);
    $date = date('Y-m-d H:i:s');
    $subject = "Compliance Report - $c_name - $date";
    $message = "As requested please find the attached file.";
    $mailSend = eventListMail($email, $subject, $message, $filename);
    updateRequeststatusCompleted($rowid);
    unlink($filename);
}	
?>