<?php
function get_company_compliances_details_for_golive_cron_by_company_id_and_act_id222( $company, $act_id, $livedate ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "SELECT DISTINCT `compliance`.`due_date` as pattern, `company_compliance`.`act_id`, `company_compliance`.`compliance_id`, `company_compliance`.`fpr_id`, `company_compliance`.`appr_id`, `company_compliance`.`hod_id`, `company_compliance`.`department`, `company_compliance`.`location`, `company_compliance`.`live_date`, `compliance`.`expiry_date`, `compliance`.`periodicity` FROM `company_compliance` INNER JOIN (SELECT `due_date`, `id`, `periodicity`, `criticality`, `expiry_date` FROM `compliance`)`compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` where company_compliance.company_id =? and company_compliance.act_id=? and (compliance.due_date like '%-*-%' or compliance.due_date like '%-1/4-%' or compliance.due_date like '%-1/4-*' or  compliance.due_date like '%-1/2-%' or  compliance.due_date like '%-%-*' or compliance.due_date like '%-1/2-*' or compliance.due_date like '%-1/6-%' or  compliance.due_date like '%-1/12-%' or compliance.due_date like '%-1/3-%') and company_compliance.status!='2' and company_compliance.status!='7' and `company_compliance`.`live_date`=? and `company_compliance`.`cycle_id`=0" ); 
    $query->bindValue( 1, $company );
	$query->bindValue( 2, $act_id );
	$query->bindValue( 3, $livedate );
    $query->execute();
	$result = $query->fetchAll();
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}


function insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $compliance_id, $act_id, $company_id, $fpr_id, $hod_id, $appr_id, $due_date, $trigr_days, $status, $live_date,$base_due_date ){
	$dbh = connect_db();  
	try {	
	    $status_fpr = "Pending at FPR";
	    $query = $dbh->prepare( "INSERT INTO `company_compliance` (company_id, act_id, compliance_id, triggerdays, due_date, status_fpr, fpr_id, hod_id, appr_id, department, location, status, live_date,base_due_date) SELECT * FROM (SELECT '$company_id' As company_id, '$act_id' As act_id, '$compliance_id' As compliance_id, '$trigr_days' As triggerdays, '$due_date' As due_date , '$status_fpr' As status_fpr, '$fpr_id' AS fpr_id, '$hod_id' As hod_id, '$appr_id' As appr_id, '$department' As department, '$location' As location, '$status' As status, '$live_date' as live_date , '$base_due_date' as base_due_date) AS tmp WHERE NOT EXISTS ( SELECT company_id, act_id, compliance_id, triggerdays, due_date, status_fpr, fpr_id, hod_id, appr_id, department, location, status, live_date FROM `company_compliance` WHERE company_id = '$company_id' and act_id='$act_id' and compliance_id='$compliance_id' and due_date='$due_date' and fpr_id='$fpr_id' and hod_id='$hod_id' and appr_id='$appr_id' and department='$department' and location='$location' and base_due_date='$base_due_date' ) LIMIT 1" );
        $q = $query->execute();
        $lastId = $dbh->lastInsertId();
        return $lastId;
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

//echo "<table width='100%' border='1'><thead><tr><th bgcolor='Green' style='color:white' colspan='11'>Compliance Set to be Live Status</th></tr><tr><th>Sr. No.</th><th>Live Date</th><th>Compliance ID</th><th>Location</th><th>Department</th><th>FPR</th><th>Approver</th><th>HoD</th><th>Pattern</th><th>Due Date</th><th>Periodicity</th></tr><thead/><tbody>";
$srno = 0;

$cc_ompliances = get_company_compliances_details_for_golive_cron_by_company_id_and_act_id222( $company_id, $act_id, $live_date );
foreach($cc_ompliances as $ccompliance){
    $compliance = get_compliance_by_id( $ccompliance['compliance_id'] );
    // edit start //
    $comp_id = $ccompliance['compliance_id'];
    $pattern = $ccompliance['pattern'];
	$location = $ccompliance['location'];
	$department = $ccompliance['department'];
	$fpr = $ccompliance['fpr_id'];
	$hod = $ccompliance['hod_id'];
	$appp = $ccompliance['appr_id'];
	$expiry_date = $ccompliance['expiry_date'];
		
    $min_date= date('Y-m-d', strtotime($live_date. ' + 5 days'));
    if (strpos($pattern, '-*-') !== false) {
		$qut_time = strtotime($min_date);
		$qut_date = date("Y-m-d", strtotime("-1 month", $qut_time));
	} elseif (strpos($pattern, '-1/4-') !== false) {
		$qut_time = strtotime($min_date);
		$qut_date = date("Y-m-d", strtotime("-3 month", $qut_time));
	} elseif (strpos($pattern, '-1/2-') !== false){
		$qut_time = strtotime($min_date);
		$qut_date = date("Y-m-d", strtotime("-6 month", $qut_time));
	} elseif (strpos($pattern, '-1/6-') !== false){
		$qut_time = strtotime($min_date);
		$qut_date = date("Y-m-d", strtotime("-2 month", $qut_time));
	} elseif (strpos($pattern, '-1/12-') !== false){
		$qut_time = strtotime($min_date);
		$qut_date = date("Y-m-d", strtotime("-1 month", $qut_time));
	} elseif (strpos($pattern, '-1/3-') !== false){
		$qut_time = strtotime($min_date);
		$qut_date = date("Y-m-d", strtotime("-4 month", $qut_time));
	} else {
		$qut_date = $min_date; 
	}
    $lddate = $min_date;
    
    if($ccompliance['expiry_date']>$due_date || $ccompliance['expiry_date']==''){
        $el = explode("-", $pattern);
        if(count($el) === 3){
            $elementOne = $el[0];
            $elementTwo = $el[1]; 
            $elementThree = $el[2];
            
            if( $ccompliance['periodicity'] =='Weekly' ){
                if( !is_numeric($elementOne)  && !is_numeric($elementTwo) && !is_numeric($elementThree) ){
            	    if(strtoupper($elementOne) == 'M'){
            		    $mondays = getWeekDay(1, $lddate); // set live date in place of today to get right data
            		    foreach($mondays as $monday){
            		        $extended_test = find_extended_date_actual($comp_id, $monday);
            		        insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $monday );
            		        //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$monday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		    }
                    } else if(strtoupper($elementOne) == 'TU'){
            		    $tuesdays = getWeekDay(2, $lddate); // set live date in place of today to get right data
            		    foreach($tuesdays as $tuesday){
            		        $extended_test = find_extended_date_actual($comp_id, $tuesday);
            		        insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $tuesday );
            		        //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$tuesday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		    }
            		} else if(strtoupper($elementOne) == 'W'){
            		    $wednesdays = getWeekDay(3, $lddate); // set live date in place of today to get right data
            		    foreach($wednesdays as $wednesday){
            		        $extended_test = find_extended_date_actual($comp_id, $wednesday);
            		        insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $wednesday );
            		        //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$wednesday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		    }
            	    } else if(strtoupper($elementOne) == 'TH'){
            		    $thursdays = getWeekDay(4, $lddate); // set live date in place of today to get right data
            		    foreach($thursdays as $thursday){
            		        $extended_test = find_extended_date_actual($comp_id, $thursday);
            		        insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $thursday );
            		        //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$thursdays."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		    }
                    } else if(strtoupper($elementOne) == 'F'){
            		    $fridays = getFirstWeekDay(5, $lddate); // set live date in place of today to get right data
            		    foreach($fridays as $friday){
            		        $extended_test = find_extended_date_actual($comp_id, $friday);
            		        insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $friday );
            		        //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$friday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		    }
            		} else if(strtoupper($elementOne) == 'SA'){
            		    $saturdays = getWeekDay(6, $lddate); // set live date in place of today to get right data
            		    foreach($saturdays as $saturday){
            		        $extended_test = find_extended_date_actual($comp_id, $saturday);
            		        insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $saturday );
            		        //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$saturday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		    }
            	    } else if(strtoupper($elementOne) == 'SU'){
            		    $sundays = getWeekDay(7, $lddate); // set live date in place of today to get right data
            		    foreach($sundays as $sunday){
            		        $extended_test = find_extended_date_actual($comp_id, $sunday);
            		        insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $sunday );
            		        //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$sunday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		    }
            		}
                } else {
                    $next_date = getTriggerDateEx($pattern, $lddate);
                	if($next_date!=""){
                	    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		    insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $next_date );
                        //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                    	$date = strtotime($next_date);
                	} else {
                	    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                	}
            	}
            } else {
                $num_term = 24;
                $y = 1;
                $month_sched = date('Y-m-d', strtotime($lddate));
                $num = 1;
                while($y <= $num_term){
                    $month_line_last = strtotime($month_sched);
                	$month_int = date("m", $month_line_last);
                	$year_int = date("Y", $month_line_last);
                	$dateToBePassed = date('Y-m-d', $month_line_last);
                	$dd = strtotime($dateToBePassed);
                	$day 	= date("d", $dd);
                	$month 	= date("m", $dd);
                	$year 	= date("Y", $dd);
                	// echo $dateToBePassed;
                	// echo $month_int;
                	
                	if($elementTwo == "1/4"){
                	    if($month_int == 3 || $month_int == 6 || $month_int == 9 || $month_int == 12){
                		    if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                			    $next_date = getTriggerDateEx($pattern, $dateToBePassed);
                				if($next_date!=""){
                				    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $next_date );
                        		    //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                        			$date = strtotime($next_date);
                    			} else {
                    			    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                    			}
                			}
                		}
                	} else if($elementTwo == "1/2"){
                	    if($month_int == 6 || $month_int == 12){
                		    if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                			    $next_date = getTriggerDateEx($pattern, $dateToBePassed);
                				if($next_date!=""){
                				    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $next_date );
                        		    //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                        			$date = strtotime($next_date);
                    			} else {
                    			   //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                    			}
                			}
                		}
                	} else if($elementTwo == "*"){
                	    if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                		    $next_date = getTriggerDateEx($pattern, $dateToBePassed);
                			if($next_date!=""){
                			    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		            insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $next_date );
                    		    //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                    			$date = strtotime($next_date);
                			} else {
                			    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                		    }
                		}
                	} else if(is_numeric($elementTwo) && !is_numeric($elementThree)){		
                	    if($month_int == $elementTwo){
                		    if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                			    $next_date = getTriggerDateEx($pattern, $dateToBePassed);
                				if($next_date!=""){
                				    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $next_date );
                        		    //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                        			$date = strtotime($next_date);
                    			} else {
                    			   //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                    			}
                			}
                		}
                	} else if( is_numeric($elementTwo) && is_numeric($elementThree) && !is_numeric($elementOne) ){		
                	    if($month_int == $elementTwo && $year_int == $elementThree){
                		    if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                				$next_date = getTriggerDateEx($pattern, $dateToBePassed);
                				if($next_date!=""){
                				    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $next_date );
                            		//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                            		//exit();
                            	} else {
                        		    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                        		}
                			}
                		}
                	} else if( is_numeric($elementOne) && is_numeric($elementTwo) && is_numeric($elementThree) ){
                		if(strtotime($pattern)>strtotime($lddate)){
                			if($month_int == $elementTwo && $year_int == $elementThree){
                				if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                					$next_date = getTriggerDateEx($pattern, $dateToBePassed);
                					if($next_date!=""){
                					    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                    insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $next_date );
                            			//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                            			//exit();
                            		} else {
                        				//echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                        			}
                				}
                			}
                		} else {
                			//echo $ccompliance['compliance_id']." is an expired compliance, cannot generate compliance";
                			//exit();
                		}
                	} else {
                		if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                			$next_date = getTriggerDateEx($pattern, $dateToBePassed);
                			if($next_date!=""){
                			    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		            insert_into_company_compliance_with_date_and_status_for_go_live_cron333($location, $department, $comp_id, $act_id, $company_id, $fpr, $hod, $appp, $extended_test, '10', '1', $live_date, $next_date );
                    			//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                    			$date = strtotime($next_date);
                			} else {
                			    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                			}
                		}
                	}
                	$month_sched = date("Y-m-d",strtotime($month_sched." +1month"));
                	$y++;
                }
            }
        } else {
            //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>"; 
        }
    }
}
//echo "</tbody></table>";
?>
