<?php
include('include/header.php');
error_reporting(0);
function find_extended_date($compliance_id,$date) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select * from extended_date where compliance_id=? and actual_due_date=? order by new_date desc limit 1" );
    $query->bindValue(1, $compliance_id );
    $query->bindValue(2, $date );
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result['new_date'];
    
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function array_flatten($array) { 
  if (!is_array($array)) { 
    return FALSE; 
  } 
  $result = array(); 
  foreach ($array as $key => $value) { 
    if (is_array($value)) { 
      $result = array_merge($result, array_flatten($value)); 
    } 
    else { 
      $result[$key] = $value; 
    } 
  } 
  return array_filter($result); 
}

function find_extended_date_actual($compliance_id,$date)
{
	$vall=find_extended_date($compliance_id,$date);
	if($vall!='')
	{
		
	return $vall;
	}
	else
	{
		return $date;
	}
	
}
if(isset($_REQUEST['setLive'])){
    $act_id = $_REQUEST['act']; 
    $company_id = $_SESSION['company_id'];
    $live_date = $_REQUEST['live_date'];  
    $temp_date =  date('Y-m-d');
    
    function get_lcomp_expiry_by_sr( $sr ) {
        $dbh = connect_db();
        try {
            $query = $dbh->prepare( "select expiry_date from compliance inner join company_compliance on company_compliance.compliance_id=compliance.id where company_compliance.sr=?" );
            $query->bindValue( 1, $sr );
            $query->execute();
            $result = $query->fetch(PDO::FETCH_ASSOC);
            return $result['expiry_date'];
        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

function update_golive_singal_with_live_date($sr, $due, $live_date, $base_due_date){
	$dbh = connect_db();
	try {
		$check_exco=get_lcomp_expiry_by_sr( $sr );
		if(($due>=$live_date || $due=='') && ($due<$check_exco || $check_exco=='')){
    		$query = $dbh->prepare('UPDATE `company_compliance` SET `status`=?, `due_date`=?, `live_date`=?, base_due_date=? WHERE `sr`=?');
    		$query->bindValue(1, '1');
    		$query->bindValue(2, $due);
    		$query->bindValue(3, $live_date);
    		$query->bindValue(4, $base_due_date);
    		$query->bindValue(5, $sr);
    		$query->execute();
		    if($query->fetchAll()) { 
		        $result = 'update';
		    } else { 
		        $result='Notupdate';
		    }
		}
		return $result;			
	} catch (Exception $e) {
        return $e->getMessage();
	}
}

function update_golive_singal_with_live_date_due($sr, $due, $live_date,$base_due_date){
	$dbh = connect_db();
	try {
		$check_exco=get_lcomp_expiry_by_sr( $sr );
		if(($due>=$live_date || $due=='') && ($due<$check_exco || $check_exco=='')){
		$query = $dbh->prepare('UPDATE `company_compliance` SET `status`=?, `due_date`=?, `live_date`=?,base_due_date=?,triggerdays=10 where `sr`=?');
		$query->bindValue(1, '10');
		$query->bindValue(2, $due);
		$query->bindValue(3, $live_date);
		$query->bindValue(4, $base_due_date); 
		$query->bindValue(5, $sr);
		$query->execute();
		if($query->fetchAll()) { $result = 'update';} else { $result='Notupdate';}
			return $result;		
		}	
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function update_golive_singal_with_live_date_er($sr, $due, $live_date,$base_due_date)
	{
	$dbh = connect_db();
	try {
		$check_exco=get_lcomp_expiry_by_sr( $sr );
		if(($due>=$live_date || $due=='') && ($due<$check_exco || $check_exco==''))
		{
		$query = $dbh->prepare('UPDATE `company_compliance` SET `status`=?, `due_date`=?, `live_date`=?,base_due_date=? where `sr`=?');
		$query->bindValue(1, '10');
		$query->bindValue(2, $due);
		$query->bindValue(3, $live_date);
		$query->bindValue(4, $base_due_date);
		$query->bindValue(5, $sr);
		$query->execute();
		if($query->fetchAll()) { $result = 'update';} else { $result='Notupdate';}
		}
		
		return $result;			
	}
	catch (Exception $e) {
    return $e->getMessage();
	}
}

function get_location_by_compay_compl_fpr( $company, $email ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select * from company_compliance where company_id=? and fpr_id=?" );
    $query->bindValue( 1, $company );
	$query->bindValue( 2, $email );
    $query->execute();
	//$result = $query->fetchAll();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function get_location_by_compay_compl_hod( $company, $email ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select * from company_compliance where company_id=? and hod_id=?" );
    $query->bindValue( 1, $company );
	$query->bindValue( 2, $email );
    $query->execute();
	//$result = $query->fetchAll();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}
function get_location_by_compay_compl_appr( $company, $email ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "select * from company_compliance where company_id=? and appr_id=?" );
    $query->bindValue( 1, $company );
	$query->bindValue( 2, $email );
    $query->execute();
	//$result = $query->fetchAll();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function delete_company_compliance_by_sr( $sr ) {
  $dbh = connect_db();
  try {
    $query = $dbh->prepare( "DELETE from company_compliance where sr=?" );
    $query->bindValue( 1, $sr );
    $query->execute();
    return true;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function delete_company_compliance_by_compl_compy_2( $act ) {
	$company_id=$_SESSION['company_id'];
	$dbh = connect_db();
  try {
    $query = $dbh->prepare( "DELETE from company_compliance where `company_id`=$company_id AND `act_id` = $act AND `status` = 2" );
    $query->execute();
    return true;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function update_company_compliance_by_compl_compy_2( $act ) {
	$company_id=$_SESSION['company_id'];
	$dbh = connect_db();
  try {
    $query = $dbh->prepare( "UPDATE `company_compliance` SET `status`=1 where `status`=10 AND `live_date` != '' AND `company_id` = $company_id AND `act_id` = $act" );
    $query->execute();
    return true;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}

function insertGoLiveHistory($act_id, $live_date, $count){
    $company_id = $_SESSION['company_id'];
    $dbh = connect_db();
    try {
        $query = $dbh->prepare("INSERT INTO `go_live_history` (`company_id`, `act_id`, `live_date`, `num_compls`) VALUES ('$company_id', '$act_id', '$live_date', '$count')");
    	$query->execute();
    } catch (Exception $e) {
        echo $e->getMessage();
    }
}


function get_number_of_one_time_company_compliances_by_sr($sr){
    $ccdetailsdf=get_comapny_compliance_by_sr($sr);
	$company_id=$_SESSION['company_id'];
	$dbh = connect_db();
  try {
    $query = $dbh->prepare( "select count(*) as nums from company_compliance where company_id=? and fpr_id=? and appr_id=? and hod_id=? and act_id=? and compliance_id=? and department=? and location=?" );
    $query->bindValue( 1, $company_id );
    $query->bindValue( 2, $ccdetailsdf['fpr_id'] );
    $query->bindValue( 3, $ccdetailsdf['appr_id'] );
    $query->bindValue( 4, $ccdetailsdf['hod_id'] );
    $query->bindValue( 5, $ccdetailsdf['act_id'] );
    $query->bindValue( 6, $ccdetailsdf['compliance_id'] );
    $query->bindValue( 7, $ccdetailsdf['department'] );
    $query->bindValue( 8, $ccdetailsdf['location'] );
    $query->execute();
	//$result = $query->fetchAll();
    $result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  }
}	
function get_draft_go_live_by_act_id_and_company_id56( $act_id, $company_id, $lddate ){
	$emails_e = email_to_deactive_for_company_compliance_2();
	$dbh = connect_db();
  try {
    $query = $dbh->prepare( "SELECT `compliance`.`periodicity` as `periodicity`, `compliance`.`expiry_date` as `expiry_date`, `company_compliance`.`compliance_id` as `compliance_id`, `company_compliance`.`fpr_id` as `fpr_id`, `company_compliance`.`hod_id` as `hod_id`, `company_compliance`.`appr_id` as `appr_id`, `company_compliance`.`sr` as `sr`, `company_compliance`.`location`, `company_compliance`.`department` FROM `company_compliance` INNER JOIN `compliance` on `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`act_id`=?  and (`compliance`.`expiry_date`='' OR `compliance`.`expiry_date`>'$lddate') and `company_compliance`.`company_id`=? and `company_compliance`.`status`='2' AND $emails_e" ); 
    $query->bindValue( 1, $act_id );
	$query->bindValue( 2, $company_id ); 
    $query->execute(); 
	$result = $query->fetchAll();
    //$result = $query->fetch(PDO::FETCH_ASSOC);
    return $result;
  } catch (Exception $e) {
    return $e->getMessage();
  } 
}



function getDepartmentLocationforRole($user, $role, $companyid){
	if($role == 'Fpr'){
		$check = " AND `fpr_id`='$user'";
	} else if($role == 'Approver'){
		$check = " AND `appr_id`='$user'";
	} else if($role == 'Hod'){
		$check = " AND `hod_id`='$user'";
	}
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT `department`, `location` FROM `company_compliance` WHERE `company_id`=? AND `department`!='' AND `location`!='' $check LIMIT 1" );
		$query->bindValue( 1, $companyid );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (PDOException $e) {
		return $e->getMessage();
	}
}

function checkUserExists( $email ) {
	$dbh = connect_db();
	$fEmail = strtoupper($email);
	try {
		$query = $dbh->prepare( "SELECT * FROM `user` WHERE UPPER(`email`)=?" );
		$query->bindValue( 1, $email );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_NUM);
		return $result;
	} catch (PDOException $e) {
		return $e->getMessage();
	}
}

function CheckUserRole($companyid, $user, $role){
	$dbh = connect_db();
	$user = get_user_by_email($user);
	try{	
		$query = $dbh->prepare("SELECT * FROM `user_role` WHERE `Company_id`=?  AND `user_id`=? AND `user_role`=?" );
		$query->bindValue( 1, $companyid );
		$query->bindValue( 2, $user['user_id']);
		$query->bindValue( 3, $role);
		$query->execute();
		$result = $query->fetch(PDO::FETCH_NUM);
		return $result;
	} catch (PDOException $e){
		return $e->getMessage();
	}
}

function getCompanyEventOngoingDetails(){
    $companyid = $_SESSION['company_id'];
    $dbh = connect_db();
	try{	
		$query = $dbh->prepare("SELECT * FROM `CompanyEventOngoing` WHERE `company_id`=? AND `status`=?" );
		$query->bindValue( 1, $companyid );
		$query->bindValue( 2, 1 );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (PDOException $e){
		return $e->getMessage();
	} 
}

function checkEventCompliance($company_id,$fpr,$appr,$due_date){
    $dbh = connect_db();
    try {
        $query = $dbh->prepare("select count(cc.sr) as count from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%event%'   and cc.`company_id`=? and cc.`cycle_id`='0' and cc.fpr_id=? and cc.appr_id=?  and str_to_date(cc.live_date, '%Y-%m-%d')<str_to_date(?, '%Y-%m-%d') and (str_to_date(c.expiry_date, '%Y-%m-%d')>str_to_date(?, '%Y-%m-%d') or c.expiry_date='')");
	    $query->bindValue( 1, $company_id );		
	    $query->bindValue( 2, $fpr );	
	    $query->bindValue( 3, $appr );		
	    $query->bindValue( 4, $due_date );	
	    $query->bindValue( 5, $due_date );	
        $query->execute();
	    $result = $query->fetch(PDO::FETCH_ASSOC);
        return $result['count'];
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function checkOngoingCompliance($company_id,$fpr,$appr,$hod,$loc,$dep,$due_date){
    $dbh = connect_db();
    try {
        $query = $dbh->prepare("select count(cc.sr) as count from `compliance` c inner join `company_compliance` cc on c.`id`=cc.`compliance_id` where c.`periodicity` like '%going%'   and cc.`company_id`=? and cc.`cycle_id`='0' and cc.fpr_id=? and cc.appr_id=? and cc.hod_id=? and cc.location=? and cc.department=? and str_to_date(cc.live_date, '%Y-%m-%d')<str_to_date(?, '%Y-%m-%d') and (str_to_date(c.expiry_date, '%Y-%m-%d')>str_to_date(?, '%Y-%m-%d') or c.expiry_date='')");
	    $query->bindValue( 1, $company_id );		
	    $query->bindValue( 2, $fpr );	
	    $query->bindValue( 3, $appr );
	    $query->bindValue( 4, $hod );	
	    $query->bindValue( 5, $loc );
	    $query->bindValue( 6, $dep );
	    $query->bindValue( 7, $due_date );	
	    $query->bindValue( 8, $due_date );	
        $query->execute();
	    $result = $query->fetch(PDO::FETCH_ASSOC);
        return $result['count'];
    } catch (Exception $e) {
        return $e->getMessage();
    }
}

function checkCycleExistOnging($act_id, $compliance_id, $fpr, $approver, $hod, $department, $location, $duedate){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=? AND `due_date`=? AND `act_id`=? AND `compliance_id`=? AND `status`!=?" );
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $approver);
		$query->bindValue(3, $hod);
		$query->bindValue(4, $location);
		$query->bindValue(5, $department);
		$query->bindValue(6, $company_id);
		$query->bindValue(7, $duedate);
		$query->bindValue(8, $act_id);
		$query->bindValue(9, $compliance_id);
		$query->bindValue(10, 7);
		$query->execute();
		$result = $query->fetchAll();
		if(count($result)>=1){
			return 1;
		} else {
			return 0;	
		}
	} catch(PDOException $e){
		return $e->getMessage();
	}								
}

function checkCycleEventinsert($act_id, $compliance_id, $fpr, $approver, $duedate){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT * FROM `company_compliance` WHERE `fpr_id`=? AND `appr_id`=? AND `company_id`=? AND `due_date`=? AND `act_id`=? AND `compliance_id`=? AND `status`!=?" );
		$query->bindValue(1, $fpr);
		$query->bindValue(2, $approver);
		$query->bindValue(3, $company_id);
		$query->bindValue(4, $duedate);
		$query->bindValue(5, $act_id);
		$query->bindValue(6, $compliance_id);
		$query->bindValue(7, 7);
		$query->execute();
		$result = $query->fetchAll();
		if(count($result)>=1){
			return 1;
		} else {
			return 0;	
		}
	} catch(PDOException $e){
		return $e->getMessage();
	}								
}


function insertOngoingCycle($act_id, $compliance_id, $company_id, $department, $location, $fpr_id, $appr_id, $hod_id, $triggerdays, $due_date){
    $dbh = connect_db();
    try {
        $query = $dbh->prepare("INSERT INTO `company_compliance` (`company_id`, `act_id`, `compliance_id`,`department`, `location`, `triggerdays`, `due_date`, `fpr_id`, `appr_id`, `hod_id`) SELECT * FROM (SELECT '$company_id' As company_id, '$act_id' As act_id, '$compliance_id' As compliance_id, '$department' As department, '$location' As location, '$triggerdays' As triggerdays , '$due_date' As due_date, '$fpr_id' AS fpr_id, '$appr_id' As appr_id, '$hod_id' As hod_id) AS tmp WHERE NOT EXISTS ( SELECT * FROM `company_compliance` WHERE due_date = '$due_date' and fpr_id='$fpr_id' and act_id='$act_id' and company_id='$company_id' and appr_id='$appr_id' and hod_id='$hod_id' and department='$department' and  location='$location' ) LIMIT 1");
        $query->execute();
	} catch (PDOException $e) {
        $act_id.'='.$e->getMessage();
    }
}

function updateStatusCompliance($sr, $company_id, $complianceid){
    $dbh = connect_db();
    try {
        $query = $dbh->prepare( "UPDATE `company_compliance` SET `status`=1 WHERE (`status`=2 OR `status`=10) AND `live_date` != '' AND `company_id` = $company_id AND `sr` = $sr AND `compliance_id`=$complianceid" );
        $query->execute();
        return true;
    } catch (Exception $e) {
        return $e->getMessage();
    } 
}

function getWeekDay($day, $livdate){ // get all the weekdays for weekly compliances
    $weekDay = array();
    $num_term = 24;
    $y = 1;
    $month_sched = date('Y-m-d', strtotime($livdate));
    $num = 1;
    while($y <= $num_term){
    	$month_line_last = strtotime($month_sched);
    	$month_int = date("m", $month_line_last);
    	$year_int = date("Y", $month_line_last);
    	if($y == 1){
    	    $startDate = date('Y-m-d', $month_line_last); // Start from the Live Date
    	} else {
    	    $startDate = date('Y-m-01', $month_line_last); // Start from the first day of the current month
    	}
        $endDate = date('Y-m-t', $month_line_last); // Get the last day of the current month
        
        $currentDate = $startDate;
        while ($currentDate <= $endDate) {
            $dayOfWeek = date('N', strtotime($currentDate)); // Get the day of the week (1 = Monday, 7 = Sunday)
            if ($dayOfWeek == $day) { // 4 represents Thursday
                $weekDay[] = $currentDate;
            }
            $currentDate = date('Y-m-d', strtotime('+1 day', strtotime($currentDate)));
        }
        $month_sched = date("Y-m-d",strtotime($month_sched." +1month"));
        $y++;
    }
    return $weekDay;
}

function getFirstWeekDay($day, $livdate){ // get all the weekdays for weekly compliances
    $weekDay = array();
    $num_term = 1;
    $y = 1;
    $month_sched = date('Y-m-d', strtotime($livdate));
    $num = 1;
    while($y <= $num_term){
    	$month_line_last = strtotime($month_sched);
    	$month_int = date("m", $month_line_last);
    	$year_int = date("Y", $month_line_last);
    	if($y == 1){
    	    $startDate = date('Y-m-d', $month_line_last); // Start from the Live Date
    	} else {
    	    $startDate = date('Y-m-01', $month_line_last); // Start from the first day of the current month
    	}
        $endDate = date('Y-m-t', $month_line_last); // Get the last day of the current month
        $m = 1;
        $currentDate = $startDate;
        while ($currentDate <= $endDate) {
            $dayOfWeek = date('N', strtotime($currentDate)); // Get the day of the week (1 = Monday, 7 = Sunday)
            if ($dayOfWeek == $day) { // 4 represents Thursday
                if($m == 1){
                    $weekDay = $currentDate;
                } else {
                    
                }
                $m++;
            }
            $currentDate = date('Y-m-d', strtotime('+1 day', strtotime($currentDate)));
        }
        $month_sched = date("Y-m-d",strtotime($month_sched." +1month"));
        $y++;
    }
    return $weekDay;
}

function getTriggerDateEx($pattern, $date){
	// < After
	// > Before
	// $ End
	// $-*-*		24-11-2015	30-11-2015	Last day of Month
	// 31-01-*		24-11-2015	31-01-2016	Given date and month every year
	// 31-*-*		24-11-2015	31-01-2016	Given date/month every year
	// *-1/4-*		24-11-2015	31-12-2015	Every Quarter
	// <20-1/4-*	10-01-2015	20-04-2015	20 Day After Every Quarter
	// >20-1/4-*	10-01-2016	11-03-2015	20 Day Before Every Quarter
	// 23-*-*		24-11-2015	23-12-2015	23rd of Every Month
	// <23-*-*		25-11-2015	18-12-2015	23 Day After
	// $-1/4-*		24-11-2015	31-12-2015	End of Quarter
	// 21-1/4-*		24-11-2015	21-12-2015	Given Date of Every Quarter
	// 30-09-2020	30-09-2020				Exact Due Date Given
	// <15-1/2-* 							15 Days after every 6 months
	// $pattern = trim($pattern);
	// pattern exploding and getting parts of pattern
	$result = "";
	$elementOne = "";
	$elementTwo = ""; 
	$elementThree = "";	
	if($pattern == '' || $pattern == '-' || $pattern == '_'){
		$time	= strtotime($date);
		$res = date("Y-m-d", $time);
		$due_date =  date('Y-m-d', strtotime($res. ' + 7 days'));
		$dat = $due_date;
		$result = $dat;
	} else if(!empty($pattern) || $pattern != '-' || $pattern != '_'){
		$el = explode("-", $pattern);
		if(count($el) === 3){
    		$elementOne = $el[0];
    		$elementTwo = $el[1]; 
    		$elementThree = $el[2];	
    		// getting date parameter passed as argument
    		$mod 	= date("d-m-Y", strtotime($date));
    		
    		if( is_numeric($elementOne) && is_numeric($elementTwo) && is_numeric($elementThree) ){
    		    // 23-05-2020
    			$t	= $pattern;
    			$time	= strtotime($t);
    		} else if( is_numeric($elementOne) && is_numeric($elementTwo) && !is_numeric($elementThree) ){
    		    // 23-05-*
    			$t	= strtotime($date);
    			$y 	= date("Y", $t);
    			$mkDate = $y."-".$elementTwo."-".$elementOne;
    			$time	= strtotime($mkDate);
    		} else if( !is_numeric($elementOne) && $elementTwo == '*' && $elementThree == '*' ){
    		    // $/*-*-*
    			$time	= strtotime($date);
    		}  else if(!is_numeric($elementOne) && is_numeric($elementTwo) && !is_numeric($elementThree) ){
    		    // */$-<20/20>-05-*
    		    if($elementTwo == 1/4 || $elementTwo == 1/6 || $elementTwo == 1/2){
    		        $time	= strtotime($date);
    		    } else {
    			    $t	= strtotime($date);
        			$y 	= date("Y", $t);
        			$d 	= date("d", $t);
        			$mkDate = $y."-".$elementTwo."-".$d;
        			$time	= strtotime($mkDate);
    		    }
    		} else if(is_numeric($elementOne) && $elementThree == '*' && !is_numeric($elementTwo) ){
    // 			echo " 5 I am here";
    			$t	= strtotime($date);
    			$y 	= date("Y", $t);
    			$m 	= date("m", $t);
    			$mkDate = $y."-".$m."-".$elementOne;
    			$time	= strtotime($mkDate);
    		} else if(is_numeric($elementThree) && is_numeric($elementTwo)) {
    // 			echo " 6 I am here";
    			$t	= strtotime($date);
    			$d 	= date("d", $t);
    			$mkDate = $elementThree."-".$elementTwo."-".$d;
    			$time	= strtotime($mkDate);
    		} else if(is_numeric($elementTwo) && !is_numeric($elementThree)) {
    // 			echo " 7 I am here";
    			$t	= strtotime($date);
    			$m 	= date("m", $t);
    			$d 	= date("d", $t);
    			$mkDate = $elementThree."-".$m."-".$d;
    			$time	= strtotime($mkDate);
    		} else {
    			$time	= strtotime($date);
    		}
    		
    		$day 	= date("d", $time);
    		$month 	= date("m", $time);
    		$year 	= date("Y", $time);
    		
    		// echo $day." - ".$month." - ".$year."<br/>";
    		
    		
    		// exploding time;
    		$val = date("d-m-Y", $time);
    		$b = explode('-',$val);
    		
    		$result = "";
    		if( substr( $elementOne, 0, 1 ) == "<" ) {
    			$getElement = explode("<", $elementOne);
    			$finalElement = $getElement[1];
    			if($elementTwo=='1/2'){
    				if($month>=1 && $month<=6){
    					$mon = 6-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."+".$finalElement." days"));
    					}
    				}
    				if($b[1]>6 && $b[1]<=12){
    					$mon = 12-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."+".$finalElement." days"));
    					}
    				}
    			} else if($elementTwo=='1/4'){
    				if($month>=1 && $month<=3){
    					$mon = 3-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."+".$finalElement." days"));
    					}
    				}
    				if($b[1]>3 && $b[1]<=6){
    					$mon = 6-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."+".$finalElement." days"));
    					}
    				}
    				if($b[1]>6 && $b[1]<=9){
    					$mon = 9-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."+".$finalElement." days"));
    					}
    				}
    				if($b[1]>9 && $b[1]<=12){
    					$mon = 12-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."+".$finalElement." days"));
    					}
    				}
    			} else if($elementTwo=='*' && $elementThree=='*'){
    			    $res = date("d-m-Y",$time);
    			    if(!is_numeric($finalElement)){
    				    $dat = $res;
    				} else {
    			        $dat = date("Y-m-d", strtotime($res."+".$finalElement." days"));
    				}
    				$result = $dat;
    			} else {
    				$res = date($elementOne."-".$elementTwo."-Y",$time);
    				if(!is_numeric($finalElement)){
    				    $dat = $res;
    				} else {
    			        $dat = date("Y-m-d", strtotime($res."+".$finalElement." days"));
    				}
    				$result = $dat;
    			}
    		} else if( substr( $elementOne, 0, 1 ) == ">" ){
    			$getElement = explode(">", $elementOne);
    			$finalElement = $getElement[1];
    			if($elementTwo=='1/2'){
    				if($month>=1 && $month<=6){
    					$mon = 6-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."-".$finalElement." days"));
    					}
    				}
    				if($b[1]>6 && $b[1]<=12){
    					$mon = 12-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."-".$finalElement." days"));
    					}
    				}
    			} else if($elementTwo=='1/4'){
    				if($month>=1 && $month<=3){
    					$mon = 3-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."-".$finalElement." days"));
    					}
    				}
    				if($b[1]>3 && $b[1]<=6){
    					$mon = 6-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."-".$finalElement." days"));
    					}
    				}
    				if($b[1]>6 && $b[1]<=9){
    					$mon = 9-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."-".$finalElement." days"));
    					}
    				}
    				if($b[1]>9 && $b[1]<=12){
    					$mon = 12-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					if(!is_numeric($finalElement)){
    					    $result = $res;
    					} else {
    					    $result = date("Y-m-d", strtotime($res."-".$finalElement." days"));
    					}
    				}
    			} else {
    				$res = date($elementOne."-".$elementTwo."-Y",$time);
    				if(!is_numeric($finalElement)){
    				    $dat = $res;
    				} else {
    			        $dat = date("Y-m-d", strtotime($res."+".$finalElement." days"));
    				}
    				$result = $dat;
    			}
    		} else if($elementOne == '$'){
    			if($elementTwo=='1/2'){
    				if($month>=1 && $month<=6){
    					$mon = 6-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    				if($b[1]>6 && $b[1]<=12){
    					$mon = 12-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    			} else if($elementTwo=='1/4'){
    				if($month>=1 && $month<=3){
    					$mon = 3-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    				if($b[1]>3 && $b[1]<=6){
    					$mon = 6-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    				if($b[1]>6 && $b[1]<=9){
    					$mon = 9-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    				if($b[1]>9 && $b[1]<=12){
    					$mon = 12-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    			} else if( $elementTwo == '*' && $elementThree == '*' ){			
    				// echo "I am here";
    				$res = date("Y-m-t", $time);
    				$resul = strtotime($res);
    				$d	= date("d", $resul);
    				$m 	= date("m", $time);
    				$y 	= date("Y", $time);
    				$dat = date($y."-".$m."-".$d);
    				$result = $dat;
    			} else if( is_numeric($elementTwo) && is_numeric($elementThree) ){
    				$res = date("Y-m-t", $time);
    				$resul = strtotime($res);
    				$d	= date("d", $resul);
    				$m 	= date("m", $time);
    				$y 	= date("Y", $time);
    				$dat = date($d."-".$elementTwo."-".$elementThree);
    				$result = $dat;
    			} else {
    				$dat = date($elementOne."-".$elementTwo."-Y", $time);
    				$result = $dat;
    			}
    		} else if($elementOne == '*'){
    			if($elementTwo=='1/2'){
    				if($month>=1 && $month<=6){
    					$mon = 6-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    				if($b[1]>6 && $b[1]<=12){
    					$mon = 12-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t", $resul);
    					$result = $res;
    				}
    			} else if($elementTwo=='1/4'){
    				if($month>=1 && $month<=3){
    					$mon = 3-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    				if($b[1]>3 && $b[1]<=6){
    					$mon = 6-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    				if($b[1]>6 && $b[1]<=9){
    					$mon = 9-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    				if($b[1]>9 && $b[1]<=12){
    					$mon = 12-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$res = date("Y-m-t",$resul);
    					$result = $res;
    				}
    			} else if( $elementTwo == '*' && $elementThree == '*' ){
    				$res = date("Y-m-t", $time);
    				$resul = strtotime($res);
    				$d	= date("d", $resul);
    				$m 	= date("m", $time);
    				$y 	= date("Y", $time);
    				$dat = date($y."-".$m."-".$d);
    				$result = $dat;
    			} else if( is_numeric($elementTwo) && is_numeric($elementThree) ){
    				$res = date("Y-m-t", $time);
    				$resul = strtotime($res);
    				$d	= date("d", $resul);
    				$m 	= date("m", $time);
    				$y 	= date("Y", $time);
    				$dat = date($d."-".$elementTwo."-".$elementThree);
    				$result = $dat;
    			} else {
    				$dat = date($elementOne."-".$elementTwo."-Y",$time);
    				$result = $dat;
    			}
    		} else {
    			if($elementTwo=='1/2'){
    				if($month>=1 && $month<=6){
    					$mon = 6-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$result = date("Y-m-".$elementOne, $resul);
    				}
    				if($b[1]>6 && $b[1]<=12){
    					$mon = 12-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$result = date("Y-m-".$elementOne, $resul);
    				}
    			} else if($elementTwo=='1/4'){
    				if($month>=1 && $month<=3){
    					$mon = 3-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$result = date("Y-m-".$elementOne, $resul);
    				}
    				if($b[1]>3 && $b[1]<=6){
    					$mon = 6-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$result = date("Y-m-".$elementOne, $resul);
    				}
    				if($b[1]>6 && $b[1]<=9){
    					$mon = 9-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$result = date("Y-m-".$elementOne, $resul);
    				}
    				if($b[1]>9 && $b[1]<=12){
    					$mon = 12-$b[1];
    					$dat = date("d-m-Y",$time);
    					$resul = strtotime(date("d-m-Y", strtotime($dat)). " +$mon month");
    					$result = date("Y-m-".$elementOne, $resul);
    				}
    			} else if( is_numeric($elementOne) && $elementTwo == '*' && $elementThree == '*' ){
    				$res = date("Y-m-d", $time);
    				$result = $res;
    			} else if( is_numeric($elementOne) && is_numeric($elementTwo) && is_numeric($elementThree) ){
    				$res = strtotime($pattern);
    				$due_date =  date('Y-m-d', $res);
    				$result = $due_date;
    			} else {
    				$res = date("Y-m-d", $time);
    				$due_date =  date('Y-m-d', strtotime($res));
    				$result = $due_date;
    			}
    		}
    	} else {
    		$time	= strtotime($date);
    		$res = date("Y-m-d", $time);
    		$due_date =  date('Y-m-d', strtotime($res));
    		$dat = $due_date;
    		$result = $dat;
    	}
    }
    return $result;
}


function getDraftForGolive($requestedAct, $companyID){
	$dbh = connect_db();
	try {
		$query = $dbh->prepare( "SELECT `compliance`.`periodicity` AS `periodicity`, `compliance`.`due_date` AS `pattern`, `compliance`.`expiry_date` AS `expiry_date`, `company_compliance`.`compliance_id` AS `compliance_id`, `company_compliance`.`fpr_id` AS `fpr_id`, `company_compliance`.`hod_id` AS `hod_id`, `company_compliance`.`appr_id` AS `appr_id`, `company_compliance`.`location` AS `location`, `company_compliance`.`department` AS `department`, `company_compliance`.`sr` AS `sr` FROM `company_compliance` INNER JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`act_id`=? AND `company_compliance`.`company_id`=? AND `company_compliance`.`status`='2' AND `company_compliance`.`fpr_id` NOT IN (SELECT DISTINCT(`email`) FROM `deactive_user` WHERE `status` = 1) AND `company_compliance`.`appr_id` NOT IN (SELECT DISTINCT(`email`) FROM `deactive_user` WHERE `status` = 1) AND `company_compliance`.`hod_id` NOT IN (SELECT DISTINCT(`email`) FROM `deactive_user` WHERE `status` = 1)" ); 
		$query->bindValue( 1, $requestedAct );
		$query->bindValue( 2, $companyID ); 
		$query->execute(); 
		$result = $query->fetchAll();
		return $result;
	} catch (PDOException $e) {
		return $e->getMessage();
	}	 
}

if(empty($live_date)){
?>
<div class="modal-dialog modal-sm">
                <div class="modal-content" id="popupcontent">
			<div class="modal-header">
                      <h3 class="modal-title custom-font" id="popuptitle">Oh !!!</h3> 
                    </div>
                    <div class="modal-body" id="popupbody<?=$popupno;?>">
                                    <!-- tile widget -->
                                    <div class="tile-widget p-30 text-center">
									<h4 class="mb-0"><strong>Please Select the Date or Correct Date</h4>
                                     
                                    </div>
                                    <!-- /tile widget -->
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-default btn-border" data-dismiss="modal">Close</button>
                    </div>
				</div>
			</div>
<?php 
} else {
    //echo "<table width='100%' border='1'><thead><tr><th bgcolor='Green' style='color:white' colspan='11'>Compliance Set to be Live Status</th></tr><tr><th>Sr. No.</th><th>Live Date</th><th>Compliance ID</th><th>Location</th><th>Department</th><th>FPR</th><th>Approver</th><th>HoD</th><th>Pattern</th><th>Due Date</th><th>Periodicity</th></tr><thead/><tbody>";
    $srno = 0;
    $ongoingArray = array();
    $eventArray = array();
    $fprArray = array();
    $apprArray = array();
    $hodArray = array();
    $oEDataOld = "";
    $o = 1;
    $e = 1;
    $lddate= date('Y-m-d', strtotime($live_date. ' + 5 days'));
    $cc_ompliances = get_draft_go_live_by_act_id_and_company_id56( $act_id, $company_id, $lddate );
    foreach($cc_ompliances as $ccompliance){
	    $compliance = get_compliance_by_id( $ccompliance['compliance_id'] );
	    // edit start //
	    $comp_id = $ccompliance['compliance_id'];
        $sr = $ccompliance['sr'];
        
        $pattern = $compliance['due_date'];
    	$oEData = $ccompliance['location'].$ccompliance['department'].$ccompliance['fpr_id'].$ccompliance['appr_id'].$ccompliance['hod_id'];
    	$fprArray[] = $ccompliance['fpr_id'];
    	$apprArray[] = $ccompliance['appr_id'];
    	$hodArray[] = $ccompliance['hod_id'];
        
        
        if( $compliance['periodicity'] =='One Time' || strtoupper($compliance['periodicity']) == strtoupper('one time') ){
    		$due_date =  date('Y-m-d', strtotime($live_date. ' + 7 days'));
    		$chkotm = get_number_of_one_time_company_compliances_by_sr($sr);
    		if(isset($chkotm['nums']) and $chkotm['nums']>=2){
    			delete_company_compliance_by_sr($sr);
    		}else{
    		    if($ccompliance['expiry_date']>$due_date || $ccompliance['expiry_date']==''){
    			    $display = update_golive_singal_with_live_date($sr, $due_date, $live_date, $due_date);
    			    //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$due_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
    		    }
    		}
    		
    	}elseif( $compliance['periodicity'] =='event based' || $compliance['periodicity'] =='Event Based'){
    	    if($ccompliance['expiry_date']>$live_date || $ccompliance['expiry_date']==''){
        		$due_date = '';
        		$display = update_golive_singal_with_live_date($sr, $due_date, $live_date, $due_date);
                $next_date = '';
    			//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
    			if($e == 1){
    				$eventArray[] = array('fpr_id'=>$ccompliance['fpr_id'], 'appr_id'=>$ccompliance['appr_id']);
    			} else {
    				if($oEDataOld != $oEData){
    					$eventArray[] = array('fpr_id'=>$ccompliance['fpr_id'], 'appr_id'=>$ccompliance['appr_id']);
    				}
    			}
    			$e++;
    	    }
    	}elseif($compliance['periodicity'] =='on going' || $compliance['periodicity'] =='On Going' || $compliance['periodicity'] =='Ongoing'){
    	    if($ccompliance['expiry_date']>$live_date || $ccompliance['expiry_date']==''){
        		$due_date = '';
        		$display = update_golive_singal_with_live_date_er($sr, $due_date, $live_date, $due_date);
                $next_date = '';
    			//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
    			if($o == 1){
    				$ongoingArray[] = array('fpr_id'=>$ccompliance['fpr_id'], 'appr_id'=>$ccompliance['appr_id'], 'hod_id'=>$ccompliance['hod_id'], 'location'=>$ccompliance['location'], 'department'=>$ccompliance['department']);
    			} else {
    				if($oEDataOld != $oEData){
    					$ongoingArray[] = array('fpr_id'=>$ccompliance['fpr_id'], 'appr_id'=>$ccompliance['appr_id'], 'hod_id'=>$ccompliance['hod_id'], 'location'=>$ccompliance['location'], 'department'=>$ccompliance['department']);
    				}
    			}
    			$o++;
    	    }
    	}else{
    		if($ccompliance['expiry_date']>$lddate || $ccompliance['expiry_date']==''){
        		
        		$el = explode("-", $pattern);
        	    if(count($el) === 3){
                    $elementOne = $el[0];
                	$elementTwo = $el[1]; 
                	$elementThree = $el[2];
            	
            	    if( $ccompliance['periodicity'] =='Weekly' ){
            		    if( !is_numeric($elementOne)  && !is_numeric($elementTwo) && !is_numeric($elementThree) ){
            		        if(strtoupper($elementOne) == 'M'){
            		            $monday = getFirstWeekDay(1, $lddate); // set live date in place of today to get right data\
            		            $extended_test = find_extended_date_actual($comp_id, $monday);
            		            $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $monday);
            		            //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$monday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		        } else if(strtoupper($elementOne) == 'TU'){
            		            $tuesday = getFirstWeekDay(2, $lddate); // set live date in place of today to get right data
            		            $extended_test = find_extended_date_actual($comp_id, $tuesday);
            		            $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $tuesday);
            		            //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$tuesday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		        } else if(strtoupper($elementOne) == 'W'){
            		            $wednesday = getFirstWeekDay(3, $lddate); // set live date in place of today to get right data
            		            $extended_test = find_extended_date_actual($comp_id, $wednesday);
            		            $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $wednesday);
            		            //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$wednesday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		        } else if(strtoupper($elementOne) == 'TH'){
            		            $thursday = getFirstWeekDay(4, $lddate); // set live date in place of today to get right data
            		            $extended_test = find_extended_date_actual($comp_id, $thursday);
            		            $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $thursday);
            		            //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$thursdays."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		        } else if(strtoupper($elementOne) == 'F'){
            		            $friday = getFirstWeekDay(5, $lddate); // set live date in place of today to get right data
            		            $extended_test = find_extended_date_actual($comp_id, $friday);
            		            $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $friday);
            		            //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$friday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		        } else if(strtoupper($elementOne) == 'SA'){
            		            $saturday = getFirstWeekDay(6, $lddate); // set live date in place of today to get right data
            		            $extended_test = find_extended_date_actual($comp_id, $saturday);
            		            $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $saturday);
            		            //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$saturday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		        } else if(strtoupper($elementOne) == 'SU'){
            		            $sunday = getFirstWeekDay(7, $lddate); // set live date in place of today to get right data
            		            $extended_test = find_extended_date_actual($comp_id, $sunday);
            		            $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $sunday);
            		            //echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$sunday."</td><td>".$ccompliance['periodicity']."</td></tr>";
            		        }
            		    } else {
            		        $next_date = getTriggerDateEx($pattern, $lddate);
                			if($next_date!=""){
                			    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		            $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $next_date);
                    			//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$lddate."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                    			$date = strtotime($next_date);
                		    } else {
                		        //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                			}
            		    }
            	    } else {
                		$month_sched = date('Y-m-d', strtotime($lddate));
                	    $month_line_last = strtotime($month_sched);
                		$month_int = date("m", $month_line_last);
                		$year_int = date("Y", $month_line_last);
                		$dateToBePassed = date('Y-m-d', $month_line_last);
                		$dd = strtotime($dateToBePassed);
                		$day 	= date("d", $dd);
                		$month 	= date("m", $dd);
                		$year 	= date("Y", $dd);
                		if($elementTwo == "1/4"){
                				if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                						$next_date = getTriggerDateEx($pattern, $dateToBePassed);
                						if($next_date!=""){
                						    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                        $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $next_date);
                        					//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                        					$date = strtotime($next_date);
                    					} else {
                    					    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                    					}
                					}
                			} else if($elementTwo == "1/2"){
                					if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                						$next_date = getTriggerDateEx($pattern, $dateToBePassed);
                						if($next_date!=""){
                						    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                        $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $next_date);
                        					//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                        					$date = strtotime($next_date);
                    					} else {
                    					    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                    					}
                					}
                			} else if($elementTwo == "*"){
                				if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                					$next_date = getTriggerDateEx($pattern, $dateToBePassed);
                					if($next_date!=""){
                					    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                    $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $next_date);
                    					//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                    					$date = strtotime($next_date);
                					} else {
                					    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                					}
                				}
                			} else if(is_numeric($elementOne) && is_numeric($elementTwo) && !is_numeric($elementThree)){
                			    $makedatewithcurrentYear = $elementOne."-".$elementTwo."-".$year;
                			    if(strtotime($makedatewithcurrentYear)>strtotime($dateToBePassed)){
                			        $dateToBePassed = $dateToBePassed;
                			    } else {
                			        $dateToBePassed = date("Y-m-d", strtotime($makedatewithcurrentYear . " +1 Year"));
                			    }
                				if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                					$next_date = getTriggerDateEx($pattern, $dateToBePassed);
                					if($next_date!=""){
                					    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                    $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $next_date);
                        				//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                        				// $date = strtotime($next_date);
                    				} else {
                    				    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                    				}
                				}
                			} else if( is_numeric($elementTwo) && is_numeric($elementThree) && !is_numeric($elementOne) ){		
                				if($month_int == $elementTwo && $year_int == $elementThree){
                					if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                						$next_date = getTriggerDateEx($pattern, $dateToBePassed);
                						if($next_date!=""){
                						        $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                            $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $next_date);
                            					//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                            				// 	exit();
                            				// 	$date = strtotime($next_date);
                        				} else {
                        				    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                        				}
                					}
                				}
                			} else if( is_numeric($elementOne) && is_numeric($elementTwo) && is_numeric($elementThree) ){
                				if(strtotime($pattern)>strtotime($lddate)){
                				// 	if($month_int == $elementTwo && $year_int == $elementThree){
                						if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                							$next_date = getTriggerDateEx($pattern, $dateToBePassed);
                							if($next_date!=""){
                							    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                            $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $next_date);
                            					//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                            				// 	exit();
                            				// 	$date = strtotime($next_date);
                        					} else {
                        					    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                        					}
                						}
                				// 	}
                				} else {
                					//echo "<tr bgcolor='white' style='color:red'><td>".$ccompliance['compliance_id']."</td><td colspan='10'> is an expired compliance, cannot generate compliance</td></tr>";
                				// 	exit();
                				}
                			} else {
                				if($ccompliance['expiry_date']>$dateToBePassed || $ccompliance['expiry_date']==''){
                					$next_date = getTriggerDateEx($pattern, $dateToBePassed);
                					if($next_date!=""){
                					    $extended_test = find_extended_date_actual($comp_id, $next_date);
            		                    $display = update_golive_singal_with_live_date_due($sr, $extended_test, $live_date, $next_date);
                    					//echo "<tr bgcolor='green' style='color:white'><td>".$srno."</td><td>".$live_date."</td><td>".$ccompliance['compliance_id']."</td><td>".$ccompliance['location']."</td><td> ".$ccompliance['department'].'</td><td> '.$ccompliance['fpr_id'].'</td><td> '.$ccompliance['appr_id'].'</td><td> '.$ccompliance['hod_id'].'</td><td>'.$pattern.'</td><td> '.$next_date."</td><td>".$ccompliance['periodicity']."</td></tr>";
                    					$date = strtotime($next_date);
                					} else {
                					    //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>";
                					}
                				}
                			}
                			$month_sched = date("Y-m-d",strtotime($month_sched." +1month"));
            	    }
            	} else {
            	   //echo "<tr bgcolor='green' style='color:white'><td colspan='11'>The Due date pattern $pattern is invalid</td></tr>"; 
            	}
    		}
    	}
    	$oEDataOld = $ccompliance['location'].$ccompliance['department'].$ccompliance['fpr_id'].$ccompliance['appr_id'].$ccompliance['hod_id'];
	    $srno++;
	    updateStatusCompliance($sr, $company_id, $comp_id);
    }
//echo "</tbody></table>";
//setting compliances live completed

// inserting log in golive table
insertGoLiveHistory($act_id, $live_date, $srno);	

// User Status and check if mails need to be sent to users
//echo "<table width='100%' border='1'><thead> <tr><th bgcolor='Indigo' style='color:white' colspan='3'>User Email Sent Status</th></tr> <tr><th>User Email</th><th>Role</th><th>Status</th><thead/></tr><tbody>";
$fprs = array_unique($fprArray);
$apprs = array_unique($apprArray);
$hods = array_unique($hodArray);
foreach($fprs as $fpr){
	$role = "Fpr";
	$userStatus = checkUserExists($fpr);
	if($userStatus == 0){
		$dL = getDepartmentLocationforRole($fpr, $role, $_SESSION['company_id']);
		$otp = rand('10000','99000');
		$status = "User $fpr with $role role does not exists and activation and user role email will be sent";
		//echo "<tr bgcolor='Indigo' style='color:white'><td>".$fpr."</td><td>".$role."</td><td>".$status."</td></tr>";
		activation_mail_send($fpr, $otp, $role);
		insert_user_role($_SESSION['company_id'], $dL['department'], $dL['location'], $fpr, $role);
	} else {
		$dL = getDepartmentLocationforRole($fpr, $role, $_SESSION['company_id']);
		$userRole = CheckUserRole($_SESSION['company_id'], $fpr, $role);
		if($userRole == 0){ 
			$status = "User $fpr exists and only for $role role email will be sent";
			//echo "<tr bgcolor='Indigo' style='color:white'><td>".$fpr."</td><td>".$role."</td><td>".$status."</td></tr>";
			insert_user_role($_SESSION['company_id'], $dL['department'], $dL['location'], $fpr, $role);
		} else {
			$status = "User $fpr exists with $role role";
			//echo "<tr bgcolor='Indigo' style='color:white'><td>".$fpr."</td><td>".$role."</td><td>".$status."</td></tr>";
		}			
	}
}

foreach($apprs as $appr){
	$role = "Approver";
	$userStatus = checkUserExists($appr);
	if($userStatus == 0){
		$dL = getDepartmentLocationforRole($appr, $role, $_SESSION['company_id']);
		$otp = rand('10000','99000');
		$status = "User $appr with $role role does not exists and activation and user role email will be sent";
		//echo "<tr bgcolor='Indigo' style='color:white'><td>".$appr."</td><td>".$role."</td><td>".$status."</td></tr>";
		activation_mail_send($appr, $otp, $role);
		insert_user_role($_SESSION['company_id'], $dL['department'], $dL['location'], $appr, $role);
	} else {
		$dL = getDepartmentLocationforRole($appr, $role, $_SESSION['company_id']);
		$userRole = CheckUserRole($_SESSION['company_id'], $appr, $role);
		if($userRole == 0){ 
			$status = "User $appr exists and only for $role role email will be sent";
			//echo "<tr bgcolor='Indigo' style='color:white'><td>".$appr."</td><td>".$role."</td><td>".$status."</td></tr>";
			insert_user_role($_SESSION['company_id'], $dL['department'], $dL['location'], $appr, $role);
		} else {
			$status = "User $appr exists with $role role";
			//echo "<tr bgcolor='Indigo' style='color:white'><td>".$appr."</td><td>".$role."</td><td>".$status."</td></tr>";
		}			
	}
}

foreach($hods as $hod){
	$role = "Hod";
	$userStatus = checkUserExists($hod);
	if($userStatus == 0){
		$dL = getDepartmentLocationforRole($hod, $role, $_SESSION['company_id']);
		$otp = rand('10000','99000');
		$status = "User $hod with $role role does not exists and activation and user role email will be sent";
		//echo "<tr bgcolor='Indigo' style='color:white'><td>".$hod."</td><td>".$role."</td><td>".$status."</td></tr>";
		activation_mail_send($hod, $otp, $role);
		insert_user_role($_SESSION['company_id'], $dL['department'], $dL['location'], $hod, $role);
	} else {
		$dL = getDepartmentLocationforRole($hod, $role, $_SESSION['company_id']);
		$userRole = CheckUserRole($_SESSION['company_id'], $hod, $role);
		if($userRole == 0){ 
			$status = "User $hod exists and only for $role role email will be sent";
			//echo "<tr bgcolor='Indigo' style='color:white'><td>".$hod."</td><td>".$role."</td><td>".$status."</td></tr>";
			insert_user_role($_SESSION['company_id'], $dL['department'], $dL['location'], $hod, $role);
		} else {
			$status = "User $hod exists with $role role";
			//echo "<tr bgcolor='Indigo' style='color:white'><td>".$hod."</td><td>".$role."</td><td>".$status."</td></tr>";
		}				
	}
}
//echo "</tbody></table>";

// setting up due date based compliances for next 2 years excluding one time compliances
include ("setting_due_date_live.php");
// generating ongoing and event based compliances
include ("event_ongoing_updated.php");
?>
<div class="modal-dialog modal-sm">
                <div class="modal-content" id="popupcontent">
			<div class="modal-header">
                      <h3 class="modal-title custom-font" id="popuptitle">Complete !!!</h3> 
                    </div>
                    <div class="modal-body" id="popupbody<?=$popupno;?>">
                                    <!-- tile widget -->
									<?php 
									//delete_company_compliance_by_compl_compy_2( $act_id );
									update_company_compliance_by_compl_compy_2( $act_id );
									?>
                                    <div class="tile-widget p-30 text-center">
									<h4 class="mb-0"><strong>Successfully Submit</h4>
                                      <!--  <?php //echo get_trigger_date('30-*-*', '2015-05-10'); ?> -->
									  <b>Act has Been Successfully Initiate Since</b>
									  <?=date('d-M-Y', strtotime($live_date));?>
									  <br>
									 
                                    </div>
                                    <!-- /tile widget -->
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-default btn-border" data-dismiss="modal">Close</button>
                    </div>
				</div>
			</div>
<?php } 
} else {?>
<div class="modal-dialog modal-sm"> 
                <div class="modal-content" id="popupcontent">
			<div class="modal-header">
                      <h3 class="modal-title custom-font" id="popuptitle">Oh !!!</h3> 
                    </div>
                    <div class="modal-body" id="popupbody<?=$popupno;?>">
                                    <!-- tile widget -->
                                    <div class="tile-widget p-30 text-center">
									<h4 class="mb-0"><strong>Some Error</h4>  
                                    </div>
                                    <!-- /tile widget -->
                    </div>
                    <div class="modal-footer"> 
                        <button class="btn btn-default btn-border" data-dismiss="modal">Close</button>
                    </div>
				</div>
			</div>
<?php } ?>