<?php
include('include/header.php');
$company_id=$_SESSION['company_id'];
function get_act_list_by_company_id_and_req_only_count ( $company_id){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT count(company_act.act_id) as count FROM company_act  WHERE company_act.status =  '1' AND company_act.company_id =? and company_act.act_id!='99998' and company_act.act_id!='99999'" );
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function get_act_list_by_company_id_and_req ( $company_id, $req ){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT company_act.act_id,`act`.`name` FROM company_act inner join `act` on `act`.`id`=company_act.act_id  WHERE company_act.status = '1' AND company_act.company_id =? and company_act.act_id!='99998' and company_act.act_id!='99999' order by `act`.`name`
		Limit ?, 10" );
		$query->bindValue( 1, $company_id );
		$query->bindValue( 2, (int)(0), PDO::PARAM_INT );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getActListforCompany(){
	$company_id = $_SESSION['company_id'];
	$emails_e = email_to_deactive_for_company_compliance_2();
	$dbh = connect_db();
	try{
		// $query = $dbh->prepare( "SELECT company_act.act_id,`act`.`name` FROM company_act inner join (SELECT `id`, `name` FROM `act`) `act` on `act`.`id`=company_act.act_id  WHERE company_act.status = '1' AND company_act.company_id =? and company_act.act_id!='99998' and company_act.act_id!='99999' order by `act`.`name` Limit ?, 10" );
		$query = $dbh->prepare( "SELECT company_act.act_id as actID, act.`name` as actName, (SELECT COUNT(`compliance`.`id`) FROM `compliance` WHERE `company_act`.`act_id`=`compliance`.`act_id` AND `compliance`.`status`=1) as ComplianceCount, (SELECT COUNT(DISTINCT(`company_compliance`.`compliance_id`)) FROM `company_compliance` WHERE `company_compliance`.`act_id`=`company_act`.`act_id` AND `company_compliance`.`status`!=7) as CompanyComplianceCount, (SELECT COUNT(DISTINCT(`company_compliance`.`compliance_id`)) FROM `company_compliance` WHERE `company_compliance`.`act_id`=`company_act`.`act_id` AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7) as LiveComplianceCount, (SELECT COUNT(DISTINCT(`company_compliance`.`compliance_id`)) FROM `company_compliance` WHERE `company_compliance`.`act_id`=`company_act`.`act_id` AND `company_compliance`.`status`=2 AND $emails_e) as DraftComplianceCount FROM company_act INNER JOIN (SELECT `id`, `name` FROM `act`) `act` on `act`.`id`=company_act.act_id INNER JOIN (SELECT DISTINCT(`act_id`) FROM `company_compliance` WHERE `status`=2)`company_compliance` ON `company_act`.`act_id`=`company_compliance`.`act_id` WHERE company_act.status = '1' AND company_act.company_id =? and company_act.act_id!='99998' AND company_act.act_id!='99999' order by `act`.`name`" );
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getGoLiveRequestsAdded(){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT * FROM goLiveRequest WHERE company_id =?" );
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getGoLiveActname($actid){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT `name` FROM act WHERE id =?" );
		$query->bindValue( 1, $actid );
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getActListforCompanySM(){
	$company_id = $_SESSION['company_id'];
	$emails_e = email_to_deactive_for_company_compliance_2();
	$dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT DISTINCT `company_act`.`act_id`, `act`.`name` FROM `company_act` INNER JOIN (SELECT `id`, `name` FROM `act`) `act` on `act`.`id`=`company_act`.`act_id`  WHERE `company_act`.`status` = '1' AND `company_act`.`company_id` =? AND `company_act`.`act_id`!='99998' AND `company_act`.`act_id`!='99999' ORDER BY `act`.`name`" );
		$query->bindValue( 1, $company_id );
// 		$query->bindValue( 2, (int)(0), PDO::PARAM_INT );
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getGoLiveActList($actid){
	$company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT `act_id`, `added`, `in_progress`, `completed`, `live_date`, `number_of_compliances`, `live_number_compliances`, `date_added`, `time_added` FROM `goLiveRequest` WHERE `company_id`=? AND `act_id`=?" );
		$query->bindValue( 1, $company_id );
		$query->bindValue( 2, $actid );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

// ComplianceCount = $allacts
// CompanyComplianceCount = $allocatedacts
// DraftComplianceCount = $nlcount
// LiveComplianceCount = $alcount


function fastest_query( $company_id, $act_id ){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT (select count(id) from compliance where act_id=? and status=1) as count_from_compliance, (select count(distinct(compliance_id)) from company_compliance where act_id=? and company_id=?) as count_from_company_compliance, (SELECT count(distinct (`compliance_id`)) FROM `company_compliance`  WHERE `act_id`=? and `company_id`=? and `status`!='2' and `status`!='7') as live, (SELECT GROUP_CONCAT(live_date) FROM `go_live_history` where `company_id`=? and `act_id`=?) as history FROM company_act AS Comp limit 1,1" );
		$query->bindValue( 1, $act_id );
		$query->bindValue( 2, $act_id );
		$query->bindValue( 3, $company_id );
		$query->bindValue( 4, $act_id );
		$query->bindValue( 5, $company_id );
		$query->bindValue( 6, $company_id );
		$query->bindValue( 7, $act_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result;
	} catch (Exception $e) {
		echo $e->getMessage();
	}
}
?>  
<style>
ul.pagination {
    display: inline-block;
    padding: 0;
    margin: 0;
}

ul.pagination li {display: inline;}

ul.pagination li a {
    color: black;
    float: left;
    padding: 8px 16px;
    text-decoration: none;
    transition: background-color .3s;
    border: 1px solid #ddd;
}

ul.pagination li a.active {
    background-color: #4CAF50;
    color: white;
    border: 1px solid #4CAF50;
}

ul.pagination li a:hover:not(.active) {background-color: #ddd;}

a.disabled:hover {
    cursor:not-allowed
}
</style>             
<div class="page page-ui-tiles">
	<div class="pageheader">
		<h2>Go-Live <span> To Make the Compliances Live</span></h2>
		<div class="page-bar">
			<ul class="page-breadcrumb">
				<li>
					<a href="javascript:void(0)" onclick="process('dashboard.php')"><i class="fa fa-home"></i></a>
				</li>
				<li>
					<a href="javascript:void(0)" onclick="processGolive('goLiveUpdatedNew.php')">Go-Live</a>
				</li>
			</ul>
		</div>
	</div>
	<!-- section area -->
	<section>
		<section class="tile"> 
		
				<!-- tile header -->
				<div class="tile-header dvd dvd-btm" style="text-align:right;">
				        <a href="javascript:void(0)" class="btn btn-info btn-sm" style="margin-right:5px;" onclick="processGolive('goLiveUpdatedNew.php')"><i class="fa fa-arrow-back"></i> Go Back</a>
				        <input type="button" class="btn btn-success btn-sm" style="margin-right:5px;" onclick="tableToExcelGo('editable-usage', 'Report')" value="Export to Excel">
				</div>
				<?php
				$sacts = getGoLiveRequestsAdded();
				// $cddd= get_act_list_by_company_id_and_req_only_count ( $company_id);
				?>
				<!-- /tile header -->
				<!-- tile body -->
				<div class="tile-body p-0">
				    <div class="col-md-12" id="requestResult" style="text-align:left;">
				        
				    </div>
					<div id="goliveshow">
					     <form id="goLiveMulti" method="post">
					<table class="table table-responsive table-striped" id="editable-usage">
					   <thead>
						<tr>
							<th>Sr</th>
							<th>Act</th>
							<th style="width:170px;">Submitted Compliances</th>
							<th>Live Compliances</th>
							<th>Current Status</th>
							<th>Live Date</th>
							<th>Date & Time of Request</th>
						</tr>
						</thead>
						<tbody class='text-sm' id='actsbody'>
						<?php
		
						$n=1;
						foreach($sacts as $key_act){
						    $getStatus = getGoLiveActList($key_act['act_id']);
						    $status = "";
						    if(!is_bool($getStatus)){
						        if($getStatus['added']==1 && $getStatus['in_progress']==0 && $getStatus['completed']==0){
						            $status = "Submitted";
						        } else if($getStatus['added']==1 && $getStatus['in_progress']==1 && $getStatus['completed']==0){
						             $status = "In Progress";
						        } else if($getStatus['added']==1 && $getStatus['in_progress']==1 && $getStatus['completed']==1){
						             $status = "Completed";
						        }
						        ?>
						        <tr>
								<td><?=$n;?></td>
								<td><?=getGoLiveActname($key_act['act_id']);?></td>
								
								<td class="text-sm">
								    <?=$getStatus['number_of_compliances'];?>
								</td>
								<td class='text-sm'>
								    <?php echo $getStatus['live_number_compliances'];?>
								</td>
								<td>
								    <?php echo $status;?>							
								</td>
								<td>
								    <?php echo $getStatus['live_date'];?>
								</td>
								<td>
								    <?php echo $getStatus['date_added']." ".$getStatus['time_added'];?>
								</td>
					        </tr>
							<?php
							$n++;
						    } else {
						        
						    }
						    
						}
						
					
						?>
						
						</tbody>
						
					</table>
					</div>
				</div>
				<!-- /tile body -->
			</section> 
	</section>
	<!-- /section area -->

</div>
