<?php
include('include/header.php');
function GetActIDFromGoLiveHistory($livefrom, $liveto, $actID){
    $company_id = $_SESSION['company_id'];
    if($actID!=''){
        $actidd = " AND `act_id`=$actID";
    } else {
        $actidd = ""; 
    }
    $dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT DISTINCT(`act_id`) as actID FROM `go_live_history` WHERE `company_id`=? AND `live_date` BETWEEN '$livefrom' AND '$liveto' $actidd" );
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		$actID = array(); $actName = array();
		foreach($result as $r){
			
		}
		return $result;
	} catch (PDOException $e) {
		return $e->getMessage();
	}
}

function GetActNameGoLive($actid){
	$dbh = connect_db();
	try{
	    $query = $dbh->prepare( "SELECT `name` FROM `act` WHERE `id`=?" );
		$query->bindValue( 1, $actid );
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


function GetActIDFromGoLiveRequestHistory($livefrom, $liveto, $actID){
    $company_id = $_SESSION['company_id'];
    if($actID!=''){
        $actidd = " AND `act_id`=$actID";
    } else {
        $actidd = ""; 
    }
    $dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT DISTINCT(`act_id`) as actID FROM `goLiveRequest` WHERE `company_id`=? AND `live_date` BETWEEN '$livefrom' AND '$liveto' $actidd" );
		$query->bindValue( 1, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		$actID = array(); $actName = array();
		foreach($result as $r){
			
		}
		return $result;
	} catch (PDOException $e) {
		return $e->getMessage();
	}
}

function actNameActID($actid){
   $dbh = connect_db();
	try{
	    $query = $dbh->prepare( "SELECT `name` FROM `act` WHERE `id`=?" );
		$query->bindValue( 1, $actid );
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	} 
}



function getGoLiveHistoryData($caRequest, $livefrom, $liveto){
	$company_id = $_SESSION['company_id'];
	$emails_e = email_to_deactive_for_company_compliance_2();
	$dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT company_act.act_id as actID, act.`name` as actName, (SELECT COUNT(`compliance`.`id`) FROM `compliance` WHERE `company_act`.`act_id`=`compliance`.`act_id` AND `compliance`.`status`=1) as ComplianceCount, (SELECT COUNT(DISTINCT(`company_compliance`.`compliance_id`)) FROM `company_compliance` WHERE `company_compliance`.`act_id`=`company_act`.`act_id` AND `company_compliance`.`status`!=7) as CompanyComplianceCount, (SELECT COUNT(DISTINCT(`company_compliance`.`compliance_id`)) FROM `company_compliance` WHERE `company_compliance`.`act_id`=`company_act`.`act_id` AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7) as LiveComplianceCount, (SELECT COUNT(DISTINCT(`company_compliance`.`compliance_id`)) FROM `company_compliance` WHERE `company_compliance`.`act_id`=`company_act`.`act_id` AND `company_compliance`.`status`=2 AND $emails_e) as DraftComplianceCount FROM company_act INNER JOIN (SELECT `id`, `name` FROM `act`) `act` on `act`.`id`=company_act.act_id WHERE
		`company_act`.`act_id` IN (SELECT DISTINCT(`act_id`) FROM `go_live_history` WHERE `company_id`=? AND `live_date` BETWEEN '$livefrom' AND '$liveto') $caRequest AND company_act.status = '1' AND company_act.company_id =? and company_act.act_id!='99998' and company_act.act_id!='99999' order by `act`.`name`" );
		$query->bindValue( 1, $company_id );
		$query->bindValue( 2, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		$actID = array(); $actName = array();
		foreach($result as $r){
			
		}
		return $result;
	} catch (PDOException $e) {
		return $e->getMessage();
	}
}

function getActualDateofLive( $actID ){
    $company_id = $_SESSION['company_id'];
    $dbh = connect_db();
    try{
        $query = $dbh->prepare("SELECT `timestamp` FROM `go_live_history` WHERE `company_id`='$company_id' AND `act_id`='$actID'");
        $query->execute();
        $result = $query->fetchAll();
        return $result;
    } catch (PDOException $e) {
		return $e->getMessage();
	}
}

function getCompanyComplianceData($caRequest, $livefrom, $liveto){
	$company_id = $_SESSION['company_id'];
	$emails_e = email_to_deactive_for_company_compliance_2();
	$dbh = connect_db();
	try{
		$query = $dbh->prepare( "SELECT company_act.act_id as actID, act.`name` as actName, (SELECT COUNT(`compliance`.`id`) FROM `compliance` WHERE `company_act`.`act_id`=`compliance`.`act_id` AND `compliance`.`status`=1) as ComplianceCount, (SELECT COUNT(DISTINCT(`company_compliance`.`compliance_id`)) FROM `company_compliance` WHERE `company_compliance`.`act_id`=`company_act`.`act_id` AND `company_compliance`.`status`!=7) as CompanyComplianceCount, (SELECT COUNT(DISTINCT(`company_compliance`.`compliance_id`)) FROM `company_compliance` WHERE `company_compliance`.`act_id`=`company_act`.`act_id` AND `company_compliance`.`status`!=2 AND `company_compliance`.`status`!=7) as LiveComplianceCount, (SELECT COUNT(DISTINCT(`company_compliance`.`compliance_id`)) FROM `company_compliance` WHERE `company_compliance`.`act_id`=`company_act`.`act_id` AND `company_compliance`.`status`=2 AND $emails_e) as DraftComplianceCount FROM company_act INNER JOIN (SELECT `id`, `name` FROM `act`) `act` on `act`.`id`=company_act.act_id WHERE
		`company_act`.`act_id` IN (SELECT DISTINCT(`act_id`) FROM `goLiveRequest` WHERE `company_id`=? AND `live_date` BETWEEN '$livefrom' AND '$liveto') $caRequest AND company_act.status = '1' AND company_act.company_id =? and company_act.act_id!='99998' and company_act.act_id!='99999' order by `act`.`name`" );
		$query->bindValue( 1, $company_id );
		$query->bindValue( 2, $company_id );
		$query->execute();
		$result = $query->fetchAll();
		$actID = array(); $actName = array();
		foreach($result as $r){
			
		}
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getActListforCompanyFilter($livefrom, $liveto){
    $company_id = $_SESSION['company_id'];
	$emails_e = email_to_deactive_for_company_compliance_2();
	$dbh = connect_db();
	try{
	    $query = $dbh->prepare("SELECT DISTINCT(`act_id`) FROM `go_live_history` WHERE `company_id`=? AND `live_date` BETWEEN '$livefrom' AND '$liveto'");
	    $query->bindValue( 1, $company_id );
        $query->execute();
		$result = $query->fetchAll();
		if(!is_bool($result)){
		   return count($result); 
		} else {
		    return 0;
		}
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function LiveComplianceCount($act_id){
    $company_id = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT COUNT(DISTINCT(`compliance_id`)) as count FROM `company_compliance` WHERE `act_id`=? AND `status`!=2 AND `status`!=7 AND `company_id`=?" );
		$query->bindValue( 1, $act_id );
		$query->bindValue( 2, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function AllocatedComplianceCount($act_id){
    $dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT COUNT(DISTINCT(`compliance_id`)) as count FROM `company_compliance` WHERE `act_id`=? AND `status`=2 AND `company_id`='$company_id'" );
		$query->bindValue( 1, $act_id );
		$query->bindValue( 2, $company_id );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getComplianceCount($actid, $livedate=null){
    $xpirydate = "";
    if($livedate == null){
        $xpirydate = "";
    } else {
        $xpirydate = " AND (`expiry_date`='' OR `expiry_date`>'$livedate')";
    }
    $dbh = connect_db();
	try{
	    $query = $dbh->prepare( "SELECT COUNT(*) as count FROM `compliance` WHERE `act_id`=? AND `compliance`.`status`=1 $xpirydate" );
		$query->bindValue( 1, $actid );
		$query->execute();
		$result = $query->fetch(PDO::FETCH_ASSOC);
		return $result['count'];
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

function getDraftCount($actid, $livedate=null){
    $company_id = $_SESSION['company_id'];
    if($livedate == null){
        $xpirydate = ""; 
    } else {
        $xpirydate = " AND (`compliance`.`expiry_date`='' OR `compliance`.`expiry_date`>'$livedate') AND (`company_compliance`.`due_date`='' OR `company_compliance`.`due_date`>'$livedate')";
    }
    $emails_e = email_to_deactive_for_company_compliance_2();
    $dbh = connect_db();
	try{
	    $query = $dbh->prepare( "SELECT COUNT(DISTINCT(`company_compliance`.`compliance_id`)) FROM `company_compliance` INNER JOIN `compliance` ON `compliance`.`id`=`company_compliance`.`compliance_id` WHERE `company_compliance`.`act_id`=? AND `company_compliance`.`company_id`=? AND `compliance`.`status`=1 AND `company_compliance`.`status`=2 AND $emails_e $xpirydate" );
		$query->bindValue( 1, $actid );
		$query->bindValue( 2, $company_id );
		$query->execute();
		$result = $query->fetchColumn();
		return $result;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}


if( isset($_POST["livedatefrom"]) ){
    if( empty($_POST["livedatefrom"]) || empty($_POST["livedateto"]) ){
        echo "<span style='color:red;'>Something went Wrong! Try Again.</span>";
    } else {
        $goliveHistory = "";
        $goLiveRequest = "";
        $ccRequest = "";
        $caRequest = "";
        if(isset($_POST['act'])){
            $postedAct = $_POST['act'];
            $sacts = "Act (".actNameActID($postedAct).")";
        } else {
            $postedAct = "";
        }
            // $goliveHistory = " AND `go_live_history`.`act_id`=".$_POST['act'];
            // $goLiveRequest = " AND `goLiveRequest`.`act_id`=".$_POST['act'];
            // $ccRequest = " AND `company_compliance`.`act_id`=".$_POST['act'];
            // $caRequest = " AND `company_act`.`act_id`=".$_POST['act'];
        $loacts = "";
        if(isset($_POST['curStatus'])){
            if($_POST['curStatus'] == 1){
                // get data from go_live History using act(if posted) and live date filter
                $loacts = GetActIDFromGoLiveHistory($_POST["livedatefrom"], $_POST["livedateto"], $postedAct);
                if($postedAct==""){
                    $sacts = "List of Acts (".count($loacts).")";
                }
            } elseif($_POST['curStatus'] == 2){
                // get data from CompanyCompliance
                $loacts = GetActIDFromGoLiveRequestHistory($_POST["livedatefrom"], $_POST["livedateto"], $postedAct);
                if($postedAct==""){
                    $sacts = "List of Acts (".count($loacts).")";
                }
            } else {
                echo "<span style='color:red;'>Invalid Request! Try Again.</span>";
            }
        } else {
            echo "<span style='color:red;'>Invalid Request! Try Again.</span>";
        }
        
        ?>
        <div class="tile-header dvd dvd-btm">
            <h1 class="custom-font"><strong><?=$sacts;?></strong></h1>
    	</div>
		<div class="col-md-12" id="requestResult" style="text-align:left;">
		</div>
		<div id="goliveshow">
		    <form id="goLiveMulti" method="post">
			    <table class="table table-responsive table-striped" id="editable-usage">
				    <thead>
					    <tr>
							<th>Sr</th>
							<th>Act</th>
							<th style="width:170px;">Allocation Status</th>
							<th>Live_Status</th>
							<th>Live_Date</th>
							<th>Actual_Date_Time</th>
						</tr>
						</thead>
						<tbody class='text-sm' id='actsbody'>
						<?php
		                $n=1;
		              //  var_dump($loacts);
		                if(count($loacts)==0){
		                    ?>
		                    <tr>
							<td colspan="7">No Data Found!</td>
						    </tr>
						<?php
		                } else {
						foreach($loacts as $key_act){
						    $draftCount = getDraftCount($key_act['actID']);
						    $liveCompliance = LiveComplianceCount($key_act['actID']);
						    $actName = GetActNameGoLive($key_act['actID']);
						    
						    $complianceCount = getComplianceCount($key_act['actID']);
					
							?>
							<tr>
								<td><?=$n;?></td>
								<td><?=$actName;?></td>
								
								<td class="text-sm">Compliances: 
								<?=$complianceCount;?> / <?=$draftCount;?></br>
								Events: 
								<?php 
								$event_count=count(get_events_by_company_id_act_id( $company_id, $key_act['actID'] ));
								$alloctd_evnt=count(get_allocated_events_by_company_id_act_id( $company_id, $key_act['actID'] ));
								echo $alloctd_evnt.'/'.$event_count;
								?>
								</td>
								<td class='text-sm'>
								<?php echo 'Live: '.$liveCompliance;?>
								</td>
								<td>
								<?php
								$hist = get_go_live_history_by_company_id_and_act_id( $company_id , $key_act['actID'] );
								foreach($hist as $key_his){
									echo date('d-M-y', strtotime($key_his['live_date'])).'</br>';
								}
								?>								
								</td>
								<td>
								<?php
								$actDate = getActualDateofLive( $key_act['actID'] );
								foreach($actDate as $ad){
									echo $ad['timestamp'].'</br>';
								}
								?>								
								</td>
								
								
							</tr>
							<?php $n++;
						}
						
    }
						?>
						<tr>
						</tbody>
						
					</table>
	
					</form>
					</div>
        <?php
    }
} else {
    echo "<span style='color:red;'>Something went Wrong! Try Again.</span>";
}
?>